/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.CreateHyperCDPAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.RetentionPolicy;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperCDPGroupManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperCDPManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCDPGroupManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCDPManager;
import com.huawei.ism.drm.storage.sdk.model.HyperCDP;
import com.huawei.ism.drm.storage.sdk.model.HyperCDPConsistencyGroup;
import com.huawei.ism.drm.storage.sdk.model.SecureSnapParam;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class CreateSecureHyperCDPAction
extends CreateHyperCDPAction {
    private static final Log logger = LogFactory.getInstance(CreateSecureHyperCDPAction.class);

    private HyperCDPConsistencyGroup createHyperCDPGroup(ProtectGroup protectGroup, ProtectGroupReplica replica, ProtectionTask curTask) {
        String devSn = replica.getStorageDeviceId();
        String lunCgId = this.getLunCgId(protectGroup, replica);
        IStorageHyperCDPGroupManager mgr = StorageHyperCDPGroupManagerProxy.getInstance().getStorageHyperCDPGroupMgrByDevId(devSn);
        if (mgr == null) {
            logger.error((Object)"get IStorageHyperCDPGroupManager by devSn: %s failed.", new Object[]{devSn});
            throw new LegoCheckedException(1073947394L);
        }
        SecureSnapParam secureSnapParam = this.getSecureSnapParam(curTask);
        return mgr.createCdpSecureSnapshotWithCg(devSn, lunCgId, secureSnapParam);
    }

    private SecureSnapParam getSecureSnapParam(ProtectionTask curTask) {
        RetentionPolicy policy = this.getRetentionPolicy(curTask);
        SecureSnapParam secureSnapParam = new SecureSnapParam();
        secureSnapParam.setUnitType(DrmEnumDefine.UnitTypeEnum.getUnitTypeEnum((int)policy.getUnitType()));
        secureSnapParam.setProtectPeriod(policy.getProtectPeriod());
        secureSnapParam.setAutoDeleteEnabled(true);
        return secureSnapParam;
    }

    @Override
    protected void createAndSetHyperCDP(ProtectGroupReplica replica, ProtectGroup protectGroup, ProtectionTask curTask) {
        String cgUuid = (String)protectGroup.getProps().get("cgUuid");
        if (!VerifyUtil.isEmpty((String)cgUuid)) {
            HyperCDPConsistencyGroup group = this.createHyperCDPGroup(protectGroup, replica, curTask);
            super.fillReplicaStorageInfo(replica, group);
            return;
        }
        String devSn = replica.getStorageDeviceId();
        IStorageHyperCDPManager mgr = StorageHyperCDPManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devSn);
        if (mgr == null) {
            logger.error((Object)"Get IStorageHyperCDPManager by devSn: %s failed.", new Object[]{devSn});
            throw new LegoCheckedException(1073947394L);
        }
        SecureSnapParam secureSnapParam = this.getSecureSnapParam(curTask);
        List<String> parentIds = this.getParentIds(protectGroup);
        if (CollectionUtils.isEmpty(parentIds)) {
            logger.error((Object)"Not find resourceId for pgName: %s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947394L);
        }
        ExecutionService.map(parentIds, parentId -> {
            HyperCDP hyperCDP = mgr.createCdpSecureSnapshot(devSn, parentId, secureSnapParam);
            this.fillReplica(replica, hyperCDP);
            return null;
        });
    }

    private List<String> getParentIds(ProtectGroup protectGroup) {
        return protectGroup.getPolist().stream().flatMap(po -> po.getUsedStorageResourceSet().stream()).map(ProtectObjectStorageInfo::getResourceId).collect(Collectors.toList());
    }

    private void fillReplica(ProtectGroupReplica replica, HyperCDP hyperCDP) {
        replica.getReplicas().forEach(poReplica -> poReplica.getStorageInfos().forEach(storageInfo -> {
            if (!(storageInfo instanceof LocalStorageReplica)) {
                logger.error((Object)"Obj storageInfo error!");
                return;
            }
            LocalStorageReplica localStorageReplica = (LocalStorageReplica)storageInfo;
            int resourceId = hyperCDP.getSrcResourceId();
            if (Objects.equals(localStorageReplica.getSrcStorageId(), String.valueOf(resourceId))) {
                localStorageReplica.setStorageId(hyperCDP.getId());
                localStorageReplica.setSnapshotName(hyperCDP.getSnapshotName());
                localStorageReplica.setConsistentGroupId(null);
            }
        }));
    }

    private RetentionPolicy getRetentionPolicy(ProtectionTask curTask) {
        Schedule schedule = curTask.getSchedule();
        RetentionPolicy policy = schedule.getRetentionPolicy();
        if (VerifyUtil.isEmpty((Object)policy)) {
            logger.error((Object)"not find policy for create secure snapshot.");
            throw new LegoCheckedException(1073947394L);
        }
        return policy;
    }

    @Override
    protected void setTimeStamp(ActionContext context) {
        Map map = (Map)context.getObject("EXCUTE_PARAMETER_MAP");
        String timeStamp = null;
        if (map != null) {
            timeStamp = (String)map.get("REPLICA_TIMESTANP");
        }
        String curTimeStamp = VerifyUtil.isEmpty(timeStamp) ? String.valueOf(new Date().getTime()) : timeStamp;
        context.addObject("REPLICA_TIMESTANP", (Object)curTimeStamp);
        ProtectionTask curTask = (ProtectionTask)context.getObject("TASK_ENTITY");
        RetentionPolicy policy = this.getRetentionPolicy(curTask);
        int replicaProtectPeriod = policy.getProtectPeriod();
        int unit = policy.getUnitType();
        Long tmp = Long.parseLong(curTimeStamp);
        long deadlineStamp = this.getReplicaDeadLineTimeStamp(tmp, replicaProtectPeriod, unit);
        context.addObject("REPLICA_DEADLINE_TIMESTANP", (Object)String.valueOf(deadlineStamp));
        context.addObject("REPLICA_ACTIVE_PERIOD", (Object)(replicaProtectPeriod + ":" + unit));
        context.addObject("REPLICA_SCHEDULEID", (Object)curTask.getSchedule().getScheduleId());
    }

    private Long getReplicaDeadLineTimeStamp(Long curTimeStamp, int period, int unit) {
        long endTime;
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        date.setTime(curTimeStamp);
        calendar.setTime(date);
        DrmEnumDefine.UnitTypeEnum unitTypeE = DrmEnumDefine.UnitTypeEnum.getUnitTypeEnum((int)unit);
        switch (unitTypeE) {
            case DAY: {
                calendar.add(5, period);
                endTime = calendar.getTime().getTime();
                break;
            }
            case MONTH: {
                calendar.add(2, period);
                endTime = calendar.getTime().getTime();
                break;
            }
            case YEAR: {
                calendar.add(1, period);
                endTime = calendar.getTime().getTime();
                break;
            }
            default: {
                endTime = -1L;
            }
        }
        return endTime;
    }
}

