/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.job;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.ProtectionTaskExecutor;
import com.huawei.ism.drm.protection.framework.service.task.ProtectionBackTaskHandler;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.quartz.Trigger;

public class ProtectionJob
implements StatefulJob {
    private static Log logger = LogFactory.getInstance(ProtectionJob.class);
    private ProtectionTask task;
    private Trigger quartzTrigger;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.quartzTrigger = jobExecutionContext.getTrigger();
        this.task = (ProtectionTask)this.quartzTrigger.getJobDataMap().get((Object)"TASK");
        String uuid = this.task.getProtectGroup().getUuid();
        ProtectGroup pg = null;
        if (!VerifyUtil.isEmpty((String)uuid)) {
            pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(uuid, false);
            Schedule schedule = Optional.ofNullable(pg.getTemplate().getSchedules().stream().filter(a -> a.getScheduleId().equals(this.task.getSchedule().getScheduleId())).findFirst()).get().orElse(null);
            this.updateSchedule(schedule);
            this.task.setSchedule(schedule);
        }
        ProtectionTaskExecutor backTask = this.getBackTask(pg);
        ProtectionBackTaskHandler.getInstance().submitTask(backTask);
    }

    private void updateSchedule(Schedule schedule) {
        Schedule scheduleOfTask = this.task.getSchedule();
        if (VerifyUtil.isEmpty((Object)scheduleOfTask)) {
            return;
        }
        Map tmpExtMap = scheduleOfTask.getExtParameters();
        if (tmpExtMap.containsKey("triggerType")) {
            String triggerType = (String)tmpExtMap.get("triggerType");
            Map extMaps = schedule.getExtParameters();
            extMaps.put("triggerType", String.valueOf(triggerType));
            schedule.setExtParameterDatas(JSONObject.fromObject((Object)extMaps).toString());
        }
    }

    private ProtectionTaskExecutor getBackTask(ProtectGroup pg) {
        Schedule schedule;
        if (VerifyUtil.isEmpty((Object)pg)) {
            return new ProtectionTaskExecutor(this.task);
        }
        int templateType = pg.getTemplate().getType();
        if (this.is4DCTplSyncAndAsync(templateType) && !VerifyUtil.isEmpty((Object)(schedule = this.task.getSchedule()))) {
            return this.getProtectionTaskExecutor(pg, schedule);
        }
        return new ProtectionTaskExecutor(this.task);
    }

    private ProtectionTaskExecutor getProtectionTaskExecutor(ProtectGroup pg, Schedule schedule) {
        Map extMap = schedule.getExtParameters();
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        if (extMap.containsKey("triggerType")) {
            int triggerType = Integer.parseInt((String)extMap.get("triggerType"));
            if (triggerType == 1) {
                parameter.put("syncTypeAfterSync", 1);
            }
            if (triggerType == 2) {
                parameter.put("backupTypeAfterSync", 2);
            }
        } else {
            this.changeAndSetTrigger(pg, schedule, extMap, parameter);
        }
        logger.info((Object)"Set back task and taskId: %s", new Object[]{this.task.getTaskId().toString()});
        if (parameter.size() > 0) {
            return new ProtectionTaskExecutor(this.task, parameter);
        }
        return new ProtectionTaskExecutor(this.task);
    }

    private void changeAndSetTrigger(ProtectGroup pg, Schedule schedule, Map<String, String> extMap, Map<String, Object> parameter) {
        if (extMap.containsKey("replicationMode") && this.is4DCCascadeSyncAndAsync(pg.getTemplate().getType())) {
            Set hmSet = pg.getHyperMetroSiteIdSet();
            if (!hmSet.contains(pg.getProductSiteId())) {
                return;
            }
            String replicationMode = (String)schedule.getExtParameters().get("replicationMode");
            if (replicationMode.equals(String.valueOf(2))) {
                this.setTakSyncSchedule(pg, 1);
            }
            parameter.put("syncTypeAfterSync", 1);
        }
        if (schedule.getProtectedType() == 2) {
            int location = schedule.getProtectLocation();
            ProtectGroupReplica replica = this.getReplicaByLocation(pg, location);
            VerifyUtil.checkObject((Object)replica);
            if (location == DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue() && replica.getType() == 1) {
                this.setTakSyncSchedule(pg, 2);
                parameter.put("backupTypeAfterSync", 2);
            }
        }
    }

    private void setTakSyncSchedule(ProtectGroup pg, int type) {
        Schedule syncSchedule = Optional.of(pg.getTemplate().getSchedules().stream().filter(schedule -> schedule.getProtectedType() != 2).filter(schedule -> schedule.getExtParameters().containsKey("replicationMode")).filter(schedule -> Objects.equals(schedule.getExtParameters().get("replicationMode"), String.valueOf(1))).findFirst()).get().orElse(null);
        if (!VerifyUtil.isEmpty((Object)syncSchedule)) {
            Map extMaps = syncSchedule.getExtParameters();
            extMaps.put("triggerType", String.valueOf(type));
            syncSchedule.setExtParameterDatas(JSONObject.fromObject((Object)extMaps).toString());
        }
        this.task.setSchedule(syncSchedule);
    }

    private ProtectGroupReplica getReplicaByLocation(ProtectGroup pg, int location) {
        Optional<ProtectGroupReplica> opt = pg.getReplicaList().stream().filter(replica -> replica.getProtectLocation() == location).findAny();
        return opt.orElse(null);
    }

    private boolean is4DCCascadeSyncAndAsync(int templateType) {
        return templateType == 38 || templateType == 40;
    }

    private boolean is4DCTplSyncAndAsync(int templateType) {
        return templateType == 38 || templateType == 39 || templateType == 40 || templateType == 41;
    }

    public static String getClassName() {
        String className = null;
        try {
            throw new Exception();
        }
        catch (Exception e) {
            Object[] element = e.getStackTrace();
            if (!VerifyUtil.isEmpty((Object[])element)) {
                className = ((StackTraceElement)element[0]).getClassName();
            }
            return className;
        }
    }
}

