/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.util;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class ProtectActionLogManager {
    private static final Log logger = LogFactory.getInstance(ProtectActionLogManager.class);
    private static final ProtectActionLogManager INSTANCE = new ProtectActionLogManager();
    private Map<String, ProtectGroupLog> runningLog = new ConcurrentHashMap<String, ProtectGroupLog>();

    private ProtectActionLogManager() {
    }

    public static ProtectActionLogManager getInstance() {
        return INSTANCE;
    }

    public synchronized void registerRunningLog(String pgId, ProtectGroupLog log) {
        this.runningLog.put(pgId, log);
    }

    public synchronized void unregisterRunningLog(String pgId) {
        if (this.runningLog.containsKey(pgId)) {
            this.runningLog.remove(pgId);
        }
    }

    public synchronized void initRunningChildDetail(int pgLogId, ProtectGroupLogDetail parentLogDetail, List<AbstractBaseProtectAction> actions, boolean isParallel) {
        ArrayList<ProtectGroupLogDetail> allDetail = new ArrayList<ProtectGroupLogDetail>();
        for (AbstractBaseProtectAction action : actions) {
            if (!action.isEnable()) continue;
            ProtectGroupLogDetail initDetail = this.initLogDetail(action, pgLogId);
            parentLogDetail.getProtectionLogDetails().add(initDetail);
            parentLogDetail.getChildDetails().add(initDetail);
            initDetail.setParentDetailId(parentLogDetail.getDetailId());
            allDetail.add(initDetail);
        }
        if (!isParallel) {
            for (int index = 0; index < allDetail.size(); ++index) {
                ProtectGroupLogDetail detail = (ProtectGroupLogDetail)allDetail.get(index);
                if (0 == index) continue;
                ProtectGroupLogDetail preDetail = (ProtectGroupLogDetail)allDetail.get(index - 1);
                preDetail.setNextDetailId(detail.getDetailId());
                detail.setPreDetailId(preDetail.getDetailId());
                logger.debug((Object)(preDetail.getDetailId() + "->" + detail.getDetailId()));
            }
        }
        for (ProtectGroupLogDetail detail : allDetail) {
            this.saveOrUpdateProtectGroupLogDetail(detail);
        }
    }

    public void initRunningDetail(String pgId, List<AbstractBaseProtectAction> actions) {
        ProtectGroupLog historyLog = this.runningLog.get(pgId);
        if (historyLog == null) {
            logger.error((Object)("historyLog is null.pgId:" + pgId));
            throw new LegoCheckedException(1073947394L);
        }
        ArrayList<ProtectGroupLogDetail> allDetail = new ArrayList<ProtectGroupLogDetail>();
        for (AbstractBaseProtectAction action : actions) {
            if (!action.isEnable()) continue;
            ProtectGroupLogDetail initDetail = this.initLogDetail(action, historyLog.getHistoryLogId());
            historyLog.getPgHistoryLogDetails().add(initDetail);
            allDetail.add(initDetail);
        }
        this.joinActionDetail(allDetail);
        for (ProtectGroupLogDetail detail : allDetail) {
            this.saveOrUpdateProtectGroupLogDetail(detail);
        }
    }

    private ProtectGroupLogDetail initLogDetail(AbstractBaseProtectAction action, int pgLogId) {
        ProtectGroupLogDetail detail = new ProtectGroupLogDetail();
        detail.setTitle(action.getName());
        detail.setTitleParams(action.getNameParams());
        detail.setActionId(action.getActionId());
        detail.setDetailId(UUIDGenerator.getUUID());
        detail.setResult(3L);
        detail.setLogId(Integer.valueOf(pgLogId));
        detail.setStartTime("--");
        detail.setEndTime("--");
        detail.setInfo("--");
        detail.setInfoParams("--");
        detail.setProtectionLogDetails(new HashSet());
        detail.setChildDetails(new ArrayList());
        return detail;
    }

    public ProtectGroupLogDetail getActionLogDetail(String pgId, String actionId) {
        ProtectGroupLog protectGroupLog = this.runningLog.get(pgId);
        if (null == protectGroupLog) {
            return null;
        }
        for (ProtectGroupLogDetail detail : protectGroupLog.getPgHistoryLogDetails()) {
            if (!detail.getActionId().equals(actionId)) continue;
            return detail;
        }
        return null;
    }

    public void saveOrUpdateProtectGroupLog(ProtectGroupLog log) {
        this.saveOrUpdateLogObject(log);
    }

    public void saveOrUpdateProtectGroupLogDetail(ProtectGroupLogDetail log) {
        this.saveOrUpdateLogObject(log);
    }

    private void saveOrUpdateLogObject(Object log) {
        if (null == log) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        Session session = null;
        Transaction tx = null;
        try {
            HibernateTemplate template = CommonDAOLocator.getBaseDao().getHibernateTemplate();
            session = template.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.saveOrUpdate(log);
            tx.commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)("add running log for pg failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
    }

    private void joinActionDetail(List<ProtectGroupLogDetail> allDetail) {
        for (int i = 0; i < allDetail.size(); ++i) {
            ProtectGroupLogDetail detail = allDetail.get(i);
            if (i > 0) {
                detail.setPreDetailId(allDetail.get(i - 1).getDetailId());
            }
            if (i >= allDetail.size() - 1) continue;
            detail.setNextDetailId(allDetail.get(i + 1).getDetailId());
        }
    }
}

