/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.replica.retention.service.IReplicaRetentionStrategyManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class SnapShotExceedLimitSubscriber
extends MessageTaskManager {
    private static Log logger = LogFactory.getInstance(SnapShotExceedLimitSubscriber.class);
    private static long waitTime = 2000L;

    public SnapShotExceedLimitSubscriber(IMessageCenter msgCenter) {
        msgCenter.addSubscriberTo((MessageTaskManager)this);
    }

    public void onMessage(MessageUnit mu) {
        if (null == mu) {
            logger.error((Object)"mu param is empty");
            return;
        }
        long msgType = mu.getCmdcode();
        if (20003L != msgType) {
            logger.error((Object)("Message was not subscribed, msgType: " + msgType), 90160758786876L);
            return;
        }
        Object msg = mu.getObj();
        if (null == msg || !(msg instanceof String)) {
            return;
        }
        String pgId = (String)msg;
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup pg = pgService.getProtectGroupByID(pgId, false);
        if (VerifyUtil.isEmpty((Object)pg)) {
            return;
        }
        Set replicas = pg.getReplicaList();
        ArrayList<ProtectGroupReplica> replicaList = new ArrayList<ProtectGroupReplica>(replicas);
        if (VerifyUtil.isEmpty(replicaList)) {
            return;
        }
        Iterator iterator = replicaList.iterator();
        while (iterator.hasNext()) {
            ProtectGroupReplica replica = (ProtectGroupReplica)iterator.next();
            if (ProtectGroupUtil.isLocalStorageReplica(replica)) continue;
            iterator.remove();
        }
        ProtectGroupHelper.getInstance().orderReplicaList(replicaList);
        this.updateReplica(pg, ((ProtectGroupReplica)replicaList.get(0)).getId());
    }

    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters((int)1);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(20003L);
        return mrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReplica(ProtectGroup pg, String replicaId) {
        boolean result = ProtectionJobUtil.getInstance().getLockPg(pg.getUuid(), waitTime);
        if (!result) {
            return;
        }
        try {
            ((IReplicaRetentionStrategyManager)ServiceLocator.getInstance().getService(IReplicaRetentionStrategyManager.class)).executeStrategy(pg);
        }
        catch (Exception e) {
            if (ExceptionUtil.isSpecialException((Throwable)e)) {
                logger.error((Object)("save new replica error,replicaId: and message is " + replicaId + ExceptionUtil.getErrorMessage((Throwable)e)));
            } else {
                logger.error((Object)("save new replica error,replicaId: " + replicaId + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
        finally {
            ProtectionJobUtil.getInstance().releaseLockPg(pg.getUuid());
        }
    }
}

