/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectActionFlowDefineMgr;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupServiceImpl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import java.util.ArrayList;

public class DeleteProtectGroupTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(DeleteProtectGroupTask.class);
    private static final int DEFAULT_TIMEOUT = 1209600;
    private ProtectGroup protectGroup;
    private ProtectGroupServiceImpl service;

    public DeleteProtectGroupTask(ProtectGroupServiceImpl service, ProtectGroup protectGroup) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)protectGroup.getName(), (String)"ism.drm.pg.delpg", (String)"System", (String)"", null), 1209600, true);
        this.service = service;
        this.protectGroup = protectGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() {
        String protectGroupId = this.protectGroup.getUuid();
        this.protectGroup = this.service.getProtectGroupByID(protectGroupId);
        MessageEvent deleteEvent = new MessageEvent();
        deleteEvent.setMessageType(2);
        ArrayList<ProtectGroup> objectList = new ArrayList<ProtectGroup>();
        objectList.add(this.protectGroup);
        deleteEvent.setObjectList(objectList);
        boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(protectGroupId);
        if (!lockFlag) {
            logger.error((Object)("The pg is locked: " + protectGroupId), 90160758786893L);
            throw new LegoCheckedException(102401L);
        }
        try {
            this.service.notifyObserverList(deleteEvent, "before");
            this.service.deleteProtectionTask(protectGroupId);
            this.service.getRetentionManager().deleteRetentionTask(this.protectGroup);
            this.service.deleteSyncRateTask(protectGroupId);
            this.service.deleteProtectGroupById(protectGroupId);
            if (null != this.protectGroup.getTemplate()) {
                String uuid = this.protectGroup.getTemplate().getUuid();
                this.service.getPolicyTemplateManager().deleteTemplate(uuid);
            }
            ServiceLocator locator = ServiceLocator.getInstance();
            ((IBizScopeManager)locator.getService(IBizScopeManager.class)).deleteScopeObject(protectGroupId);
            ProtectGroupHelper.getInstance().deleteReplica(this.protectGroup);
            ProtectActionFlowDefineMgr.getInstance().deleteProtectActions(protectGroupId);
            this.service.notifyObserverList(deleteEvent, "after");
            this.service.deleteProtectGroupReplica(protectGroupId);
            this.deleteAlarmOfPg(protectGroupId, locator);
        }
        catch (LegoCheckedException e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Delete protectGroup:" + this.protectGroup.getName() + " failed!"), (long)e.getErrorCode(), (String[])e.getParameters(), (Log)logger);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("failed to delete ProtectGroup(" + this.protectGroup.getUuid() + ")."), (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
        }
    }

    private void deleteAlarmOfPg(String protectGroupId, ServiceLocator locator) {
        ArrayList<String> sourceList = new ArrayList<String>();
        sourceList.add(protectGroupId);
        ((IAlarmService)locator.getService(IAlarmService.class)).deleteAlarmAndEventBySorceId(sourceList);
    }
}

