/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.drm.backup.BackupManagerProxy;
import com.huawei.ism.drm.backup.IBackupManager;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.service.replica.factory.IReplicaFactory;
import com.huawei.ism.drm.protection.framework.service.replica.factory.ReplicaFactoryManager;
import com.huawei.ism.drm.protection.framework.template.factory.ReplicaBuilderFactory;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.model.BackupPlan;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.ism.drm.storage.util.BackupPlanUtil;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class NativeBackupObserver
implements IObjectObserver {
    private static Log logger = LogFactory.getInstance(NativeBackupObserver.class);
    private BackupManagerProxy proxy = BackupManagerProxy.getInstance();
    private ReplicaBuilderFactory factory = ReplicaBuilderFactory.getInstance();

    public void before(MessageEvent event) {
        if (VerifyUtil.isEmpty((Object)event)) {
            return;
        }
        List objectList = event.getObjectList();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        for (DRMObject object : objectList) {
            if (!(object instanceof ProtectGroup) || !this.checkPolicyTemplateType((ProtectGroup)object)) continue;
            if (event.getMessageType() == 2) {
                this.removeProtectObjects((ProtectGroup)object);
                continue;
            }
            if (event.getMessageType() != 1) continue;
            this.checkBackupPlan((ProtectGroup)object);
        }
    }

    public void after(MessageEvent event) {
        if (VerifyUtil.isEmpty((Object)event)) {
            return;
        }
        List objectList = event.getObjectList();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        for (DRMObject object : objectList) {
            if (!(object instanceof ProtectGroup) || !this.checkPolicyTemplateType((ProtectGroup)object) || event.getMessageType() != 2) continue;
            this.deleteBackupPlan((ProtectGroup)object);
        }
    }

    private void removeProtectObjects(ProtectGroup protectGroup) {
        logger.debug((Object)"Start to remove protectGroup(%s) from backup plan.", new Object[]{protectGroup.getName()});
        for (Schedule schedule : protectGroup.getTemplate().getSchedules()) {
            if (!BackupPlanUtil.isExistBackupPlan(schedule)) continue;
            String devSn = schedule.getSourceSn();
            String backupPlanId = (String)schedule.getExtParameters().get("BACKUP_PLAN_ID");
            try {
                List<String> lunIds = BackupPlanUtil.getBackupLuns(devSn, backupPlanId);
                BackupPlanUtil.removeLun(devSn, backupPlanId, lunIds);
                logger.debug((Object)"remove lunIds(%s) from backupPlan(%s) success!", new Object[]{lunIds.toString(), backupPlanId});
            }
            catch (Exception e) {
                logger.error((Object)("remove protectObject from backupPlan failed. bakcupPlanId is " + backupPlanId), (Throwable)e);
            }
        }
    }

    private void checkBackupPlan(ProtectGroup protectGroup) {
        IReplicaBuilder builder = this.factory.getTemplateByType(protectGroup.getTemplate().getType());
        Map devSns = builder.getProtectedDeviceSn(protectGroup);
        for (Schedule schedule : protectGroup.getTemplate().getSchedules()) {
            if (!BackupPlanUtil.isExistBackupPlan(schedule)) continue;
            String devSn = (String)devSns.get(schedule.getProtectLocation());
            String backupPlanId = (String)schedule.getExtParameters().get("BACKUP_PLAN_ID");
            String backupPlanName = (String)schedule.getExtParameters().get("BACKUP_PLAN_NAME");
            if (VerifyUtil.isEmpty((String)backupPlanId)) {
                logger.info((Object)"backup plan not exists.");
                continue;
            }
            IBackupManager backupManager = this.proxy.getBackupService("NativeBackupEngine");
            BackupPlan backupPlanOnCloudBackup = null;
            try {
                backupPlanOnCloudBackup = backupManager.queryBackupPlan(devSn, backupPlanId);
            }
            catch (LegoCheckedException le) {
                String devIP = "";
                DrResource drResource = TopoServiceUtil.getDrResource(devSn);
                if (!VerifyUtil.isEmpty((Object)drResource)) {
                    devIP = drResource.getIpAddress();
                }
                String siteId = schedule.getSourceSiteId();
                Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(siteId);
                AlarmReporter.sendAlarm(52625496L, protectGroup.getUuid(), FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), FaultEnum.AlarmSeverity.MAJOR, backupPlanId, site.getName(), protectGroup.getName(), devIP, backupPlanName);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"check protect group failed.", (Throwable)e);
                throw new LegoCheckedException("check protect group failed.");
            }
            if (!this.isBackupPlanChanged(protectGroup, backupPlanOnCloudBackup, schedule)) continue;
            logger.error((Object)"backup plan's lun has been modified, the devSn is %s, backup plan's name is %s.", new Object[]{schedule.getSourceSn(), backupPlanOnCloudBackup.getName()});
        }
    }

    private boolean isBackupPlanChanged(ProtectGroup protectGroup, BackupPlan planOnCloudBackup, Schedule schedule) {
        if (this.isProtectObjectChanged(protectGroup, schedule)) {
            return true;
        }
        return !planOnCloudBackup.getActivated().equals(BackupPlan.BACKUP_PLAN_ACTIVE);
    }

    private boolean isProtectObjectChanged(ProtectGroup protectGroup, Schedule schedule) {
        IReplicaBuilder builder = this.factory.getTemplateByType(protectGroup.getTemplate().getType());
        Map stroageInfos = builder.getAllStroageInfo(protectGroup);
        Map devSns = builder.getProtectedDeviceSn(protectGroup);
        if (!BackupPlanUtil.isExistBackupPlan(schedule)) {
            return false;
        }
        String devSn = (String)devSns.get(schedule.getProtectLocation());
        String backupPlanId = (String)schedule.getExtParameters().get("BACKUP_PLAN_ID");
        List storageInfoList = (List)stroageInfos.get(devSn);
        List<String> lunIdsExist = BackupPlanUtil.getBackupLuns(devSn, backupPlanId);
        ArrayList<String> lunIdsDiff = new ArrayList<String>();
        lunIdsDiff.addAll(lunIdsExist);
        if (lunIdsExist.size() != storageInfoList.size()) {
            return true;
        }
        for (ProtectObjectStorageInfo storageInfo : storageInfoList) {
            String lunId = storageInfo.getResourceId();
            if (lunIdsDiff.contains(lunId)) {
                lunIdsDiff.remove(lunId);
                continue;
            }
            return true;
        }
        return !VerifyUtil.isEmpty(lunIdsDiff);
    }

    private void deleteSnapshot(Snapshot snapshot) {
        if (null == snapshot) {
            return;
        }
        LocalStorageReplica localStorageReplica = new LocalStorageReplica();
        localStorageReplica.setSnapshotName(snapshot.getName());
        localStorageReplica.setStorageId(snapshot.getSnapshotId());
        localStorageReplica.setSrcStorageId(String.valueOf(snapshot.getSrcResourceId()));
        localStorageReplica.setSrcStorageProviderSN(snapshot.getDevSn());
        localStorageReplica.setStorageProviderSN(snapshot.getDevSn());
        IReplicaFactory iReplicaFactory = ReplicaFactoryManager.getInstance().getReplicaFactory(3);
        iReplicaFactory.deleteRelicaStorageInfo((RelicaStorageInfo)localStorageReplica, true);
    }

    private void deleteBackupPlan(ProtectGroup protectGroup) {
        for (Schedule schedule : protectGroup.getTemplate().getSchedules()) {
            String devSn = schedule.getSourceSn();
            String backupPlanId = (String)schedule.getExtParameters().get("BACKUP_PLAN_ID");
            String snapStr = (String)schedule.getExtParameters().get("BACKUP_SNAPSHOTLIST");
            JSONArray array = JSONArray.fromObject((Object)snapStr);
            List oldList = JSONArray.toCollection((JSONArray)array, Snapshot.class);
            String backupPlanName = (String)schedule.getExtParameters().get("BACKUP_PLAN_NAME");
            for (Snapshot snapshot : oldList) {
                this.deleteSnapshot(snapshot);
            }
            try {
                if (VerifyUtil.isEmpty((String)backupPlanId)) continue;
                BackupPlanUtil.deleteBackupPlan(devSn, backupPlanId);
            }
            catch (Exception e) {
                String devIP = "";
                DrResource drResource = TopoServiceUtil.getDrResource(devSn);
                if (!VerifyUtil.isEmpty((Object)drResource)) {
                    devIP = drResource.getIpAddress();
                }
                AlarmReporter.sendAlarm(52625497L, protectGroup.getUuid(), FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), FaultEnum.AlarmSeverity.MINOR, backupPlanId, protectGroup.getName(), devIP, backupPlanName);
                logger.error((Object)("delete backup plan failed." + backupPlanId), (Throwable)e);
            }
        }
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }

    private boolean checkPolicyTemplateType(ProtectGroup protectGroup) {
        return PolicyTemplateType.ARRAY_SECOND_SNAPSHOT.contains(protectGroup.getTemplate().getType());
    }
}

