/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group.refinement;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.IConfigSyncRateService;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.ProtectObjectConstant;
import com.huawei.ism.drm.protection.framework.service.group.CreateProtectGroupBackTask;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.refinement.BaseProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.service.replica.retention.service.IReplicaRetentionStrategyManager;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;

public class CreateProtectGroupRefineService
extends BaseProtectGroupRefineService {
    private static final CreateProtectGroupRefineService INSTANCE = new CreateProtectGroupRefineService();
    private static final Object THREAD_LOCK = new Object();
    private static final Log logger = LogFactory.getInstance(CreateProtectGroupRefineService.class);
    private static final List<Integer> ALLOW_TYPES = Arrays.asList(16, 30, 31, 32, 40, 41, 42, 43, 44, 45);
    private IConfigSyncRateService configSyncRateService = null;
    private IReplicaRetentionStrategyManager retentionManager = null;

    private CreateProtectGroupRefineService() {
    }

    public static CreateProtectGroupRefineService getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createProtectGroup(ProtectGroup protectGroup, boolean createRp) {
        Object object = THREAD_LOCK;
        synchronized (object) {
            this.updateProtectObjectProperties(protectGroup);
            ProtectGroupHelper.getInstance().validateProtectGroupParameter(protectGroup, true);
            if (!ProtectGroupHelper.getInstance().checkSiteResourceExist(protectGroup.getPoProviderSN(), protectGroup.getProductSiteId())) {
                logger.error((Object)"The DrResource is empty.");
                throw new LegoCheckedException(1073948181L);
            }
            if (!this.checkGroupName(null, protectGroup.getName())) {
                logger.error((Object)"Protect group name repeated!");
                throw new LegoCheckedException(1073947392L);
            }
            CreateProtectGroupRefineService.checkProtectGroupTotalCount();
            String uuid = protectGroup.getTemplate().getUuid();
            PolicyTemplate policyTemplate = ((IPolicyTemplateManager)ServiceLocator.getInstance().getService(IPolicyTemplateManager.class)).getPtByUuid(uuid);
            if (VerifyUtil.isEmpty((Object)policyTemplate)) {
                logger.error((Object)"Policy template is null!");
                throw new LegoCheckedException(1073947393L);
            }
            PolicyTemplate newPolicyTemplate = this.getNewPolicyTemplate(protectGroup, uuid, policyTemplate);
            protectGroup.setTemplate(newPolicyTemplate);
            if (!ALLOW_TYPES.contains(newPolicyTemplate.getType()) && this.checkHasUsedProtectObject(protectGroup)) {
                logger.error((Object)"The pg has used protect object");
                throw new LegoCheckedException(1073948177L);
            }
            CreateProtectGroupBackTask task = new CreateProtectGroupBackTask(this, protectGroup, createRp);
            if (PolicyTemplateTools.getInstance().isNotimeout(newPolicyTemplate.getType())) {
                task.setTimeout(2147483);
            }
            return BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        }
    }

    private PolicyTemplate getNewPolicyTemplate(ProtectGroup protectGroup, String uuid, PolicyTemplate policyTemplate) {
        PolicyTemplate newPolicyTemplate;
        try {
            newPolicyTemplate = (PolicyTemplate)policyTemplate.clone();
            newPolicyTemplate.setPtId(UUIDGenerator.getUUID());
            newPolicyTemplate.setUuid(newPolicyTemplate.getPtId());
            newPolicyTemplate.setReplicationType(newPolicyTemplate.getType());
            newPolicyTemplate.setParentId(uuid);
            newPolicyTemplate.getProps().clear();
            if (protectGroup.getPoType() == 11 && (protectGroup.getTemplate().getType() == 2 || protectGroup.getTemplate().getType() == 19 || protectGroup.getTemplate().getType() == 44)) {
                logger.info((Object)"Encrypt sensitive script params");
                IProtectObjectProvider provider = CreateProtectGroupRefineService.getProtectObjectProvider(protectGroup.getPoType());
                if (null != provider) {
                    provider.updatePolicyTempalate(protectGroup.getTemplate());
                }
            }
            newPolicyTemplate.setProps(protectGroup.getTemplate().getProps());
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"Failed to Clone policyTemplate, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        newPolicyTemplate.getSchedules().clear();
        newPolicyTemplate.setSchedules(protectGroup.getTemplate().getSchedules());
        return newPolicyTemplate;
    }

    public static synchronized void checkProtectGroupTotalCount() {
        int maxPgCount;
        int dbCount = CreateProtectGroupRefineService.getProtectGroupTotalCount();
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        int n = maxPgCount = isVasa ? 1024 : 512;
        if (dbCount >= maxPgCount) {
            logger.error((Object)"System has equal than: %s protected groups, can not add new protected group.", new Object[]{String.valueOf(maxPgCount)});
            throw new LegoCheckedException(1073948164L);
        }
        if (dbCount + ProtectObjectConstant.CREATING_PG_COUNT.get() > maxPgCount) {
            logger.error((Object)"System db and running tasks have more than: %s protected groups, can not add new protected group.", new Object[]{String.valueOf(maxPgCount)});
            throw new LegoCheckedException(102401L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getProtectGroupTotalCount() {
        String hql = "select count(pg.pgId) from ProtectGroup pg";
        Session session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
        try {
            Object result = session.createQuery(hql).uniqueResult();
            if (result instanceof Long) {
                int n = ((Long)result).intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            logger.error((Object)"GetProtectGroupTotalCount error");
            ExceptionUtil.rethrowException((Throwable)e, (String)"Query user objects failed.", (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return 0;
    }

    private boolean checkHasUsedProtectObject(ProtectGroup protectGroup) {
        String pairId;
        List<String> managedObjects = this.getProtectObjectMoUuids(protectGroup);
        String hql = "select moUuid from ProtectObject where protectGroup.template.type = :type and moUuid in(:uuids)";
        List results = CommonDAOLocator.getBaseDao().getHibernateTemplate().findByNamedParam(hql, new String[]{"type", "uuids"}, new Object[]{protectGroup.getTemplate().getType(), managedObjects});
        if (!VerifyUtil.isEmpty((Collection)results)) {
            return true;
        }
        if (14 == protectGroup.getPoType() && 15 == protectGroup.getTemplate().getType() && !VerifyUtil.isEmpty((String)(pairId = (String)protectGroup.getProps().get("PROP_KEY_VSTORE_PAIR_ID")))) {
            return this.doGetByPairId(pairId);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doGetByPairId(String pairId) {
        Session session;
        block2: {
            boolean bl;
            session = null;
            try {
                String sql = "select count(pg.UUID) from ti_protectgroup as pg, ti_protectgroup_prop as prop where pg.PGID = prop.PGID and  prop.PROPNAME = :PROPNAME and prop.PROPVALUE = :PROPVALUE and pg.POTYPE = :POTYPE";
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                NativeQuery sqlQuery = session.createSQLQuery(sql);
                sqlQuery.setString("PROPNAME", "PROP_KEY_VSTORE_PAIR_ID");
                sqlQuery.setString("PROPVALUE", pairId);
                sqlQuery.setString("POTYPE", String.valueOf(14));
                Object result = sqlQuery.uniqueResult();
                if (!(result instanceof BigInteger) || ((BigInteger)result).intValue() == 0) break block2;
                logger.info((Object)"The got protect object is used query by pairId : %s", new Object[]{pairId});
                bl = true;
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
            return bl;
        }
        DBOperationUtil.closeSession(session);
        return false;
    }

    private List<String> getProtectObjectMoUuids(ProtectGroup protectGroup) {
        Set objects = protectGroup.getPolist();
        if (VerifyUtil.isEmpty((Collection)objects)) {
            return Collections.emptyList();
        }
        ArrayList<String> results = new ArrayList<String>();
        for (ProtectObject object : objects) {
            results.add(object.getMoUuid());
        }
        return results;
    }

    public boolean checkGroupName(String protectGroupId, String groupName) {
        List list;
        if (VerifyUtil.isEmpty((String)groupName)) {
            logger.error((Object)"ProtectGroup(%s) is empty.", new Object[]{groupName});
            throw new LegoCheckedException(1073947393L);
        }
        String hql = "from ProtectGroup as pg where pg.name = ? and pg.primary = ?";
        try {
            list = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[]{groupName, true});
        }
        catch (DataAccessException e) {
            logger.error((Object)"Failed to check GroupName because of query error, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (VerifyUtil.isEmpty((String)protectGroupId)) {
            return VerifyUtil.isEmpty((Collection)list);
        }
        for (ProtectGroup pg : list) {
            if (protectGroupId.equals(pg.getUuid())) continue;
            return false;
        }
        return true;
    }

    public IConfigSyncRateService getConfigSyncRateService() {
        return this.configSyncRateService;
    }

    public void setConfigSyncRateService(IConfigSyncRateService configSyncRateService) {
        this.configSyncRateService = configSyncRateService;
    }

    public IReplicaRetentionStrategyManager getRetentionManager() {
        return this.retentionManager;
    }

    public void setRetentionManager(IReplicaRetentionStrategyManager retentionManager) {
        this.retentionManager = retentionManager;
    }
}

