/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.path;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.path.sdk.service.IProtectionPathBuilder;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractProtectionPathImpl
implements IProtectionPathBuilder {
    protected static final String LINE_BREAK = "\n";
    protected static final String STORAGE_RESOURCES_KEY = "STORAGE_RESOURCES_KEY";
    private static Log logger = LogFactory.getInstance(AbstractProtectionPathImpl.class);
    private static final String BATCHOPERATION_KEY = "BATCHOPERATION_KEY";
    private IStorageService storageService;
    private IResourceService resourceService;
    private ISiteService siteService;

    public BatchOperation getBatchOperation(ExecutionContext context) {
        BatchOperation batchOperation = (BatchOperation)context.getAttribute(BATCHOPERATION_KEY);
        if (batchOperation == null) {
            logger.error((Object)"batchOperation is null!", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        return batchOperation;
    }

    public Map<String, ? extends StorageResource> getAllLuns(ExecutionContext context) {
        Map storageResorceMap = (Map)context.getAttribute(STORAGE_RESOURCES_KEY);
        if (storageResorceMap == null) {
            logger.error((Object)"storageResorceMap is null!", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        return storageResorceMap;
    }

    public IStorageService getStorageService() {
        return this.storageService;
    }

    public void setStorageService(IStorageService storageService) {
        this.storageService = storageService;
    }

    public IResourceService getResourceService() {
        return this.resourceService;
    }

    public void setResourceService(IResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public ISiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(ISiteService siteService) {
        this.siteService = siteService;
    }

    protected ExecutionContext init(Map<String, ? extends StorageResource> luns, BatchOperation batchOperationParam) {
        ExecutionContext context = new ExecutionContext();
        context.setAttribute(STORAGE_RESOURCES_KEY, luns);
        context.setAttribute(BATCHOPERATION_KEY, (Object)batchOperationParam);
        return context;
    }

    protected List<String> getProductLunNamesAndIp(ProtectObjectReplica protectobjectreplica, Map<String, String> proLunInfo, ExecutionContext context) {
        Map<String, ? extends StorageResource> allLuns = this.getAllLuns(context);
        BatchOperation batchOperation = this.getBatchOperation(context);
        ArrayList<String> listRsInfoId = new ArrayList<String>();
        for (RelicaStorageInfo relicastorageinfo : protectobjectreplica.getStorageInfos()) {
            DrResource drResource = this.getResourceService().getDrResourceBySn(relicastorageinfo.getSrcStorageProviderSN());
            String ipAddress = "";
            if (null != drResource) {
                ipAddress = drResource.getIpAddress();
            }
            StorageResource productLun = allLuns.get(relicastorageinfo.getSrcStorageProviderSN() + relicastorageinfo.getSrcStorageId());
            if (VerifyUtil.isEmpty((String)ipAddress) || null == productLun) {
                batchOperation.setErrorCode(1073948206L);
                continue;
            }
            String result = productLun.getName() + "(" + ipAddress + ")";
            proLunInfo.put(relicastorageinfo.getId(), result);
            listRsInfoId.add(relicastorageinfo.getId());
        }
        return listRsInfoId;
    }

    protected List<String> getTargetLunNamesAndIp(ProtectObjectReplica protectobjectreplica, Map<String, String> recoveryLunInfo, ExecutionContext context) {
        Map<String, ? extends StorageResource> allLuns = this.getAllLuns(context);
        BatchOperation batchOperation = this.getBatchOperation(context);
        ArrayList<String> listRsInfoId = new ArrayList<String>();
        for (RelicaStorageInfo relicastorageinfo : protectobjectreplica.getStorageInfos()) {
            DrResource drResource = this.getResourceService().getDrResourceBySn(relicastorageinfo.getStorageProviderSN());
            String ipAddress = "";
            if (null != drResource) {
                ipAddress = drResource.getIpAddress();
            }
            String lunName = null;
            StorageResource targetLun = allLuns.get(relicastorageinfo.getStorageProviderSN() + relicastorageinfo.getStorageId());
            if (VerifyUtil.isEmpty((String)ipAddress) || null == targetLun) {
                batchOperation.setErrorCode(1073948206L);
            }
            if (null != targetLun) {
                lunName = targetLun.getName();
            }
            String result = null == lunName ? ";\n" : lunName + "(" + ipAddress + ")";
            recoveryLunInfo.put(relicastorageinfo.getId(), result);
            listRsInfoId.add(relicastorageinfo.getId());
        }
        return listRsInfoId;
    }

    protected String getResult(List<String> list, StringBuffer sb, Map<String, String> proLunInfo, Map<String, String> recoveryLunInfo, Set<String> pathSet) {
        for (String rsinfoid : list) {
            String result = proLunInfo.get(rsinfoid) + " --> " + recoveryLunInfo.get(rsinfoid) + ";\n";
            if (pathSet.contains(result)) continue;
            pathSet.add(result);
            sb.append(result);
        }
        return sb.toString();
    }

    protected Site getSiteByStorageSn(String sn) {
        DrResource resource = this.getStorageBySn(sn);
        if (null == resource) {
            return null;
        }
        return this.getSiteById(resource.getSiteId());
    }

    protected DrResource getStorageBySn(String sn) {
        return this.getDrResourceInfo(sn, "ism.deviceType.storage.mainType");
    }

    protected Site getSiteById(String id) {
        return this.getSiteService().getSiteById(id);
    }

    protected DrResource getDrResourceInfo(String devSn, String resType) {
        DrResource dr = this.getResourceService().getDrResourceBySn(devSn, resType);
        return dr;
    }

    protected DrmEnumDefine.RESOURCE_TYPE_E getResourceTypeByPgReplica(ProtectGroupReplica replica) {
        int protectObjectType = Optional.ofNullable(replica).map(ProtectGroupReplica::getPg).map(ProtectGroup::getPoType).orElse(11);
        return protectObjectType == 11 ? DrmEnumDefine.RESOURCE_TYPE_E.LUN : DrmEnumDefine.RESOURCE_TYPE_E.NAS;
    }
}

