/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.replica.realtime.impl;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IRealTimeReplicaBuilder;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractReplicaBuilder;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.Set;

public abstract class AbstractReplicaRealTimeBuilder
implements IRealTimeReplicaBuilder {
    private static Log logger = LogFactory.getInstance(AbstractReplicaBuilder.class);

    protected String getSrcDevSN(ProtectGroup protectGroup) {
        String srcDevSN = null;
        for (ProtectObject po : protectGroup.getPolist()) {
            for (ProtectObjectStorageInfo info : po.getUsedStorageResourceSet()) {
                srcDevSN = info.getResourceProviderSN();
            }
        }
        if (VerifyUtil.isEmpty(srcDevSN)) {
            logger.error((Object)"product array is null", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        return srcDevSN;
    }

    protected String getSiteByArraySn(String deviceSN) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource drResource = resourceService.getDrResourceBySn(deviceSN, "ism.deviceType.storage.mainType");
        if (null == drResource) {
            logger.error((Object)("the dr is null: " + deviceSN), 1L);
            return null;
        }
        return drResource.getSiteId();
    }

    public ProtectGroupReplica buildReplica(ActionContext context) {
        logger.error((Object)"method buildReplica should be implemented in subClass.");
        throw new LegoCheckedException(100663460L);
    }

    public ProtectGroupReplica buildReplica(ProtectGroup protectGroup, int protectLocation) {
        logger.error((Object)"method buildReplica should be implemented in subClass.");
        throw new LegoCheckedException(100663460L);
    }

    public int getReplicaType(ProtectGroup protectGroup, int protectLocation) {
        Set schedules = protectGroup.getTemplate().getSchedules();
        if (VerifyUtil.isEmpty((Collection)schedules)) {
            return 3;
        }
        for (Schedule schedule : schedules) {
            if (protectLocation != schedule.getProtectLocation() || ScheduleProtectedType.HYPERCDP.getValue() != schedule.getProtectedType()) continue;
            return 4;
        }
        return 3;
    }
}

