/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.replica.retention.impl;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.RecoveryPlanUse;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.framework.engine.executor.FixedProtectionThreadPool;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.replica.retention.bean.ReplicaRetentionStrategy;
import com.huawei.ism.drm.protection.framework.service.replica.retention.service.IReplicaRetentionStrategyHandler;
import com.huawei.ism.drm.protection.framework.service.replica.retention.util.CheckReplicaTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupTempReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.schedule.sdk.model.RetentionPolicy;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.ArraySnapshot;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class CountReplicaRetentionHandler
implements IReplicaRetentionStrategyHandler {
    public static final String PROTECTLOCATION = "ProtectLocation_";
    private static Log logger = LogFactory.getInstance(CountReplicaRetentionHandler.class);
    private static Pattern pattern = Pattern.compile("ProtectLocation_\\d");
    private static List<Integer> retentionFilter = new ArrayList<Integer>();
    private static Set<Integer> sanSnaphotTemplateTypeSet = new HashSet<Integer>();

    @Override
    public boolean executeStrategy(ProtectGroup pg) {
        ArrayList<ProtectGroupReplica> toDelete = new ArrayList<ProtectGroupReplica>();
        Set<String> usedReplicaIds = this.getUsedReplicaIds(pg);
        for (Schedule schedule : pg.getTemplate().getSchedules()) {
            schedule.setPolicyTemplate(pg.getTemplate());
            RetentionPolicy strategy = schedule.getRetentionPolicy();
            if (null == strategy) continue;
            List<ProtectGroupReplica> tmpDelete = this.getToDeleteReplicas(strategy, schedule, pg.getReplicaList(), usedReplicaIds, null);
            if (this.isSanSnapshotPg(pg)) {
                this.handleSanSnapshotReplicas(strategy, tmpDelete, pg, schedule);
            }
            if (CollectionUtils.isEmpty(tmpDelete)) continue;
            toDelete.addAll(tmpDelete);
        }
        if (!this.isSanSnapshotPg(pg)) {
            this.deleteReplicas(toDelete, pg);
        }
        return true;
    }

    private boolean isSanSnapshotPg(ProtectGroup pg) {
        if (!sanSnaphotTemplateTypeSet.contains(pg.getTemplate().getType())) {
            return false;
        }
        ProtectObject po = (ProtectObject)CommonUtil.getFirstElement((Collection)pg.getPolist());
        ProtectObjectStorageInfo poStorageInfo = (ProtectObjectStorageInfo)CommonUtil.getFirstElement((Collection)po.getUsedStorageResourceSet());
        return DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue() == poStorageInfo.getResourceType().intValue();
    }

    @Override
    public Set<String> getUsedReplicaIds(ProtectGroup pg) {
        HashSet<String> usedReplicaIds = new HashSet<String>();
        IRecoveryPlanService rpService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        List planIdList = rpService.getAssociatedRecoveryPlanListWithProtectGroup(pg.getUuid(), null);
        if (VerifyUtil.isEmpty((Collection)planIdList)) {
            return usedReplicaIds;
        }
        for (String planId : planIdList) {
            RecoveryPlan plan = rpService.getRecoveryPlan(planId, false, false);
            if (null == plan) continue;
            HashSet<Integer> availablePlanStatus = new HashSet<Integer>();
            availablePlanStatus.add(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_RUNNING.getValue());
            availablePlanStatus.add(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_FAILED.getValue());
            availablePlanStatus.add(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_COMPLETED.getValue());
            availablePlanStatus.add(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_RUNNING.getValue());
            availablePlanStatus.add(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_FAILED.getValue());
            if (!availablePlanStatus.contains(plan.getPlanStatus()) && RecoveryPlanUse.INTERNAL_USE.getValue() != plan.getUse().intValue() || null == plan.getGlobalSettings() || !plan.getGlobalSettings().containsKey("REPLICA_ID") || VerifyUtil.isEmpty((String)((String)plan.getGlobalSettings().get("REPLICA_ID")))) continue;
            usedReplicaIds.add((String)plan.getGlobalSettings().get("REPLICA_ID"));
        }
        return usedReplicaIds;
    }

    private void deleteReplicasStorage(ProtectGroup pg, List<ProtectGroupReplica> toDelete) {
        ProtectGroup protectGroup;
        List<ProtectGroupTempReplica> tempReplicaList;
        HashSet<ProtectGroupReplica> replicaSet = new HashSet<ProtectGroupReplica>(toDelete);
        try {
            tempReplicaList = this.queryFailedDeleteReplicaInDB(pg);
            this.addFailedDeleteReplica(replicaSet, tempReplicaList);
            if (VerifyUtil.isEmpty(replicaSet)) {
                return;
            }
            protectGroup = (ProtectGroup)pg.clone();
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("deleteReplicasStorage error!pg name:" + pg.getName()), (Throwable)e);
            this.saveFailedReplica(pg, toDelete);
            return;
        }
        catch (Exception e) {
            logger.error((Object)("deleteReplicasStorage error!pg name:" + pg.getName()));
            this.saveFailedReplica(pg, toDelete);
            return;
        }
        protectGroup.setReplicaList(replicaSet);
        Set<ProtectGroupReplica> failedReplicaSet = ProtectGroupHelper.getInstance().deleteReplica(protectGroup);
        if (!VerifyUtil.isEmpty(tempReplicaList)) {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().deleteAll(tempReplicaList);
        }
        this.printfToDeleteReplicas(pg, replicaSet, failedReplicaSet);
        if (VerifyUtil.isEmpty(failedReplicaSet)) {
            return;
        }
        this.saveFailedReplica(pg, failedReplicaSet);
    }

    private List<ProtectGroupTempReplica> queryFailedDeleteReplicaInDB(ProtectGroup pg) {
        String queryTempReplicaSql = "from ProtectGroupTempReplica where pgId=?";
        List tempReplicaList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(queryTempReplicaSql, new Object[]{pg.getUuid()});
        logger.debug((Object)("pg uuid:" + pg.getUuid()));
        return tempReplicaList;
    }

    private void saveFailedReplica(ProtectGroup pg, Collection<ProtectGroupReplica> failedReplicaSet) {
        logger.warn((Object)("failed to delete replicas:" + pg.getName() + ", to delete size:" + failedReplicaSet.size()));
        HashSet<ProtectGroupTempReplica> deleteFailedReplicaSet = new HashSet<ProtectGroupTempReplica>();
        for (ProtectGroupReplica pgReplica : failedReplicaSet) {
            deleteFailedReplicaSet.add(ProtectGroupTempReplica.toProtectGroupTempReplica((ProtectGroup)pg, (ProtectGroupReplica)pgReplica));
        }
        CommonDAOLocator.getBaseDao().saveOrUpdateAll(deleteFailedReplicaSet);
        logger.info((Object)"success to save deleteFailedReplicas");
    }

    private void addFailedDeleteReplica(Set<ProtectGroupReplica> replicaSet, List<ProtectGroupTempReplica> tempReplicaList) {
        if (VerifyUtil.isEmpty(tempReplicaList)) {
            logger.warn((Object)"tempReplicaList is empty!");
            return;
        }
        for (ProtectGroupTempReplica tempReplica : tempReplicaList) {
            replicaSet.add(tempReplica.toProtectGroupReplica());
        }
    }

    @Override
    public void deleteReplicas(List<ProtectGroupReplica> toDelete, ProtectGroup pg) {
        if (VerifyUtil.isEmpty(toDelete)) {
            return;
        }
        List<String> failedIds = this.deletePgReplicaFromDB(toDelete);
        if (!VerifyUtil.isEmpty(failedIds)) {
            logger.error((Object)String.format("delete replicas failed, cause by visit db exception, replicaIds is %s", failedIds));
            return;
        }
        FixedProtectionThreadPool.submit(FixedProtectionThreadPool.FixedProtectionThreadPoolEnum.PROTECT_DELETE_REPLICA_EXECUTOR, new DeleteReplicaTask(pg, toDelete));
    }

    private List<String> deletePgReplicaFromDB(List<ProtectGroupReplica> toDelete) {
        ArrayList<String> allReplicaIds = new ArrayList<String>();
        for (ProtectGroupReplica replica : toDelete) {
            allReplicaIds.add(replica.getId());
        }
        return this.deleteProtectGroupReplicaFromDBById(allReplicaIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> deleteProtectGroupReplicaFromDBById(List<String> replicaIds) {
        Session session;
        ArrayList<String> failReplicaIds;
        block5: {
            failReplicaIds = new ArrayList<String>();
            if (VerifyUtil.isEmpty(replicaIds)) {
                logger.error((Object)"replicaIds is empty");
                return null;
            }
            session = null;
            Transaction transation = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                if (null == session) break block5;
                transation = session.beginTransaction();
                Query hql = session.createQuery("delete ProtectGroupReplica a where a.id in (:id) ");
                hql.setParameterList("id", replicaIds);
                hql.executeUpdate();
                transation.commit();
            }
            catch (Exception e) {
                try {
                    DBOperationUtil.rollbackSession(session);
                    failReplicaIds.addAll(replicaIds);
                    logger.error((Object)("delete new replica error," + ExceptionUtil.getErrorMessage((Throwable)e)));
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return failReplicaIds;
    }

    private int getMaxReserveSize(RetentionPolicy strategy) {
        return strategy.getTotalCopyies();
    }

    private int getStrategyReplicaSize(ProtectGroup pg, Schedule schedule) {
        List<ProtectGroupReplica> replicaList = this.filterReplicasByLocation(pg.getReplicaList(), schedule);
        return replicaList.size();
    }

    private void handleSanSnapshotReplicas(RetentionPolicy strategy, List<ProtectGroupReplica> list, ProtectGroup pg, Schedule schedule) {
        ProtectGroupReplica protectGroupReplica;
        if (CollectionUtils.isEmpty(list)) {
            list = new ArrayList<ProtectGroupReplica>();
        }
        if (schedule.getProtectedType() == 102) {
            this.deleteSecureSnapshot(list);
            return;
        }
        ArrayList<ProtectGroupReplica> toDelete = new ArrayList<ProtectGroupReplica>();
        Iterator<ProtectGroupReplica> iterator = list.iterator();
        while (iterator.hasNext()) {
            ProtectGroupReplica protectGroupReplica2 = iterator.next();
            if (3 != protectGroupReplica2.getStatus()) continue;
            toDelete.add(protectGroupReplica2);
            iterator.remove();
        }
        int strategyReplicaSize = this.getStrategyReplicaSize(pg, schedule);
        int maxReserveSize = this.getMaxReserveSize(strategy);
        iterator = list.iterator();
        for (int exceedDeleteSize = strategyReplicaSize - maxReserveSize - toDelete.size(); exceedDeleteSize > 0 && iterator.hasNext(); --exceedDeleteSize) {
            protectGroupReplica = iterator.next();
            toDelete.add(protectGroupReplica);
            iterator.remove();
        }
        if (!VerifyUtil.isEmpty(toDelete)) {
            this.deleteReplicas(toDelete, pg);
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            protectGroupReplica = iterator.next();
            if (protectGroupReplica.getStatus() != 0) continue;
            iterator.remove();
        }
    }

    private void deleteSecureSnapshot(List<ProtectGroupReplica> list) {
        logger.info((Object)"Delete secure snapshots: %s ", new Object[]{list});
        if (VerifyUtil.isEmpty(list)) {
            return;
        }
        List<String> failedIds = this.deletePgReplicaFromDB(list);
        if (!VerifyUtil.isEmpty(failedIds)) {
            logger.error((Object)"delete secure replicas failed, cause by visit db exception, replicaIds is %s", new Object[]{failedIds});
        }
    }

    @Override
    public List<ProtectGroupReplica> getToReactivateReplicas(ProtectGroup pg, int protectLocation, Integer differ, Integer type) {
        Schedule schedule = null;
        for (Schedule sc : pg.getTemplate().getSchedules()) {
            if (protectLocation != sc.getProtectLocation() || sc.getProtectedType() != type.intValue()) continue;
            schedule = sc;
            break;
        }
        if (null == schedule) {
            return new ArrayList<ProtectGroupReplica>();
        }
        RetentionPolicy currentStrategy = schedule.getRetentionPolicy();
        if (null == currentStrategy) {
            return new ArrayList<ProtectGroupReplica>();
        }
        Set<String> usedReplicaIds = this.getUsedReplicaIds(pg);
        List<ProtectGroupReplica> replicaList = this.filterReplicasByLocation(pg.getReplicaList(), schedule);
        HashSet<ProtectGroupReplica> replicaSet = new HashSet<ProtectGroupReplica>(replicaList);
        List<ProtectGroupReplica> tmpDelete = this.getToDeleteReplicas(currentStrategy, schedule, replicaSet, usedReplicaIds, differ);
        if (null == tmpDelete) {
            tmpDelete = new ArrayList<ProtectGroupReplica>();
        }
        Collections.sort(tmpDelete, new Comparator<ProtectGroupReplica>(){

            @Override
            public int compare(ProtectGroupReplica pgr0, ProtectGroupReplica pgr1) {
                int power1;
                int status0 = pgr0.getStatus();
                int status1 = pgr1.getStatus();
                int power0 = CountReplicaRetentionHandler.this.getPower(status0);
                if (power0 != (power1 = CountReplicaRetentionHandler.this.getPower(status1))) {
                    Integer powerInteger0 = NumberUtil.convertToInteger((Object)power0);
                    Integer powerInteger1 = NumberUtil.convertToInteger((Object)power1);
                    return powerInteger0.compareTo(powerInteger1);
                }
                return pgr0.compareTo(pgr1);
            }
        });
        Iterator<ProtectGroupReplica> iterator = tmpDelete.iterator();
        while (iterator.hasNext()) {
            ProtectGroupReplica protectGroupReplica = iterator.next();
            if (3 != protectGroupReplica.getStatus()) continue;
            iterator.remove();
        }
        return tmpDelete;
    }

    private int getPower(int status) {
        switch (status) {
            case 3: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 0: {
                return 3;
            }
        }
        logger.error((Object)"the Snap builder don't support the status!", -1L);
        throw new LegoCheckedException(-1L);
    }

    private List<ProtectGroupReplica> getToDeleteReplicas(RetentionPolicy strategy, Schedule schedule, Set<ProtectGroupReplica> replicas, Set<String> usedReplicaIds, Integer differ) {
        List<ProtectGroupReplica> replicaList;
        if (schedule.getProtectedType() == 102 || schedule.isNeedSecureSnapshot().booleanValue()) {
            return this.getToDeleteSecureReplicas(replicas, usedReplicaIds);
        }
        int retentionNumber = strategy.getLatestCopies();
        if (null != differ && (retentionNumber += differ.intValue()) < 0) {
            retentionNumber = 0;
        }
        if ((replicaList = this.filterReplicasByLocation(replicas, schedule)).size() <= retentionNumber) {
            logger.debug((Object)("replica number :" + replicaList.size() + " retentionNumber:" + retentionNumber));
            return null;
        }
        ArrayList<ProtectGroupReplica> toDelete = new ArrayList<ProtectGroupReplica>();
        for (ProtectGroupReplica replica : replicaList) {
            if (1 == replica.getStatus()) continue;
            toDelete.add(replica);
        }
        replicaList.removeAll(toDelete);
        if (replicaList.size() <= retentionNumber) {
            logger.debug((Object)("replica number :" + replicaList.size() + " retentionNumber:" + retentionNumber));
            return toDelete;
        }
        ProtectGroupHelper.getInstance().orderReplicaList(replicaList);
        List<ProtectGroupReplica> exceedLimitReplicas = replicaList.subList(0, replicaList.size() - retentionNumber);
        toDelete.addAll(this.handleExceedLimitReplicas(strategy, exceedLimitReplicas, replicaList));
        this.handleUsedReplicas(usedReplicaIds, toDelete);
        return toDelete;
    }

    private List<ProtectGroupReplica> getToDeleteSecureReplicas(Set<ProtectGroupReplica> replicas, Set<String> usedReplicaIds) {
        ArrayList<ProtectGroupReplica> toDeleteReplicas = new ArrayList<ProtectGroupReplica>();
        long curTime = System.currentTimeMillis();
        for (ProtectGroupReplica replica : replicas) {
            long timeStamp;
            if (replica.getType() != 102 || curTime < (timeStamp = Long.parseLong(replica.getDeadlineTimeStamp()))) continue;
            toDeleteReplicas.add(replica);
        }
        this.handleUsedReplicas(usedReplicaIds, toDeleteReplicas);
        return toDeleteReplicas;
    }

    private void handleUsedReplicas(Set<String> usedReplicaIds, List<ProtectGroupReplica> toDelete) {
        if (VerifyUtil.isEmpty(toDelete) || VerifyUtil.isEmpty(usedReplicaIds)) {
            return;
        }
        logger.info((Object)("there are some Replica used by recoveryplan:" + usedReplicaIds));
        Iterator<ProtectGroupReplica> itr = toDelete.iterator();
        while (itr.hasNext()) {
            ProtectGroupReplica replica = itr.next();
            if (!usedReplicaIds.contains(replica.getId())) continue;
            itr.remove();
        }
    }

    private List<ProtectGroupReplica> filterReplicasByLocation(Set<ProtectGroupReplica> replicas, Schedule schedule) {
        if (null == schedule) {
            logger.debug((Object)"schedule is null.");
            return new ArrayList<ProtectGroupReplica>(replicas);
        }
        ArrayList<ProtectGroupReplica> result = new ArrayList<ProtectGroupReplica>();
        for (ProtectGroupReplica replica : replicas) {
            if (!ProtectGroupUtil.isLocalStorageReplica(replica) || replica.getProtectLocation() != schedule.getProtectLocation() || !ScheduleProtectedType.isSameType((int)replica.getType(), (int)schedule.getProtectedType()) || null != replica.getGeneration() && replica.getGeneration() != 1) continue;
            result.add(replica);
        }
        return result;
    }

    private List<ProtectGroupReplica> handleExceedLimitReplicas(RetentionPolicy strategy, List<ProtectGroupReplica> exceedLimitReplicas, List<ProtectGroupReplica> allReplicas) {
        ArrayList<ProtectGroupReplica> retentionReplicas = new ArrayList<ProtectGroupReplica>();
        if (exceedLimitReplicas.isEmpty()) {
            return retentionReplicas;
        }
        retentionReplicas.addAll(this.getRetentionReplicas(strategy, allReplicas, "dailyRetention"));
        retentionReplicas.addAll(this.getRetentionReplicas(strategy, allReplicas, "weeklyRetention"));
        retentionReplicas.addAll(this.getRetentionReplicas(strategy, allReplicas, "monthlyRetention"));
        ArrayList<ProtectGroupReplica> toDelete = new ArrayList<ProtectGroupReplica>();
        for (ProtectGroupReplica replica : exceedLimitReplicas) {
            if (retentionReplicas.contains(replica)) continue;
            toDelete.add(replica);
        }
        return toDelete;
    }

    private List<ProtectGroupReplica> getRetentionReplicas(RetentionPolicy strategy, List<ProtectGroupReplica> allReplicas, String retentionType) {
        int retentionNumber = -1;
        if ("dailyRetention".equals(retentionType)) {
            retentionNumber = strategy.getDailyCopies();
        } else if ("weeklyRetention".equals(retentionType)) {
            retentionNumber = strategy.getWeeklyCopies();
        } else if ("monthlyRetention".equals(retentionType)) {
            retentionNumber = strategy.getMonthlyCopyies();
        }
        ArrayList<ProtectGroupReplica> allAvailableReplicas = new ArrayList<ProtectGroupReplica>();
        if (retentionNumber <= 0) {
            logger.debug((Object)"retentionNumber <= 0");
            return allAvailableReplicas;
        }
        for (int i = 0; i < retentionNumber; ++i) {
            String beginDateStr = this.getTimeBefore(i + 1, retentionType);
            String endDateStr = this.getTimeBefore(i, retentionType);
            if (VerifyUtil.isEmpty((String)endDateStr) || VerifyUtil.isEmpty((String)beginDateStr)) {
                logger.error((Object)"beginDateStr or endDateStr is null");
                throw new LegoCheckedException(1073947394L);
            }
            ProtectGroupReplica lastestReplica = this.lastestReplicaInPeriod(allReplicas, beginDateStr, endDateStr);
            if (VerifyUtil.isEmpty((Object)lastestReplica)) continue;
            allAvailableReplicas.add(lastestReplica);
        }
        return allAvailableReplicas;
    }

    private String getTimeBefore(int count, String retentionType) {
        logger.debug((Object)("retentionType:" + retentionType + ", count:" + count));
        String result = null;
        switch (retentionType) {
            case "dailyRetention": {
                result = String.valueOf(CountReplicaRetentionHandler.getDateBefore(count).getTime());
                break;
            }
            case "weeklyRetention": {
                result = String.valueOf(CountReplicaRetentionHandler.getWeekBefore(count).getTime());
                break;
            }
            case "monthlyRetention": {
                result = String.valueOf(CountReplicaRetentionHandler.getMonthBefore(count).getTime());
                break;
            }
        }
        return result;
    }

    private ProtectGroupReplica lastestReplicaInPeriod(List<ProtectGroupReplica> allReplicas, String beginDateStr, String endDateStr) {
        ProtectGroupReplica lastestReplica = null;
        for (ProtectGroupReplica replica : allReplicas) {
            if (replica.getTimeStamp().compareTo(beginDateStr) < 0 || replica.getTimeStamp().compareTo(endDateStr) >= 0) continue;
            if (VerifyUtil.isEmpty(lastestReplica)) {
                lastestReplica = replica;
                continue;
            }
            if (replica.getTimeStamp().compareTo(lastestReplica.getTimeStamp()) <= 0) continue;
            lastestReplica = replica;
        }
        return lastestReplica;
    }

    private static Date getMonthBefore(int day) {
        logger.debug((Object)("day:" + day));
        Calendar now = Calendar.getInstance();
        now.set(11, 0);
        now.set(12, 0);
        now.set(13, 0);
        now.set(14, 0);
        now.set(5, 1);
        now.setTime(now.getTime());
        now.add(2, 0 - day);
        return now.getTime();
    }

    private static Date getWeekBefore(int day) {
        logger.debug((Object)("day:" + day));
        Calendar now = Calendar.getInstance();
        now.set(11, 0);
        now.set(12, 0);
        now.set(13, 0);
        now.set(14, 0);
        if (now.get(7) == 1) {
            now.add(3, -1 - day);
        } else {
            now.add(3, 0 - day);
        }
        now.set(7, 2);
        return now.getTime();
    }

    private static Date getDateBefore(int day) {
        logger.debug((Object)("day:" + day));
        Calendar now = Calendar.getInstance();
        now.set(11, 0);
        now.set(12, 0);
        now.set(13, 0);
        now.set(14, 0);
        now.setTime(now.getTime());
        now.add(5, 0 - day);
        return now.getTime();
    }

    @Override
    public Set<ReplicaRetentionStrategy> convertReplicaStrategy(ProtectGroup pg) {
        HashSet<ReplicaRetentionStrategy> result = new HashSet<ReplicaRetentionStrategy>();
        String strategyValue = (String)pg.getTemplate().getProps().get("ReplicaRetentionPolicy");
        JSONObject replicaRetentionPolicyJsonValue = JSONObject.fromObject((Object)strategyValue);
        Set jsonEntry = replicaRetentionPolicyJsonValue.keySet();
        if (VerifyUtil.isEmpty((Collection)jsonEntry)) {
            logger.info((Object)"jsonEntry is empty!");
            this.dealUpgrade(pg, result);
            return result;
        }
        for (String key : jsonEntry) {
            ReplicaRetentionStrategy tmp = new ReplicaRetentionStrategy();
            tmp.setPgId(pg.getUuid());
            tmp.setType(this.getType());
            int protectLocation = NumberUtil.convertToInteger((Object)key.substring(key.length() - 1, key.length()));
            tmp.setProtectLocation(protectLocation);
            String protectLocationJsonString = replicaRetentionPolicyJsonValue.getString(key);
            JSONObject protectLocationJsonValue = JSONObject.fromObject((Object)protectLocationJsonString).getJSONObject("props");
            Map<String, String> props = tmp.getProps();
            props.put("dailyRetention", this.getRetentionCount(protectLocationJsonValue, "dailyRetention"));
            props.put("weeklyRetention", this.getRetentionCount(protectLocationJsonValue, "weeklyRetention"));
            props.put("monthlyRetention", this.getRetentionCount(protectLocationJsonValue, "monthlyRetention"));
            props.put("retentionNumber", this.getRetentionNumber(pg.getTemplate().getProps(), protectLocation));
            tmp.setProps(props);
            result.add(tmp);
        }
        return result;
    }

    private void dealUpgrade(ProtectGroup pg, Set<ReplicaRetentionStrategy> result) {
        Set schedules = pg.getTemplate().getSchedules();
        HashSet<Integer> protectLocationSet = new HashSet<Integer>();
        for (Schedule schedule : schedules) {
            protectLocationSet.add(schedule.getProtectLocation());
        }
        for (Integer protectLocation : protectLocationSet) {
            ReplicaRetentionStrategy tmp = new ReplicaRetentionStrategy();
            tmp.setPgId(pg.getUuid());
            tmp.setType(this.getType());
            tmp.setProtectLocation(protectLocation);
            HashMap<String, String> props = new HashMap<String, String>();
            String notSetValue = "-1";
            props.put("dailyRetention", notSetValue);
            props.put("weeklyRetention", notSetValue);
            props.put("monthlyRetention", notSetValue);
            props.put("retentionNumber", this.getRetentionNumber(pg.getTemplate().getProps(), protectLocation));
            tmp.setProps(props);
            result.add(tmp);
        }
    }

    private String getRetentionNumber(Map<String, String> props, int protectLocation) {
        logger.debug((Object)"Do getRetentionNumber. protectLocation: %s", new Object[]{String.valueOf(protectLocation)});
        if (props.containsKey("PP_SNAPSHOT_COUNT" + protectLocation)) {
            return props.get("PP_SNAPSHOT_COUNT" + protectLocation);
        }
        return props.get("PP_SNAPSHOT_COUNT");
    }

    @Override
    public boolean checkReplicaStrategy(ProtectGroup pg) {
        if (!retentionFilter.contains(pg.getTemplate().getType())) {
            logger.info((Object)"Template type not support: %s", new Object[]{String.valueOf(pg.getTemplate().getType())});
            return false;
        }
        return true;
    }

    private String getRetentionCount(JSONObject protectLocationJsonValue, String key) {
        if (protectLocationJsonValue == null || !protectLocationJsonValue.containsKey((Object)key)) {
            return "-1";
        }
        return protectLocationJsonValue.getString(key);
    }

    @Override
    public boolean checkProtectLocationValue(ProtectGroup protectGroup, String value, int location) {
        Schedule schedule2;
        JSONObject protectLocationJsonValue = JSONObject.fromObject((Object)value);
        if (!protectLocationJsonValue.containsKey((Object)"type") || !protectLocationJsonValue.getString("type").equals(this.getType())) {
            return false;
        }
        if (!protectLocationJsonValue.containsKey((Object)"props")) {
            return false;
        }
        String propsJsonString = protectLocationJsonValue.getString("props");
        JSONObject propsJson = JSONObject.fromObject((Object)propsJsonString);
        String daily = "dailyRetention";
        String weekly = "weeklyRetention";
        String monthly = "monthlyRetention";
        List schedules = protectGroup.getTemplate().getSchedules().stream().filter(schedule -> schedule.getProtectLocation() == location && schedule.getScheduleMode() == 0).collect(Collectors.toList());
        long retentionNumber = 0L;
        String retentionNumberStr = this.getRetentionNumber(protectGroup.getTemplate().getProps(), location);
        if (!VerifyUtil.isEmpty((String)retentionNumberStr)) {
            retentionNumber = NumberUtil.convertToLong((Object)retentionNumberStr);
        }
        if (!VerifyUtil.isEmpty(schedules) && (schedule2 = (Schedule)schedules.get(0)).getProtectedType() == ScheduleProtectedType.HYPERCDP.getValue() && schedule2.getPeriodType() == 5) {
            if (retentionNumber > 60000L) {
                return false;
            }
            return this.compareTheJsonValue(propsJson, daily, 256) && this.compareTheJsonValue(propsJson, weekly, 256) && this.compareTheJsonValue(propsJson, monthly, 256);
        }
        if (retentionNumber > 2048L) {
            return false;
        }
        return this.compareTheJsonValue(propsJson, daily, 365) && this.compareTheJsonValue(propsJson, weekly, 52) && this.compareTheJsonValue(propsJson, monthly, 60);
    }

    private boolean compareTheJsonValue(JSONObject protectLocationJsonValue, String key, int upperLimit) {
        return protectLocationJsonValue.containsKey((Object)key) && NumberUtil.convertToInteger((Object)protectLocationJsonValue.getString(key)) >= 0 && NumberUtil.convertToInteger((Object)protectLocationJsonValue.getString(key)) <= upperLimit;
    }

    @Override
    public String getType() {
        return "0";
    }

    private void printfToDeleteReplicas(ProtectGroup pg, Set<ProtectGroupReplica> toDelete, Set<ProtectGroupReplica> failedReplicaSet) {
        logger.info((Object)("delete replicas:" + pg.getName() + ", to delete size:" + toDelete.size()));
        for (ProtectGroupReplica replica : toDelete) {
            String formatTime = "";
            try {
                if (!VerifyUtil.isEmpty((String)replica.getTimeStamp())) {
                    Date date = new Date(NumberUtil.convertToLong((Object)replica.getTimeStamp(), (long)0L));
                    formatTime = date.toString();
                }
            }
            catch (Exception e) {
                logger.error((Object)("get formatTime error! error:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
            if (!VerifyUtil.isEmpty(failedReplicaSet) && failedReplicaSet.contains(replica)) {
                logger.warn((Object)("fail to delete replica! replica id: " + replica.getId() + " time:" + formatTime));
                continue;
            }
            logger.info((Object)("success to delete replica " + replica.getId() + " time:" + formatTime));
        }
    }

    private void cancelReplica(ProtectGroup pg, ProtectGroupReplica protectGroupReplica) {
        if (null == pg || null == protectGroupReplica) {
            logger.error((Object)"error param for cancelReplica!");
            return;
        }
        Set poReplicaSet = protectGroupReplica.getReplicas();
        if (VerifyUtil.isEmpty((Collection)poReplicaSet)) {
            return;
        }
        for (ProtectObjectReplica poReplica : poReplicaSet) {
            if (VerifyUtil.isEmpty((Collection)poReplica.getStorageInfos())) continue;
            for (RelicaStorageInfo stor : poReplica.getStorageInfos()) {
                LocalStorageReplica localStor = (LocalStorageReplica)stor;
                String arraySn = localStor.getSrcStorageProviderSN();
                String snapshotId = localStor.getStorageId();
                StorageSnapshotManagerProxy storageSnapshotManagerProxy = StorageSnapshotManagerProxy.getInstance();
                IStorageSnapshotManager proxy = storageSnapshotManagerProxy.getStorageSnapshotMgrByDevId(arraySn);
                if (proxy == null) {
                    logger.error((Object)("IStorageSnapshotManager is null. arraySn:" + arraySn));
                    throw new LegoCheckedException(1073947394L);
                }
                ArraySnapshot arraySnapshot = new ArraySnapshot();
                arraySnapshot.setId(snapshotId);
                OperationResult optResult = proxy.disableSnapshot(arraySn, (Snapshot)arraySnapshot);
                if (null == optResult) {
                    logger.error((Object)"Disable snapshot error", 90160758784001L);
                    continue;
                }
                if (optResult.isSuccess()) continue;
                logger.error((Object)"Disable snapshot error", 90160758784001L);
                throw new LegoCheckedException(1073948681L);
            }
        }
        CheckReplicaTools.updateProtectGroupReplicaStatus(protectGroupReplica.getId(), DrmEnumDefine.REPLICA_STATUS.UNACTIVE_STATUS.getValue());
    }

    static {
        retentionFilter.add(2);
        retentionFilter.add(14);
        retentionFilter.add(19);
        retentionFilter.add(17);
        retentionFilter.add(28);
        retentionFilter.add(30);
        retentionFilter.add(31);
        retentionFilter.add(32);
        retentionFilter.add(33);
        retentionFilter.add(40);
        retentionFilter.add(41);
        retentionFilter.add(42);
        retentionFilter.add(43);
        retentionFilter.add(44);
        retentionFilter.add(45);
        sanSnaphotTemplateTypeSet.add(PolicyTemplateType.POLICY_TEMPLATE_E.ARRAY_SNAPSHOT.getValue());
        sanSnaphotTemplateTypeSet.add(PolicyTemplateType.POLICY_TEMPLATE_E.ARRAY_HYPER_METRO_SNAPSHOT.getValue());
        sanSnaphotTemplateTypeSet.add(PolicyTemplateType.POLICY_TEMPLATE_E.ARRAY_SAN_AIRGAP_SNAPSHOT.getValue());
        sanSnaphotTemplateTypeSet.addAll(PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE);
    }

    class CancelSnapshotTask
    implements Callable<Boolean> {
        private ProtectGroup pg;
        private List<ProtectGroupReplica> replicaList;

        public CancelSnapshotTask(ProtectGroup pg, List<ProtectGroupReplica> replicaList) {
            this.pg = pg;
            this.replicaList = replicaList;
        }

        @Override
        public Boolean call() {
            boolean result = true;
            if (!VerifyUtil.isEmpty(this.replicaList)) {
                for (ProtectGroupReplica protectGroupReplica : this.replicaList) {
                    try {
                        CountReplicaRetentionHandler.this.cancelReplica(this.pg, protectGroupReplica);
                    }
                    catch (LegoCheckedException e) {
                        logger.error((Object)("cancelReplica error for replica:" + protectGroupReplica.getId()));
                    }
                }
            }
            return result;
        }
    }

    class DeleteReplicaTask
    implements Callable<Boolean> {
        private ProtectGroup pg;
        private List<ProtectGroupReplica> replicaList;

        public DeleteReplicaTask(ProtectGroup pg, List<ProtectGroupReplica> replicaList) {
            this.pg = pg;
            this.replicaList = replicaList;
        }

        @Override
        public Boolean call() {
            boolean result = true;
            try {
                CountReplicaRetentionHandler.this.deleteReplicasStorage(this.pg, this.replicaList);
            }
            catch (Exception e) {
                logger.error((Object)("delete replicas storage failed!pgName:" + this.pg.getName() + ", exception:" + ExceptionUtil.getErrorMessage((Throwable)e)));
                result = false;
            }
            return result;
        }
    }
}

