/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.AbstractPgLockingCustomPreProcessor;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.framework.task.FixedRecoveryThreadPool;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DisasterRecoveryPgLockingCustomPreProcessor
extends AbstractPgLockingCustomPreProcessor {
    @Override
    public Map<String, Object> process(final RecoveryPlan plan) {
        boolean lockResult;
        HashMap<String, Object> result;
        block11: {
            result = new HashMap<String, Object>();
            final IRecoveryProcessHandler recoveryProcHandler = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
            lockResult = false;
            try {
                Future<Boolean> future = FixedRecoveryThreadPool.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return recoveryProcHandler.lockProtectGroups(plan.getProtectGroups());
                    }
                });
                lockResult = future.get(40L, TimeUnit.SECONDS);
            }
            catch (LegoCheckedException ex) {
                this.getLogger().error((Object)("lock protect group failed, planId=" + plan.getUuid()), (Throwable)ex);
                if (this.isHCStype(plan)) {
                    ExceptionUtil.rethrowException((Throwable)ex, (String)("HCS type! get po lock failed" + plan.getUuid()), (long)1073948693L, (String[])new String[0], (Log)this.getLogger());
                }
            }
            catch (InterruptedException e1) {
                this.getLogger().error((Object)("lock protect group failed, planId=" + plan.getUuid()), (Throwable)e1);
                if (this.isHCStype(plan)) {
                    ExceptionUtil.rethrowException((Throwable)e1, (String)("HCS type! get po lock failed" + plan.getUuid()), (long)1073948693L, (String[])new String[0], (Log)this.getLogger());
                }
            }
            catch (ExecutionException e2) {
                this.getLogger().error((Object)("lock protect group failed, planId=" + plan.getUuid()), (Throwable)e2);
                if (this.isHCStype(plan)) {
                    ExceptionUtil.rethrowException((Throwable)e2, (String)("HCS type! get po lock failed" + plan.getUuid()), (long)1073948693L, (String[])new String[0], (Log)this.getLogger());
                }
            }
            catch (TimeoutException e3) {
                this.getLogger().error((Object)("lock protect group failed, planId=" + plan.getUuid()), (Throwable)e3);
                if (!this.isHCStype(plan)) break block11;
                ExceptionUtil.rethrowException((Throwable)e3, (String)("HCS type! get po lock failed" + plan.getUuid()), (long)1073948693L, (String[])new String[0], (Log)this.getLogger());
            }
        }
        if (lockResult) {
            result.put("LockProtectGroup", lockResult);
        }
        return result;
    }

    private boolean isHCStype(RecoveryPlan plan) {
        Set protectGroups = plan.getProtectGroups();
        for (ProtectGroup protectGroup : protectGroups) {
            if (!PolicyTemplateType.OPENSTACK_POLICYTEMPLATE.contains(protectGroup.getTemplate().getType())) continue;
            return true;
        }
        return false;
    }

    public String getType() {
        return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.name();
    }
}

