/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.operation.sdk.model.OperationResultBill;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.recovery.framework.process.IReplicationRecoveryTaskConstructor;
import com.huawei.ism.drm.recovery.framework.process.ParameterEntity;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageVstoreReplicationPairManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageVstoreReplicationPairManager;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.unistor.sdk.model.VstoreReplicationPair;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class RecoveryProcessHandler
implements IRecoveryProcessHandler,
IReplicationRecoveryTaskConstructor {
    private static Log logger = LogFactory.getInstance(RecoveryProcessHandler.class);
    private ISiteService siteService;
    private IRecoveryPlanService recoveryPlanService;
    private IRecoveryResourceService recoveryService;
    private IMoDao moDao;
    private IReplicationRecoveryTaskConstructor replicationRecoveryTaskConstructor;

    public void setSiteService(ISiteService siteService) {
        this.siteService = siteService;
    }

    public void setRecoveryPlanService(IRecoveryPlanService recoveryPlanService) {
        this.recoveryPlanService = recoveryPlanService;
    }

    public IRecoveryPlanService getRecoveryPlanService() {
        return this.recoveryPlanService;
    }

    public ISiteService getSiteService() {
        return this.siteService;
    }

    public void setMoDao(IMoDao moDao) {
        this.moDao = moDao;
    }

    public IMoDao getMoDao() {
        return this.moDao;
    }

    public void setRecoveryService(IRecoveryResourceService recoveryService) {
        this.recoveryService = recoveryService;
    }

    public IRecoveryResourceService getRecoveryService() {
        return this.recoveryService;
    }

    public IReplicationRecoveryTaskConstructor getReplicationRecoveryTaskConstructor() {
        return this.replicationRecoveryTaskConstructor;
    }

    public void setReplicationRecoveryTaskConstructor(IReplicationRecoveryTaskConstructor replicationRecoveryTaskConstructor) {
        this.replicationRecoveryTaskConstructor = replicationRecoveryTaskConstructor;
    }

    public boolean lockProtectGroups(Set<ProtectGroup> pgs) {
        boolean result = false;
        if (VerifyUtil.isEmpty(pgs)) {
            logger.error((Object)"Invalid parameter", 90160758784001L);
            return result;
        }
        Iterator<ProtectGroup> iterator = pgs.iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = iterator.next();
        Site productionSite = this.siteService.getSiteById(pg.getProductSiteId());
        String[] pgIds = RecoveryProcessUtil.getProtectGroupIds(pgs);
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        result = 0 == productionSite.getSiteType() ? pgService.lockProtectGroup(pgIds) : this.lockRemoteProtectGroup(productionSite, pgIds);
        logger.info((Object)("lock protect groups. Result:" + result + ",Site:" + productionSite.getName() + "Pg:" + pg.getName()), 90160758784000L);
        return result;
    }

    public boolean unlockProtectGroups(Set<ProtectGroup> pgs) {
        boolean result = false;
        if (VerifyUtil.isEmpty(pgs)) {
            logger.error((Object)"Invalid parameter", 90160758784001L);
            return result;
        }
        String[] pgIds = RecoveryProcessUtil.getProtectGroupIds(pgs);
        Iterator<ProtectGroup> iterator = pgs.iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = iterator.next();
        Site productionSite = this.siteService.getSiteById(pg.getProductSiteId());
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        if (0 == productionSite.getSiteType()) {
            for (String pgId : pgIds) {
                ProtectionJobUtil.getInstance().releaseLockPg(pgId);
            }
            result = pgService.unlockProtectGroup(pgIds);
        } else {
            result = this.unlockRemoteProtectGroup(productionSite, pgIds);
        }
        logger.info((Object)("Unlock protect groups. Result:" + result + ",Site:" + productionSite.getName() + "Pg:" + pg.getName()), 90160758784000L);
        return result;
    }

    public Collection<RecoveryTask> getRecoveryTasks(RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null) {
            logger.error((Object)"Invalid parameter", 90160758784001L);
            return new ArrayList<RecoveryTask>();
        }
        Set protectGroups = recoveryPlan.getProtectGroups();
        if (VerifyUtil.isEmpty((Collection)protectGroups)) {
            logger.error((Object)("There is no protect groups. planName:" + recoveryPlan.getName()), 90160758784001L);
            return new ArrayList<RecoveryTask>();
        }
        HashMap<String, String> poAndHostMap = new HashMap<String, String>();
        HashMap<String, Integer> poAndTypeMap = new HashMap<String, Integer>();
        Map<String, String> pgAndHostMap = this.getDisasterHostOrGroupSettings(recoveryPlan.getPlanId(), recoveryPlan.getRecoverySettings());
        for (ProtectGroup protectGroup : protectGroups) {
            String hostOrGroupId = pgAndHostMap.get(protectGroup.getUuid());
            Set protectObjs = protectGroup.getPolist();
            for (ProtectObject po : protectObjs) {
                poAndHostMap.put(po.getUuid(), hostOrGroupId);
                poAndTypeMap.put(po.getUuid(), po.getPoType());
            }
        }
        ParameterEntity paramEntity = new ParameterEntity();
        paramEntity.setRecoveryPlan(recoveryPlan);
        paramEntity.setPoAndHostMap(poAndHostMap);
        paramEntity.setPoAndTypeMap(poAndTypeMap);
        HashMap<String, RecoveryTask> recoveryTasks = new HashMap<String, RecoveryTask>();
        String createByReplicationPairOnly = Optional.ofNullable(recoveryPlan.getGlobalSettings()).map(map -> (String)map.get("creteRecoveryTaskByReplicationPairOnly")).orElse(String.valueOf(Boolean.FALSE));
        for (ProtectGroup protectGroup : protectGroups) {
            Site productionSite = this.siteService.getSiteById(protectGroup.getProductSiteId());
            paramEntity.setProductionSite(productionSite);
            paramEntity.getExtendParams().put("creteRecoveryTaskByReplicationPairOnly", createByReplicationPairOnly);
            this.constructRecoveryTasks(paramEntity, protectGroup, recoveryTasks);
        }
        this.handleTaskRelation(recoveryPlan, recoveryTasks);
        return recoveryTasks.values();
    }

    private void handleTaskRelation(RecoveryPlan recoveryPlan, Map<String, RecoveryTask> recoveryTasks) {
        String isReverseSync = (String)recoveryPlan.getGlobalSettings().get("IS_REVERSE_SYNC");
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        int templateType = pg.getTemplate().getType();
        if (PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(templateType)) {
            this.calcTaskRelation(templateType, pg, recoveryTasks.values(), isReverseSync);
        } else {
            Collection<RecoveryTask> tasks = recoveryTasks.values();
            for (RecoveryTask task : tasks) {
                this.calcTaskCascadeRelation(tasks, task);
                this.calcTaskParallelRelation(tasks, task);
            }
        }
    }

    private void calcTaskRelation(int templateType, ProtectGroup pg, Collection<RecoveryTask> tasks, String isReverseSync) {
        String siteInfoListStr = (String)pg.getProps().get("PROP_KEY_SITE_INFO");
        if (VerifyUtil.isEmpty((String)siteInfoListStr)) {
            logger.error((Object)("4DC no site info:" + pg.getName()));
            return;
        }
        List siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class);
        if (PolicyTemplateType.REP_4DC_CASCADE_POLICYTEMPLATE.contains(templateType)) {
            List<RecoveryTask> oneTaskList = tasks.stream().filter(task -> ((SiteInfo)siteInfoList.get(1)).getSiteIdSet().contains(task.getDisasterSite().getSiteId())).collect(Collectors.toList());
            List<RecoveryTask> twoTaskList = tasks.stream().filter(task -> ((SiteInfo)siteInfoList.get(2)).getSiteIdSet().contains(task.getDisasterSite().getSiteId())).collect(Collectors.toList());
            if ("true".equals(isReverseSync)) {
                twoTaskList.forEach(twoTask -> {
                    RecoveryTask oneTask = this.getRecoveryTaskByTaskList((RecoveryTask)twoTask, oneTaskList);
                    twoTask.getCascadeTasks().add(oneTask);
                    oneTask.setAssociatedTask(twoTask);
                });
            } else {
                oneTaskList.forEach(oneTask -> {
                    RecoveryTask twoTask = this.getRecoveryTaskByTaskList((RecoveryTask)oneTask, twoTaskList);
                    oneTask.getCascadeTasks().add(twoTask);
                    twoTask.setAssociatedTask(oneTask);
                });
            }
        } else if (PolicyTemplateType.REP_4DC_CONCURRENT_POLICYTEMPLATE.contains(templateType)) {
            List<RecoveryTask> oneTaskList = tasks.stream().filter(task -> ((SiteInfo)siteInfoList.get(1)).getSiteIdSet().contains(task.getDisasterSite().getSiteId())).collect(Collectors.toList());
            List twoTaskList = tasks.stream().filter(task -> ((SiteInfo)siteInfoList.get(2)).getSiteIdSet().contains(task.getDisasterSite().getSiteId())).collect(Collectors.toList());
            oneTaskList.forEach(oneTask -> {
                RecoveryTask twoTask = this.getRecoveryTaskByTaskList((RecoveryTask)oneTask, twoTaskList);
                if (oneTask.getSrcDeviceId().equals(twoTask.getSrcDeviceId())) {
                    oneTask.getCascadeTasks().add(twoTask);
                } else {
                    oneTask.getParallelTasks().add(twoTask);
                }
                twoTask.setAssociatedTask(oneTask);
            });
        }
    }

    private RecoveryTask getRecoveryTaskByTaskList(RecoveryTask oneTask, List<RecoveryTask> twoTaskList) {
        return twoTaskList.stream().filter(task -> {
            for (String srcStorageWwn : task.getSrcStorageWwns()) {
                if (!oneTask.getSrcStorageWwns().contains(srcStorageWwn)) continue;
                return true;
            }
            return false;
        }).findFirst().get();
    }

    @Override
    public void checkRecoveryTasks(Collection<RecoveryTask> recoveryTasks, RecoveryPlan recoveryPlan, RecoveryProcessor processor) {
        if (this.replicationRecoveryTaskConstructor != null) {
            this.replicationRecoveryTaskConstructor.checkRecoveryTasks(recoveryTasks, recoveryPlan, processor);
        }
    }

    public Collection<RecoveryTask> getLocalRecoveryTasks(RecoveryProcessorContext context) {
        HashMap<String, RecoveryTask> recoveryTasks = new HashMap<String, RecoveryTask>();
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        ProtectGroup protectGroup = context.getProtectGroup();
        ProtectGroupReplica pgReplica = context.getProtectGroupReplica();
        if (null == recoveryPlan || null == protectGroup || null == pgReplica) {
            logger.error((Object)"Invalid parameter", 90160758784001L);
            return new ArrayList<RecoveryTask>();
        }
        String hostOrGroupId = (String)recoveryPlan.getGlobalSettings().get("PG_DISASTER_HOST");
        Set<ProtectObject> poList = RecoveryProcessUtil.getRecoveryProtectObjects(protectGroup, pgReplica, null);
        Map<String, String> poAndHostMap = this.constructPoAndHostMap(poList, hostOrGroupId);
        Site productionSite = this.siteService.getSiteById(RecoveryServiceUtil.getProductSiteId(recoveryPlan));
        ParameterEntity paramEntity = new ParameterEntity();
        paramEntity.setRecoveryPlan(recoveryPlan);
        paramEntity.setProductionSite(productionSite);
        paramEntity.setDisasterSite(productionSite);
        paramEntity.setPoAndHostMap(poAndHostMap);
        paramEntity.setPgReplica(pgReplica);
        Set poReplicas = pgReplica.getReplicas();
        for (ProtectObjectReplica poReplica : poReplicas) {
            this.constructLocalRecoveryTasks(paramEntity, poReplica, recoveryTasks);
        }
        return recoveryTasks.values();
    }

    public OperationResultBill swap(String replicationId, String srcDeviceId, String tgtDeviceId, boolean isConsistentGroup, boolean onlySplit) {
        OperationResultBill bill = new OperationResultBill();
        if (VerifyUtil.isEmpty((String)replicationId) || VerifyUtil.isEmpty((String)srcDeviceId) || VerifyUtil.isEmpty((String)tgtDeviceId)) {
            logger.error((Object)("Invalid parameter. " + this.generateLogMsg(replicationId, srcDeviceId, tgtDeviceId, isConsistentGroup)), 90160758784001L);
            bill.addFailedOperationResult("ism.drm.swap.replication.operation", 1073947393L, new String[0]);
            return bill;
        }
        ReplicationRelation replication = this.recoveryService.queryReplication(srcDeviceId, tgtDeviceId, replicationId, isConsistentGroup);
        if (null != replication) {
            try {
                StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
                OperationResult result = onlySplit ? proxy.splitReplication(srcDeviceId, tgtDeviceId, replicationId, isConsistentGroup) : proxy.setSecondaryLunReadWrite(srcDeviceId, tgtDeviceId, replicationId, isConsistentGroup);
                if (null == result) {
                    result = new OperationResult("ism.drm.swap.replication.operation", true, false, new String[]{replication.getReplicationId()});
                }
                bill.addOperationResult(result);
            }
            catch (Exception e) {
                logger.error((Object)("Swap replication failed. " + this.generateLogMsg(replicationId, srcDeviceId, tgtDeviceId, isConsistentGroup) + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                bill.addFailedOperationResult("ism.drm.swap.replication.operation", 1073948674L, new String[]{replication.getReplicationId()});
            }
        } else {
            bill.addFailedOperationResult("ism.drm.swap.replication.operation", isConsistentGroup ? 1073948767L : 1073948677L, new String[]{replicationId});
        }
        return bill;
    }

    public OperationResultBill forceSwap(String replicationId, String srcDeviceId, String tgtDeviceId, boolean isConsistentGroup, boolean onlySplit) {
        OperationResultBill bill = new OperationResultBill();
        if (VerifyUtil.isEmpty((String)replicationId) || VerifyUtil.isEmpty((String)srcDeviceId) || VerifyUtil.isEmpty((String)tgtDeviceId)) {
            logger.error((Object)("Invalid parameter. " + this.generateLogMsg(replicationId, srcDeviceId, tgtDeviceId, isConsistentGroup)), 90160758784001L);
            bill.addFailedOperationResult("ism.drm.swap.replication.operation", 1073947393L, new String[0]);
            return bill;
        }
        try {
            OperationResult result;
            StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
            if (onlySplit) {
                proxy.splitReplication(tgtDeviceId, tgtDeviceId, replicationId, isConsistentGroup);
                result = new OperationResult("ism.business.replication.splitReplicationGroup", true, true, new String[]{tgtDeviceId});
            } else {
                result = proxy.forceSwitchReplication(srcDeviceId, tgtDeviceId, replicationId, isConsistentGroup);
            }
            bill.addOperationResult(result);
        }
        catch (Exception e) {
            logger.error((Object)("Force swap replication failed. " + this.generateLogMsg(replicationId, srcDeviceId, tgtDeviceId, isConsistentGroup) + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            bill.addFailedOperationResult("ism.drm.swap.replication.operation", 1073948675L, new String[]{replicationId});
        }
        return bill;
    }

    public OperationResultBill synchronize(String replicationId, String srcDeviceId, String tgtDeviceId, boolean isConsistentGroup) {
        this.checkReplicationOperationParameters(replicationId, srcDeviceId, tgtDeviceId, isConsistentGroup);
        OperationResultBill bill = new OperationResultBill();
        ReplicationRelation replication = this.recoveryService.queryReplication(srcDeviceId, tgtDeviceId, replicationId, isConsistentGroup);
        if (VerifyUtil.isEmpty((Object)replication)) {
            logger.error((Object)"The replication is null: %s,tgtDeviceId: %s, replicationId: %s", new Object[]{srcDeviceId, tgtDeviceId, replicationId});
            bill.addFailedOperationResult("ism.drm.synchronize.replication.operation", isConsistentGroup ? 1073948767L : 1073948677L, new String[]{replicationId});
            return bill;
        }
        OperationResult operationResult = this.syncLocalReplication(srcDeviceId, tgtDeviceId, replicationId, isConsistentGroup);
        bill.addOperationResult(operationResult);
        return bill;
    }

    public List<ReplicationTargetLun> querySyncStatus(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        this.checkReplicationOperationParameters(replicationId, sourceArrayId, targetArrayId, isConsistentGroup);
        StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
        return proxy.querySyncStatus(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
    }

    public boolean setProtectGroupsInvalid(Site productionSite, Set<ProtectGroup> protectGroups, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType) {
        return this.setProtectGroupsValidStatus(productionSite, protectGroups, procType, false);
    }

    public boolean setProtectGroupsValid(Site productionSite, Set<ProtectGroup> protectGroups, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType) {
        return this.setProtectGroupsValidStatus(productionSite, protectGroups, procType, true);
    }

    private boolean setProtectGroupsValidStatus(Site productionSite, Set<ProtectGroup> protectGroups, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType, boolean isValid) {
        boolean result = false;
        if (null == productionSite || VerifyUtil.isEmpty(protectGroups) || null == procType) {
            logger.error((Object)"Invalid parameter", 90160758784001L);
            return result;
        }
        List localSites = this.siteService.getAllLocalSites();
        String[] pgIds = RecoveryProcessUtil.getProtectGroupIds(protectGroups);
        if (null != localSites && localSites.contains(productionSite)) {
            result = this.changeProtectGroupValidStatus(pgIds, isValid);
        } else {
            result = this.changeProtectGroupValidStatus(productionSite, pgIds, isValid);
            if (!result && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue() == procType.getValue()) {
                result = this.changeProtectGroupValidStatus(pgIds, isValid);
            }
        }
        Iterator<ProtectGroup> iterator = protectGroups.iterator();
        if (iterator.hasNext()) {
            logger.info((Object)("Set protect groups valid status. Result:" + result + ",Site:" + productionSite.getName() + "Pg:" + iterator.next().getName() + ",ProcType:" + procType.getValue() + ",Status:" + isValid), 90160758784000L);
        }
        return result;
    }

    private void constructRecoveryTasks(ParameterEntity paramEntity, ProtectGroup protectGroup, Map<String, RecoveryTask> recoveryTasks) {
        Set pgReplicas = protectGroup.getReplicaList();
        for (ProtectGroupReplica pgReplica : pgReplicas) {
            boolean isSyncOrAsync;
            if (ProtectGroupUtil.isLocalStorageReplica(pgReplica)) continue;
            Site disasterSite = this.siteService.getSiteById(pgReplica.getRecoverySite());
            paramEntity.setDisasterSite(disasterSite);
            boolean bl = isSyncOrAsync = 1 == pgReplica.getType() || 2 == pgReplica.getType();
            if (!isSyncOrAsync) continue;
            Set poReplicas = pgReplica.getReplicas();
            for (ProtectObjectReplica poReplica : poReplicas) {
                this.constructRecoveryTasks(paramEntity, poReplica, recoveryTasks);
            }
        }
    }

    private void constructRecoveryTasks(ParameterEntity paramEntity, ProtectObjectReplica poReplica, Map<String, RecoveryTask> recoveryTasks) {
        String disasterHostId = paramEntity.getPoAndHostMap().get(poReplica.getPoId());
        Set remoteStorageReplicas = poReplica.getStorageInfos();
        IReplicationRecoveryTaskConstructor constructor = this.replicationRecoveryTaskConstructor;
        if (constructor == null) {
            constructor = this;
        }
        for (RelicaStorageInfo remoteStorageReplica : remoteStorageReplicas) {
            constructor.constructReplicationRecoveryTask(paramEntity, (RemoteStorageReplica)remoteStorageReplica, disasterHostId, recoveryTasks);
        }
    }

    private void constructLocalRecoveryTasks(ParameterEntity paramEntity, ProtectObjectReplica poReplica, Map<String, RecoveryTask> recoveryTasks) {
        String disasterHost = paramEntity.getPoAndHostMap().get(poReplica.getPoId());
        Set storageReplicas = poReplica.getStorageInfos();
        for (RelicaStorageInfo storageReplica : storageReplicas) {
            this.constructLocalRecoveryTask(paramEntity, storageReplica, disasterHost, recoveryTasks);
        }
    }

    @Override
    public void constructReplicationRecoveryTask(ParameterEntity paramEntity, RemoteStorageReplica remoteStorageReplica, String associatedHostId, Map<String, RecoveryTask> recoveryTasks) {
        ProtectGroupReplica pgReplica = remoteStorageReplica.getPoReplica().getPgReplica();
        if (VerifyUtil.isEmpty((Object)pgReplica)) {
            logger.error((Object)"ProtectGroupReplica is empty");
            return;
        }
        boolean ignoreVstorePair = Optional.ofNullable(paramEntity).map(ParameterEntity::getExtendParams).map(map -> (String)map.get("creteRecoveryTaskByReplicationPairOnly")).map(Boolean::parseBoolean).orElse(Boolean.FALSE);
        String key = RecoveryProcessHandler.generateRecoveryTaskKey(remoteStorageReplica, ignoreVstorePair);
        RecoveryTask task = recoveryTasks.get(key);
        if (VerifyUtil.isEmpty((Object)task)) {
            task = this.createRecoveryTask(paramEntity, remoteStorageReplica, ignoreVstorePair);
        }
        String srcStorageId = remoteStorageReplica.getSrcStorageProviderSN() + ":" + remoteStorageReplica.getSrcStorageId();
        task.getSrcStorageIds().add(srcStorageId);
        String tagStorageId = remoteStorageReplica.getStorageProviderSN() + ":" + remoteStorageReplica.getStorageId();
        task.getTgtStorageIds().add(tagStorageId);
        String slaveLunIdKey = RecoveryProcessUtil.generateLunAndHostMapKey(remoteStorageReplica);
        task.addLunAndHostRelation(slaveLunIdKey, associatedHostId);
        String poId = remoteStorageReplica.getPoReplica().getPoId();
        task.addLunAndPoRelation(slaveLunIdKey, poId);
        task.addLunAndPgRelation(slaveLunIdKey, pgReplica.getPg().getUuid());
        task.getResourceAndTypeMap().put(slaveLunIdKey, paramEntity.getPoAndTypeMap().get(poId));
        if (!VerifyUtil.isEmpty((String)remoteStorageReplica.getProtectObjectStorageWwn())) {
            task.getSrcStorageWwns().add(remoteStorageReplica.getProtectObjectStorageWwn());
        }
        recoveryTasks.put(key, task);
    }

    private RecoveryTask createRecoveryTask(ParameterEntity paramEntity, RemoteStorageReplica remoteStorageReplica, boolean ignoreVstorePair) {
        RecoveryTask task = new RecoveryTask();
        task.setRecoveryPlanId(paramEntity.getRecoveryPlan().getPlanId());
        task.setDisasterSite(paramEntity.getDisasterSite());
        task.setProductionSite(paramEntity.getProductionSite());
        task.setSrcDeviceId(remoteStorageReplica.getSrcStorageProviderSN());
        task.setTgtDevcieId(remoteStorageReplica.getStorageProviderSN());
        if (RecoveryProcessUtil.isConsistentGroup(remoteStorageReplica)) {
            task.setProtectType(ReplicationConstantDefine.ReplicationDescription.CONSISTENT_GROUP.getValue());
            task.setProtectId(remoteStorageReplica.getConsistentGroupId());
        } else if (RecoveryProcessUtil.isVstorePair(remoteStorageReplica) && !ignoreVstorePair) {
            task.setProtectType(ReplicationConstantDefine.ReplicationDescription.VSTORE_PAIR.getValue());
            task.setProtectId(remoteStorageReplica.getVstorePairId());
        } else {
            task.setProtectType(ReplicationConstantDefine.ReplicationDescription.HYPER_MIRROR.getValue());
            task.setProtectId(remoteStorageReplica.getReplicationPairId());
        }
        return task;
    }

    private void constructLocalRecoveryTask(ParameterEntity paramEntity, RelicaStorageInfo relicaStorageInfo, String associatedHostId, Map<String, RecoveryTask> recoveryTasks) {
        String key = relicaStorageInfo.getSrcStorageProviderSN() + ":" + relicaStorageInfo.getSrcStorageId() + ":" + relicaStorageInfo.getStorageId();
        RecoveryTask task = recoveryTasks.get(key);
        if (task == null) {
            task = this.getRecoveryTaskWhenNull(paramEntity, relicaStorageInfo);
        }
        String slaveLunIdKey = relicaStorageInfo.getStorageId();
        Map lunAndHostMap = task.getLunAndHostMap();
        ArrayList<String> hosts = (ArrayList<String>)lunAndHostMap.get(slaveLunIdKey);
        if (CollectionUtils.isEmpty((Collection)hosts)) {
            hosts = new ArrayList<String>();
        }
        if (!hosts.contains(associatedHostId)) {
            hosts.add(associatedHostId);
        }
        lunAndHostMap.put(slaveLunIdKey, hosts);
        Map lunAndPoMap = task.getLunAndPoMap();
        ArrayList<String> pos = (ArrayList<String>)lunAndPoMap.get(slaveLunIdKey);
        if (null == pos) {
            pos = new ArrayList<String>();
        }
        if (!pos.contains(relicaStorageInfo.getPoReplica().getPoId())) {
            pos.add(relicaStorageInfo.getPoReplica().getPoId());
        }
        lunAndPoMap.put(slaveLunIdKey, pos);
        recoveryTasks.put(key, task);
    }

    private RecoveryTask getRecoveryTaskWhenNull(ParameterEntity paramEntity, RelicaStorageInfo relicaStorageInfo) {
        RecoveryTask task = new RecoveryTask();
        task.setRecoveryPlanId(paramEntity.getRecoveryPlan().getPlanId());
        task.setDisasterSite(paramEntity.getDisasterSite());
        task.setProductionSite(paramEntity.getProductionSite());
        task.setSrcDeviceId(relicaStorageInfo.getSrcStorageProviderSN());
        task.setTgtDevcieId(relicaStorageInfo.getStorageProviderSN());
        task.getSrcStorageIds().add(relicaStorageInfo.getSrcStorageId());
        task.getSrcStorageWwns().add(relicaStorageInfo.getProtectObjectStorageWwn());
        task.setProtectType(ReplicationConstantDefine.ReplicationDescription.UNKNOW.getValue());
        task.setProtectId(relicaStorageInfo.getStorageId());
        if (relicaStorageInfo instanceof LocalStorageReplica) {
            task.setProtectName(((LocalStorageReplica)relicaStorageInfo).getSnapshotName());
            task.setConsistentGroupId(((LocalStorageReplica)relicaStorageInfo).getConsistentGroupId());
        }
        HashMap lunAndHostMap = new HashMap();
        task.setLunAndHostMap(lunAndHostMap);
        HashMap lunAndPoMap = new HashMap();
        task.setLunAndPoMap(lunAndPoMap);
        int type = paramEntity.getPgReplica().getType();
        this.setProtectType(paramEntity, task, type);
        return task;
    }

    private void setProtectType(ParameterEntity paramEntity, RecoveryTask task, int type) {
        if (paramEntity.getPgReplica() == null) {
            logger.error((Object)"Object paramEntity not has pg replica, please check!");
            return;
        }
        if (type == 4 || type == 102) {
            if (!VerifyUtil.isEmpty((String)task.getConsistentGroupId())) {
                task.setProtectType(ReplicationConstantDefine.LocalTaskType.HYPERCDP_GROUP.getValue());
            } else {
                task.setProtectType(ReplicationConstantDefine.LocalTaskType.HYPERCDP.getValue());
            }
        } else if (type == 3) {
            if (!VerifyUtil.isEmpty((String)task.getConsistentGroupId())) {
                task.setProtectType(ReplicationConstantDefine.LocalTaskType.SNAPSHOT_GROUP.getValue());
            } else {
                task.setProtectType(ReplicationConstantDefine.LocalTaskType.SNAPSHOT.getValue());
            }
        }
    }

    public static String generateRecoveryTaskKey(RemoteStorageReplica remoteStorageReplica) {
        return RecoveryProcessHandler.generateRecoveryTaskKey(remoteStorageReplica, false);
    }

    private static String generateRecoveryTaskKey(RemoteStorageReplica remoteStorageReplica, boolean ignoreVstorePair) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(remoteStorageReplica.getSrcStorageProviderSN());
        strBuilder.append(":");
        strBuilder.append(remoteStorageReplica.getStorageProviderSN());
        strBuilder.append(":");
        strBuilder.append(remoteStorageReplica.getSynchronization());
        if (RecoveryProcessUtil.isConsistentGroup(remoteStorageReplica)) {
            strBuilder.append(":");
            strBuilder.append(remoteStorageReplica.getConsistentGroupId());
            strBuilder.append(":");
            strBuilder.append(ReplicationConstantDefine.ReplicationDescription.CONSISTENT_GROUP.getValue());
        } else if (RecoveryProcessUtil.isVstorePair(remoteStorageReplica) && !ignoreVstorePair) {
            strBuilder.append(":");
            strBuilder.append(remoteStorageReplica.getVstorePairId());
            strBuilder.append(":");
            strBuilder.append(ReplicationConstantDefine.ReplicationDescription.VSTORE_PAIR.getValue());
        } else {
            strBuilder.append(":");
            strBuilder.append(remoteStorageReplica.getReplicationPairId());
        }
        return strBuilder.toString();
    }

    private boolean lockRemoteProtectGroup(Site remoteSite, String[] pgIds) {
        RestClient client = SiteUtil.initClient(remoteSite);
        try {
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("protectGroupId", pgIds[0]);
            client.invoke("/ws/protectgroups/{protectGroupId}/action/lockProtectGroup", uriVariables, HttpMethod.PUT);
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)("lock remote protect groups failed, pgIds=" + Arrays.asList(pgIds)), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)("lock remote protect groups failed, pgIds=" + Arrays.asList(pgIds) + ExceptionUtil.getErrorMessage((Throwable)ex)));
            throw new LegoCheckedException(102401L, (Throwable)ex);
        }
        logger.info((Object)("lock remote protect groups success, pgIds=" + Arrays.asList(pgIds) + ", site:" + remoteSite.getName()));
        return true;
    }

    private boolean unlockRemoteProtectGroup(Site remoteSite, String[] pgIds) {
        boolean result = false;
        RestClient client = SiteUtil.initClient(remoteSite);
        try {
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("protectGroupId", pgIds[0]);
            client.invoke("/ws/protectgroups/{protectGroupId}/action/unlockProtectGroup", uriVariables, HttpMethod.PUT);
            result = true;
        }
        catch (Exception e) {
            logger.error((Object)("change protect group lock status failed. Ids:" + StringUtil.arrayToString((Object[])pgIds) + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        logger.info((Object)("Set remote protect groups lock status. Result:" + result + ",Site:" + remoteSite.getName() + "Pg:" + StringUtil.arrayToString((Object[])pgIds)), 90160758784000L);
        return result;
    }

    private boolean changeProtectGroupValidStatus(Site remoteSite, String[] pgIds, boolean isValid) {
        boolean result = false;
        RestClient client = SiteUtil.initClient(remoteSite);
        try {
            HashMap<String, Object> uriVariables = new HashMap<String, Object>();
            uriVariables.put("protectGroupId", pgIds[0]);
            DrmEnumDefine.PROTECT_GROUP_STATUS pgStatus = DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL;
            if (!isValid) {
                pgStatus = DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID;
            }
            uriVariables.put("status", pgStatus.getStatus());
            client.invoke("/ws/protectgroups/{protectGroupId}/action/updateProtectGroupStatus?status={status}", uriVariables, HttpMethod.PUT);
            result = true;
        }
        catch (Exception e) {
            logger.error((Object)("Setting protect groups valid status failed. Ids:" + StringUtil.arrayToString((Object[])pgIds) + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        logger.info((Object)("Set remote protect groups valid status. Result:" + result + ",Site:" + remoteSite.getName() + "Pg:" + StringUtil.arrayToString((Object[])pgIds) + ",IsValid:" + isValid), 90160758784000L);
        return result;
    }

    private boolean changeProtectGroupValidStatus(String[] pgIds, boolean isValid) {
        boolean result = false;
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        try {
            DrmEnumDefine.PROTECT_GROUP_STATUS pgStatus = DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL;
            if (!isValid) {
                pgStatus = DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID;
            }
            pgService.updateProtectGroupStatus(pgStatus, pgIds);
            result = true;
        }
        catch (Exception e) {
            logger.error((Object)("Setting protect groups valid status failed. Ids:" + StringUtil.arrayToString((Object[])pgIds) + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        logger.info((Object)("Set protect groups valid status. Result:" + result + "Pg:" + StringUtil.arrayToString((Object[])pgIds) + ",IsValid:" + isValid), 90160758784000L);
        return result;
    }

    private OperationResult syncLocalReplication(String srcDeviceId, String tgtDeviceId, String replicationId, boolean isConsistentGroup) {
        OperationResult result = null;
        try {
            StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
            result = proxy.syncOnce(srcDeviceId, tgtDeviceId, replicationId, isConsistentGroup);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Synchronize replication failed. " + this.generateLogMsg(replicationId, srcDeviceId, tgtDeviceId, isConsistentGroup)), (Throwable)e, 90160758784001L);
            result = new OperationResult("ism.drm.synchronize.replication.operation", false, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        catch (Exception e) {
            logger.error((Object)("Synchronize replication failed. " + this.generateLogMsg(replicationId, srcDeviceId, tgtDeviceId, isConsistentGroup) + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            result = new OperationResult("ism.drm.synchronize.replication.operation", false, false, String.valueOf(1073948673L), new String[]{replicationId});
        }
        return result;
    }

    private Map<String, String> getDisasterHostOrGroupSettings(String planId, Set<RecoverySetting> settings) {
        HashMap<String, String> pgAndHostMap = new HashMap<String, String>();
        for (RecoverySetting setting : settings) {
            if (!setting.getRecoveryPlan().getPlanId().equals(planId) || !setting.getName().equals("PG_DISASTER_HOST")) continue;
            pgAndHostMap.put(setting.getOwnerId(), setting.getValue());
        }
        return pgAndHostMap;
    }

    private String generateLogMsg(String replicationId, String srcDeviceId, String tgtDeviceId, boolean isConsistentGroup) {
        StringBuilder logMsg = new StringBuilder();
        logMsg.append("RepId:");
        logMsg.append(replicationId);
        logMsg.append(",SrcDevId:");
        logMsg.append(srcDeviceId);
        logMsg.append(",TgtDevId:");
        logMsg.append(tgtDeviceId);
        logMsg.append(",isCG:");
        logMsg.append(isConsistentGroup);
        return logMsg.toString();
    }

    private void calcTaskParallelRelation(Collection<RecoveryTask> tasks, RecoveryTask associatedTask) {
        Set srcStorageIds = associatedTask.getSrcStorageIds();
        for (RecoveryTask task : tasks) {
            if (task.getTaskId().equals(associatedTask.getTaskId())) continue;
            Set srcStorageIds2 = task.getSrcStorageIds();
            for (String storageId : srcStorageIds2) {
                if (!srcStorageIds.contains(storageId) || null != associatedTask.getAssociatedTask() && associatedTask.getAssociatedTask().getTaskId().equals(task.getTaskId())) continue;
                associatedTask.getParallelTasks().add(task);
                task.setAssociatedTask(associatedTask);
            }
        }
    }

    private void calcTaskCascadeRelation(Collection<RecoveryTask> tasks, RecoveryTask associatedTask) {
        Set tgtStorageIds = associatedTask.getTgtStorageIds();
        for (RecoveryTask task : tasks) {
            Set srcStorageIds = task.getSrcStorageIds();
            for (String storageId : srcStorageIds) {
                if (!tgtStorageIds.contains(storageId)) continue;
                associatedTask.getCascadeTasks().add(task);
                task.setAssociatedTask(associatedTask);
            }
        }
    }

    private void checkReplicationOperationParameters(String replicationId, String srcDeviceId, String tgtDeviceId, boolean isConsistentGroup) {
        if (VerifyUtil.isEmpty((String)replicationId) || VerifyUtil.isEmpty((String)srcDeviceId) || VerifyUtil.isEmpty((String)tgtDeviceId)) {
            logger.error((Object)("Invalid parameter." + this.generateLogMsg(replicationId, srcDeviceId, tgtDeviceId, isConsistentGroup)), 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private Map<String, String> constructPoAndHostMap(Set<ProtectObject> protectObjects, String hostOrGroupId) {
        HashMap<String, String> poAndHostMap = new HashMap<String, String>();
        if (VerifyUtil.isEmpty(protectObjects) || VerifyUtil.isEmpty((String)hostOrGroupId)) {
            return poAndHostMap;
        }
        for (ProtectObject po : protectObjects) {
            poAndHostMap.put(po.getUuid(), hostOrGroupId);
        }
        return poAndHostMap;
    }

    public OperationResultBill setVstoreSecondaryPairProtection(String srcDeviceId, String tgtDeviceId, String pairId, boolean isForce) {
        OperationResultBill bill = new OperationResultBill();
        this.checkReplicationOperationParameters(pairId, srcDeviceId, tgtDeviceId, true);
        logger.info((Object)"PairId: %s,isForce: %s", new Object[]{pairId, isForce});
        VstoreReplicationPair vstoreReplicationPair = this.recoveryService.queryVstoreReplicationPair(srcDeviceId, tgtDeviceId, pairId);
        if (null == vstoreReplicationPair) {
            logger.error((Object)"The replication is null: %s,tgtDeviceId: %s, pairId: %s", new Object[]{srcDeviceId, tgtDeviceId, pairId});
            bill.addFailedOperationResult("ism.drm.swap.replication.operation", 1073948677L, new String[]{pairId});
            return bill;
        }
        IStorageVstoreReplicationPairManager replicationPairManager = StorageVstoreReplicationPairManagerProxy.getInstance().getMgrByDevId(tgtDeviceId);
        OperationResult result = replicationPairManager.split(tgtDeviceId, pairId);
        if (!isForce && !result.isSuccess()) {
            bill.addOperationResult(result);
            return bill;
        }
        OperationResult inactiveResult = replicationPairManager.modifyActiveStatus(srcDeviceId, vstoreReplicationPair, 1);
        if (!isForce && !inactiveResult.isSuccess()) {
            bill.addOperationResult(inactiveResult);
            return bill;
        }
        bill.addOperationResult(replicationPairManager.setSecondaryPairReadWrite(tgtDeviceId, pairId, String.valueOf(3)));
        bill.addOperationResult(replicationPairManager.modifyActiveStatus(tgtDeviceId, vstoreReplicationPair, 0));
        return bill;
    }

    public OperationResultBill synchronizeVstorePair(String srcDeviceId, String tgtDeviceId, String pairId) {
        this.checkReplicationOperationParameters(pairId, srcDeviceId, tgtDeviceId, true);
        OperationResultBill bill = new OperationResultBill();
        VstoreReplicationPair vstoreReplicationPair = this.recoveryService.queryVstoreReplicationPair(srcDeviceId, tgtDeviceId, pairId);
        if (null == vstoreReplicationPair) {
            logger.error((Object)"The replication is null: %s,tgtDeviceId: %s, pairId: %s", new Object[]{srcDeviceId, tgtDeviceId, pairId});
            bill.addFailedOperationResult("ism.drm.synchronize.replication.operation", 1073948677L, new String[]{pairId});
            return bill;
        }
        IStorageVstoreReplicationPairManager replicationPairManager = StorageVstoreReplicationPairManagerProxy.getInstance().getMgrByDevId(tgtDeviceId);
        OperationResult operationResult = replicationPairManager.sync(tgtDeviceId, pairId);
        logger.debug((Object)"Exit syncVstoreReplicationPair");
        bill.addOperationResult(operationResult);
        return bill;
    }

    public List<ReplicationTargetLun> queryVstorePairSyncStatus(String sourceArrayId, String targetArrayId, String replicationId, boolean queryOnly) {
        this.checkReplicationOperationParameters(replicationId, sourceArrayId, replicationId, true);
        IStorageVstoreReplicationPairManager manager = StorageVstoreReplicationPairManagerProxy.getInstance().getMgrByDevId(targetArrayId);
        return manager.querySyncStatusByVstorePair(targetArrayId, replicationId, queryOnly);
    }

    public ReplicationRelation queryReplication(ReplicationRelationBo relationBo) {
        if (VerifyUtil.isEmpty((Object)relationBo)) {
            logger.error((Object)"Replication relationship obj is empty!");
            throw new LegoCheckedException(1073947394L);
        }
        return this.recoveryService.queryReplication(relationBo.getSrcDeviceSn(), relationBo.getTgtDeviceSn(), relationBo.getReplicationId(), relationBo.isConsistentGroup());
    }
}

