/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process.reprotect;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.reprotect.CheckStorageRelationSubProcessor;
import com.huawei.ism.drm.recovery.framework.process.reprotect.ReprotectBaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CheckResourceProcessor
extends ReprotectBaseRecoveryProcessor {
    private static final long serialVersionUID = -4182734116663703439L;
    private static final Log logger = LogFactory.getInstance(CheckResourceProcessor.class);

    public CheckResourceProcessor() {
        this.setProcName(this.getName());
        this.setIsNeedSave(false);
    }

    @Override
    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    public boolean execute(RecoveryProcessorContext context) {
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type;
        RecoveryProcessSerialExecutor recoveryTemplate;
        logger.debug((Object)"Begin to check reprotect resources.", 90160758786816L);
        Set<RecoveryProcessor> subProcessors = this.createSubProcessors(context);
        if (!VerifyUtil.isEmpty(subProcessors)) {
            this.setHasChildProc(true);
        }
        if (null == (recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(subProcessors, type = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType())))) {
            throw new LegoCheckedException(1073947395L);
        }
        recoveryTemplate.process(context);
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E procStatus = this.calcProcStatusBySubProc(subProcessors);
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.equals((Object)procStatus);
    }

    private Set<RecoveryProcessor> createSubProcessors(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        Map globalSettings = recoveryPlan.getGlobalSettings();
        String disasterSiteId = (String)globalSettings.get("DISASTER_SITE_ID");
        CheckStorageRelationSubProcessor rp = null;
        for (ProtectGroup protectGroup : recoveryPlan.getProtectGroups()) {
            String recoveryArray = this.getRecoveryArrayByPg(protectGroup, disasterSiteId);
            if (null == recoveryArray) continue;
            HashMap<String, Integer> resourceMap = new HashMap<String, Integer>();
            List<String> lunIds = this.getLunIds(protectGroup, disasterSiteId, resourceMap);
            CheckStorageRelationSubProcessor checkStorageProcessor = new CheckStorageRelationSubProcessor(this, recoveryArray, lunIds);
            if (!VerifyUtil.isEmpty(rp)) {
                rp.setNextProcessor(checkStorageProcessor);
                checkStorageProcessor.setPreviousProcessor(rp);
            }
            subProcessors.add(checkStorageProcessor);
            rp = checkStorageProcessor;
        }
        return subProcessors;
    }

    @Override
    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.recovery.framework.process.reprotect.CheckResourceProcessor.des");
    }
}

