/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process.reprotect;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.reprotect.ReprotectBaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.provider.RefactorConfigurationProviderMgr;
import com.huawei.ism.drm.recovery.process.IRefactorConfigurationProvider;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.reprotect.sdk.service.IReprotectService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Map;
import java.util.Set;

public class RefactorConfigurationSubProcessor
extends ReprotectBaseRecoveryProcessor {
    private static final long serialVersionUID = 3880674622172150069L;
    private static final Log logger = LogFactory.getInstance(RefactorConfigurationSubProcessor.class);

    public RefactorConfigurationSubProcessor() {
        this.setIsNeedSave(false);
    }

    public RefactorConfigurationSubProcessor(RecoveryProcessor parentProcess) {
        super(parentProcess);
        this.setIsNeedSave(false);
    }

    @Override
    public boolean execute(RecoveryProcessorContext context) {
        try {
            RefactorConfigurationProviderMgr refactorCfgProviderMgr = RefactorConfigurationProviderMgr.getInstance();
            RecoveryPlan recoveryPlan = context.getRecoveryPlan();
            DrmEnumDefine.APP_TYPE appType = RecoveryServiceUtil.getAppType(recoveryPlan);
            IRefactorConfigurationProvider provider = refactorCfgProviderMgr.getRefactorConfigurationProvider(appType.name());
            if (null == provider) {
                throw new LegoCheckedException(1073947393L);
            }
            this.setRecoverPlanGlobalSetting(context, recoveryPlan);
            provider.refactorConfiguration(recoveryPlan);
            Set protectGroups = recoveryPlan.getProtectGroups();
            for (ProtectGroup pg : protectGroups) {
                pg.setStatus(DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID.getStatus());
            }
            IReprotectService reprotectService = (IReprotectService)ServiceLocator.getInstance().getService(IReprotectService.class);
            reprotectService.saveReprotectUpdate(recoveryPlan);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Refactoring configuration failed.", (Throwable)e, 90160758787071L);
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("Refactoring configuration failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }

    private void setRecoverPlanGlobalSetting(RecoveryProcessorContext context, RecoveryPlan recoveryPlan) {
        String hyperMetroDeviceSn = (String)context.getObject("hyperMetroDeviceSn", String.class);
        Map pairIdMap = (Map)context.getAttribute("pairIdMap");
        String vstoreId = (String)context.getObject("vstoreId", String.class);
        Map globalSettings = recoveryPlan.getGlobalSettings();
        if (!VerifyUtil.isEmpty((String)hyperMetroDeviceSn)) {
            globalSettings.put("hyperMetroDeviceSn", hyperMetroDeviceSn);
        }
        if (pairIdMap != null && !pairIdMap.isEmpty()) {
            globalSettings.put("pairIdMap", JSONObject.fromObject((Object)pairIdMap).toString());
        }
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            globalSettings.put("vstoreId", vstoreId);
        }
    }
}

