/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.provider;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.ITaskManager;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.template.manager.TemplateFilterManager;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateFilter;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessProvider;
import com.huawei.ism.drm.recovery.process.IRefactorConfigurationProvider;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public abstract class BaseRefactorConfigurationProvider
implements IRefactorConfigurationProvider {
    private static Log logger = LogFactory.getInstance(BaseRefactorConfigurationProvider.class);
    private static final Set<Integer> TEMPLATE3DC = new HashSet<Integer>();
    private static final Set<Integer> TEMPLATE4DC = new HashSet<Integer>();
    private static final String CACHE_SITE_PREFIX = "CACHE_SITE_PREFIX_";
    private static List<Integer> hyperMetroAsynTypeList = Arrays.asList(18, 26, 20, 23, 24, 31, 32, 35, 36, 38, 39, 40, 41, 42, 43);
    private static List<Integer> lagReversalReplicaTypeList = Arrays.asList(33);
    private static Map<Integer, Integer> mapTemplate = new HashMap<Integer, Integer>();
    private ThreadLocal<String> isReversed = new ThreadLocal();

    protected Boolean getIsReversed() {
        if (null != this.isReversed && "true".equalsIgnoreCase(this.isReversed.get())) {
            return true;
        }
        return false;
    }

    protected void setIsReversed(String reversedValue) {
        if (null == this.isReversed) {
            logger.error((Object)"isReversed is null");
            return;
        }
        this.isReversed.set(reversedValue);
    }

    public void refactorConfiguration(RecoveryPlan recoveryPlan) {
        Map globalSettings = recoveryPlan.getGlobalSettings();
        String disasterSiteId = (String)globalSettings.get("DISASTER_SITE_ID");
        logger.debug((Object)"DisasterSiteId:%s, recoveryPlan name=%s", new Object[]{disasterSiteId, recoveryPlan.getName()});
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Site disasterSite = siteService.getSiteById(disasterSiteId);
        Map<String, Object> params = this.setParams(globalSettings, disasterSiteId);
        HashMap<String, String> pgAndDisasterHosts = new HashMap<String, String>();
        params.put("PG_DISASTER_HOST", pgAndDisasterHosts);
        String isReversedInGlobalSetting = (String)globalSettings.get("isReserved");
        this.setIsReversed(isReversedInGlobalSetting);
        params.put("isReserved", isReversedInGlobalSetting);
        params.put("RecoveryPlan", recoveryPlan);
        for (ProtectGroup protectGroup : recoveryPlan.getProtectGroups()) {
            RecoverySetting setting = RecoveryUtil.getRecoverySetting((String)recoveryPlan.getPlanId(), (String)protectGroup.getUuid(), (String)"PG_DISASTER_HOST", (Set)recoveryPlan.getRecoverySettings());
            if (null != setting) {
                pgAndDisasterHosts.put(protectGroup.getUuid(), setting.getValue());
            }
            protectGroup.setProductSiteId(disasterSiteId);
            protectGroup.setProductSiteName(disasterSite.getName());
            this.refactorProtectGroup(protectGroup, params);
            int oldTemplateType = protectGroup.getTemplate().getType();
            PolicyTemplate newTemplate = ProtectGroupHelper.getInstance().matchAvailableTemplate(protectGroup);
            if (!VerifyUtil.isEmpty((Object)newTemplate)) {
                protectGroup.setTemplate(newTemplate);
            } else {
                this.refactorPolicyTemplate(protectGroup);
            }
            if (!lagReversalReplicaTypeList.contains(oldTemplateType)) {
                this.refactorLocalScheduleAndProps(protectGroup, oldTemplateType);
            } else {
                protectGroup.getProps().put("FS_last_recovery_plan_execute_type", String.valueOf(recoveryPlan.getLastExecuteType()));
            }
            logger.debug((Object)"After refactorLocalScheduleAndPropsrecoveryPlan name=%s", new Object[]{recoveryPlan.getName()});
            if (25 != protectGroup.getTemplate().getType() && !PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(protectGroup)) {
                logger.debug((Object)"CleanRemote and buildReplica, protectGroupName=%s", new Object[]{protectGroup.getName()});
                ProtectGroupUtil.clearRemoteReplicas(protectGroup.getReplicaList());
                ProtectGroupHelper.getInstance().buildReplica(protectGroup, false);
                this.refactorLocalReplica(protectGroup, params);
            }
            if (lagReversalReplicaTypeList.contains(oldTemplateType)) {
                this.refactorLocalScheduleAndProps(protectGroup, oldTemplateType);
                protectGroup.getProps().remove("FS_last_recovery_plan_execute_type");
            }
            this.resumeGroup(protectGroup);
        }
        this.refactorRecoveryPlan(recoveryPlan, params);
    }

    private Map<String, Object> setParams(Map<String, String> globalSettings, String disasterSiteId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("DISASTER_SITE_ID", disasterSiteId);
        if (!VerifyUtil.isEmpty((String)globalSettings.get("PRODUCT_SITE_ID"))) {
            params.put("PRODUCT_SITE_ID", globalSettings.get("PRODUCT_SITE_ID"));
        }
        if (!VerifyUtil.isEmpty((String)globalSettings.get("SELECT_DISASTER_SITE_KEY"))) {
            params.put("SELECT_DISASTER_SITE_KEY", globalSettings.get("SELECT_DISASTER_SITE_KEY"));
        }
        if (!VerifyUtil.isEmpty((String)globalSettings.get("vstoreId"))) {
            params.put("vstoreId", globalSettings.get("vstoreId"));
        }
        if (!VerifyUtil.isEmpty((String)globalSettings.get("hyperMetroDeviceSn"))) {
            params.put("hyperMetroDeviceSn", globalSettings.get("hyperMetroDeviceSn"));
        }
        if (!VerifyUtil.isEmpty((String)globalSettings.get("pairIdMap"))) {
            params.put("pairIdMap", globalSettings.get("pairIdMap"));
        }
        return params;
    }

    private void updateDRRingScheduleProtectLocationPath(Map<Integer, ProtectLocationPath> locationMap, int policyTemplateType, Schedule schedule) {
        boolean flag = false;
        if (!VerifyUtil.isEmpty(locationMap) && locationMap.keySet().contains(DrmEnumDefine.PROTECT_LOCATION.PL_C.getValue())) {
            flag = true;
        }
        if (flag && (DrmEnumDefine.PROTECT_LOCATION.PL_A_C.getValue() == schedule.getProtectLocation() || DrmEnumDefine.PROTECT_LOCATION.PL_B_C.getValue() == schedule.getProtectLocation())) {
            schedule.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.PL_C.getValue());
        } else if (!(flag || 3 != policyTemplateType || DrmEnumDefine.PROTECT_LOCATION.PL_C.getValue() != schedule.getProtectLocation() && DrmEnumDefine.PROTECT_LOCATION.PL_A_C.getValue() != schedule.getProtectLocation())) {
            schedule.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.PL_B_C.getValue());
        } else if (!(flag || 5 != policyTemplateType || DrmEnumDefine.PROTECT_LOCATION.PL_C.getValue() != schedule.getProtectLocation() && DrmEnumDefine.PROTECT_LOCATION.PL_B_C.getValue() != schedule.getProtectLocation())) {
            schedule.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.PL_A_C.getValue());
        }
    }

    public void saveConfiguration(RecoveryPlan recoveryPlan) {
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan oldRecoveryPlan = planService.getRecoveryPlan(recoveryPlan.getPlanId());
        if (null == oldRecoveryPlan) {
            logger.error((Object)("The recovery plan does not exist. PlanName:" + recoveryPlan.getPlanId()), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        String isReversedInGlobalSetting = (String)recoveryPlan.getGlobalSettings().get("isReserved");
        this.setIsReversed(isReversedInGlobalSetting);
        this.updateRecoveryPlan(oldRecoveryPlan, recoveryPlan);
        IProtectionTaskService protectionTaskService = (IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class);
        for (ProtectGroup oldProtectGroup : oldRecoveryPlan.getProtectGroups()) {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)oldProtectGroup.getTemplate());
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)oldProtectGroup);
            protectionTaskService.createTask(oldProtectGroup);
            this.deleteProtectActions(oldProtectGroup.getUuid());
        }
        this.deleteRemovedRecoverySettings(oldRecoveryPlan.getRecoverySettings(), recoveryPlan.getRecoverySettings());
        this.updateRecoveryProcessDef(recoveryPlan);
        oldRecoveryPlan.getRecoverySettings().clear();
        oldRecoveryPlan.getRecoverySettings().addAll(recoveryPlan.getRecoverySettings());
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)oldRecoveryPlan);
    }

    protected void updateRecoveryPlan(RecoveryPlan recoveryPlanInDb, RecoveryPlan newRecoveryPlan) {
        recoveryPlanInDb.getGlobalSettings().clear();
        recoveryPlanInDb.getGlobalSettings().putAll(newRecoveryPlan.getGlobalSettings());
        Set oldProtectGroups = recoveryPlanInDb.getProtectGroups();
        Set newProtectGroups = newRecoveryPlan.getProtectGroups();
        for (ProtectGroup oldProtectGroup : oldProtectGroups) {
            DRMObject drmObject = this.getMatchedDrmObject(newProtectGroups, (DRMObject)oldProtectGroup);
            if (null == drmObject) {
                logger.debug((Object)"drmObject is null!");
                continue;
            }
            ProtectGroup newProtectGroup = (ProtectGroup)drmObject;
            this.updateProtectGroup(oldProtectGroup, newProtectGroup);
        }
    }

    protected void refactorRecoveryPlan(RecoveryPlan recoveryPlan, Map<String, Object> params) {
        HashMap<String, String> newGlobalSettings = new HashMap<String, String>();
        newGlobalSettings.put("RECOVERY_EXTEND_ATTRIBUTES", String.valueOf(DrmEnumDefine.RECOVERY_EXTEND_ATTRIBUTES.REFACTOR_CONFIGURATION_SUCCESS.getValue()));
        newGlobalSettings.put("DISASTER_SITE_ID", params.get("DISASTER_SITE_ID").toString());
        newGlobalSettings.put("isReserved", String.valueOf(params.get("isReserved")));
        if (!VerifyUtil.isEmpty((Object)params.get("PRODUCT_SITE_ID"))) {
            newGlobalSettings.put("PRODUCT_SITE_ID", String.valueOf(params.get("PRODUCT_SITE_ID")));
        }
        if (!VerifyUtil.isEmpty((Object)params.get("SELECT_DISASTER_SITE_KEY"))) {
            newGlobalSettings.put("SELECT_DISASTER_SITE_KEY", String.valueOf(params.get("SELECT_DISASTER_SITE_KEY")));
        }
        if (!VerifyUtil.isEmpty((Object)params.get("REPLICA_ID"))) {
            newGlobalSettings.put("REPLICA_ID", String.valueOf(params.get("REPLICA_ID")));
        }
        if (!VerifyUtil.isEmpty((Object)params.get("hyperMetroDeviceSn"))) {
            newGlobalSettings.put("hyperMetroDeviceSn", String.valueOf(params.get("hyperMetroDeviceSn")));
        }
        if (!VerifyUtil.isEmpty((Object)params.get("pairIdMap"))) {
            newGlobalSettings.put("pairIdMap", String.valueOf(params.get("pairIdMap")));
        }
        if (!VerifyUtil.isEmpty((Object)params.get("vstoreId"))) {
            newGlobalSettings.put("vstoreId", String.valueOf(params.get("vstoreId")));
        }
        recoveryPlan.setGlobalSettings(newGlobalSettings);
        HashSet<RecoverySetting> needRemovedSettings = new HashSet<RecoverySetting>();
        Set recoverySettings = recoveryPlan.getRecoverySettings();
        for (RecoverySetting recoverySetting : recoverySettings) {
            if (!"PG_DISASTER_HOST".equals(recoverySetting.getName())) continue;
            needRemovedSettings.add(recoverySetting);
        }
        for (RecoverySetting setting : needRemovedSettings) {
            recoverySettings.remove(setting);
        }
    }

    protected void updateProtectGroup(ProtectGroup oldProtectGroup, ProtectGroup newProtectGroup) {
        oldProtectGroup.setProductSiteId(newProtectGroup.getProductSiteId());
        oldProtectGroup.setProductSiteName(newProtectGroup.getProductSiteName());
        oldProtectGroup.setStatus(newProtectGroup.getStatus());
        oldProtectGroup.setPrimary(newProtectGroup.isPrimary());
        oldProtectGroup.setPoProviderSN(newProtectGroup.getPoProviderSN());
        oldProtectGroup.setProps(this.updateExtendedProps(oldProtectGroup.getProps(), newProtectGroup.getProps()));
        PolicyTemplate oldTemplate = oldProtectGroup.getTemplate();
        PolicyTemplate newTemplate = newProtectGroup.getTemplate();
        oldTemplate.setType(newTemplate.getType());
        oldTemplate.setSketch(newTemplate.getSketch());
        oldTemplate.setEditTemplateUrl(newTemplate.getEditTemplateUrl());
        oldTemplate.setViewTemplateUrl(newTemplate.getViewTemplateUrl());
        oldTemplate.setName(newTemplate.getName());
        oldTemplate.setDescription(newTemplate.getDescription());
        oldTemplate.setProps(this.updateExtendedProps(oldTemplate.getProps(), newTemplate.getProps()));
        this.deleteProtectionTasks(oldProtectGroup.getUuid());
        oldTemplate.getSchedules().clear();
        oldTemplate.getSchedules().addAll(newTemplate.getSchedules());
        ProtectGroupUtil.clearRemoteReplicas(oldProtectGroup.getReplicaList());
        oldProtectGroup.getReplicaList().addAll(newProtectGroup.getReplicaList());
        Set oldProtectObjects = oldProtectGroup.getPolist();
        Set newProtectObjects = newProtectGroup.getPolist();
        for (ProtectObject oldProtectObject : oldProtectObjects) {
            DRMObject drmObject = this.getMatchedDrmObject(newProtectObjects, (DRMObject)oldProtectObject);
            if (null == drmObject) {
                logger.debug((Object)"drmObject is null!");
                continue;
            }
            ProtectObject newProtectObject = (ProtectObject)drmObject;
            this.updateProtectObject(oldProtectObject, newProtectObject);
        }
    }

    protected void refactorProtectGroup(ProtectGroup protectGroup, Map<String, Object> params) {
        protectGroup.setStatus(DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL.getStatus());
        protectGroup.setPrimary(true);
        protectGroup.setLastExecResult(null);
        this.reverseProtectGroupAttributes(protectGroup, params);
        logger.debug((Object)("after reverseProtectGroupAttributes:recoveryPlan name" + protectGroup.getName()));
        for (ProtectObject po : protectGroup.getPolist()) {
            po.setPoRecoveryStatus(DrmEnumDefine.PROTECT_OBJECT_RECOVERY_STATUS_E.NOT_STARTED.getValue());
            this.refactorProtectObject(po, params);
        }
    }

    protected void updateProtectObject(ProtectObject oldProtectObject, ProtectObject newProtectObject) {
        oldProtectObject.setMoUuid(newProtectObject.getMoUuid());
        oldProtectObject.setProviderSN(newProtectObject.getProviderSN());
        oldProtectObject.setPoRecoveryStatus(newProtectObject.getPoRecoveryStatus());
        oldProtectObject.setName(newProtectObject.getName());
        oldProtectObject.setProps(this.updateExtendedProps(oldProtectObject.getProps(), newProtectObject.getProps()));
        Set oldPoStorageInfos = oldProtectObject.getUsedStorageResourceSet();
        Set newPoStorageInfos = newProtectObject.getUsedStorageResourceSet();
        Iterator oldIterator = oldPoStorageInfos.iterator();
        while (oldIterator.hasNext()) {
            ProtectObjectStorageInfo oldPoStorageInfo = (ProtectObjectStorageInfo)oldIterator.next();
            boolean isExist = false;
            Iterator newIterator = newPoStorageInfos.iterator();
            while (newIterator.hasNext()) {
                ProtectObjectStorageInfo newPoStorageInfo = (ProtectObjectStorageInfo)newIterator.next();
                if (!oldPoStorageInfo.getId().equals(newPoStorageInfo.getId())) continue;
                this.updateProtectObjectStorageInfo(oldPoStorageInfo, newPoStorageInfo);
                newIterator.remove();
                isExist = true;
                break;
            }
            if (isExist) continue;
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)oldPoStorageInfo);
            oldIterator.remove();
            oldIterator = oldPoStorageInfos.iterator();
        }
        for (ProtectObjectStorageInfo newPoStorageInfo : newPoStorageInfos) {
            newPoStorageInfo.setProtectObject(oldProtectObject);
            oldProtectObject.getUsedStorageResourceSet().add(newPoStorageInfo);
        }
    }

    protected void refactorProtectObject(ProtectObject protectObject, Map<String, Object> params) {
        this.refactorProtectObjectStorageInfos(protectObject, params);
        long start = System.currentTimeMillis();
        this.reverseProtectObjectAttributes(protectObject, params);
        logger.debug((Object)("reverseProtectObjectAttributes cost time:" + (System.currentTimeMillis() - start)));
    }

    protected void updateProtectObjectStorageInfo(ProtectObjectStorageInfo oldPoStorageInfo, ProtectObjectStorageInfo newPoStorageInfo) {
        oldPoStorageInfo.setResourceProviderSN(newPoStorageInfo.getResourceProviderSN());
        oldPoStorageInfo.setResourceId(newPoStorageInfo.getResourceId());
        oldPoStorageInfo.setLunWWN(newPoStorageInfo.getLunWWN());
    }

    protected void caculateOToNewWwnMap(List<ProtectObjectStorageInfo> oldStorageInfoList, ProtectObject protectObject, Map<String, Object> params) {
        HashMap oldStorageInfoWwnMap = new HashMap();
        oldStorageInfoList.stream().forEach(storageInfo -> oldStorageInfoWwnMap.put(storageInfo.getResourceProviderSN() + ':' + storageInfo.getResourceId(), storageInfo.getLunWWN()));
        ProtectObjectReplica curPoReplica = this.getProtectObjectReplica(protectObject, params);
        Map<String, String> storageInfos = this.retrieveProductAndDisasterInfos(curPoReplica);
        HashMap devResourceIdList = new HashMap();
        for (Object storageInfo2 : curPoReplica.getStorageInfos()) {
            CommUtil.addToMap(devResourceIdList, (String)storageInfo2.getSrcStorageProviderSN(), (Object)storageInfo2.getSrcStorageId());
            CommUtil.addToMap(devResourceIdList, (String)storageInfo2.getStorageProviderSN(), (Object)storageInfo2.getStorageId());
        }
        HashMap lunWwnMap = new HashMap();
        for (Map.Entry entry : devResourceIdList.entrySet()) {
            String devSn = (String)entry.getKey();
            List lunIdSet = (List)entry.getValue();
            List storageResourceList = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResources(devSn, new ArrayList(lunIdSet), DrmEnumDefine.RESOURCE_TYPE_E.LUN);
            storageResourceList.stream().forEach(storageResource -> {
                if (storageResource instanceof Lun) {
                    Lun lun = (Lun)storageResource;
                    lunWwnMap.put(lun.getDevSn() + ':' + lun.getResourceId(), lun.getWwn());
                }
            });
        }
        HashMap<String, String> olToNewWwnMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : storageInfos.entrySet()) {
            String wwn1 = (String)lunWwnMap.get(entry.getKey());
            String wwn2 = (String)lunWwnMap.get(entry.getValue());
            if (VerifyUtil.isEmpty((String)wwn1) || VerifyUtil.isEmpty((String)wwn2)) continue;
            olToNewWwnMap.put(wwn1, wwn2);
        }
        params.put("olToNewWwnMap", olToNewWwnMap);
    }

    protected void refactorProtectObjectStorageInfos(ProtectObject protectObject, Map<String, Object> params) {
        ProtectObjectReplica curPoReplica = this.getProtectObjectReplica(protectObject, params);
        Map<String, String> storageInfos = this.retrieveProductAndDisasterInfos(curPoReplica);
        Iterator iterator = protectObject.getUsedStorageResourceSet().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        String devSn = ((ProtectObjectStorageInfo)iterator.next()).getResourceProviderSN();
        Site site = this.getSite(params, devSn);
        ProtectGroup pg = protectObject.getProtectGroup();
        if (null == pg) {
            return;
        }
        int templateType = pg.getTemplate().getType();
        Set<ProtectObjectStorageInfo> poStorageInfos = this.getProtectObjectStorageInfos(protectObject, storageInfos, site, templateType);
        HashMap<String, String> olToNewWwnMap = new HashMap<String, String>();
        for (ProtectObjectStorageInfo poStorageInfo : poStorageInfos) {
            if (DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue() != poStorageInfo.getResourceType().intValue()) continue;
            ArrayList<String> resourceIds = new ArrayList<String>();
            resourceIds.add(poStorageInfo.getResourceId());
            List<Lun> luns = this.getStorageLunsByDevId(poStorageInfo.getResourceProviderSN(), resourceIds);
            Lun matchedLun = this.filterMatchedLun(poStorageInfo.getResourceId(), luns);
            if (null == matchedLun) {
                logger.error((Object)("There is no matched lun. ResId:" + poStorageInfo.getResourceId()), 90160758784001L);
                throw new LegoCheckedException(1073947394L);
            }
            String newWwn = matchedLun.getWwn();
            olToNewWwnMap.put(poStorageInfo.getLunWWN(), newWwn);
            poStorageInfo.setLunWWN(newWwn);
        }
        params.put("olToNewWwnMap", olToNewWwnMap);
    }

    private Set<ProtectObjectStorageInfo> getProtectObjectStorageInfos(ProtectObject protectObject, Map<String, String> storageInfos, Site site, int templateType) {
        Set poStorageInfos = protectObject.getUsedStorageResourceSet();
        for (ProtectObjectStorageInfo poStorageInfo : poStorageInfos) {
            String resourceId = poStorageInfo.getResourceId();
            String resourceProviderSN = poStorageInfo.getResourceProviderSN();
            logger.info((Object)("resourceId:" + resourceId + "resourceProviderSN:" + resourceProviderSN));
            if (DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue() == poStorageInfo.getResourceType().intValue() && hyperMetroAsynTypeList.contains(templateType)) {
                ArrayList<String> wwnList = new ArrayList<String>();
                wwnList.add(poStorageInfo.getLunWWN());
                List<Lun> lunList = StorageResourceServiceRouter.getInstance().getStorageResourcesByWwns(site.getServerUuid(), wwnList, Lun.class);
                logger.info((Object)("lunWwn=" + poStorageInfo.getLunWWN() + ",get lunlist size " + lunList.size() + ",lunList info " + lunList));
                for (Lun lun : lunList) {
                    String key = lun.getDevSn() + ":" + lun.getLunId();
                    if (!storageInfos.containsKey(key)) continue;
                    resourceId = lun.getLunId();
                    resourceProviderSN = lun.getDevSn();
                    break;
                }
            }
            logger.info((Object)("resourceId:" + resourceId + "resourceProviderSN:" + resourceProviderSN));
            poStorageInfo.setResourceProviderSN(storageInfos.get(resourceProviderSN));
            String str = storageInfos.get(resourceProviderSN + ":" + resourceId);
            String[] strArray = str.split(":");
            if (strArray.length <= 1) continue;
            poStorageInfo.setResourceId(strArray[1]);
        }
        return poStorageInfos;
    }

    private Site getSite(Map<String, Object> params, String devSn) {
        logger.debug((Object)("devSn:" + devSn));
        Object siteObj = params.get(CACHE_SITE_PREFIX + devSn);
        Site site = siteObj instanceof Site ? (Site)siteObj : this.getSiteByDeviceSn(devSn);
        return site;
    }

    private Site getSiteByDeviceSn(String devSn) {
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(devSn);
        if (null == drResource) {
            logger.error((Object)("DrResource is null, sn=" + devSn));
            throw new LegoCheckedException(1073947393L);
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(drResource.getSiteId());
        if (null == site) {
            logger.error((Object)("Site is null, siteId=" + drResource.getSiteId()));
            throw new LegoCheckedException(1073947393L);
        }
        return site;
    }

    protected void refactorPolicyTemplate(ProtectGroup pg) {
        IPolicyTemplateManager policyTemplateManager;
        PolicyTemplate newTemplate;
        Integer newTemplateType = mapTemplate.get(pg.getTemplate().getType());
        if (null == newTemplateType) {
            newTemplateType = pg.getTemplate().getType();
        }
        if (null == (newTemplate = (policyTemplateManager = (IPolicyTemplateManager)ServiceLocator.getInstance().getService(IPolicyTemplateManager.class)).clonePolicyTemlate(newTemplateType.intValue()))) {
            logger.error((Object)("There is no matched template in db. Type:" + newTemplateType), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        PolicyTemplate oldTemplate = pg.getTemplate();
        oldTemplate.setType(newTemplate.getType());
        oldTemplate.setSketch(newTemplate.getSketch());
        oldTemplate.setEditTemplateUrl(newTemplate.getEditTemplateUrl());
        oldTemplate.setViewTemplateUrl(newTemplate.getViewTemplateUrl());
        oldTemplate.setName(newTemplate.getName());
        oldTemplate.setDescription(newTemplate.getDescription());
        Set schedules = newTemplate.getSchedules();
        if (!VerifyUtil.isEmpty((Collection)schedules)) {
            for (Schedule schedule : schedules) {
                schedule.setScheduleId(UUIDGenerator.getUUID());
            }
        }
        if (TEMPLATE3DC.contains(newTemplate.getType()) || this.is4dcWithoutVault(newTemplate) || !this.getIsReversed().booleanValue()) {
            oldTemplate.setSchedules(schedules);
            if (oldTemplate.getProps().containsKey("syncRateRecords")) {
                oldTemplate.getProps().put("syncRateRecords", "[]");
            }
        }
    }

    private boolean is4dcWithoutVault(PolicyTemplate newTemplate) {
        int templateType = newTemplate.getType();
        if (!TEMPLATE4DC.contains(templateType)) {
            return false;
        }
        return templateType != 40 && templateType != 41 && templateType != 42 && templateType != 43;
    }

    protected abstract void reverseProtectObjectAttributes(ProtectObject var1, Map<String, Object> var2);

    protected abstract void reverseProtectGroupAttributes(ProtectGroup var1, Map<String, Object> var2);

    protected Map<String, String> retrieveProductAndDisasterInfos(ProtectObjectReplica poReplica) {
        HashMap<String, String> infos = new HashMap<String, String>();
        for (RelicaStorageInfo storageInfo : poReplica.getStorageInfos()) {
            infos.put(storageInfo.getSrcStorageProviderSN(), storageInfo.getStorageProviderSN());
            infos.put(storageInfo.getStorageProviderSN(), storageInfo.getSrcStorageProviderSN());
            infos.put(storageInfo.getSrcStorageProviderSN() + ':' + storageInfo.getSrcStorageId(), storageInfo.getStorageProviderSN() + ':' + storageInfo.getStorageId());
            infos.put(storageInfo.getStorageProviderSN() + ':' + storageInfo.getStorageId(), storageInfo.getSrcStorageProviderSN() + ':' + storageInfo.getSrcStorageId());
        }
        return infos;
    }

    protected ProtectObjectReplica getProtectObjectReplica(ProtectObject protectObject, Map<String, Object> params) {
        String disasterSiteId = String.valueOf(params.get("DISASTER_SITE_ID"));
        String productSiteId = String.valueOf(params.get("PRODUCT_SITE_ID"));
        ProtectGroupReplica pgReplica = null;
        Set pgReplicas = protectObject.getProtectGroup().getReplicaList();
        for (ProtectGroupReplica replica : pgReplicas) {
            if (ProtectGroupUtil.isLocalStorageReplica(replica) || !replica.getRecoverySite().equals(disasterSiteId)) continue;
            pgReplica = replica;
            if (params.containsKey("oldProductSiteIds")) break;
            Set<String> productSiteIds = this.getProductSiteByPo(protectObject);
            params.put("oldProductSiteIds", productSiteIds);
            break;
        }
        if (null == pgReplica) {
            Set<String> productSiteIds = (Set<String>)params.get("oldProductSiteIds");
            if (null == productSiteIds || productSiteIds.size() == 0) {
                productSiteIds = this.getProductSiteByPo(protectObject);
            }
            for (ProtectGroupReplica replica : pgReplicas) {
                if (ProtectGroupUtil.isLocalStorageReplica(replica) || !productSiteIds.contains(replica.getRecoverySite()) && !productSiteId.equals(replica.getRecoverySite())) continue;
                pgReplica = replica;
                break;
            }
        }
        ProtectObjectReplica curPoReplica = null;
        if (null != pgReplica) {
            for (ProtectObjectReplica poReplica : pgReplica.getReplicas()) {
                if (!poReplica.getPoId().equals(protectObject.getUuid())) continue;
                curPoReplica = poReplica;
                break;
            }
        }
        if (null == curPoReplica) {
            logger.error((Object)"curPoReplica is null!");
            throw new LegoCheckedException(-1L);
        }
        return curPoReplica;
    }

    protected Set<String> getProductSiteByPo(ProtectObject protectObject) {
        HashSet<String> resourceWwnSet = new HashSet<String>();
        HashSet<String> productSiteIds = new HashSet<String>();
        Set storageInfos = protectObject.getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)storageInfos)) {
            logger.error((Object)"storageInfos is empty, poName: %s", new Object[]{protectObject.getName()});
            return productSiteIds;
        }
        ProtectObjectStorageInfo protectObjectStorageInfo = (ProtectObjectStorageInfo)storageInfos.iterator().next();
        String wwn = protectObjectStorageInfo.getLunWWN();
        resourceWwnSet.add(wwn);
        List luns = new ArrayList();
        try {
            luns = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getLunByWwn(protectObjectStorageInfo.getResourceProviderSN(), resourceWwnSet);
        }
        catch (Exception e) {
            logger.error((Object)"query lun by wwn error, devsn: %s, wwn: %s", new Object[]{protectObjectStorageInfo.getResourceProviderSN(), wwn});
        }
        Set devSns = luns.stream().map(lun -> lun.getDevSn()).collect(Collectors.toSet());
        for (String devSn : devSns) {
            Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteByDeviceSn(devSn);
            if (VerifyUtil.isEmpty((Object)site)) continue;
            productSiteIds.add(site.getSiteId());
        }
        return productSiteIds;
    }

    private Map<String, String> updateExtendedProps(Map<String, String> oldProps, Map<String, String> newProps) {
        if (VerifyUtil.isEmpty(newProps)) {
            logger.debug((Object)"newProps is empty!");
            return oldProps;
        }
        if (null == oldProps) {
            oldProps = new HashMap<String, String>();
        }
        for (Map.Entry<String, String> entry : newProps.entrySet()) {
            oldProps.put(entry.getKey(), entry.getValue());
        }
        ArrayList<String> oldKeys = new ArrayList<String>();
        for (Map.Entry<String, String> entry : oldProps.entrySet()) {
            if (newProps.containsKey(entry.getKey())) continue;
            oldKeys.add(entry.getKey());
        }
        for (String oldKey : oldKeys) {
            oldProps.remove(oldKey);
        }
        return oldProps;
    }

    private Lun filterMatchedLun(String resourceId, List<Lun> luns) {
        logger.debug((Object)("resourceId:" + resourceId));
        Lun matchedLun = null;
        for (Lun lun : luns) {
            if (!lun.getLunId().equals(resourceId)) continue;
            matchedLun = lun;
            break;
        }
        return matchedLun;
    }

    private void resumeGroup(ProtectGroup pg) {
        ITaskManager protectionTaskManager = (ITaskManager)ServiceLocator.getInstance().getService(ITaskManager.class);
        String groupName = protectionTaskManager.getGroupName(pg.getUuid());
        protectionTaskManager.resumeGroup(groupName);
        logger.debug((Object)("uuid:" + pg.getUuid() + ", groupName:" + groupName));
    }

    private List<Lun> getStorageLunsByDevId(String deviceId, List<String> listLunID) {
        logger.debug((Object)"deviceId:%s , listLunID:%s", new Object[]{deviceId, listLunID});
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("devSn", deviceId);
        props.put("lunId", listLunID.toArray());
        List groups = CommonDAOLocator.getMoDao().findMoBy(Lun.class, props);
        return groups;
    }

    private void deleteRemovedRecoverySettings(Set<RecoverySetting> oldRecoverySettings, Set<RecoverySetting> newRecoverySettings) {
        for (RecoverySetting setting : oldRecoverySettings) {
            if (newRecoverySettings.contains(setting)) continue;
            CommonDAOLocator.getMoDao().getHibernateTemplate().delete((Object)setting);
        }
    }

    private void deleteProtectionTasks(String protectGroupId) {
        List<ProtectionTask> tasks = this.getProtectionTasks(protectGroupId);
        if (null != tasks) {
            for (ProtectionTask task : tasks) {
                CommonDAOLocator.getMoDao().getHibernateTemplate().delete((Object)task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProtectionTask> getProtectionTasks(String protectGroupId) {
        if (VerifyUtil.isEmpty((String)protectGroupId)) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        List tasks = null;
        Session session = null;
        try {
            session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(ProtectionTask.class);
            criteria.add((Criterion)Restrictions.eq((String)"protectGroup.pgId", (Object)protectGroupId));
            tasks = criteria.list();
        }
        catch (Exception e) {
            try {
                ExceptionUtil.rethrowException((Throwable)e, (String)("get tasks by pgId failed, pgId=" + protectGroupId), (long)-1L, (String[])new String[0], (Log)logger);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return tasks;
    }

    private void updateRecoveryProcessDef(RecoveryPlan recoveryPlan) {
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan planWithProcess = planService.getRecoveryPlanWithProcess(recoveryPlan.getPlanId());
        if (null == planWithProcess) {
            logger.error((Object)("The recovery plan does not exist. Name:" + recoveryPlan.getName()), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        Set definitions = planWithProcess.getRecoveryProcesses();
        if (VerifyUtil.isEmpty((Collection)definitions)) {
            return;
        }
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (null == provider) {
            logger.error((Object)("provicer is null: " + recoveryPlan.getPlanId()), 90160758784001L);
            throw new LegoCheckedException(1073947395L);
        }
        Class customProcessorCls = provider.getCustomRecoveryProcessorClass();
        IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        for (RecoveryProcessDefinition definition : definitions) {
            Integer newProtectionType = mapTemplate.get(definition.getProtectionType());
            if (null != newProtectionType) {
                definition.setProtectionType(newProtectionType.intValue());
                recoveryProcessService.updateRecoveryProcessDefinition(definition);
            }
            if (this.getIsReversed().booleanValue()) continue;
            this.deleteCustomRecoveryProcessors(definition, customProcessorCls, provider);
        }
    }

    public void deleteCustomRecoveryProcessors(RecoveryProcessDefinition definition, Class<? extends RecoveryProcessor> customProcessorCls, IRecoveryProcessProvider provider) {
        if (null == customProcessorCls || null == definition || VerifyUtil.isEmpty((Collection)definition.getRecoveryProcessors())) {
            return;
        }
        Set processors = definition.getRecoveryProcessors();
        Iterator procIterator = processors.iterator();
        while (procIterator.hasNext()) {
            RecoveryProcessor processor = (RecoveryProcessor)procIterator.next();
            if (!processor.getClass().getName().equals(customProcessorCls.getName()) || !provider.checkIfAllowDelete(processor)) continue;
            provider.deleteRecoveryProcessors(definition, processor.getProcId(), true);
            procIterator = processors.iterator();
        }
    }

    private void deleteProtectActions(String pgId) {
        logger.debug((Object)("pgId:" + pgId));
        String hql = "from AbstractBaseProtectAction action where action.protectGroupId=?";
        List actions = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[]{pgId});
        if (!VerifyUtil.isEmpty((Collection)actions)) {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().deleteAll((Collection)actions);
        }
    }

    private DRMObject getMatchedDrmObject(Set<? extends DRMObject> drmObjects, DRMObject drmObject) {
        for (DRMObject dRMObject : drmObjects) {
            if (!dRMObject.getUuid().equals(drmObject.getUuid())) continue;
            return dRMObject;
        }
        logger.warn((Object)"getMatchedDrmObject return null.");
        return null;
    }

    private boolean refactorLocalReplica(ProtectGroup pg, Map<String, Object> params) {
        boolean changed = false;
        if (VerifyUtil.isEmpty((Object)pg) || VerifyUtil.isEmpty((Collection)pg.getReplicaList())) {
            return changed;
        }
        ProtectGroupReplica remotePgReplica = this.findMatchFromReversedRemoteReplica(pg, params);
        if (VerifyUtil.isEmpty((Object)remotePgReplica)) {
            return changed;
        }
        HashMap<String, ProtectObject> poMap = new HashMap<String, ProtectObject>();
        for (ProtectObject po : pg.getPolist()) {
            poMap.put(po.getUuid(), po);
        }
        for (ProtectGroupReplica pgr : pg.getReplicaList()) {
            if (!pgr.isSanSnapshotReplica() && !pgr.isBackUpReplica()) continue;
            changed = this.refactorReplica(pg, changed, remotePgReplica, pgr);
            Set replicas = pgr.getReplicas();
            this.refactorLocalPoReplica(remotePgReplica, replicas, poMap, params);
        }
        params.put("REPLICA_ID", remotePgReplica.getId());
        if (changed) {
            logger.info((Object)"Use remoteReplica: pArray=%s, dArray=%s, replicaName=%s", new Object[]{remotePgReplica.getProductArray(), remotePgReplica.getRecoveryArray(), remotePgReplica.getName()});
            CommonDAOLocator.getBaseDao().saveOrUpdateAll((Collection)pg.getReplicaList());
        }
        return changed;
    }

    private boolean refactorReplica(ProtectGroup pg, boolean changed, ProtectGroupReplica remotePgReplica, ProtectGroupReplica pgr) {
        if (remotePgReplica.getProductArray().equals(pgr.getStorageDeviceId()) && pgr.getProtectLocation() != DrmEnumDefine.PROTECT_LOCATION.PL_A.getValue()) {
            changed = true;
            pgr.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.PL_A.getValue());
            pgr.setProductArray(remotePgReplica.getProductArray());
        } else if (remotePgReplica.getRecoveryArray().equals(pgr.getStorageDeviceId()) && pgr.getProtectLocation() != DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue()) {
            changed = true;
            pgr.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue());
            pgr.setProductArray(remotePgReplica.getProductArray());
        }
        if (this.refactorRemoteDisasterSitePgr(pg, remotePgReplica, pgr)) {
            changed = true;
        }
        return changed;
    }

    private boolean refactorRemoteDisasterSitePgr(ProtectGroup pg, ProtectGroupReplica remotePgReplica, ProtectGroupReplica pgr) {
        if (this.is4dcWithoutVault(pg.getTemplate())) {
            return false;
        }
        String pgrStorageDeviceId = pgr.getStorageDeviceId();
        if (remotePgReplica.getProductArray().equals(pgrStorageDeviceId) || remotePgReplica.getRecoveryArray().equals(pgrStorageDeviceId)) {
            return false;
        }
        Set hyperMetroSiteIdSet = pg.getHyperMetroSiteIdSet();
        if (hyperMetroSiteIdSet.contains(pgrStorageDeviceId)) {
            return false;
        }
        if (pgr.getProtectLocation() == DrmEnumDefine.PROTECT_LOCATION.PL_B_C.getValue()) {
            pgr.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.PL_A_C.getValue());
            logger.info((Object)"protectGroup replica id = %s change location 3 to 2.", new Object[]{pgr.getId()});
            return true;
        }
        if (pgr.getProtectLocation() == DrmEnumDefine.PROTECT_LOCATION.PL_A_C.getValue() && PolicyTemplateType.REP_4DC_CASCADE_POLICYTEMPLATE.contains(pg.getTemplate().getType()) && hyperMetroSiteIdSet.contains(pg.getProductSiteId())) {
            pgr.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.PL_B_C.getValue());
            logger.info((Object)"protectGroup replica id = %s change location 2 to 3.", new Object[]{pgr.getId()});
            return true;
        }
        return false;
    }

    private ProtectGroupReplica findMatchFromReversedRemoteReplica(ProtectGroup pg, Map<String, Object> params) {
        List protectGroupReplicas = pg.listAllReplicatonRepica();
        if (!TEMPLATE4DC.contains(pg.getTemplate().getType()) || this.is4dcWithoutVault(pg.getTemplate())) {
            return pg.getAnyoneReplicationReplica();
        }
        List collect = protectGroupReplicas.stream().filter(protectGroupReplica -> pg.getPoProviderSN().equals(protectGroupReplica.getProductArray())).collect(Collectors.toList());
        if (collect.size() == 1) {
            return (ProtectGroupReplica)collect.get(0);
        }
        for (ProtectGroupReplica remoteReplica : collect) {
            if (!Objects.equals(remoteReplica.getProductArray(), pg.getPoProviderSN()) || !Objects.equals(remoteReplica.getRecoveryArray(), params.get(pg.getPoProviderSN()))) continue;
            return remoteReplica;
        }
        Set hyperMetroSiteIdSet = pg.getHyperMetroSiteIdSet();
        for (ProtectGroupReplica remoteReplica : collect) {
            if (!hyperMetroSiteIdSet.contains(remoteReplica.getRecoverySite())) continue;
            return remoteReplica;
        }
        logger.warn((Object)"Can't find remoteReplica by ProductArray: productArray=%s", new Object[]{pg.getPoProviderSN()});
        return null;
    }

    protected void refactorLocalPoReplica(ProtectGroupReplica remotePgReplica, Set<ProtectObjectReplica> replicas, Map<String, ProtectObject> poMap, Map<String, Object> params) {
        if (VerifyUtil.isEmpty(replicas) || VerifyUtil.isEmpty((Object)remotePgReplica)) {
            return;
        }
        for (ProtectObjectReplica poReplica : replicas) {
            this.refactorRelicaStorageInfo(remotePgReplica, poReplica, params);
            ProtectObject po = poMap.get(poReplica.getPoId());
            if (!VerifyUtil.isEmpty((Object)po)) {
                poReplica.setProtectObject(po);
                continue;
            }
            logger.error((Object)("po not found:" + poReplica.getPoId()));
        }
    }

    protected void refactorRelicaStorageInfo(ProtectGroupReplica remotePgReplica, ProtectObjectReplica poReplica, Map<String, Object> params) {
        Set storageInfos = poReplica.getStorageInfos();
        ProtectObject po = poReplica.getProtectObject();
        if (VerifyUtil.isEmpty((Object)remotePgReplica) || VerifyUtil.isEmpty((Collection)storageInfos)) {
            return;
        }
        this.caculateOToNewWwnMap(new ArrayList<ProtectObjectStorageInfo>(po.getUsedStorageResourceSet()), (ProtectObject)CommonUtil.getFirstElement((Collection)remotePgReplica.getPg().getPolist()), params);
        HashSet remoteStorageInfos = new HashSet();
        Set remotePoReplicas = remotePgReplica.getReplicas();
        if (!VerifyUtil.isEmpty((Collection)remotePoReplicas)) {
            for (ProtectObjectReplica remotePoReplica : remotePoReplicas) {
                remoteStorageInfos.addAll(remotePoReplica.getStorageInfos());
            }
        }
        Map olToNewWwnMap = (Map)params.get("olToNewWwnMap");
        block1: for (RelicaStorageInfo storageInfo : storageInfos) {
            for (RelicaStorageInfo remoteStorageInfo : remoteStorageInfos) {
                if (!remoteStorageInfo.getSrcStorageId().equals(storageInfo.getSrcStorageId()) && !remoteStorageInfo.getStorageId().equals(storageInfo.getSrcStorageId()) && (null == olToNewWwnMap || !remoteStorageInfo.getProtectObjectStorageWwn().equals(olToNewWwnMap.get(storageInfo.getProtectObjectStorageWwn()))) && !remoteStorageInfo.getProtectObjectStorageWwn().equals(storageInfo.getProtectObjectStorageWwn())) continue;
                storageInfo.setProtectObjectStorageWwn(remoteStorageInfo.getProtectObjectStorageWwn());
                continue block1;
            }
        }
        for (RelicaStorageInfo storageInfo : po.getUsedStorageResourceSet()) {
            if (null == olToNewWwnMap) {
                return;
            }
            String newWwn = (String)olToNewWwnMap.get(storageInfo.getLunWWN());
            if (null == newWwn) continue;
            storageInfo.setLunWWN(newWwn);
        }
    }

    protected void resetWwnMap(ProtectObject po, ProtectGroupReplica remotePgReplica, Map<String, Object> params) {
    }

    private void refactorLocalScheduleAndProps(ProtectGroup pg, int oldPolicytemplateType) {
        TemplateFilterManager manager;
        IPolicyTemplateFilter filter;
        List<ProtectLocationPath> paths;
        if (VerifyUtil.isEmpty((Object)pg) || VerifyUtil.isEmpty((Object)pg.getTemplate())) {
            return;
        }
        PolicyTemplate template = pg.getTemplate();
        if (PolicyTemplateType.OPENSTACK_POLICYTEMPLATE.contains(template.getType())) {
            return;
        }
        if (null != template.getProps().get("AUTOMOUNTCONFIGS")) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"enabled", (Object)false);
            template.getProps().put("AUTOMOUNTCONFIGS", jsonObject.toString());
        }
        if (null == (paths = (filter = (manager = TemplateFilterManager.getInstance()).getTemplateFilterByType(template.getType())).getProtectLocationPaths(new ArrayList(pg.getPolist())))) {
            logger.debug((Object)"paths is null");
            paths = Collections.emptyList();
        }
        pg.getProps().put("PROTECTGROUP_PROTECTLOCATIONPATH", JSONArray.fromObject(paths).toString());
        Set schedules = template.getSchedules();
        if (VerifyUtil.isEmpty((Collection)schedules)) {
            logger.error((Object)"no need reverse schedule.");
            return;
        }
        HashMap<String, ProtectLocationPath> pathMap = new HashMap<String, ProtectLocationPath>();
        for (ProtectLocationPath path : paths) {
            pathMap.put(path.getRecoverySiteId(), path);
        }
        HashMap<Integer, ProtectLocationPath> locationMap = new HashMap<Integer, ProtectLocationPath>();
        for (ProtectLocationPath path : paths) {
            locationMap.put(path.getProtectLocation(), path);
        }
        for (Schedule schedule : schedules) {
            this.updateSchedule(pg, pathMap, locationMap, schedule, oldPolicytemplateType, template.getType());
        }
    }

    private void updateSchedule(ProtectGroup protectGroup, Map<String, ProtectLocationPath> pathMap, Map<Integer, ProtectLocationPath> locationMap, Schedule schedule, int oldTemplateType, int newTemplateType) {
        if (11 == protectGroup.getPoType()) {
            schedule.setAppConsistent(Boolean.valueOf(false));
        }
        if (!ScheduleProtectedType.getAllProtectedTypes().contains(schedule.getProtectedType())) {
            this.updateDRRingScheduleProtectLocationPath(locationMap, newTemplateType, schedule);
            this.update4dcScheduleProtectLocationPath(protectGroup.getTemplate(), schedule);
            ProtectLocationPath path = locationMap.get(schedule.getProtectLocation());
            schedule.setSourceSiteId(path.getProtectedSiteId());
            schedule.setTargetSiteId(path.getRecoverySiteId());
            schedule.setName(path.getProtectedSiteId() + ";" + path.getRecoverySiteId());
            schedule.setSourceSn(path.getProtectedStorageSN());
            schedule.setTargetSn(path.getRecoveryStorageSN());
            this.updateReplicationMode(locationMap, schedule, newTemplateType);
            if (schedule.getProtectedType() == -1 || schedule.getProtectedType() == oldTemplateType) {
                schedule.setProtectedType(newTemplateType);
            }
            return;
        }
        if (null == schedule.getSourceSiteId()) {
            this.setScheduleManual(protectGroup, schedule);
            return;
        }
        ProtectLocationPath path = pathMap.get(schedule.getSourceSiteId());
        if (null == path) {
            schedule.setEnable(Boolean.valueOf(false));
        } else {
            Integer location = path.getProtectLocation();
            schedule.setSourceSiteId(path.getRecoverySiteId());
            schedule.setTargetSiteId(path.getRecoverySiteId());
            schedule.setProtectLocation(location.intValue());
        }
        if (schedule.getPeriodType() == 5) {
            this.setScheduleManual(protectGroup, schedule);
        }
        schedule.setScheduleMode(1);
    }

    private void updateReplicationMode(Map<Integer, ProtectLocationPath> locationMap, Schedule schedule, int newTemplateType) {
        if (TEMPLATE4DC.contains(newTemplateType)) {
            Map<String, String> extParameters = schedule.getExtParameters() == null ? new HashMap() : schedule.getExtParameters();
            schedule.setExtParameters(extParameters);
            boolean isSnapShot = schedule.getProtectedType() == 2 || schedule.getProtectedType() == 100;
            ProtectLocationPath locationPath = this.findMatchLocationBySchedule(locationMap.values(), schedule);
            if (!VerifyUtil.isEmpty((Object)locationPath) && !isSnapShot) {
                extParameters.put("replicationMode", locationPath.getReplicationMode());
            }
        }
    }

    private ProtectLocationPath findMatchLocationBySchedule(Collection<ProtectLocationPath> values, Schedule schedule) {
        for (ProtectLocationPath path : values) {
            if (!Objects.equals(schedule.getSourceSiteId(), path.getProtectedSiteId()) || !Objects.equals(schedule.getTargetSiteId(), path.getRecoverySiteId())) continue;
            return path;
        }
        return null;
    }

    private void update4dcScheduleProtectLocationPath(PolicyTemplate newTemplateType, Schedule schedule) {
        logger.debug((Object)"protect location: %s", new Object[]{String.valueOf(schedule.getProtectLocation())});
        if (!TEMPLATE4DC.contains(newTemplateType.getType()) || this.is4dcWithoutVault(newTemplateType)) {
            return;
        }
        if (schedule.getProtectLocation() == DrmEnumDefine.PROTECT_LOCATION.PL_B_C.getValue()) {
            schedule.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.PL_A_C.getValue());
            return;
        }
        if (schedule.getProtectLocation() == DrmEnumDefine.PROTECT_LOCATION.PL_A_C.getValue()) {
            schedule.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.PL_B_C.getValue());
        }
    }

    private void setScheduleManual(ProtectGroup protectGroup, Schedule schedule) {
        if (null == schedule) {
            return;
        }
        IProtectionTaskService service = (IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class);
        schedule.setScheduleMode(1);
        schedule.setPeriodType(2);
        if (null != schedule.getRetentionPolicy()) {
            schedule.getRetentionPolicy().setLatestCopies(5);
            schedule.getRetentionPolicy().setDailyCopies(0);
            schedule.getRetentionPolicy().setWeeklyCopies(0);
            schedule.getRetentionPolicy().setMonthlyCopyies(0);
        }
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)service.getTask(protectGroup.getUuid(), schedule.getScheduleId()))) {
            service.addTask(protectGroup, schedule);
        }
    }

    static {
        mapTemplate.put(4, 6);
        mapTemplate.put(6, 4);
        mapTemplate.put(3, 5);
        mapTemplate.put(5, 3);
        mapTemplate.put(18, 20);
        mapTemplate.put(20, 18);
        mapTemplate.put(23, 24);
        mapTemplate.put(24, 23);
        mapTemplate.put(31, 32);
        mapTemplate.put(32, 31);
        mapTemplate.put(35, 36);
        mapTemplate.put(36, 35);
        mapTemplate.put(38, 39);
        mapTemplate.put(39, 38);
        mapTemplate.put(26, 27);
        mapTemplate.put(27, 26);
        mapTemplate.put(40, 41);
        mapTemplate.put(41, 40);
        mapTemplate.put(42, 43);
        mapTemplate.put(43, 42);
        TEMPLATE3DC.add(4);
        TEMPLATE3DC.add(6);
        TEMPLATE3DC.add(3);
        TEMPLATE3DC.add(5);
        TEMPLATE3DC.add(26);
        TEMPLATE3DC.add(27);
        TEMPLATE4DC.add(35);
        TEMPLATE4DC.add(36);
        TEMPLATE4DC.add(38);
        TEMPLATE4DC.add(39);
        TEMPLATE4DC.add(40);
        TEMPLATE4DC.add(41);
        TEMPLATE4DC.add(42);
        TEMPLATE4DC.add(43);
    }
}

