/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.provider;

import com.huawei.ism.drm.recovery.process.IRefactorConfigurationProvider;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.CollectionUtils;

public final class RefactorConfigurationProviderMgr {
    private static RefactorConfigurationProviderMgr refactorConfigProviderMgr = new RefactorConfigurationProviderMgr();
    private Map<String, IRefactorConfigurationProvider> refactorConfigurationProviders = new ConcurrentHashMap<String, IRefactorConfigurationProvider>();

    private RefactorConfigurationProviderMgr() {
    }

    public static RefactorConfigurationProviderMgr getInstance() {
        return refactorConfigProviderMgr;
    }

    public IRefactorConfigurationProvider getRefactorConfigurationProvider(String appType) {
        return this.refactorConfigurationProviders.get(appType);
    }

    public void onBind(IRefactorConfigurationProvider provider, Map<?, ?> properties) {
        if (!CollectionUtils.isEmpty((Collection)provider.getAppType())) {
            for (String appType : provider.getAppType()) {
                this.refactorConfigurationProviders.put(appType, provider);
            }
        }
    }

    public void onUnbind(IRefactorConfigurationProvider provider, Map<?, ?> properties) {
        for (String appType : provider.getAppType()) {
            this.refactorConfigurationProviders.remove(appType);
        }
    }
}

