/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.task;

import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.util.UUIDGenerator;

public final class RecoveryProcessCascadeExecutor
implements IProcessor {
    private RecoveryProcessor recoveryProcessor;
    private String name;

    private RecoveryProcessCascadeExecutor() {
    }

    public static RecoveryProcessCascadeExecutor createExecutor(RecoveryProcessor recoveryProcessor) {
        RecoveryProcessCascadeExecutor executor = new RecoveryProcessCascadeExecutor();
        executor.recoveryProcessor = recoveryProcessor;
        executor.name = "RPCE_" + UUIDGenerator.getUUID();
        return executor;
    }

    public String getName() {
        return this.name;
    }

    public boolean process(RecoveryProcessorContext context) {
        return this.cascadeExecuteProcessor(this.recoveryProcessor, context);
    }

    private boolean cascadeExecuteProcessor(RecoveryProcessor processor, RecoveryProcessorContext context) {
        boolean result = processor.process(context);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor(processor);
        if (!result) {
            return result;
        }
        if (null != processor.getNextCascadeProcessor()) {
            result = this.cascadeExecuteProcessor(processor.getNextCascadeProcessor(), context);
        }
        return result;
    }
}

