/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.util;

import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.recovery.framework.checker.manager.RecoveryProcessCheckerManager;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessChecker;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.manager.proxy.StoragePortLinksManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStoragePortLinksManager;
import com.huawei.ism.drm.storage.sdk.model.RemoteLinkDevice;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.drm.storage.util.SnapshotScheduleUtil;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public final class RecoveryProcessUtil {
    private static Log logger = LogFactory.getInstance(RecoveryProcessUtil.class);
    private static final String ALL_RELATED_REPLICATION_PAIRS = "all-related-replication-pairs";
    private static final String STANDBY = "standby";

    private RecoveryProcessUtil() {
    }

    public static String generateLunAndHostMapKey(RemoteStorageReplica remoteStorageReplica) {
        if (VerifyUtil.isEmpty((Object)remoteStorageReplica)) {
            return "";
        }
        String replicationId = remoteStorageReplica.getReplicationPairId();
        if (!VerifyUtil.isEmpty((String)remoteStorageReplica.getConsistentGroupId()) && !remoteStorageReplica.getConsistentGroupId().equals("--")) {
            replicationId = remoteStorageReplica.getConsistentGroupId();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(replicationId);
        builder.append(":");
        builder.append(remoteStorageReplica.getSrcStorageProviderSN());
        builder.append(":");
        builder.append(remoteStorageReplica.getSrcStorageId());
        builder.append(":");
        builder.append(remoteStorageReplica.getStorageProviderSN());
        builder.append(":");
        builder.append(remoteStorageReplica.getStorageId());
        return builder.toString();
    }

    public static String generateLunAndHostMapKey(String replicationId, String srcProviderSN, String srcStorageId, String providerSN, String storageId) {
        if (VerifyUtil.isEmpty((String)replicationId) || VerifyUtil.isEmpty((String)srcProviderSN) || VerifyUtil.isEmpty((String)srcStorageId) || VerifyUtil.isEmpty((String)providerSN) || VerifyUtil.isEmpty((String)storageId)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(replicationId);
        builder.append(":");
        builder.append(srcProviderSN);
        builder.append(":");
        builder.append(srcStorageId);
        builder.append(":");
        builder.append(providerSN);
        builder.append(":");
        builder.append(storageId);
        return builder.toString();
    }

    public static String getSrcLunIdFromLunAndHostMapKey(String lunAndHostMapKey) {
        if (VerifyUtil.isEmpty((String)lunAndHostMapKey)) {
            return "";
        }
        String[] strArray = lunAndHostMapKey.split(":");
        if (strArray == null || strArray.length < 3) {
            return "";
        }
        return strArray[2];
    }

    public static String getLunIdFromLunAndHostMapKey(String lunAndHostMapKey) {
        if (VerifyUtil.isEmpty((String)lunAndHostMapKey)) {
            return "";
        }
        String[] strArray = lunAndHostMapKey.split(":");
        if (strArray == null || strArray.length < 5) {
            return "";
        }
        return strArray[4];
    }

    public static String getProtectGroupIdFromWrapper(String wrappedProtectGroupId) {
        if (VerifyUtil.isEmpty((String)wrappedProtectGroupId)) {
            logger.error((Object)"wrapped pg id is null");
            return wrappedProtectGroupId;
        }
        if (!wrappedProtectGroupId.contains(":")) {
            return wrappedProtectGroupId;
        }
        return wrappedProtectGroupId.split(":")[0];
    }

    public static String getHostOrGroupIds(List<String> hostOrGroupIds) {
        if (VerifyUtil.isEmpty(hostOrGroupIds)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (String hostMoId : hostOrGroupIds) {
            builder.append(hostMoId);
            if (++index >= hostOrGroupIds.size()) continue;
            builder.append(":");
        }
        return builder.toString();
    }

    public static List<String> getHostOrGroupIds(String hostOrGroupIds) {
        String[] strArray;
        ArrayList<String> hostOrGroupIdList = new ArrayList<String>();
        if (VerifyUtil.isEmpty((String)hostOrGroupIds)) {
            return hostOrGroupIdList;
        }
        for (String str : strArray = hostOrGroupIds.split(":")) {
            hostOrGroupIdList.add(str);
        }
        return hostOrGroupIdList;
    }

    public static List<Long> getHostMoIds(String hostMoIds) {
        String[] strArray;
        ArrayList<Long> hostMoIdList = new ArrayList<Long>();
        if (VerifyUtil.isEmpty((String)hostMoIds)) {
            return hostMoIdList;
        }
        for (String str : strArray = hostMoIds.split(":")) {
            hostMoIdList.add(NumberUtil.convertToLong((Object)str));
        }
        return hostMoIdList;
    }

    public static String getPoIds(List<String> poIds) {
        if (VerifyUtil.isEmpty(poIds)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (String poId : poIds) {
            builder.append(poId);
            if (++index >= poIds.size()) continue;
            builder.append(":");
        }
        return builder.toString();
    }

    public static List<String> getPoIds(String poIds) {
        String[] strArray;
        ArrayList<String> poIdList = new ArrayList<String>();
        if (VerifyUtil.isEmpty((String)poIds)) {
            return poIdList;
        }
        for (String str : strArray = poIds.split(":")) {
            poIdList.add(str);
        }
        return poIdList;
    }

    public static String[] getProtectGroupIds(Set<ProtectGroup> pgs) {
        if (VerifyUtil.isEmpty(pgs)) {
            return new String[0];
        }
        String[] results = new String[pgs.size()];
        int i = 0;
        for (ProtectGroup pg : pgs) {
            results[i++] = pg.getUuid();
        }
        return results;
    }

    public static RecoveryProcessSerialExecutor createSerialExecutorWithConcurrentSubExecutor(Map<Integer, List<IProcessor>> processorsWithPriority, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type, boolean isAsc) {
        int i;
        if (null == processorsWithPriority || null == type) {
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<IProcessor> iProcessors = new ArrayList<IProcessor>();
        ArrayList<RecoveryProcessConcurrentExecutor> subProcessors = new ArrayList<RecoveryProcessConcurrentExecutor>();
        ArrayList<Integer> priorityLevel = new ArrayList<Integer>();
        priorityLevel.addAll(processorsWithPriority.keySet());
        Collections.sort(priorityLevel, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return arg0.compareTo(arg1);
            }
        });
        if (isAsc) {
            for (i = 0; i < priorityLevel.size(); ++i) {
                List<IProcessor> processors = processorsWithPriority.get(priorityLevel.get(i));
                RecoveryProcessConcurrentExecutor executor = null;
                executor = RecoveryProcessConcurrentExecutor.createExecutor(processors, false);
                subProcessors.add(executor);
                iProcessors.addAll(processors);
            }
        } else {
            for (i = priorityLevel.size() - 1; i >= 0; --i) {
                List<IProcessor> processors = processorsWithPriority.get(priorityLevel.get(i));
                RecoveryProcessConcurrentExecutor executor = null;
                executor = RecoveryProcessConcurrentExecutor.createExecutor(processors, false);
                subProcessors.add(executor);
                iProcessors.addAll(processors);
            }
        }
        RecoveryProcessUtil.updateProgressRatio(iProcessors);
        RecoveryProcessSerialExecutor mainExecutor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(subProcessors, type);
        if (null == mainExecutor) {
            logger.error((Object)"mainExecutor is null.");
            throw new LegoCheckedException(0x300001L);
        }
        return mainExecutor;
    }

    public static RecoveryProcessSerialExecutor createSerialExecutorWithSerialSubExecutor(Map<Integer, List<IProcessor>> processorsWithPriority, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type, boolean isAsc) {
        int i;
        if (null == processorsWithPriority || null == type) {
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<IProcessor> iProcessors = new ArrayList<IProcessor>();
        ArrayList<RecoveryProcessSerialExecutor> subProcessors = new ArrayList<RecoveryProcessSerialExecutor>();
        ArrayList<Integer> priorityLevel = new ArrayList<Integer>();
        priorityLevel.addAll(processorsWithPriority.keySet());
        Collections.sort(priorityLevel, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return arg0.compareTo(arg1);
            }
        });
        if (isAsc) {
            for (i = 0; i < priorityLevel.size(); ++i) {
                List<IProcessor> processors = processorsWithPriority.get(priorityLevel.get(i));
                RecoveryProcessSerialExecutor executor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(processors, type);
                subProcessors.add(executor);
                iProcessors.addAll(processors);
            }
        } else {
            for (i = priorityLevel.size() - 1; i >= 0; --i) {
                List<IProcessor> processors = processorsWithPriority.get(priorityLevel.get(i));
                RecoveryProcessSerialExecutor executor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(processors, type);
                subProcessors.add(executor);
                iProcessors.addAll(processors);
            }
        }
        RecoveryProcessUtil.updateProgressRatio(iProcessors);
        RecoveryProcessSerialExecutor mainExecutor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(subProcessors, type);
        return mainExecutor;
    }

    private static void updateProgressRatio(List<IProcessor> iProcessors) {
        ArrayList<RecoveryProcessor> recoveryProcessors = new ArrayList<RecoveryProcessor>();
        for (IProcessor processor : iProcessors) {
            if (!(processor instanceof RecoveryProcessor)) continue;
            recoveryProcessors.add((RecoveryProcessor)processor);
        }
        RecoveryServiceUtil.updateProgressRatio(recoveryProcessors);
    }

    public static boolean isConsistentGroup(RemoteStorageReplica remoteStorageReplica) {
        String consistentGroupId = remoteStorageReplica.getConsistentGroupId();
        boolean isConsistentGroup = false;
        if (null != consistentGroupId && 0 < consistentGroupId.length() && !consistentGroupId.equals("--")) {
            isConsistentGroup = true;
        }
        return isConsistentGroup;
    }

    public static boolean isVstorePair(RemoteStorageReplica remoteStorageReplica) {
        String vstorePairId = remoteStorageReplica.getVstorePairId();
        return !VerifyUtil.isEmpty((String)vstorePairId) && !vstorePairId.startsWith("--");
    }

    public static RecoveryProcessor getValidPreviousProcessor(RecoveryProcessor recoveryProcessor) {
        RecoveryProcessor preProcessor;
        if (null == recoveryProcessor) {
            return null;
        }
        for (preProcessor = recoveryProcessor.getPreviousProcessor(); null != preProcessor && !preProcessor.getIsEnabled().booleanValue(); preProcessor = preProcessor.getPreviousProcessor()) {
        }
        return preProcessor;
    }

    public static RecoveryProcessor getValidNextProcessor(RecoveryProcessor recoveryProcessor) {
        RecoveryProcessor nextProcessor;
        if (null == recoveryProcessor) {
            return null;
        }
        for (nextProcessor = recoveryProcessor.getNextProcessor(); null != nextProcessor && !nextProcessor.getIsEnabled().booleanValue(); nextProcessor = nextProcessor.getNextProcessor()) {
        }
        return nextProcessor;
    }

    public static String constructParamsString(String[] params) {
        JSONArray jsonArray = new JSONArray();
        if (null == params) {
            return "";
        }
        for (int i = 0; i < params.length; ++i) {
            jsonArray.add((Object)params[i]);
        }
        return jsonArray.toString();
    }

    public static boolean isAllSrcLunUnMapping(RecoveryProcessorContext context, Site remoteSite, Collection<RecoveryTask> recoveryTasks) {
        RecoveryPlan plan = context.getRecoveryPlan();
        Iterator iterator = plan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        HashSet<Integer> hyperMetreTypeSet = new HashSet<Integer>(Arrays.asList(18, 23, 31, 36, 35, 38, 39));
        PolicyTemplate template = ((ProtectGroup)iterator.next()).getTemplate();
        if (null != template && hyperMetreTypeSet.contains(template.getType())) {
            if (null == context.getProtectGroup()) {
                logger.error((Object)"The protectgroup in context is empty!");
                throw new LegoCheckedException(1073947394L);
            }
            return RecoveryProcessUtil.checkHyperMetroSrcLunUnMapping(remoteSite, context.getProtectGroup().getPolist());
        }
        HashMap<String, Set<String>> devAndLunMap = new HashMap<String, Set<String>>();
        for (RecoveryTask rt : recoveryTasks) {
            Map lunAndHostMap = rt.getLunAndHostMap();
            Map resourceAndTypeMap = rt.getResourceAndTypeMap();
            String srcDevId = rt.getSrcDeviceId();
            HashSet<String> srcLunIds = (HashSet<String>)devAndLunMap.get(srcDevId);
            if (null == srcLunIds) {
                srcLunIds = new HashSet<String>();
                devAndLunMap.put(srcDevId, srcLunIds);
            }
            for (String key : lunAndHostMap.keySet()) {
                if (DrmEnumDefine.APP_TYPE.NAS_FILESYSTEM.getValue() == ((Integer)resourceAndTypeMap.get(key)).intValue()) continue;
                String srcLunId = RecoveryProcessUtil.getSrcLunIdFromLunAndHostMapKey(key);
                srcLunIds.add(srcLunId);
            }
        }
        return RecoveryProcessUtil.isSrcLunsUnMapping(remoteSite, devAndLunMap);
    }

    private static boolean isSrcLunsUnMapping(Site remoteSite, Map<String, Set<String>> devAndLunMap) {
        boolean isSrcLunUnMap = false;
        for (Map.Entry<String, Set<String>> entry : devAndLunMap.entrySet()) {
            ArrayList<String> srcLunIds;
            String devId = entry.getKey();
            isSrcLunUnMap = RecoveryProcessUtil.isSrcLunUnMapping(remoteSite, devId, srcLunIds = new ArrayList<String>((Collection)entry.getValue()));
            if (isSrcLunUnMap) continue;
            return false;
        }
        return isSrcLunUnMap;
    }

    private static boolean checkHyperMetroSrcLunUnMapping(Site productionSite, Set<ProtectObject> protectObjects) {
        Set<String> lunWwnSet = RecoveryProcessUtil.getAllWwn(protectObjects);
        ArrayList<String> wwnList = new ArrayList<String>(lunWwnSet);
        List<Lun> lunList = StorageResourceServiceRouter.getInstance().getStorageResourcesByWwns(productionSite.getServerUuid(), wwnList, Lun.class);
        HashMap<String, Set<String>> devAndLunMap = new HashMap<String, Set<String>>();
        for (Lun lun : lunList) {
            HashSet<String> srcLunIds = (HashSet<String>)devAndLunMap.get(lun.getDevSn());
            if (null == srcLunIds) {
                srcLunIds = new HashSet<String>();
                devAndLunMap.put(lun.getDevSn(), srcLunIds);
            }
            srcLunIds.add(lun.getLunId());
        }
        return RecoveryProcessUtil.isSrcLunsUnMapping(productionSite, devAndLunMap);
    }

    public static void addContextParam(RecoveryProcessorContext context, String key, String value) {
        if (null == context) {
            logger.error((Object)("save context param failed, context is null, key: " + key + ", value:" + value));
            return;
        }
        String contextParamsStr = (String)context.getAttribute("ContextParams");
        JSONObject contextParams = JSONObject.fromObject((Object)contextParamsStr);
        if (null == contextParams) {
            contextParams = new JSONObject();
        }
        String valueStr = "";
        if (contextParams.size() != 0 && contextParams.containsKey((Object)key) && !VerifyUtil.isEmpty((String)(valueStr = (String)contextParams.get(key)))) {
            valueStr = valueStr + ",";
        }
        contextParams.put((Object)key, (Object)(valueStr + value));
        context.setAttribute("ContextParams", (Object)contextParams.toString());
        logger.info((Object)("saved key: " + key + ", value: " + value + " to context param."));
    }

    public static void removeContextParamByKey(RecoveryProcessorContext context, String key) {
        if (null == context) {
            logger.error((Object)("delete context param failed, context is null, key: " + key));
            return;
        }
        String contextParamsStr = (String)context.getAttribute("ContextParams");
        JSONObject contextParams = JSONObject.fromObject((Object)contextParamsStr);
        if (null != contextParams) {
            contextParams.remove((Object)key);
            context.setAttribute("ContextParams", (Object)contextParams.toString());
        }
        logger.info((Object)("deleted key: " + key + " from context param."));
    }

    public static String getContextParamByKey(RecoveryProcessorContext context, String key) {
        if (null == context) {
            logger.error((Object)("delete context param failed, context is null, key: " + key));
            return null;
        }
        String contextParamsStr = (String)context.getAttribute("ContextParams");
        JSONObject contextParams = JSONObject.fromObject((Object)contextParamsStr);
        if (null == contextParams) {
            logger.error((Object)"contextParams is null");
            return null;
        }
        return (String)contextParams.get(key);
    }

    public static boolean isAllSrcLunUnMapping(RecoveryProcessorContext context, Collection<RecoveryTask> recoveryTasks) {
        if (null == recoveryTasks) {
            throw new LegoCheckedException(-1L);
        }
        ProtectGroup protectGroup = context.getProtectGroup();
        if (protectGroup.getTemplate().getType() == 44) {
            return RecoveryProcessUtil.checkAirGapSrcLunUnMapping(protectGroup);
        }
        Map<String, Set<String>> devLunMap = RecoveryProcessUtil.getReplicaSourceMap(context);
        if (!VerifyUtil.isEmpty(devLunMap)) {
            return RecoveryProcessUtil.isReplicaSourceUnMapping(devLunMap);
        }
        HashSet<String> devSns = new HashSet<String>();
        HashSet<String> srcLunIds = new HashSet<String>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            Iterator iterator;
            devSns.add(recoveryTask.getSrcDeviceId());
            Set srcStorageIds = recoveryTask.getSrcStorageIds();
            if (VerifyUtil.isEmpty((Collection)srcStorageIds) || !(iterator = srcStorageIds.iterator()).hasNext()) continue;
            String srcLunId = (String)iterator.next();
            srcLunIds.add(srcLunId);
        }
        if (devSns.isEmpty() || devSns.size() > 1) {
            logger.error((Object)("Error: the source device amount:" + devSns.size()));
            throw new LegoCheckedException(-1L);
        }
        String srcDevSn = (String)CommonUtil.getFirstElement(devSns);
        ArrayList<String> lunIds = new ArrayList<String>(srcLunIds);
        return RecoveryProcessUtil.isSrcLunUnMapping(srcDevSn, lunIds);
    }

    private static Map<String, Set<String>> getReplicaSourceMap(RecoveryProcessorContext context) {
        HashMap<String, Set<String>> devLunMap = new HashMap<String, Set<String>>();
        if (VerifyUtil.isEmpty((Object)context)) {
            return devLunMap;
        }
        ProtectGroupReplica protectGroupReplica = context.getProtectGroupReplica();
        if (VerifyUtil.isEmpty((Object)protectGroupReplica)) {
            return devLunMap;
        }
        Set replicas = protectGroupReplica.getReplicas();
        if (VerifyUtil.isEmpty((Collection)replicas)) {
            return devLunMap;
        }
        HashSet<String> lunWwnSet = new HashSet<String>();
        for (ProtectObjectReplica protectObjectReplica : replicas) {
            Set storageInfos = protectObjectReplica.getStorageInfos();
            if (VerifyUtil.isEmpty((Collection)storageInfos)) continue;
            for (RelicaStorageInfo storageInfo : storageInfos) {
                String lunWwn = storageInfo.getProtectObjectStorageWwn();
                if (VerifyUtil.isEmpty((String)lunWwn)) {
                    logger.warn((Object)"Empty lunWwn, SrcStorageId=%s", new Object[]{storageInfo.getSrcStorageId()});
                    continue;
                }
                lunWwnSet.add(lunWwn);
                List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{lunWwn});
                if (VerifyUtil.isEmpty((Collection)resources)) {
                    logger.error((Object)"Resources null, lunWwn=%s", new Object[]{lunWwn});
                    continue;
                }
                for (StorageResource resource : resources) {
                    String devSn = resource.getDevSn();
                    String lunId = resource.getResourceId();
                    HashSet<String> lunIdSet = (HashSet<String>)devLunMap.get(devSn);
                    if (VerifyUtil.isEmpty((Collection)lunIdSet)) {
                        lunIdSet = new HashSet<String>();
                        devLunMap.put(devSn, lunIdSet);
                    }
                    lunIdSet.add(lunId);
                }
            }
        }
        for (Map.Entry entry : devLunMap.entrySet()) {
            if (((Set)entry.getValue()).size() == lunWwnSet.size()) continue;
            logger.error((Object)"StorageInfos.size=%s, not equal lunIdSet.size=%s", new Object[]{lunWwnSet.size(), entry.getValue()});
            return new HashMap<String, Set<String>>();
        }
        return devLunMap;
    }

    private static boolean checkAirGapSrcLunUnMapping(ProtectGroup protectGroup) {
        ProtectGroupReplica tmpReplica = protectGroup.getAnyoneReplicationReplica();
        String metaData = tmpReplica.getPoReplicaMateData();
        Set<String> srcProviderSns = RecoveryProcessUtil.getValueByKey(metaData, "srcStorageProviderSN");
        Set<String> srcStorageIds = RecoveryProcessUtil.getValueByKey(metaData, "srcStorageId");
        Optional<String> opt = srcProviderSns.stream().filter(srcProviderSn -> !VerifyUtil.isEmpty((String)srcProviderSn)).findAny();
        if (!opt.isPresent()) {
            logger.error((Object)"Not find remote devSn for pgName: %s", new Object[]{protectGroup.getName()});
            return false;
        }
        String localDevSn = protectGroup.getPoProviderSN();
        String remoteDevSn = opt.get();
        IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(localDevSn);
        List remoteDevices = mgr.getStorageRemoteDeviceByRemoteSn(localDevSn, remoteDevSn);
        for (RemoteLinkDevice remoteLinkDevice : remoteDevices) {
            boolean res = mgr.checkRemoteLunMappedByIds(localDevSn, remoteLinkDevice.getDeviceId(), new ArrayList<String>(srcStorageIds));
            if (!res) continue;
            return false;
        }
        return true;
    }

    private static Set<String> getValueByKey(String metaData, String key) {
        HashSet<String> res = new HashSet<String>();
        JSONArray jsonArray = JSONArray.fromObject((Object)metaData);
        for (Object obj : jsonArray) {
            JSONArray array = JSONObject.fromObject(obj).getJSONArray("storageInfos");
            Set<String> tmpSet = RecoveryProcessUtil.getString(key, array);
            if (CollectionUtils.isEmpty(tmpSet)) continue;
            res.addAll(tmpSet);
        }
        return res;
    }

    private static Set<String> getString(String key, JSONArray array) {
        HashSet<String> ret = new HashSet<String>();
        for (Object objReplica : array) {
            String value;
            JSONObject remoteJson = JSONObject.fromObject(objReplica).getJSONObject("RemoteStorageReplica");
            if (remoteJson == null || !remoteJson.containsKey((Object)key) || VerifyUtil.isEmpty((String)(value = remoteJson.getString(key)))) continue;
            ret.add(value);
        }
        return ret;
    }

    private static boolean isReplicaSourceUnMapping(Map<String, Set<String>> devLunMap) {
        for (Map.Entry<String, Set<String>> entry : devLunMap.entrySet()) {
            ArrayList<String> lunIds;
            String srcDevSn = entry.getKey();
            if (RecoveryProcessUtil.isSrcLunUnMapping(srcDevSn, lunIds = new ArrayList<String>((Collection)entry.getValue()))) continue;
            return false;
        }
        return true;
    }

    public static List<ProtectGroupReplica> getAllReplicaById(RecoveryPlan recoveryPlan, String replicaId) {
        ArrayList<ProtectGroupReplica> pgReplicas = new ArrayList<ProtectGroupReplica>();
        for (ProtectGroup protectGroup : recoveryPlan.getProtectGroups()) {
            for (ProtectGroupReplica pgReplica : protectGroup.getReplicaList()) {
                if (!replicaId.equals(pgReplica.getId())) continue;
                if (DrmEnumDefine.REPLICA_STATUS.ACTIVE_STATUS.getValue() != pgReplica.getStatus()) {
                    logger.error((Object)"Invalid ProtectGroupReplica status", 90160758784001L);
                    return new ArrayList<ProtectGroupReplica>();
                }
                pgReplicas.add(pgReplica);
            }
        }
        return pgReplicas;
    }

    public static Map<String, Object> convertSettingType(Map<String, String> globalSettings) {
        if (VerifyUtil.isEmpty(globalSettings)) {
            return null;
        }
        HashMap<String, Object> convertedSettings = new HashMap<String, Object>();
        Set<Map.Entry<String, String>> settingsEntrySet = globalSettings.entrySet();
        for (Map.Entry<String, String> entry : settingsEntrySet) {
            convertedSettings.put(entry.getKey(), entry.getValue());
        }
        return convertedSettings;
    }

    public static boolean changeProtectGroupStatus(String[] pgIds, DrmEnumDefine.PROTECT_GROUP_STATUS pgStatus) {
        boolean result = false;
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        try {
            pgService.updateProtectGroupStatus(pgStatus, pgIds);
            result = true;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("Setting protect groups status failed. Ids:" + StringUtil.arrayToString((Object[])pgIds) + ExceptionUtil.getErrorMessage((Throwable)le)), 90160758784001L);
        }
        logger.info((Object)("Set protect groups status. Result:" + result + "Pg:" + StringUtil.arrayToString((Object[])pgIds) + ",pgStatus:" + pgStatus.getStatus()));
        return result;
    }

    public static Set<String> getAllWwn(Set<ProtectObject> protectObjects) {
        HashSet<String> allWwn = new HashSet<String>();
        for (ProtectObject po : protectObjects) {
            if (VerifyUtil.isEmpty((Collection)po.getUsedStorageResourceSet())) {
                logger.error((Object)("PolicyTemplate check protectObject storageInfo is empty, po is:" + po.getUuid() + "-" + po.getName()), 90160758786897L);
                throw new LegoCheckedException(1073948453L);
            }
            for (ProtectObjectStorageInfo posi : po.getUsedStorageResourceSet()) {
                String lunWWN = null;
                lunWWN = Integer.valueOf(DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue()).equals(posi.getResourceType()) ? posi.getResourceId() : posi.getLunWWN();
                if (VerifyUtil.isEmpty((String)lunWWN)) {
                    logger.error((Object)("lunWWN is empty, po is:" + po.getUuid() + "-" + po.getName()), 90160758786897L);
                    throw new LegoCheckedException(1073948453L);
                }
                allWwn.add(lunWWN);
            }
        }
        return allWwn;
    }

    public static Set<String> getAllSecondaryLunWwn(ProtectGroup protectGroup) {
        return RecoveryProcessUtil.getSecondaryLunWwn(protectGroup, null);
    }

    public static Set<String> getSecondaryLunWwn(ProtectGroup protectGroup, Set<String> secondarySites) {
        HashSet<String> allWwn = new HashSet<String>();
        ArrayList resourceIds = new ArrayList();
        String deviceSn = null;
        ArrayList replicationRelations = new ArrayList();
        Map replicationRelationBoMap = protectGroup.getAllReplicationRelation();
        Set entrySet = replicationRelationBoMap.entrySet();
        for (Map.Entry entry : entrySet) {
            if (!VerifyUtil.isEmpty(secondarySites) && !secondarySites.contains(entry.getKey())) continue;
            replicationRelations.addAll((Collection)entry.getValue());
        }
        for (ReplicationRelationBo rep : replicationRelations) {
            deviceSn = rep.getTgtDeviceSn();
            resourceIds.addAll(rep.getTgtLuns().values());
        }
        if (null == deviceSn || VerifyUtil.isEmpty(resourceIds)) {
            logger.error((Object)("ProtectGroup's ReplicationRelation info is empty, pgId:" + protectGroup.getUuid()), 90160758786897L);
            throw new LegoCheckedException(1073948453L);
        }
        if (RecoveryProcessUtil.isProtectGroupUseNasFileSystem(protectGroup)) {
            allWwn.addAll(resourceIds);
            return allWwn;
        }
        List targetLuns = ((IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class)).getStorageResources(deviceSn, resourceIds, Lun.class);
        if (!VerifyUtil.isEmpty((Collection)targetLuns)) {
            for (Lun lun : targetLuns) {
                allWwn.add(lun.getWwn());
            }
        }
        return allWwn;
    }

    public static String getPairStr(HyperMetroPair pair) {
        StringBuilder sb = new StringBuilder();
        String uuid = pair.getUuid();
        String resourceWwn = pair.getResourceWwn();
        String localObjId = pair.getLocalObjId();
        String remoteObjId = pair.getRemoteObjId();
        String remoteDevSn = pair.getRemoteDevSn();
        sb.append("[");
        sb.append("pairUuid:").append(uuid).append(",").append("runningStatus:").append(pair.getRunningState()).append(",").append("healthStatus:").append(pair.getHealthState()).append(",").append("syncDirection:").append(VerifyUtil.isEmpty((Object)pair.getSyncDirection()) ? "empty" : pair.getSyncDirection().toString()).append(",").append("resourceWwn:").append(resourceWwn).append(",").append("localObjId:").append(localObjId).append(",").append("remoteObjId:").append(remoteObjId).append(",").append("remoteDevSn:").append(remoteDevSn).append("]");
        return sb.toString();
    }

    public static String getConsistentGroupStr(HyperMetroConsistentGroup group) {
        StringBuilder sb = new StringBuilder();
        String uuid = group.getUuid();
        String devSn = group.getDevSn();
        sb.append("[");
        sb.append("pairUuid:").append(uuid).append(",").append("runningStatus:").append(group.getRunningState()).append(",").append("healthStatus:").append(group.getHealthState()).append(",").append("syncDirection:").append(VerifyUtil.isEmpty((Object)group.getSyncDirection()) ? "empty" : group.getSyncDirection().toString()).append(",").append("DevSn:").append(devSn).append("]");
        return sb.toString();
    }

    public static void presetCheck(RecoveryProcessorContext context, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType) {
        RecoveryProcessCheckerManager rpCheckerMgr = RecoveryProcessCheckerManager.getInstance();
        List<IRecoveryProcessChecker> recoveryProcessCheckers = rpCheckerMgr.getRecoveryProcessCheckers();
        if (VerifyUtil.isEmpty(recoveryProcessCheckers)) {
            logger.error((Object)"There is no recovery process checkers.", 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        for (IRecoveryProcessChecker checker : recoveryProcessCheckers) {
            checker.check(context, procType);
        }
    }

    public static DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E getProcType(String procType) {
        if (procType.equalsIgnoreCase(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.name())) {
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.name())) {
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.HOT_MIGRATION.name())) {
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.HOT_MIGRATION;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.name())) {
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING.name())) {
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.name())) {
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SNAPSHOT_ROLLBACK.name())) {
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SNAPSHOT_ROLLBACK;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SWAP.name())) {
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SWAP;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.MOUNT_REPLICA.name())) {
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.MOUNT_REPLICA;
        }
        return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.UMOUNT_REPLICA;
    }

    public static boolean isSrcLunUnMapping(Site remoteSite, String srcDeviceId, List<String> srcLunIds) {
        if (null == remoteSite || null == srcDeviceId || VerifyUtil.isEmpty(srcLunIds)) {
            logger.error((Object)"Invalid parameters. srcDeviceId=%s, srcLunIds=%s", new Object[]{srcDeviceId, srcLunIds});
            throw new LegoCheckedException(1073947393L);
        }
        return RecoveryProcessUtil.isSrcLunUnMapping(srcDeviceId, srcLunIds);
    }

    public static ProtectGroupReplica getProtectGroupReplicaBySiteId(ProtectGroup protectGroup, String disasterSiteId) {
        if (null == protectGroup || VerifyUtil.isEmpty((Collection)protectGroup.getReplicaList()) || VerifyUtil.isEmpty((String)disasterSiteId)) {
            logger.error((Object)"Invalid parameters.");
            return null;
        }
        Set pgReplicas = protectGroup.getReplicaList();
        for (ProtectGroupReplica pgReplica : pgReplicas) {
            List siteInfoList;
            Set siteIdSet;
            String siteInfoListStr;
            if (ProtectGroupUtil.isLocalStorageReplica(pgReplica)) continue;
            if (pgReplica.getRecoverySite().equals(disasterSiteId)) {
                return pgReplica;
            }
            if (20 == protectGroup.getTemplate().getType() || 24 == protectGroup.getTemplate().getType() || 27 == protectGroup.getTemplate().getType() || 32 == protectGroup.getTemplate().getType()) {
                return pgReplica;
            }
            if (!PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(protectGroup.getTemplate().getType()) || null == (siteInfoListStr = (String)protectGroup.getProps().get("PROP_KEY_SITE_INFO")) || null == (siteIdSet = (siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class)).stream().filter(siteInfo -> siteInfo.getSiteIdSet().contains(disasterSiteId)).findFirst().get().getSiteIdSet()) || !siteIdSet.contains(pgReplica.getRecoverySite())) continue;
            return pgReplica;
        }
        return null;
    }

    public static String getDisterSiteId(String defaultSiteId, ProtectGroup pg) {
        ProtectGroupReplica rep = RecoveryProcessUtil.getProtectGroupReplicaBySiteId(pg, defaultSiteId);
        if (null != rep) {
            return rep.getRecoverySite();
        }
        return defaultSiteId;
    }

    public static ProtectGroupReplica getProtectGroupReplicaByReplicaId(ProtectGroup protectGroup, String replicaId) {
        if (null == protectGroup || VerifyUtil.isEmpty((String)replicaId)) {
            return null;
        }
        ProtectGroupReplica replica = SnapshotScheduleUtil.getProtectGroupReplica(replicaId);
        if (null != replica) {
            return replica;
        }
        Set pgReplicas = protectGroup.getReplicaList();
        if (null == pgReplicas) {
            return null;
        }
        for (ProtectGroupReplica pgReplica : pgReplicas) {
            if (!pgReplica.getId().equals(replicaId)) continue;
            return pgReplica;
        }
        return null;
    }

    public static Set<ProtectObject> getRecoveryProtectObjects(ProtectGroup protectGroup, ProtectGroupReplica pgReplica, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E rpExecuteType) {
        if (VerifyUtil.isEmpty((Object)protectGroup) || VerifyUtil.isEmpty((Object)pgReplica)) {
            return new HashSet<ProtectObject>();
        }
        HashSet<DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E> remoteExecuteTypeSet = new HashSet<DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E>();
        remoteExecuteTypeSet.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING);
        remoteExecuteTypeSet.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING);
        remoteExecuteTypeSet.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY);
        remoteExecuteTypeSet.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION);
        remoteExecuteTypeSet.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.HOT_MIGRATION);
        remoteExecuteTypeSet.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT);
        HashSet<ProtectObject> result = new HashSet<ProtectObject>();
        ExecuteReplicaManager mgr = ExecuteReplicaManager.getInstance();
        if (mgr.getRealTimeReplicaPolicyType().contains(protectGroup.getTemplate().getType())) {
            if (null != rpExecuteType && remoteExecuteTypeSet.contains(rpExecuteType)) {
                result.addAll(protectGroup.getPolist());
            } else {
                Set<ProtectObjectReplica> poReplicas = RecoveryProcessUtil.getProtectObjectReplicas(pgReplica);
                for (ProtectObjectReplica poReplica : poReplicas) {
                    result.add(poReplica.getProtectObject());
                }
            }
        } else {
            result.addAll(protectGroup.getPolist());
        }
        return result;
    }

    private static Set<ProtectObjectReplica> getProtectObjectReplicas(ProtectGroupReplica pgReplica) {
        Set<ProtectObjectReplica> poReplicas;
        block3: {
            poReplicas = new HashSet();
            try {
                Iterator iterator;
                poReplicas = pgReplica.getReplicas();
                if (null != poReplicas && !(iterator = poReplicas.iterator()).hasNext()) {
                    throw new LegoCheckedException(1073947394L);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Getting po replicas from pg replica failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
                IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
                ProtectGroupReplica newPgReplica = replicaService.queryProtectGroupReplicaById(pgReplica.getId());
                if (null == newPgReplica) break block3;
                poReplicas = newPgReplica.getReplicas();
            }
        }
        return poReplicas;
    }

    private static boolean isSrcLunUnMapping(String srcDeviceId, List<String> lunIds) {
        try {
            List luns = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).queryLunByDevSnAndLunIds(srcDeviceId, lunIds);
            return RecoveryProcessUtil.isLunUnMapping(lunIds, luns);
        }
        catch (Exception e) {
            logger.error((Object)("query SrcLunUnMapping Local error:" + srcDeviceId + "-" + lunIds + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            return false;
        }
    }

    private static boolean isLunUnMapping(List<String> lunIds, List<Lun> luns) {
        if (VerifyUtil.isEmpty(luns)) {
            logger.error((Object)"LUNs quered is empty, return isLunUnMapping is false", 90160758784001L);
            return false;
        }
        if (luns.size() != lunIds.size()) {
            logger.error((Object)"LUNs quered is not equals to the lunID amount, return isLunUnMapping is false", 90160758784001L);
            return false;
        }
        for (Lun lun : luns) {
            boolean isMapped = lun.getMapped();
            if (!isMapped) continue;
            logger.error((Object)("The lun is mapped, and ID: " + lun.getLunId() + ",name: " + lun.getName()), 90160758784001L);
            return false;
        }
        return true;
    }

    public static boolean isProtectGroupUseNasFileSystem(ProtectGroup pg) {
        ProtectObjectStorageInfo storageInfo;
        logger.debug((Object)"enter isProtectGroupUseNasFileSystem ");
        boolean isNas = false;
        if (1 == pg.getTemplate().getType() && 2 == pg.getTemplate().getSubType()) {
            isNas = true;
        }
        if (!(PolicyTemplateType.POLICY_TEMPLATE_E.ARRAY_HYPER_METRO_ASYNC_REPLICATION.getValue() != pg.getTemplate().getType() && PolicyTemplateType.POLICY_TEMPLATE_E.ARRAY_ASYNC_HYPER_METRO.getValue() != pg.getTemplate().getType() || VerifyUtil.isEmpty((Object)(storageInfo = pg.getAnyProtectObjectStorageInfo())) || DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue() != storageInfo.getResourceType().intValue())) {
            isNas = true;
        }
        if (14 == pg.getTemplate().getType() || 17 == pg.getTemplate().getType() || 28 == pg.getTemplate().getType()) {
            isNas = true;
        }
        return isNas;
    }

    public static String getVstoreId(ProtectGroup pg) {
        String vStoreId = null;
        if (null != pg && null != pg.getPolist() && pg.getPolist().size() > 0) {
            ProtectObject protectObject = (ProtectObject)pg.getPolist().iterator().next();
            vStoreId = RecoveryProcessUtil.getVstoreId(protectObject);
        }
        return vStoreId;
    }

    private static String getVstoreId(ProtectObject protectObject) {
        String vStoreId = null;
        if (null != protectObject && null != protectObject.getUsedStorageResourceSet() && protectObject.getUsedStorageResourceSet().size() > 0) {
            ProtectObjectStorageInfo protectObjectStorageInfo = (ProtectObjectStorageInfo)protectObject.getUsedStorageResourceSet().iterator().next();
            vStoreId = null != protectObjectStorageInfo ? protectObjectStorageInfo.getVstoreId() : null;
        }
        return vStoreId;
    }

    public static String getVstoreIdByResourceId(String devSn, String resourceId) {
        IMoDao moDao = CommonDAOLocator.getMoDao();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", devSn);
        props.put("resourceId", resourceId);
        List result = moDao.findMoBy(NasFileSystem.class, props);
        if (!VerifyUtil.isEmpty((Collection)result)) {
            return ((NasFileSystem)result.iterator().next()).getVstoreId();
        }
        return null;
    }

    public static Collection<RecoveryTask> filterRecoveryTask(RecoveryProcessorContext context, String recoveryTasksKey) {
        RecoveryProcessUtil.checkContext(context);
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        RecoveryProcessUtil.checkRecoveryPlan(recoveryPlan);
        Iterator<ProtectGroup> iterator = recoveryPlan.getProtectGroups().iterator();
        RecoveryProcessUtil.checkProtectGroup(iterator);
        Collection candidates = (Collection)context.getAttribute(recoveryTasksKey);
        boolean ring = candidates.stream().anyMatch(task -> Objects.nonNull(task.getParams()) && task.getParams().containsKey(STANDBY));
        if (ring) {
            return RecoveryProcessUtil.getNormalReplicationTask(candidates);
        }
        return candidates;
    }

    private static Collection<RecoveryTask> getNormalReplicationTask(Collection<RecoveryTask> candidates) {
        ArrayList<RecoveryTask> recoverTasks = new ArrayList<RecoveryTask>();
        if (VerifyUtil.isEmpty(candidates)) {
            return recoverTasks;
        }
        for (RecoveryTask recoveryTask : candidates) {
            Map params = recoveryTask.getParams();
            if (params == null) {
                recoverTasks.add(recoveryTask);
                continue;
            }
            Object allRelatedReplicationPairs = params.get(ALL_RELATED_REPLICATION_PAIRS);
            if (!Collection.class.isInstance(allRelatedReplicationPairs)) {
                return recoverTasks;
            }
            Collection collection = (Collection)Collection.class.cast(allRelatedReplicationPairs);
            RecoveryProcessUtil.checkPairStatusConsistentByRingID(collection);
            if (((Boolean)params.get(STANDBY)).booleanValue()) continue;
            recoverTasks.add(recoveryTask);
        }
        return recoverTasks;
    }

    private static void checkPairStatusConsistentByRingID(Collection<?> collection) {
        HashMap<String, ArrayList<ReplicationPair>> ringPairs = new HashMap<String, ArrayList<ReplicationPair>>();
        for (Object item : collection) {
            if (!ReplicationPair.class.isInstance(item)) {
                logger.error((Object)"Object item is not ReplicationPair", 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
            ReplicationPair replicaPair = (ReplicationPair)ReplicationPair.class.cast(item);
            if (replicaPair.getRepTgtLuns() == null || replicaPair.getRepTgtLuns().isEmpty()) {
                logger.error((Object)"replicaPair have no target lun.", 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
            String pairKey = replicaPair.getDrRingId() + ":" + replicaPair.getSrcDevSN() + ":" + ((ReplicationTargetLun)replicaPair.getRepTgtLuns().get(0)).getTgtDevSN();
            ArrayList<ReplicationPair> pairs = (ArrayList<ReplicationPair>)ringPairs.get(pairKey);
            if (pairs == null || pairs.isEmpty()) {
                pairs = new ArrayList<ReplicationPair>();
                ringPairs.put(pairKey, pairs);
            }
            pairs.add(replicaPair);
        }
        for (Map.Entry entry : ringPairs.entrySet()) {
            String originState = "";
            for (ReplicationPair pair : (List)entry.getValue()) {
                String runningState = RecoveryProcessUtil.getReplicationPairRunningStatus(pair);
                if (originState.isEmpty()) {
                    originState = runningState;
                    continue;
                }
                if (originState.equals(runningState) || !originState.equals(STANDBY) && !runningState.equals(STANDBY)) continue;
                logger.error((Object)("Ring(" + (String)entry.getKey() + ")'s replcationpair(" + pair.getId() + ") running status is not as same as others."), 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    private static String getReplicationPairRunningStatus(ReplicationPair pair) {
        String pairStatus = null;
        if (pair == null) {
            return pairStatus;
        }
        String runningState = pair.getRunningState();
        if (runningState != null) {
            pairStatus = runningState;
            return pairStatus;
        }
        List targets = pair.getRepTgtLuns();
        if (targets == null || targets.size() != 1) {
            return pairStatus;
        }
        Integer status = ((ReplicationTargetLun)targets.get(0)).getPairStatus();
        return status != null ? status.toString() : pairStatus;
    }

    private static void checkProtectGroup(Iterator<ProtectGroup> iterator) {
        if (!iterator.hasNext()) {
            logger.error((Object)"iterator is empty");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static void checkRecoveryPlan(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"recoveryPlan is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static void checkContext(RecoveryProcessorContext context) {
        if (null == context) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }
}

