/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.resource.service.impl;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.manager.proxy.ManagedObjectManagerProxy;
import com.huawei.ism.cbb.base.service.IsmBaseService;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.job.airgapjob.AirGapLinkProcessor;
import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.SwitchoverEnum;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceManager;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.resource.service.DeleteResourceBackTask;
import com.huawei.ism.drm.site.resource.service.DiscoverResourceBackTask;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.util.SiteResourceManagerUtil;
import com.huawei.ism.drm.site.util.SiteResourceServiceProxy;
import com.huawei.ism.drm.storage.manager.proxy.StoragePortLinksManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStoragePortLinksManager;
import com.huawei.ism.drm.storage.sdk.model.EnablePortTask;
import com.huawei.ism.drm.storage.sdk.model.RemoteLinkDevice;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindow;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindowRange;
import com.huawei.ism.drm.storage.sdk.model.StorageLinkPort;
import com.huawei.ism.drm.storage.sdk.model.StoragePortOperateLog;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;

@Service(Name="com.huawei.ism.drm.site.resource.sdk.service.IResourceService", Desc="", Interface=IResourceService.class)
public class ResourceServiceImpl
extends IsmBaseService
implements IResourceService {
    private static final Log LOGGER = LogFactory.getInstance(ResourceServiceImpl.class);
    private static final String ZERO_TIME = "00:00";
    private Map<String, IResourceManager> rmMapping = new ConcurrentHashMap<String, IResourceManager>();

    public void onBind(IResourceManager rm, Map<?, ?> properties) {
        LOGGER.debug((Object)"onBind");
        this.rmMapping.put(rm.getResourceType(), rm);
    }

    public void onUnbind(IResourceManager rm, Map<?, ?> properties) {
        LOGGER.debug((Object)"onUnbind");
        this.rmMapping.remove(rm.getResourceType());
    }

    public DrResource getDrResourceBySn(String devSn, String resType) {
        LOGGER.debug((Object)("devSn=" + devSn + ", resType=" + resType));
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        return SiteResourceServiceProxy.getInstance().getSiteResourceService(resType).getDrResourceBySn(devSn);
    }

    public DrResource getDrResourceBySnInLocalSite(String devSn, String resType) {
        LOGGER.debug((Object)("devSn=" + devSn + ", resType=" + resType));
        VerifyUtil.checkStrs((String[])new String[]{devSn, resType});
        DrResource resource = this.getDrResourceBySn(devSn, resType);
        VerifyUtil.checkObject((Object)resource);
        Site site = (Site)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Site.class, (Serializable)((Object)resource.getSiteId()));
        if (null != site && 0 == site.getSiteType()) {
            return resource;
        }
        return null;
    }

    public DrResource getDrResourceBySn(String devSn) {
        LOGGER.debug((Object)("devSn=" + devSn));
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        DrResource result = null;
        List resources = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrResource where deviceSn=?", new Object[]{devSn});
        if (!VerifyUtil.isEmpty((Collection)resources)) {
            result = (DrResource)resources.get(0);
        }
        return result;
    }

    public <T extends ManagedObject> List<T> queryMoList(Class<T> t, Map<String, Object> queryCondition) {
        if (VerifyUtil.isEmpty(t)) {
            throw new LegoCheckedException(1073947393L);
        }
        return CommonDAOLocator.getMoDao().findMoBy(t, queryCondition);
    }

    public List<String> getResourceMainTypes(long userId) {
        ArrayList<String> types = new ArrayList<String>(SiteResourceServiceProxy.getInstance().getAllSiteResourceServiceKey());
        LOGGER.debug((Object)("ResourceMainTypes: " + types));
        return types;
    }

    public <T extends Serializable> List<T> query(Class<T> clazz, Map<String, Object> queryCondition) {
        if (VerifyUtil.isEmpty(clazz)) {
            return null;
        }
        if (VerifyUtil.isEmpty(queryCondition)) {
            queryCondition = new HashMap<String, Object>(0);
        }
        List criterionList = CommonDAOLocator.getBaseDao().translatePropsToCriterions(queryCondition);
        List createCriteria = CommonDAOLocator.getBaseDao().createCriteria(clazz, criterionList.toArray(new Criterion[criterionList.size()]));
        ArrayList<T> list = new ArrayList<T>();
        if (null != createCriteria) {
            for (Serializable s : createCriteria) {
                list.add(clazz.cast(s));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMo(ManagedObject mo) {
        if (VerifyUtil.isEmpty((Object)mo)) {
            LOGGER.error((Object)"UpdateMo method param is null error");
            throw new LegoCheckedException(1073947393L);
        }
        Session session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
        try {
            session.beginTransaction();
            DrResource resource = SiteResourceManagerUtil.getDrResourceByMoId(mo.getMoId());
            if (!VerifyUtil.isEmpty((Object)resource)) {
                resource.setName(mo.getName());
                session.update((Object)resource);
            }
            session.update((Object)mo);
            this.modifyChildName(mo);
            if (mo instanceof Host) {
                ((Host)mo).setHostName(mo.getName());
            }
            session.getTransaction().commit();
            LOGGER.info((Object)"Send modify managedobject message. moId: %s", new Object[]{mo.getMoId() + ""});
            this.sendModifyMoMessage(mo);
        }
        catch (Exception e) {
            DBOperationUtil.rollbackSession(session);
            ExceptionUtil.rethrowException((Throwable)e, (String)"Update mo and mo child drresour ", (long)-1L, (String[])new String[0], (Log)LOGGER);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
    }

    private void modifyChildName(ManagedObject mo) {
        if (mo == null || mo.getChildMos() == null) {
            return;
        }
        for (ManagedObject cmo : mo.getChildMos()) {
            if (!(cmo instanceof StorageUnit)) continue;
            cmo.setName(mo.getName());
        }
    }

    private void sendModifyMoMessage(ManagedObject mo) {
        if (VerifyUtil.isEmpty((Object)mo)) {
            LOGGER.debug((Object)"Mo is null,not send ModifyMoMessage.");
            return;
        }
        HashMap<String, ManagedObject> messageBody = new HashMap<String, ManagedObject>();
        messageBody.put("ModifyManagedObject", mo);
        MessageUnit mu = new MessageUnit();
        mu.setCmdcode(7005L);
        mu.setObj(messageBody);
        mu.setMt(MessageTopic.COMMAND);
        mu.setSourceAppName(((Object)((Object)this)).getClass().getName());
        ((IMessageCenter)ServiceLocator.getInstance().getService(IMessageCenter.class)).sendMessage(mu);
    }

    public void updateMgrProtocol(NeMgrProtocolExtend neMgrProtocol) {
        long moId = neMgrProtocol.getMoId();
        String mainType = this.getMainType(moId);
        IResourceManager resourceManager = this.rmMapping.get(mainType);
        if (VerifyUtil.isEmpty((Object)resourceManager)) {
            String errorMsg = "Can not get resourceManager by " + mainType;
            throw new LegoCheckedException(1073947395L, errorMsg);
        }
        resourceManager.validate(neMgrProtocol);
        resourceManager.updateMgrProtocol(neMgrProtocol);
    }

    private String getMainType(long moId) {
        LOGGER.debug((Object)("moId=" + moId));
        List obs = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from TopoObject where moId=?", new Object[]{moId});
        if (null == obs || obs.isEmpty()) {
            throw new LegoCheckedException(1073947394L);
        }
        return ((TopoObject)obs.get(0)).getMainType();
    }

    public NeMgrProtocolExtend getMgrProtocol(Long moId) {
        LOGGER.debug((Object)("moId=" + moId));
        String mainType = this.getMainType(moId);
        IResourceManager resourceManager = this.rmMapping.get(mainType);
        if (VerifyUtil.isEmpty((Object)resourceManager)) {
            String errorMsg = "Can not get resourceManager by " + mainType;
            throw new LegoCheckedException(1073947395L, errorMsg);
        }
        return resourceManager.getMgrProtocol(moId);
    }

    public long deleteResources(List<BatchOperation> opts) {
        DeleteResourceBackTask task = new DeleteResourceBackTask(opts);
        BackTaskHandler instance = BackTaskHandler.getInstance();
        return instance.submitTask((AbstractBackTask)task);
    }

    public long discoveryResource(DiscoveryPolicy policy) {
        String siteId = policy.getLocation();
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(siteId);
        if (null == site) {
            LOGGER.error((Object)"Site is not exist, siteId=%s", new Object[]{siteId});
            throw new LegoCheckedException(1073947393L);
        }
        DiscoverResourceBackTask backtask = new DiscoverResourceBackTask(policy);
        backtask.setTimeout(ManagedObjectManagerProxy.getInstance().getMgr(policy.getDeviceType()).getTimeout());
        BackTaskHandler instance = BackTaskHandler.getInstance();
        return instance.submitTask((AbstractBackTask)backtask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getSupportResource() {
        Session session;
        Map<String, String> supportResources;
        block4: {
            supportResources = new HashMap<String, String>();
            IMoDao moDao = CommonDAOLocator.getMoDao();
            session = null;
            try {
                session = moDao.getHibernateTemplate().getSessionFactory().openSession();
                String querySQL = "select NAME, DESCRIPTION from T_MAIN_DEVICE_TYPE";
                NativeQuery query = session.createSQLQuery(querySQL);
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results)) break block4;
                supportResources = this.parseSupportResoureDbData(results);
            }
            catch (Exception e) {
                try {
                    ExceptionUtil.rethrowException((Throwable)e, (String)"Querying support resource failed.", (long)-1L, (String[])new String[0], (Log)LOGGER);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return supportResources;
    }

    private Map<String, String> parseSupportResoureDbData(List<?> results) {
        HashMap<String, String> supportResources = new HashMap<String, String>();
        for (Object object : results) {
            Object[] values;
            if (!(object instanceof Object[]) || 2 != (values = (Object[])object).length) continue;
            String name = String.valueOf(values[0]);
            String desc = String.valueOf(values[1]);
            supportResources.put(name, desc);
        }
        return supportResources;
    }

    public void modifyResourceSite(String resourceId, String siteId) {
        if (VerifyUtil.isEmpty((String)resourceId) || VerifyUtil.isEmpty((String)siteId)) {
            throw new LegoCheckedException(1073947393L);
        }
        DrResource resource = this.getDrResourceBySn(resourceId);
        if (VerifyUtil.isEmpty((Object)resource)) {
            throw new LegoCheckedException(1073947394L);
        }
        List obs = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from NetworkEntity where sn=?", new Object[]{resourceId});
        if (!VerifyUtil.isEmpty((Collection)obs)) {
            NetworkEntity networkEntity = (NetworkEntity)obs.get(0);
            String mainType = networkEntity.getMainType();
            SiteResourceServiceProxy.getInstance().getSiteResourceService(mainType).isResourceUsed(networkEntity.getMoId());
        }
        try {
            resource.setSiteId(siteId);
            CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)resource);
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)"Unable to modify resource site", (Throwable)e);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public void addResourceTimeWindow(ResourceTimeWindow timeWindow) {
        if (CollectionUtils.isEmpty((Collection)timeWindow.getTimeWindowRanges())) {
            throw new LegoCheckedException(1073947393L);
        }
        timeWindow.setWindowId(UUIDGenerator.getUUID());
        this.changeTimeWindowRangeInfo(timeWindow);
        try {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)timeWindow);
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)"Add resource time window failed. errorMsg: %s", new Object[]{e.getMessage()});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    private void changeTimeWindowRangeInfo(ResourceTimeWindow timeWindow) {
        Set ranges = timeWindow.getTimeWindowRanges();
        for (ResourceTimeWindowRange range : ranges) {
            Date startDate = range.getStartTime();
            Date endDate = range.getEndTime();
            String[] strStartArray = new SimpleDateFormat("HH:mm:ss").format(startDate).split(":");
            String startHour = strStartArray[0];
            String startMin = strStartArray[1];
            range.setStartTimeStr(startHour + ":" + startMin);
            String[] strEndArray = new SimpleDateFormat("HH:mm:ss").format(endDate).split(":");
            String endHour = strEndArray[0];
            String endMin = strEndArray[1];
            range.setEndTimeStr(endHour + ":" + endMin);
            this.changeTimeRangeStr(range);
        }
    }

    public void updateResourceTimeWindow(ResourceTimeWindow timeWindow) {
        if (VerifyUtil.isEmpty((Object)timeWindow)) {
            throw new LegoCheckedException(1073947393L);
        }
        String windowId = timeWindow.getWindowId();
        ResourceTimeWindow timeWindowInDb = (ResourceTimeWindow)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ResourceTimeWindow.class, (Serializable)((Object)windowId));
        if (VerifyUtil.isEmpty((Object)timeWindowInDb)) {
            LOGGER.error((Object)"Not find time window of windowId: %s", new Object[]{windowId});
            throw new LegoCheckedException(1073947394L);
        }
        this.changeTimeWindowRangeInfo(timeWindow);
        if (!ResourceServiceImpl.validTimeWindowRange(timeWindow.getTimeWindowRanges())) {
            LOGGER.error((Object)"Input illegal time window. resourceId: %s", new Object[]{timeWindow.getResourceId()});
            throw new LegoCheckedException(1073947393L);
        }
        timeWindowInDb.setTimeWindowRanges(timeWindow.getTimeWindowRanges());
        LOGGER.info((Object)"Update time window time ranges. timeWindow: %s", new Object[]{timeWindowInDb.toString()});
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        try {
            baseDao.delete("delete from ti_ResourceTimeWindowRange where windowId=?", new Object[]{windowId});
            baseDao.evict((Object)timeWindowInDb);
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)timeWindowInDb);
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)"Modify resource time window failed.", (Throwable)e);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    private static boolean validTimeWindowRange(Set<ResourceTimeWindowRange> timeWindowRanges) {
        ArrayList<ResourceTimeWindowRange> ranges = new ArrayList<ResourceTimeWindowRange>(timeWindowRanges);
        ranges.sort(Comparator.comparing(ResourceTimeWindowRange::getStartTime));
        int len = ranges.size();
        if (len > 5) {
            LOGGER.error((Object)"Time windows numbers: %s more then 5.", new Object[]{String.valueOf(len)});
            return false;
        }
        Optional<ResourceTimeWindowRange> optFiveMin = ranges.stream().filter(range -> !ZERO_TIME.equals(range.getStartTimeStr()) || !ZERO_TIME.equals(range.getEndTimeStr())).filter(range -> range.getStartTime().getTime() + 300000L > range.getEndTime().getTime()).findAny();
        if (optFiveMin.isPresent()) {
            LOGGER.error((Object)"The range: %s starTime and endTime must be greater than 5 minutes.", new Object[]{optFiveMin.get()});
            return false;
        }
        long minTime = ((ResourceTimeWindowRange)ranges.get(0)).getStartTime().getTime();
        long maxTime = ((ResourceTimeWindowRange)ranges.get(ranges.size() - 1)).getEndTime().getTime();
        if (maxTime - minTime > 86400000L) {
            LOGGER.error((Object)"The maximum time span is 1 day. minTime: %s, maxTime: %s", new Object[]{minTime, maxTime});
            return false;
        }
        long preEndTime = 0L;
        for (ResourceTimeWindowRange range2 : ranges) {
            if (preEndTime == 0L) {
                preEndTime = range2.getEndTime().getTime();
                continue;
            }
            long nowStartTime = range2.getStartTime().getTime();
            if (nowStartTime < preEndTime) {
                LOGGER.error((Object)"The time windows cannot overlap. startTime: %s", new Object[]{String.valueOf(nowStartTime)});
                return false;
            }
            preEndTime = range2.getEndTime().getTime();
        }
        return true;
    }

    public void deleteResourceTimeWindow(String windowId) {
        if (VerifyUtil.isEmpty((String)windowId)) {
            throw new LegoCheckedException(1073947393L);
        }
        ResourceTimeWindow timeWindowInDb = (ResourceTimeWindow)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ResourceTimeWindow.class, (Serializable)((Object)windowId));
        if (VerifyUtil.isEmpty((Object)timeWindowInDb)) {
            return;
        }
        try {
            LOGGER.info((Object)"Begin to delete time window info by windowsId: %s", new Object[]{windowId});
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)timeWindowInDb);
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)"Delete resource time window failed. errorMsg: %s", new Object[]{e.getMessage()});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public void deleteResourceRelationTimeWindows(String devSn) {
        DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(devSn);
        if (!resource.getIsAirGapResource().booleanValue()) {
            return;
        }
        List<ResourceTimeWindow> resourceTimeWindows = this.getResourceTimeWindow(devSn);
        if (!CollectionUtils.isEmpty(resourceTimeWindows)) {
            resourceTimeWindows.forEach(timeWindow -> this.deleteResourceTimeWindow(timeWindow.getWindowId()));
        }
        try {
            List linkPorts = CommonDAOLocator.getBaseDao().find("from StorageLinkPort where devSn=?", new Object[]{devSn});
            List portLogs = CommonDAOLocator.getBaseDao().find("from StoragePortOperateLog where devSn=?", new Object[]{devSn});
            LOGGER.info((Object)"Get storage link port and logs success. resourceId: %s", new Object[]{devSn});
            this.doDeleteLogAndTimeWindows(linkPorts, portLogs, devSn);
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)"Find storage link port failed.", (Throwable)e);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public void deletePortAndLogsForTimeWindow(String portId) {
        if (VerifyUtil.isEmpty((String)portId)) {
            LOGGER.info((Object)"Port id is null");
            return;
        }
        try {
            List linkPorts = CommonDAOLocator.getBaseDao().find("from StorageLinkPort where portId=?", new Object[]{portId});
            List portLogs = CommonDAOLocator.getBaseDao().find("from StoragePortOperateLog where portId=?", new Object[]{portId});
            LOGGER.info((Object)"Delete storage link port and logs success. portId: %s", new Object[]{portId});
            this.doDeleteLogAndTimeWindows(linkPorts, portLogs, portId);
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)"Find storage link port failed.", (Throwable)e);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    private void doDeleteLogAndTimeWindows(List<StorageLinkPort> linkPorts, List<StoragePortOperateLog> portLogs, String devSn) {
        for (StorageLinkPort linkPort : linkPorts) {
            LOGGER.info((Object)"Delete portName: %s success!", new Object[]{linkPort.getPortName()});
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)linkPort);
        }
        if (CollectionUtils.isEmpty(portLogs)) {
            LOGGER.info((Object)"Not logs to delete. devSn/portId: %s", new Object[]{devSn});
            return;
        }
        for (StoragePortOperateLog log : portLogs) {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)log);
        }
        LOGGER.info((Object)"Logs delete success. devSn/portId: %s", new Object[]{devSn});
    }

    public void updateTimeWindowWithLatestRemoteDevices(String devSn, List<RemoteLinkDevice> remoteLatestDevices) {
        DrResource drResourceBySn = this.getDrResourceBySn(devSn);
        if (VerifyUtil.isEmpty((Object)drResourceBySn) || !drResourceBySn.getIsAirGapResource().booleanValue()) {
            LOGGER.error((Object)"Params is illegal, return update.");
            return;
        }
        LOGGER.info((Object)"Update time-window relation of devSn: %s", new Object[]{devSn});
        List remoteLatestDeviceList = Optional.ofNullable(remoteLatestDevices).orElseGet(Collections::emptyList);
        Set<String> remoteLinkDeviceWwnSet = remoteLatestDeviceList.stream().map(RemoteLinkDevice::getRemoteWwn).collect(Collectors.toSet());
        List<ResourceTimeWindow> resourceTimeWindowList = this.getResourceTimeWindow(devSn);
        HashMap<String, ResourceTimeWindow> resourceTimeWindowMap = new HashMap<String, ResourceTimeWindow>();
        ArrayList<ResourceTimeWindow> windowIdToDelete = new ArrayList<ResourceTimeWindow>();
        HashMap<String, Integer> portIdUsedCount = new HashMap<String, Integer>();
        for (ResourceTimeWindow resourceTimeWindow : resourceTimeWindowList) {
            String remoteWwn = resourceTimeWindow.getRemoteWwn();
            if (VerifyUtil.isEmpty((String)remoteWwn)) {
                LOGGER.info((Object)"RemoteWwn is null: resourceTimeWindow: %s", new Object[]{resourceTimeWindow.toString()});
                continue;
            }
            resourceTimeWindowMap.put(remoteWwn, resourceTimeWindow);
            String portId = resourceTimeWindow.getPortId();
            if (!VerifyUtil.isEmpty((String)portId)) {
                String[] splitPortId = portId.split(",", -1);
                this.updatePortRefCount(portIdUsedCount, splitPortId);
            }
            if (remoteLinkDeviceWwnSet.contains(remoteWwn)) continue;
            LOGGER.info((Object)"There is no remote device which has remoteWwn(%s), its time-window will be deleted.", new Object[]{remoteWwn});
            windowIdToDelete.add(resourceTimeWindow);
        }
        this.updateExistedTimeWindow(remoteLatestDeviceList, resourceTimeWindowMap);
        this.doUpdateLinkPorts(devSn);
        this.deleteNotExistedTimeWindow(windowIdToDelete, portIdUsedCount);
        remoteLinkDeviceWwnSet.removeAll(resourceTimeWindowList.stream().map(ResourceTimeWindow::getRemoteWwn).collect(Collectors.toSet()));
        this.addNewTimeWindow(devSn, remoteLatestDeviceList, remoteLinkDeviceWwnSet);
        LOGGER.info((Object)"Updating timeWindow finished.");
    }

    private void deleteNotExistedTimeWindow(List<ResourceTimeWindow> windowIdToDelete, Map<String, Integer> portIdUsedCount) {
        List<String> portIdToDelete = this.getPortIdToDelete(windowIdToDelete, portIdUsedCount);
        windowIdToDelete.forEach(window -> this.deleteResourceTimeWindow(window.getWindowId()));
        portIdToDelete.forEach(this::deletePortAndLogsForTimeWindow);
    }

    private void updateExistedTimeWindow(List<RemoteLinkDevice> remoteLatestDeviceList, Map<String, ResourceTimeWindow> resourceTimeWindowMap) {
        for (RemoteLinkDevice remoteLinkDevice : remoteLatestDeviceList) {
            String remoteWwn = remoteLinkDevice.getRemoteWwn();
            if (!resourceTimeWindowMap.containsKey(remoteWwn)) continue;
            ResourceTimeWindow resourceTimeWindow = resourceTimeWindowMap.get(remoteWwn);
            List portIds = remoteLinkDevice.getLinkPorts().stream().map(StorageLinkPort::getPortId).collect(Collectors.toList());
            String tmpStr = portIds.toString();
            String portIdStr = tmpStr.substring(1, tmpStr.length() - 1);
            resourceTimeWindow.setPortId(portIdStr);
            resourceTimeWindow.setRemoteName(remoteLinkDevice.getRemoteName());
            LOGGER.debug((Object)"Update timeWindow: portId=%s, remoteName=%s", new Object[]{portIdStr, remoteLinkDevice.getRemoteName()});
            String updateWindowSql = "update TI_RESOURCETIMEWINDOW set REMOTENAME=?, PORTID=? where WINDOWID=?";
            CommonDAOLocator.getBaseDao().update(updateWindowSql, new Object[]{resourceTimeWindow.getRemoteName(), portIdStr, resourceTimeWindow.getWindowId()});
        }
    }

    private void addNewTimeWindow(String devSn, List<RemoteLinkDevice> remoteLatestDeviceList, Set<String> remoteLinkDeviceWwnSet) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        for (RemoteLinkDevice remoteLatestDevice : remoteLatestDeviceList) {
            if (!remoteLinkDeviceWwnSet.contains(remoteLatestDevice.getRemoteWwn())) continue;
            ResourceTimeWindow resourceTimeWindow = ResourceTimeWindow.instance((String)devSn, (RemoteLinkDevice)remoteLatestDevice);
            LOGGER.info((Object)"Add new time-window: %s", new Object[]{resourceTimeWindow});
            resourceService.addResourceTimeWindow(resourceTimeWindow);
        }
    }

    private List<String> getPortIdToDelete(List<ResourceTimeWindow> windowIdToDelete, Map<String, Integer> portIdUsedCount) {
        ArrayList portIdSet = new ArrayList();
        for (ResourceTimeWindow timeWindow : windowIdToDelete) {
            String portId = timeWindow.getPortId();
            if (VerifyUtil.isEmpty((String)portId)) continue;
            String[] split = portId.split(",", -1);
            Arrays.stream(split).filter(str -> !VerifyUtil.isEmpty((String)str)).forEach(str -> portIdSet.add(str.trim()));
        }
        for (String portIdToDelete : portIdSet) {
            if (!portIdUsedCount.containsKey(portIdToDelete)) continue;
            Integer count = portIdUsedCount.get(portIdToDelete);
            portIdUsedCount.put(portIdToDelete, count - 1);
        }
        return portIdUsedCount.entrySet().stream().filter(entry -> (Integer)entry.getValue() == 0).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private void updatePortRefCount(Map<String, Integer> portIdUsedCount, String[] splitPortIdList) {
        for (String portId : splitPortIdList) {
            if (VerifyUtil.isEmpty((String)portId)) continue;
            if (!portIdUsedCount.containsKey(portId = portId.trim())) {
                portIdUsedCount.put(portId, 1);
                continue;
            }
            Integer usedCount = portIdUsedCount.get(portId);
            portIdUsedCount.put(portId, usedCount + 1);
        }
    }

    public List<ResourceTimeWindow> getResourceTimeWindow(String resourceId) {
        List<ResourceTimeWindow> timeWindows;
        if (VerifyUtil.isEmpty((String)resourceId)) {
            throw new LegoCheckedException(1073947393L);
        }
        int index = 0;
        do {
            if (!CollectionUtils.isEmpty(timeWindows = this.getTimeWindowsInDb(resourceId))) {
                LOGGER.debug((Object)"Get resource time window success. resourceId: %s", new Object[]{resourceId});
                break;
            }
            CommUtil.pauseThread((long)2000L);
            LOGGER.info((Object)"Not find time windows, wait for 2s");
        } while (++index < 10);
        for (ResourceTimeWindow timeWindow : timeWindows) {
            Set tmpRanges = timeWindow.getTimeWindowRanges();
            for (ResourceTimeWindowRange range : tmpRanges) {
                this.changeTimeRangeStr(range);
            }
            if (timeWindow.getSwitchoverEnum() != SwitchoverEnum.MAINTENANCE) continue;
            timeWindow.setEndSwitchOnTime(timeWindow.getLastSwitchOnTime() + 86400000L);
        }
        return timeWindows;
    }

    private List<ResourceTimeWindow> getTimeWindowsInDb(String resourceId) {
        try {
            return CommonDAOLocator.getBaseDao().find("from ResourceTimeWindow where resourceId=?", new Object[]{resourceId});
        }
        catch (Exception e) {
            LOGGER.error((Object)"Find time window db exception. msg: %s", new Object[]{e.getMessage()});
            return Collections.emptyList();
        }
    }

    private void changeTimeRangeStr(ResourceTimeWindowRange range) {
        String startTimeStr = range.getStartTimeStr();
        String endTimeStr = range.getEndTimeStr();
        if (VerifyUtil.isEmpty((String)startTimeStr) || VerifyUtil.isEmpty((String)endTimeStr)) {
            LOGGER.error((Object)("Error to find time str by rangeId:" + range.getId()));
            throw new LegoCheckedException(1073947394L);
        }
        Date curDate = new Date();
        String[] startTimeArray = startTimeStr.split(":");
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(curDate);
        calStart.set(11, Integer.parseInt(startTimeArray[0]));
        calStart.set(12, Integer.parseInt(startTimeArray[1]));
        calStart.set(13, 0);
        calStart.set(14, 0);
        Date dateStart = calStart.getTime();
        range.setStartTime(dateStart);
        String[] endTimeArray = endTimeStr.split(":");
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(curDate);
        calEnd.set(11, Integer.parseInt(endTimeArray[0]));
        calEnd.set(12, Integer.parseInt(endTimeArray[1]));
        calEnd.set(13, 0);
        calEnd.set(14, 0);
        Date dateEnd = calEnd.getTime();
        range.setEndTime(dateEnd);
        if (dateStart.getTime() >= dateEnd.getTime()) {
            if (curDate.getTime() <= dateEnd.getTime()) {
                long startTimeValue = dateStart.getTime() - 86400000L;
                Date newStartDate = new Date();
                newStartDate.setTime(startTimeValue);
                range.setStartTime(newStartDate);
            } else {
                calEnd.add(5, 1);
                Date tmpEndDate = calEnd.getTime();
                range.setEndTime(tmpEndDate);
            }
        }
    }

    public List<StoragePortOperateLog> getResourcePortOperateLog(String resourceId, String portId) {
        List portOperateLogs;
        try {
            portOperateLogs = CommonDAOLocator.getBaseDao().find("from StoragePortOperateLog as log where log.portId=? and log.devSn=?", new Object[]{portId, resourceId});
            LOGGER.debug((Object)"Get port operate log success. portId: %s", new Object[]{portId});
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)"Find port operate log failed.", (Throwable)e);
            return Collections.emptyList();
        }
        return portOperateLogs;
    }

    public List<DrResource> getAirGapResource() {
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        List allLocalSites = siteService.getAllLocalSites();
        allLocalSites = Optional.ofNullable(allLocalSites).orElseGet(Collections::emptyList);
        ArrayList<DrResource> airGapResource = new ArrayList<DrResource>();
        for (Site localSite : allLocalSites) {
            List allResourceBySite = siteService.getAllResourceBySite(localSite.getSiteId(), "ism.deviceType.storage.mainType");
            allResourceBySite = Optional.ofNullable(allResourceBySite).orElseGet(Collections::emptyList);
            allResourceBySite.stream().filter(DrResource::getIsAirGapResource).forEach(airGapResource::add);
        }
        return airGapResource;
    }

    public List<StorageLinkPort> getResourceLinkPorts(String devSn) {
        List linkPorts;
        try {
            linkPorts = CommonDAOLocator.getBaseDao().find("from StorageLinkPort where devSn=?", new Object[]{devSn});
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)"Find port failed.", (Throwable)e);
            return Collections.emptyList();
        }
        return linkPorts;
    }

    public void doUpdateLinkPorts(String devSn) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        List portsInDb = resourceService.getResourceLinkPorts(devSn);
        List portsInStorage = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageLinkPorts(devSn);
        if (CollectionUtils.isEmpty((Collection)portsInStorage)) {
            LOGGER.error((Object)"Not find ports, return. System error! devSn\uff1a%s", new Object[]{devSn});
            return;
        }
        HashMap storageMap = new HashMap();
        portsInStorage.forEach(port -> storageMap.put(port.getPortId(), port));
        for (StorageLinkPort portInDb : portsInDb) {
            StorageLinkPort tmpPort = (StorageLinkPort)storageMap.get(portInDb.getPortId());
            if (tmpPort != null) continue;
            LOGGER.error((Object)"Not find port in storage by portId: %s, delete port in db", new Object[]{portInDb.getPortId()});
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)portInDb);
        }
        Set dbPortIds = portsInDb.stream().map(StorageLinkPort::getPortId).collect(Collectors.toSet());
        IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(devSn);
        Set<String> manuelPorts = AirGapLinkPortUtil.getSwitchMaintainPortIds();
        Set<String> workPorts = AirGapLinkPortUtil.getProtectGroupWorkPorts();
        for (StorageLinkPort port2 : portsInStorage) {
            String newPortId = port2.getPortId();
            if (!dbPortIds.contains(newPortId)) {
                boolean portEnable;
                boolean bl = portEnable = port2.getEnable() != false || port2.getOperationalStatus() != false;
                if (!manuelPorts.contains(newPortId) && !workPorts.contains(newPortId) && portEnable) {
                    mgr.disableStoragePort(devSn, port2);
                    port2.setEnable(Boolean.valueOf(false));
                    port2.setOperationalStatus(Boolean.valueOf(false));
                    LOGGER.info((Object)"Storage new port, portName: %s, portId: %s is not in Db, add and disable", new Object[]{port2.getPortName(), port2.getPortId()});
                }
            }
            port2.setTime(System.currentTimeMillis());
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)port2);
        }
    }

    public void switchoverTimeWindows(String devSn, String windowId, boolean isManualTunnel, boolean isAutoTrigger) {
        ResourceTimeWindow timeWindow = (ResourceTimeWindow)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ResourceTimeWindow.class, (Serializable)((Object)windowId));
        if (VerifyUtil.isEmpty((Object)timeWindow)) {
            LOGGER.error((Object)"Not find time window by windowId: %s", new Object[]{windowId});
            throw new LegoCheckedException(1073947393L, "Not find time window by windowId");
        }
        if (isManualTunnel) {
            this.switchOnManual(timeWindow);
        } else {
            if (timeWindow.getSwitchoverEnum() == SwitchoverEnum.SECURITY) {
                LOGGER.info((Object)"TimeWindow: %s already switch to security mode, return.", new Object[]{windowId});
                return;
            }
            List<StorageLinkPort> linkPorts = this.getAndSetPorts(timeWindow, isAutoTrigger);
            if (CollectionUtils.isEmpty(linkPorts)) {
                throw new LegoCheckedException(1073948475L);
            }
            AirGapLinkProcessor linkProcessor = AirGapLinkProcessor.getInstance();
            linkProcessor.filterAndDisablePortsWithoutTask(linkPorts);
            LOGGER.info((Object)"Switch to security mode, windowId: %s, ports: %s", new Object[]{windowId, linkPorts});
            timeWindow.setSwitchoverEnum(SwitchoverEnum.SECURITY);
            timeWindow.setTime(System.currentTimeMillis());
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)timeWindow);
        }
    }

    private void switchOnManual(ResourceTimeWindow timeWindow) {
        long curTime;
        if (timeWindow.getSwitchoverEnum() == SwitchoverEnum.MAINTENANCE) {
            LOGGER.info((Object)"Already switch on maintenance mode, return");
            return;
        }
        if (timeWindow.getLastSwitchOnTime() != -1L && (curTime = System.currentTimeMillis()) - timeWindow.getLastSwitchOnTime() < 900000L) {
            LOGGER.error((Object)"The interval between two startups is less than 15 minutes.");
            throw new LegoCheckedException(1073948766L);
        }
        this.enablePortsInStorage(timeWindow);
        timeWindow.setLastSwitchOnTime(System.currentTimeMillis());
        timeWindow.setSwitchoverEnum(SwitchoverEnum.MAINTENANCE);
        timeWindow.setTime(System.currentTimeMillis());
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)timeWindow);
    }

    private void enablePortsInStorage(ResourceTimeWindow timeWindow) {
        List<StorageLinkPort> linkPorts = this.getAndSetPorts(timeWindow, false);
        if (CollectionUtils.isEmpty(linkPorts)) {
            throw new LegoCheckedException(1073948475L);
        }
        EnablePortTask task = new EnablePortTask();
        task.setPortList(linkPorts);
        task.setDevSn(timeWindow.getResourceId());
        task.setTaskId("1");
        task.setRemoteDevSn(timeWindow.getEsn());
        AirGapLinkProcessor linkProcessor = AirGapLinkProcessor.getInstance();
        linkProcessor.addEnablePortsToProcessor(task);
        LOGGER.info((Object)"TimeWindow: %s switch to maintenance mode success.", new Object[]{timeWindow.getWindowId()});
    }

    private List<StorageLinkPort> getAndSetPorts(ResourceTimeWindow timeWindow, boolean isAuto) {
        List<StorageLinkPort> linkPorts = AirGapLinkPortUtil.getAirGapPortListByTimeWindow(timeWindow);
        if (CollectionUtils.isEmpty(linkPorts)) {
            return Collections.emptyList();
        }
        for (StorageLinkPort linkPort : linkPorts) {
            linkPort.setOperator(timeWindow.getWindowId());
            linkPort.setOperateType(3);
            if (isAuto) {
                linkPort.setExecTypeEnum(DrmEnumDefine.ExecTypeEnum.AUTO);
            } else {
                linkPort.setExecTypeEnum(DrmEnumDefine.ExecTypeEnum.MANUAL);
            }
            linkPort.setSwitchover(Boolean.valueOf(true));
            linkPort.setTaskId("1");
        }
        return linkPorts;
    }
}

