/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.service.impl;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.discover.commons.DeviceOperationLock;
import com.huawei.ism.cbb.discover.commons.OperationLock;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class RefreshSiteBackTask
extends AbstractBackTask {
    private static Log logger = LogFactory.getInstance(RefreshSiteBackTask.class);
    private Site site;

    public RefreshSiteBackTask(Site site, BackTask bt, boolean isVisible) {
        super(site.getSiteId(), bt, isVisible);
        this.site = site;
    }

    protected void doWork() {
        String id = this.site.getSiteId();
        OperationLock opLock = DeviceOperationLock.getLock((String)id);
        if (!opLock.tryLock()) {
            logger.warn((Object)("Someone[" + opLock.getOwnerName() + "] has locked site, siteId=" + id));
            throw new LegoCheckedException(102401L);
        }
        logger.info((Object)("Get site operation lock ... siteId=" + id));
        try {
            ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).refreshSite(this.site);
        }
        finally {
            opLock.unTryLock();
            logger.info((Object)("Release site operation lock ... siteId=" + id));
        }
    }
}

