/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.util;

import com.huawei.ism.drm.site.sdk.service.ISiteResourceService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class SiteResourceServiceProxy {
    private static SiteResourceServiceProxy instance = null;
    private static Map<String, ISiteResourceService> siteResourceServices = null;

    private SiteResourceServiceProxy() {
        SiteResourceServiceProxy.setSiteResourceServices(new HashMap<String, ISiteResourceService>());
    }

    public static synchronized SiteResourceServiceProxy getInstance() {
        if (null == instance) {
            instance = new SiteResourceServiceProxy();
        }
        return instance;
    }

    public void onBind(ISiteResourceService resourceService, Map<String, String> properties) {
        if (null != resourceService && null != properties && null != properties.get("resType")) {
            siteResourceServices.put(properties.get("resType"), resourceService);
        }
    }

    public void onUnbind(ISiteResourceService resourceService, Map<String, String> properties) {
        if (null != resourceService && null != properties && null != properties.get("resType")) {
            siteResourceServices.remove(properties.get("resType"));
        }
    }

    public ISiteResourceService getSiteResourceService(String resType) {
        ISiteResourceService service = siteResourceServices.get(resType);
        if (null == service) {
            throw new LegoCheckedException(1073947393L, resType + "is not supported.");
        }
        return service;
    }

    public Collection<ISiteResourceService> getAllSiteResourceService() {
        return siteResourceServices.values();
    }

    public Set<String> getAllSiteResourceServiceKey() {
        return siteResourceServices.keySet();
    }

    private static void setSiteResourceServices(Map<String, ISiteResourceService> siteResourceServices) {
        SiteResourceServiceProxy.siteResourceServices = siteResourceServices;
    }
}

