/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.manager.proxy;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.drm.storage.manager.proxy.BaseStorageManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageHyperMetroManagerProxy
extends BaseStorageManagerProxy {
    private static final StorageHyperMetroManagerProxy PROXY = new StorageHyperMetroManagerProxy();
    private final Map<String, IStorageHyperMetroManager> managers = new HashMap<String, IStorageHyperMetroManager>();

    public static StorageHyperMetroManagerProxy getInstance() {
        return PROXY;
    }

    public void onBind(IStorageHyperMetroManager handler, Map<String, Object> properties) {
        this.managers.put(handler.getStorageType() + handler.getVersion(), handler);
    }

    public void onUnbind(IStorageHyperMetroManager handler, Map<String, Object> properties) {
        this.managers.remove(handler.getStorageType() + handler.getVersion());
    }

    public IStorageHyperMetroManager getMgrByDevType(String deviceType) {
        return this.managers.get(deviceType);
    }

    public IStorageHyperMetroManager getMgrByDevId(String deviceId) {
        String deviceType = this.getStorageTypeWithVersion(deviceId);
        IStorageHyperMetroManager mgr = this.managers.get(deviceType);
        if (mgr == null) {
            logger.error((Object)"IStorageHyperMetroManager is null, sn=%s, deviceType=%s", new Object[]{deviceId, deviceType});
            throw new LegoCheckedException(1073947393L);
        }
        return mgr;
    }

    @Override
    protected List<String> getSupportedVersions(String storageType) {
        List<String> supportedVersions = super.getSupportedVersions(storageType);
        if (!HvsUnit.class.getName().equals(storageType)) {
            return supportedVersions;
        }
        return Arrays.asList("", "V600R000C00");
    }
}

