/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.manager.proxy;

import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.storage.manager.proxy.BaseStorageManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageReprotectManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class StorageReprotectManagerProxy
extends BaseStorageManagerProxy
implements IStorageReprotectManager {
    private static StorageReprotectManagerProxy reprotectManagerProxy = new StorageReprotectManagerProxy();
    private static final Log logger = LogFactory.getInstance(StorageReprotectManagerProxy.class);
    private Map<String, IStorageReprotectManager> storageReprotectManagers = new HashMap<String, IStorageReprotectManager>();

    private StorageReprotectManagerProxy() {
    }

    public static StorageReprotectManagerProxy getInstance() {
        return reprotectManagerProxy;
    }

    public void onBind(IStorageReprotectManager handler, Map<String, Object> properties) {
        this.storageReprotectManagers.put(handler.getStorageType(), handler);
    }

    public void onUnbind(IStorageReprotectManager handler, Map<String, Object> properties) {
        this.storageReprotectManagers.remove(handler.getStorageType());
    }

    public IStorageReprotectManager getStorageReprotectMgrByDevType(String deviceType) {
        return this.storageReprotectManagers.get(deviceType);
    }

    public IStorageReprotectManager getStorageReprotectMgrByDevId(String deviceId) {
        String deviceType = this.getStorageType(deviceId);
        IStorageReprotectManager mgr = this.storageReprotectManagers.get(deviceType);
        if (null == mgr) {
            logger.error((Object)("mgr is null, sn=" + deviceId + ", type=" + deviceType));
            throw new LegoCheckedException(1073947395L);
        }
        return mgr;
    }

    public OperationResult reverseReplication(String srcDeviceId, String targetDeviceId, String replicationId, boolean isConsistentGroup) {
        IStorageReprotectManager storageReprotectMgr = this.getStorageReprotectMgrByDevId(targetDeviceId);
        return storageReprotectMgr.reverseReplication(srcDeviceId, targetDeviceId, replicationId, isConsistentGroup);
    }

    public void refreshStorage(String deviceId) {
        IStorageReprotectManager storageReprotectMgr = this.getStorageReprotectMgrByDevId(deviceId);
        storageReprotectMgr.refreshStorage(deviceId);
    }

    public void checkStorageReplication(String deviceId, List<String> resourceIds) {
        IStorageReprotectManager storageReprotectMgr = this.getStorageReprotectMgrByDevId(deviceId);
        storageReprotectMgr.checkStorageReplication(deviceId, resourceIds);
    }

    public OperationResult setSecondaryLunWriteProtection(String srcDeviceId, String targetDeviceId, String replicationId, boolean isConsistentGroup) {
        IStorageReprotectManager storageReprotectMgr = this.getStorageReprotectMgrByDevId(targetDeviceId);
        return storageReprotectMgr.setSecondaryLunWriteProtection(srcDeviceId, targetDeviceId, replicationId, isConsistentGroup);
    }

    public String getStorageType() {
        return null;
    }

    public void refreshVasaProtectGroupStorage(String deviceId, String consistencyGroupId) {
        IStorageReprotectManager storageReprotectMgr = this.getStorageReprotectMgrByDevId(deviceId);
        storageReprotectMgr.refreshVasaProtectGroupStorage(deviceId, consistencyGroupId);
    }

    public void checkStorageRunningStatus(String deviceId, List<String> usedDrRingIds, String drStrategy) {
        IStorageReprotectManager storageReprotectMgr = this.getStorageReprotectMgrByDevId(deviceId);
        storageReprotectMgr.checkStorageRunningStatus(deviceId, usedDrRingIds, drStrategy);
    }
}

