/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.manager.proxy;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.drm.storage.manager.proxy.BaseStorageManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageVstoreReplicationPairManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageVstoreReplicationPairManagerProxy
extends BaseStorageManagerProxy {
    private static final StorageVstoreReplicationPairManagerProxy PROXY = new StorageVstoreReplicationPairManagerProxy();
    private final Map<String, IStorageVstoreReplicationPairManager> managers = new HashMap<String, IStorageVstoreReplicationPairManager>();

    public static StorageVstoreReplicationPairManagerProxy getInstance() {
        return PROXY;
    }

    public void onBind(IStorageVstoreReplicationPairManager handler, Map<String, Object> properties) {
        this.managers.put(handler.getStorageType() + handler.getVersion(), handler);
    }

    @Override
    protected List<String> getSupportedVersions(String storageType) {
        List<String> supportedVersions = super.getSupportedVersions(storageType);
        if (!HvsUnit.class.getName().equals(storageType)) {
            return supportedVersions;
        }
        ArrayList<String> versionList = new ArrayList<String>(supportedVersions);
        versionList.add("V600R000C00");
        return versionList;
    }

    public IStorageVstoreReplicationPairManager getMgrByDevType(String deviceType) {
        return this.managers.get(deviceType);
    }

    public IStorageVstoreReplicationPairManager getMgrByDevId(String deviceId) {
        String deviceType = this.getStorageTypeWithVersion(deviceId);
        IStorageVstoreReplicationPairManager mgr = this.managers.get(deviceType);
        if (null == mgr) {
            logger.error((Object)"IStorageVstoreHyperMetroPairManager is null, sn=%s, deviceType=%s", new Object[]{deviceId, deviceType});
            throw new LegoCheckedException(1073947393L);
        }
        return mgr;
    }
}

