/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.service.impl;

import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.RemoteDevice;
import com.huawei.ism.array.sdk.model.XveLunGroup;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.base.sdk.model.StoragePool;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.IDiscoverService;
import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.DrmStorageUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.util.SiteResourceManagerUtil;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperVaultManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageLicenseManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StoragePortLinksManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperVaultManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStoragePortLinksManager;
import com.huawei.ism.drm.storage.replication.service.impl.AbstractReplicationService;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationLink;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.model.StorageLicense;
import com.huawei.ism.drm.storage.sdk.model.StorageLinkPort;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreInfo;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.query.Query;

@Service(Name="com.huawei.ism.drm.storage.sdk.service.IStorageService", Desc="", Interface=IStorageService.class)
public class DrmStorageServiceImpl
extends AbstractReplicationService
implements IStorageService {
    private static Log logger = LogFactory.getInstance(DrmStorageServiceImpl.class);

    public void refreshStorage(Long moId, String userName) {
        IDiscoverService cbbDiscoverService = (IDiscoverService)ServiceLocator.getInstance().getService(IDiscoverService.class);
        NetworkEntity entity = (NetworkEntity)this.getMoDao().getMo(NetworkEntity.class, "moId", (Object)moId);
        if (!(entity instanceof StorageNE)) {
            logger.error((Object)("the entity is :" + entity.getClass().getName()), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        cbbDiscoverService.refreshStorage((StorageNE)entity, userName);
    }

    public List<DrStorage> getStorageListBySiteId(String siteId, Long userId) {
        logger.debug((Object)("siteId=" + siteId));
        Site site = SiteResourceManagerUtil.isSiteExisted(siteId);
        if (null == site) {
            return new ArrayList<DrStorage>(0);
        }
        List<String> sns = SiteResourceManagerUtil.getResourceSNBySiteId(siteId, 2);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(sns)) {
            return new ArrayList<DrStorage>(0);
        }
        if (site.getSiteType() == 0 && null != userId && com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(sns = SiteResourceManagerUtil.filterDrResourceSN(sns, userId))) {
            return new ArrayList<DrStorage>(0);
        }
        return SiteResourceManagerUtil.translateCriAndGetResource(sns, DrStorage.class, "deviceSn", siteId);
    }

    public StorageNE getStorageBySn(String sn, Long userId) {
        StorageNE storage = (StorageNE)this.getMoDao().getMo(StorageNE.class, "sn", (Object)sn);
        if (null != storage) {
            if (null == userId) {
                return storage;
            }
            if (this.getScopeManager().checkUserGrandObject(userId.longValue(), (ManagedObject)storage).booleanValue()) {
                return storage;
            }
            return null;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public List<ManagedObject> queryChildMO(Long parentMoId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Lun> queryLunByStorageSn(String sn, String orderBy, boolean isAsc, List<QueryCondition> queryCondition) {
        StorageNE storage;
        List<Object> data = new ArrayList<Lun>();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)orderBy)) {
            orderBy = "name";
        }
        if (null == (storage = (StorageNE)this.getMoDao().getMo(StorageNE.class, "sn", (Object)sn))) {
            return data;
        }
        String topMoUuid = storage.getTopMoUuid();
        QueryCondition condition = new QueryCondition("topMoUuid", (Object)topMoUuid);
        if (null == queryCondition) {
            queryCondition = new ArrayList<QueryCondition>();
            queryCondition.add(condition);
        } else {
            queryCondition.add(condition);
        }
        try {
            data = this.getMoDao().findMoBy(Lun.class, orderBy, isAsc, queryCondition);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("getAllStorage Exception by sn:" + sn), (Throwable)e, 90160758787071L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("getAllLun Error by storage sn:" + sn), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return data;
    }

    /*
     * Exception decompiling
     */
    public Map<String, String> queryLunGroup(String devSn, List<QueryCondition> queryConditions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addAllLunMap(boolean filterByGroup, String devSn, Map<String, String> lunGroupMap, List<QueryCondition> queryConditions) {
        if (!filterByGroup) {
            List<Lun> lunData = this.queryLunByStorageSn(devSn, "name", true, queryConditions);
            for (Lun lun : lunData) {
                lunGroupMap.put(lun.getLunId(), "--");
            }
        }
    }

    private void initLunGroupMap(XveLunGroup xveLunGroup, Map<String, String> lunGroupMap) {
        List lunIds = xveLunGroup.getLunIds();
        if (null == lunIds || lunIds.isEmpty()) {
            return;
        }
        for (String lunId : lunIds) {
            lunGroupMap.put(lunId, xveLunGroup.getName());
        }
    }

    public List<Lun> getLunsByDeviceSnAndLunIds(String deviceSn, List<String> lunIds) {
        logger.debug((Object)("sn=" + deviceSn + ", lunIds=" + lunIds));
        List<StorageResource> storageResources = this.getStorageResources(deviceSn, lunIds, DrmEnumDefine.RESOURCE_TYPE_E.LUN);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(storageResources)) {
            return new ArrayList<Lun>();
        }
        ArrayList<Lun> luns = new ArrayList<Lun>();
        for (StorageResource storageResource : storageResources) {
            luns.add((Lun)storageResource);
        }
        return luns;
    }

    public List<StorageResource> getStorageResources(String deviceSn, List<String> resourceIds, DrmEnumDefine.RESOURCE_TYPE_E resourceType) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)deviceSn) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(resourceIds)) {
            return new ArrayList<StorageResource>();
        }
        DrResource dr = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(deviceSn);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)dr)) {
            logger.error((Object)("Device does not exist. Id:" + deviceSn), 90160758787071L);
            return new ArrayList<StorageResource>();
        }
        List<StorageResource> batchList = this.batchQueryStorageResourcesByDeviceSn(deviceSn, resourceIds, false);
        return this.filterStorageResourceByType(batchList, resourceType);
    }

    public List<StorageResource> getStorageResources(String deviceSn, List<String> resourceIdOrNames, boolean isUseName, DrmEnumDefine.RESOURCE_TYPE_E resourceType) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)deviceSn) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(resourceIdOrNames)) {
            return new ArrayList<StorageResource>();
        }
        DrResource dr = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(deviceSn);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)dr)) {
            logger.error((Object)("Device does not exist. Id:" + deviceSn), 90160758787071L);
            return new ArrayList<StorageResource>();
        }
        List<StorageResource> batchList = this.batchQueryStorageResourcesByDeviceSn(deviceSn, resourceIdOrNames, isUseName);
        return this.filterStorageResourceByType(batchList, resourceType);
    }

    private List<StorageResource> filterStorageResourceByType(List<StorageResource> list, DrmEnumDefine.RESOURCE_TYPE_E type) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(list)) {
            return list;
        }
        list = type != null && type == DrmEnumDefine.RESOURCE_TYPE_E.NAS ? list.stream().filter(NasFileSystem.class::isInstance).collect(Collectors.toList()) : list.stream().filter(Lun.class::isInstance).collect(Collectors.toList());
        return list;
    }

    public Lun getLunBySnAndLunId(String devSn, String lunId) {
        DrResource dr = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(devSn);
        if (null == dr) {
            logger.error((Object)("can not found DrResource by " + devSn), 90160758787071L);
            return null;
        }
        Lun ret = null;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", devSn);
        props.put("lunId", lunId);
        List lunList = this.getMoDao().findMoBy(Lun.class, props);
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)lunList)) {
            ret = (Lun)lunList.get(0);
        }
        return ret;
    }

    public ArrayUnit getStorageBySn(String devSn) {
        if (null == devSn) {
            logger.info((Object)"devSn is null.");
            return null;
        }
        return (ArrayUnit)this.getMoDao().getMo(ArrayUnit.class, "devSn", (Object)devSn);
    }

    public StorageUnit getStorageUnitBySn(String devSn) {
        if (null == devSn) {
            logger.info((Object)"devSn is null.");
            return null;
        }
        return (StorageUnit)this.getMoDao().getMo(StorageUnit.class, "devSn", (Object)devSn);
    }

    public void checkStorageUsed(Long moId) {
        if (null == moId) {
            logger.error((Object)"MO id is null.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        ManagedObject ob = (ManagedObject)CommonDAOLocator.getMoDao().get((Serializable)moId);
        if (null == ob) {
            logger.error((Object)"storage mo is null", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        this.processArray(moId);
    }

    private void processArray(Long moId) {
        DrResource resource = SiteResourceManagerUtil.getDrResourceByMoId(moId);
        if (null == resource) {
            return;
        }
        IStorageResourceService srService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        boolean isStorageUsed = srService.isStorageUsedByPoStorageInfo(resource.getDeviceSn());
        if (isStorageUsed) {
            throw new LegoCheckedException(1073947655L);
        }
        isStorageUsed = srService.isStorageUsedByPoType(resource.getDeviceSn(), 11);
        if (isStorageUsed) {
            throw new LegoCheckedException(1073947655L);
        }
        isStorageUsed = srService.isStorageUsedByPoType(resource.getDeviceSn(), 2);
        if (isStorageUsed) {
            throw new LegoCheckedException(1073947655L);
        }
    }

    public List<Lun> getSrcLunByReplicasionUuid(String replicationUuid) {
        logger.debug((Object)("replicationUuid=" + replicationUuid));
        ArrayList<Lun> result = new ArrayList<Lun>();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)replicationUuid)) {
            return result;
        }
        ReplicationRelation rp = (ReplicationRelation)this.getMoDao().getMo(ReplicationRelation.class, "uuid", (Object)replicationUuid);
        if (rp instanceof ReplicationPair) {
            ReplicationPair pair = (ReplicationPair)rp;
            Lun lun = this.getSrcLunByReplicationPair(pair);
            result.add(lun);
        } else if (rp instanceof ReplicationGroup) {
            ReplicationGroup cg = (ReplicationGroup)rp;
            boolean isPrimary = cg.getIsPrimary();
            String queryDevSn = isPrimary ? cg.getSrcDevSN() : cg.getDevSn();
            List<ReplicationPair> pairs = this.getReplicationPairByRepGroupId(queryDevSn, cg.getReplicationId(), isPrimary);
            for (ReplicationPair pair : pairs) {
                Lun lun = this.getSrcLunByReplicationPair(pair);
                result.add(lun);
            }
        }
        Collections.sort(result, new CommonComparator("name", true));
        return result;
    }

    public List<NasFileSystem> getFileSystemByVstoreUuid(String vstoreUuid) {
        logger.debug((Object)("vstoreUuid=" + vstoreUuid));
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)vstoreUuid)) {
            return Collections.emptyList();
        }
        VstoreInfo vstoreInfo = (VstoreInfo)this.getMoDao().getMo(VstoreInfo.class, "uuid", (Object)vstoreUuid);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", vstoreInfo.getDevSn());
        props.put("vstoreId", vstoreInfo.getVstoreId());
        List result = this.getMoDao().findMoBy(NasFileSystem.class, props);
        Collections.sort(result, new CommonComparator("name", true));
        return result;
    }

    private Lun getSrcLunByReplicationPair(ReplicationPair pair) {
        Lun lun = null;
        if (!pair.getIsPrimary().booleanValue()) {
            List<ReplicationTargetLun> luns = DrmStorageUtil.getTargetLunsByReplicationId(pair.getDevSn(), pair.getReplicationId());
            Optional<String> opt = luns.stream().map(ReplicationTargetLun::getTgtLunId).findAny();
            if (opt.isPresent()) {
                lun = this.getLunBySnAndLunId(pair.getDevSn(), opt.get());
            }
        } else {
            lun = this.getLunBySnAndLunId(pair.getSrcDevSN(), pair.getSrcLunId());
        }
        if (lun == null) {
            logger.error((Object)("lun(" + pair.getSrcDevSN() + ":" + pair.getSrcLunId() + ") is null"), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        return lun;
    }

    private List<ReplicationPair> getReplicationPairByRepGroupId(String queryDevSn, String replicationGrpId, boolean isPrimary) {
        logger.debug((Object)("queryDevSn=" + queryDevSn + ", replicationGrpId=" + replicationGrpId));
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)queryDevSn)) {
            if (isPrimary) {
                props.put("srcDevSN", queryDevSn);
            } else {
                props.put("devSn", queryDevSn);
            }
        }
        props.put("consistentGroupId", replicationGrpId);
        props.put("isPrimary", isPrimary);
        List pairList = this.getMoDao().findMoBy(ReplicationPair.class, props);
        if (pairList == null) {
            return new ArrayList<ReplicationPair>();
        }
        return pairList;
    }

    public List<StorageResource> getResourceByWwnFromRemote(Site srcSite, List<String> srcResourceWwns) {
        ArrayList<StorageResource> srcResources = new ArrayList<StorageResource>();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(srcResourceWwns)) {
            logger.error((Object)"The para is null");
            return srcResources;
        }
        HashMap<String, String> srcUriVariabels = new HashMap<String, String>();
        StringBuffer strResourceWwns = new StringBuffer();
        for (String srcResourceID : srcResourceWwns) {
            strResourceWwns.append(srcResourceID).append(';');
        }
        String srcResourceIdStr = strResourceWwns.toString();
        srcUriVariabels.put("wwn", srcResourceIdStr.substring(0, srcResourceIdStr.length() - 1));
        try {
            RestClient srcClient = SiteUtil.initClient(srcSite);
            String reqUrl = "/ws/storages/action/getStorageResourceByWwn?wwn={wwn}";
            String sResults = srcClient.get(reqUrl, srcUriVariabels);
            JSONArray jsonArray = JSONArray.fromObject((Object)sResults);
            if (null != jsonArray && jsonArray.size() > 0) {
                this.buildResouceInfo(srcResources, jsonArray);
            }
        }
        catch (Exception e) {
            logger.error((Object)("getResourceFromRemote failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786962L);
        }
        return srcResources;
    }

    private void buildResouceInfo(List<StorageResource> srcResources, JSONArray jsonArray) {
        Iterator it = jsonArray.iterator();
        while (it.hasNext()) {
            JSONObject jsonObject = JSONObject.fromObject(it.next());
            int resourceType = 0;
            if (jsonObject.containsKey((Object)"resourceType")) {
                resourceType = jsonObject.getInt("resourceType");
            }
            if (DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue() != resourceType) continue;
            StorageResource storageResource = (StorageResource)JSONObject.toBean((JSONObject)jsonObject, Lun.class);
            srcResources.add(storageResource);
        }
    }

    public List<StorageResource> getStorageResourceByWwn(String ... wwn) {
        try {
            int len = wwn.length;
            String[] upWWN = new String[len];
            String[] lowWWN = new String[len];
            for (int i = 0; i < len; ++i) {
                lowWWN[i] = wwn[i].toLowerCase(Locale.getDefault());
                upWWN[i] = wwn[i].toUpperCase(Locale.getDefault());
            }
            HashMap<String, String[]> upcondition = new HashMap<String, String[]>();
            upcondition.put("wwn", upWWN);
            List upLunList = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).query(Lun.class, upcondition);
            HashMap<String, String[]> lowcondition = new HashMap<String, String[]>();
            lowcondition.put("wwn", lowWWN);
            List lowLunList = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).query(Lun.class, lowcondition);
            ArrayList resourceList = new ArrayList();
            resourceList.addAll(upLunList);
            resourceList.addAll(lowLunList);
            HashSet storageResourceSet = new HashSet();
            storageResourceSet.addAll(resourceList);
            ArrayList<StorageResource> result = new ArrayList(storageResourceSet);
            result = result.stream().sorted((res1, res2) -> res1.getDevSn().compareTo(res2.getDevSn())).collect(Collectors.toList());
            return result;
        }
        catch (Exception ex) {
            logger.error((Object)("getStorageResourceByWwn failed." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758786878L);
            return null;
        }
    }

    public List<ReplicationRelation> queryReplicationRelationByStorageSn(String sn, String orderBy, boolean isAsc, List<QueryCondition> queryCondition) {
        List<Object> data = new ArrayList<ReplicationRelation>();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)sn)) {
            return data;
        }
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)orderBy)) {
            orderBy = "name";
        }
        queryCondition = Optional.ofNullable(queryCondition).orElse(new ArrayList());
        QueryCondition srcCond = new QueryCondition("srcDevSN", (Object)sn);
        queryCondition.add(srcCond);
        Iterator iterator = queryCondition.iterator();
        while (iterator.hasNext()) {
            QueryCondition condition = (QueryCondition)iterator.next();
            if (!condition.getPropName().equals("isAirGap") || !((Boolean)condition.getPropValue()).booleanValue()) continue;
            iterator.remove();
            queryCondition.remove(srcCond);
            queryCondition.add(new QueryCondition("devSn", (Object)sn));
            break;
        }
        try {
            data = this.getMoDao().findMoBy(ReplicationRelation.class, orderBy, isAsc, queryCondition);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("getAllreplication Exception by sn:" + sn), (Throwable)e, 90160758787071L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("getAllreplication Error by storage sn:" + sn), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return data;
    }

    public List<VstoreInfo> queryVstoreInfoByStorageSn(String sn, String orderBy, boolean isAsc, List<QueryCondition> queryCondition) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)sn)) {
            return Collections.EMPTY_LIST;
        }
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)orderBy)) {
            orderBy = "name";
        }
        QueryCondition condition = new QueryCondition("devSn", (Object)sn);
        if (null == queryCondition) {
            queryCondition = new ArrayList<QueryCondition>();
            queryCondition.add(condition);
        } else {
            queryCondition.add(condition);
        }
        try {
            return this.getMoDao().findMoBy(VstoreInfo.class, orderBy, isAsc, queryCondition);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("getAll VstoreInfo Exception by sn:" + sn), (Throwable)e, 90160758787071L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("getAll VstoreInfo Error by storage sn:" + sn), (long)-1L, (String[])new String[0], (Log)logger);
            return Collections.EMPTY_LIST;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StorageResource> batchQueryStorageResourcesByDeviceSn(String deviceSn, List<String> resourceIdOrNames, boolean isUseName) {
        ArrayList<StorageResource> resources = new ArrayList<StorageResource>();
        Session session = null;
        try {
            session = this.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            String queryHQL = "";
            queryHQL = !isUseName ? "from StorageResource where devSn=:deviceSn and resourceId in (:resourceIdOrNames)" : "from StorageResource where devSn=:deviceSn and name in (:resourceIdOrNames)";
            List<List<String>> params = DBOperationUtil.createBatchQueryParameters(resourceIdOrNames, 15);
            for (List<String> param : params) {
                Query query = session.createQuery(queryHQL);
                query.setString("deviceSn", deviceSn);
                query.setParameterList("resourceIdOrNames", param);
                List result = query.list();
                if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)result)) continue;
                for (Object object : result) {
                    resources.add((StorageResource)object);
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Batch quering res failed. Sn:" + deviceSn + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return resources;
    }

    public List<StorageNE> getStorageList(String ... snList) {
        try {
            HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
            paramMap.put("sn", snList);
            return CommonDAOLocator.getMoDao().findMoBy(StorageNE.class, paramMap);
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"getAllStorageNE Exception.", 90160758787071L);
        }
        catch (Exception ex) {
            logger.error((Object)"getAllStorageNE Error.", 90160758787071L);
        }
        return new ArrayList<StorageNE>();
    }

    public List<Lun> queryLunByDevSnAndLunIds(String deviceSn, List<String> lunIds) {
        List luns;
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)StringUtil.trim((String)deviceSn)) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(lunIds)) {
            throw new LegoCheckedException(1073947393L);
        }
        try {
            StorageLunManagerProxy proxy = StorageLunManagerProxy.getInstance();
            IStorageLunManager manager = proxy.getStorageLunMgrByDevId(deviceSn);
            luns = manager.queryLuns(deviceSn, lunIds);
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("devSn", deviceSn);
            props.put("lunId", lunIds.toArray());
            List oldLuns = this.getMoDao().findMoBy(Lun.class, props);
            List<Long> deleted = this.extractDeletedLunMoId(oldLuns, com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)luns) ? Collections.emptyList() : luns);
            logger.info((Object)("Deleted lun list=" + Arrays.toString(deleted.toArray())), 90160758784000L);
            this.getMoDao().deleteMoList(deleted);
            ArrayList<Lun> moList = new ArrayList<Lun>();
            StorageUnit storageUnit = (StorageUnit)this.getMoDao().getMo(StorageUnit.class, "devSn", (Object)deviceSn);
            for (Lun lun : luns) {
                lun.setParentMo((ManagedObject)storageUnit);
                lun.setTopMoUuid(storageUnit.getTopMoUuid());
                moList.add(lun);
            }
            this.getMoDao().saveOrUpdateMoList(moList);
        }
        catch (LegoUnsupportedOperationException ex) {
            logger.info((Object)ex, 90160758784000L);
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("devSn", deviceSn);
            props.put("lunId", lunIds.toArray());
            luns = this.getMoDao().findMoBy(Lun.class, props);
        }
        return luns;
    }

    private List<Long> extractDeletedLunMoId(List<Lun> oldLuns, List<Lun> newLuns) {
        ArrayList<String> newLunIds = new ArrayList<String>();
        ArrayList<Long> delLunMoIds = new ArrayList<Long>();
        for (Lun lun : newLuns) {
            newLunIds.add(lun.getLunId());
        }
        for (Lun lun : oldLuns) {
            String lunId = lun.getLunId();
            if (newLunIds.contains(lunId)) continue;
            delLunMoIds.add(lun.getMoId());
        }
        return delLunMoIds;
    }

    public List<ReplicationPair> queryReplicationPairsByMasterLunWWN(List<String> lunWWNs) {
        return this.queryReplicationPairsByMasterLunWWN(lunWWNs, false);
    }

    public List<ReplicationPair> queryReplicationPairsByMasterLunWWN(List<String> lunWWNs, boolean bQueryTgtLun) {
        logger.debug((Object)("lunWwns=" + lunWWNs));
        List<Lun> srcLuns = this.queryLunsByWWN(lunWWNs);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(srcLuns)) {
            return new ArrayList<ReplicationPair>();
        }
        HashMap<String, String> lunIdAndWWNMap = new HashMap<String, String>();
        HashMap<String, ArrayList<String>> groupingLunIds = new HashMap<String, ArrayList<String>>();
        for (Lun lun : srcLuns) {
            lunIdAndWWNMap.put(lun.getDevSn() + ":" + lun.getLunId(), lun.getWwn());
            ArrayList<String> lunIds = (ArrayList<String>)groupingLunIds.get(lun.getDevSn());
            if (null == lunIds) {
                lunIds = new ArrayList<String>();
                groupingLunIds.put(lun.getDevSn(), lunIds);
            }
            lunIds.add(lun.getLunId());
        }
        ArrayList<ReplicationPair> allPairs = new ArrayList<ReplicationPair>();
        Set entrySet = groupingLunIds.entrySet();
        for (Map.Entry entry : entrySet) {
            allPairs.addAll(this.getReplicationPairsByMasterLunFromDb((String)entry.getKey(), (List)entry.getValue(), bQueryTgtLun, DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue()));
        }
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(allPairs)) {
            for (ReplicationPair pair : allPairs) {
                pair.setSrcLunWWN((String)lunIdAndWWNMap.get(pair.getSrcDevSN() + ":" + pair.getSrcLunId()));
            }
        }
        return allPairs;
    }

    public List<ReplicationPair> queryReplicationPairsByMasterLunId(String devSn, List<String> lunIds, boolean isFromDevice, Integer resourceType) {
        return this.queryReplicationPairsByLunIds(devSn, lunIds, isFromDevice, true, resourceType);
    }

    public List<ReplicationPair> queryReplicationPairsByLunIds(String devSn, Collection<String> lunIds, boolean isFromDevice, boolean isPrimary, Integer resourceType) {
        logger.debug((Object)("sn=" + devSn + ", lunIds=" + lunIds + ", isRealTime=" + isFromDevice));
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(lunIds)) {
            throw new LegoCheckedException(1073947393L);
        }
        List<ReplicationPair> replications = null;
        long startA = System.currentTimeMillis();
        long startB = 0L;
        if (isFromDevice) {
            ArrayList<UpdateReplicationRelationTask> taskList = new ArrayList<UpdateReplicationRelationTask>();
            for (String lunId : lunIds) {
                taskList.add(new UpdateReplicationRelationTask(devSn, lunId, isPrimary, resourceType));
            }
            List taskResults = ExecutionService.batchSubmit(taskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_CONTINUE, (int)180, (int)30);
            startB = System.currentTimeMillis();
            logger.debug((Object)("update ReplicationPairsByMasterLun cost time:" + (startA - startB)));
            if (null == taskResults || taskResults.size() != taskList.size()) {
                logger.error((Object)"Update ReplicationRelation failed. taskResults size: %s", new Object[]{taskResults == null ? "null" : String.valueOf(taskResults.size())});
                throw new LegoCheckedException(0x300001L);
            }
            for (Boolean result : taskResults) {
                if (null != result && result.booleanValue()) continue;
                logger.error((Object)"Update ReplicationRelation task exist failed.");
                throw new LegoCheckedException(0x300001L);
            }
        }
        replications = this.getReplicationPairsByLunIdsFromDb(devSn, lunIds, true, isPrimary, resourceType);
        logger.debug((Object)("get ReplicationPairsByMasterLunFromDb cost time:" + (System.currentTimeMillis() - startB)));
        return replications;
    }

    private void updateReplicationRelationsByLunIds(String devSn, String lunId, boolean isPrimary, Integer resourceType) {
        StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
        List<ReplicationPair> replications = proxy.queryReplications(devSn, lunId, resourceType);
        ArrayList<String> pairIdListRealTime = new ArrayList<String>();
        HashSet<String> groupIds = new HashSet<String>();
        for (ReplicationPair replicationPair : replications) {
            pairIdListRealTime.add(replicationPair.getReplicationId());
        }
        logger.debug(pairIdListRealTime);
        List<ReplicationPair> pairsInDb = this.getReplicationPairsByLunIdsFromDb(devSn, Arrays.asList(lunId), true, isPrimary, resourceType);
        for (ReplicationPair pairInDb : pairsInDb) {
            if (pairIdListRealTime.contains(pairInDb.getReplicationId())) continue;
            this.getMoDao().remove((Object)pairInDb);
        }
        StorageUnit storageUnit = (StorageUnit)this.getMoDao().getMo(StorageUnit.class, "devSn", (Object)devSn);
        for (ReplicationPair pair : replications) {
            pair.setParentMo((ManagedObject)storageUnit);
            pair.setTopMoUuid(storageUnit.getTopMoUuid());
            this.getMoDao().addMoAndSubMoWithoutMsg((ManagedObject)pair, new HashMap());
            if (null == pair.getConsistentGroupId() || pair.getConsistentGroupId().startsWith("--")) continue;
            groupIds.add(pair.getConsistentGroupId());
        }
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(groupIds)) {
            logger.debug((Object)"ConsistentGroup is empty");
            return;
        }
        proxy.refresh(devSn, new ArrayList<String>(groupIds), true);
    }

    private List<ReplicationPair> getReplicationPairsByMasterLunFromDb(String deviceSn, List<String> lunIds, boolean isQueryTgtLun, Integer resourceType) {
        return this.getReplicationPairsByLunIdsFromDb(deviceSn, lunIds, isQueryTgtLun, true, resourceType);
    }

    private List<ReplicationPair> getReplicationPairsByLunIdsFromDb(String deviceSn, Collection<String> lunIds, boolean isQueryTgtLun, boolean isPrimary, Integer resourceType) {
        Integer localResType = 11;
        if (resourceType != null && resourceType.intValue() == DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue()) {
            localResType = 40;
        }
        logger.debug((Object)"deviceSn:%s, lunIds:%s, isQueryTgtLun:%s, isPrimary:%s, resourceType:%s", new Object[]{deviceSn, lunIds.toArray(), isQueryTgtLun, isPrimary, resourceType});
        if (isPrimary) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("srcDevSN", deviceSn);
            props.put("isPrimary", true);
            props.put("relationType", 0);
            props.put("srcLunId", lunIds.toArray());
            props.put("localResType", localResType);
            List pairs = this.getMoDao().findMoBy(ReplicationPair.class, props);
            if (isQueryTgtLun) {
                for (ReplicationPair pair : pairs) {
                    List tgtLuns = this.getMoDao().findSubMoBy(pair.getMoId().longValue(), ReplicationTargetLun.class, new HashMap());
                    pair.setRepTgtLuns(tgtLuns);
                }
            }
            return pairs;
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("tgtDevSN", deviceSn);
        props.put("tgtLunId", lunIds.toArray());
        List tgtLuns = this.getMoDao().findMoBy(ReplicationTargetLun.class, props);
        HashMap<Long, ArrayList<ReplicationTargetLun>> pairMoIdAndtgtLuns = new HashMap<Long, ArrayList<ReplicationTargetLun>>();
        for (ReplicationTargetLun tgtLun : tgtLuns) {
            Long parentId = tgtLun.getParentId();
            ArrayList<ReplicationTargetLun> tempTgtLuns = (ArrayList<ReplicationTargetLun>)pairMoIdAndtgtLuns.get(parentId);
            if (null == tempTgtLuns) {
                tempTgtLuns = new ArrayList<ReplicationTargetLun>();
                pairMoIdAndtgtLuns.put(parentId, tempTgtLuns);
            }
            tempTgtLuns.add(tgtLun);
        }
        props.clear();
        props.put("moId", pairMoIdAndtgtLuns.keySet().toArray(new Long[0]));
        props.put("isPrimary", false);
        List pairs = this.getMoDao().findMoBy(ReplicationPair.class, props);
        for (ReplicationPair replicationPair : pairs) {
            Long moId = replicationPair.getMoId();
            if (!pairMoIdAndtgtLuns.containsKey(moId)) continue;
            replicationPair.setRepTgtLuns((List)pairMoIdAndtgtLuns.get(moId));
        }
        return pairs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Lun> queryLunsByWWN(List<String> wwns) {
        ArrayList<Lun> luns = new ArrayList<Lun>();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(wwns)) {
            return luns;
        }
        Session session = null;
        try {
            session = this.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            String queryHQL = "from Lun where wwn in (:wwns)";
            List<List<String>> params = DBOperationUtil.createBatchQueryParameters(wwns, 30);
            for (List<String> param : params) {
                Query query = session.createQuery(queryHQL);
                query.setParameterList("wwns", param);
                List result = query.list();
                if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)result)) continue;
                for (Object object : result) {
                    luns.add((Lun)object);
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Quering luns failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return luns;
    }

    public Map<String, Object> getStorageAddressInfo(String devSn) {
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(devSn);
        if (null == drResource) {
            logger.error((Object)"Parameter is null.", 90160758784000L);
            throw new LegoCheckedException(2117645L);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        StorageNE ne = (StorageNE)this.getMoDao().getMo(StorageNE.class, "sn", (Object)devSn);
        NeMgrProtocolExtend extend = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getMgrProtocol(ne.getMoId());
        map.put("linkIp", extend.getNetworkIpAddress());
        String protocol = (String)extend.getExtendParams().get("protocol");
        if (protocol.equalsIgnoreCase("REST") || protocol.equalsIgnoreCase("FSB-REST")) {
            map.put("linkPort", extend.getExtendParams().get("port"));
        }
        return map;
    }

    public List<RemoteDevice> queryRemoteDevices(String devSn) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)("devSn is empty, devSn=" + devSn));
            throw new LegoCheckedException(1073947393L);
        }
        IStorageHyperVaultManager mgr = StorageHyperVaultManagerProxy.getInstance().getMgrByDevId(devSn);
        if (null == mgr) {
            logger.error((Object)("mgr is not exsit, sn=" + devSn));
            throw new LegoCheckedException(102L);
        }
        List devices = mgr.queryRemoteDevices(devSn);
        return devices;
    }

    public RemoteDevice queryRemoteDevice(String devSn, String remoteDeviceSn) {
        logger.debug((Object)("devSn=" + devSn + ", remoteDeviceSn=" + remoteDeviceSn));
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn, remoteDeviceSn});
        List<RemoteDevice> remoteDevices = this.queryRemoteDevices(devSn);
        for (RemoteDevice remoteDevice : remoteDevices) {
            if (!remoteDeviceSn.equals(remoteDevice.getSn())) continue;
            return remoteDevice;
        }
        return null;
    }

    public List<ReplicationPair> getReplicationPairsByResourceIds(String devSn, List<String> resIdList, Integer resourceType) {
        return this.getReplicationPairsByResourceIds(devSn, resIdList, true, resourceType);
    }

    public List<ReplicationPair> getReplicationPairsByResourceIds(String devSn, Collection<String> resIdList, boolean isPrimary, Integer resourceType) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn)) {
            return new ArrayList<ReplicationPair>();
        }
        return this.getReplicationPairsLocal(devSn, resIdList, isPrimary, resourceType);
    }

    private List<ReplicationPair> getReplicationPairsLocal(String devSn, Collection<String> resIdList, boolean isPrimary, Integer resourceType) {
        List<ReplicationPair> replications;
        StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
        try {
            replications = proxy.queryReplications(devSn, resIdList, resourceType);
        }
        catch (LegoUnsupportedOperationException e) {
            return this.queryReplicationPairsByLunIds(devSn, resIdList, true, true, resourceType);
        }
        ArrayList<ReplicationPair> result = new ArrayList<ReplicationPair>();
        HashSet<String> idList = new HashSet<String>();
        for (String id : resIdList) {
            idList.add(id);
        }
        logger.info((Object)("getPairsByResourceIdsWithOutUpdateDB: " + idList.size()));
        for (ReplicationPair pair : replications) {
            if (idList.contains(pair.getSrcLunId()) && pair.getIsPrimary().booleanValue() && isPrimary) {
                result.add(pair);
                continue;
            }
            for (ReplicationTargetLun tgtLun : pair.getRepTgtLuns()) {
                if (!idList.contains(tgtLun.getTgtLunId()) || pair.getIsPrimary().booleanValue() || isPrimary || !devSn.equals(tgtLun.getTgtDevSN())) continue;
                result.add(pair);
            }
        }
        logger.info((Object)("getPairsByResourceIdsWithOutUpdateDB after filter: " + result.size()));
        return result;
    }

    public List<Lun> getLunByWwn(String devSn, Set<String> resourceWwnSet) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn)) {
            return Collections.emptyList();
        }
        List storageResourceList = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(resourceWwnSet.toArray(new String[resourceWwnSet.size()]));
        ArrayList<Lun> luns = new ArrayList<Lun>();
        for (StorageResource storageResource : storageResourceList) {
            luns.add((Lun)storageResource);
        }
        return luns;
    }

    public Collection<ReplicationPair> getRelicationPairByLun(String devSn, List<String> lunIds, boolean isPrimary) {
        List<Lun> lunList = this.queryLunByDevSnAndLunIds(devSn, lunIds);
        if (VerifyUtil.isEmpty(lunList)) {
            return Collections.emptyList();
        }
        Set<String> wwnSet = lunList.stream().map(lun -> lun.getWwn()).collect(Collectors.toSet());
        List<Lun> luns = this.getLunByWwn(devSn, wwnSet);
        if (VerifyUtil.isEmpty(luns)) {
            return Collections.emptyList();
        }
        HashMap lunIdMap = new HashMap();
        luns.stream().forEach(lun -> CommUtil.addSetToMap((Map)lunIdMap, (Object)lun.getDevSn(), (Object)lun.getLunId()));
        ArrayList<ReplicationPair> allPairList = new ArrayList<ReplicationPair>();
        for (Map.Entry entry : lunIdMap.entrySet()) {
            List<ReplicationPair> pairList = this.getReplicationPairsByResourceIds((String)entry.getKey(), new ArrayList<String>((Collection)entry.getValue()), isPrimary, DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue());
            if (VerifyUtil.isEmpty(pairList)) continue;
            allPairList.addAll(pairList);
        }
        return allPairList;
    }

    public StorageLicense getStorageAllLicense(String storageSn) {
        if (VerifyUtil.isEmpty((String)storageSn)) {
            logger.error((Object)"hostSN is empty, and get Host License failed");
            throw new LegoCheckedException(1073947393L);
        }
        return StorageLicenseManagerProxy.getInstance().getArrayLicense(storageSn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StorageResource> queryStorageResourcesByName(String deviceSn, List<String> nameList) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)deviceSn) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(nameList)) {
            return new ArrayList<StorageResource>();
        }
        ArrayList<StorageResource> resources = new ArrayList<StorageResource>();
        Session session = null;
        try {
            session = this.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            String queryHQL = "from StorageResource where devSn=:deviceSn and name in (:nameList)";
            List<List<String>> params = DBOperationUtil.createBatchQueryParameters(nameList, 15);
            for (List<String> param : params) {
                Query query = session.createQuery(queryHQL);
                query.setString("deviceSn", deviceSn);
                query.setParameterList("nameList", param);
                List result = query.list();
                if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)result)) continue;
                for (Object object : result) {
                    resources.add((StorageResource)object);
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Batch quering res failed. Sn:" + deviceSn + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return resources;
    }

    public JSONObject queryTargetStorages(String deviceSn) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("deviceId", deviceSn);
        List linkList = CommonDAOLocator.getMoDao().findMoBy(ReplicationLink.class, props);
        HashSet<String> snList = new HashSet<String>();
        for (ReplicationLink replicationLink : linkList) {
            snList.add(replicationLink.getRemoteArrayId());
        }
        HashMap<String, String[]> storageProps = new HashMap<String, String[]>();
        storageProps.put("deviceSn", snList.toArray(new String[snList.size()]));
        List criterionList = CommonDAOLocator.getBaseDao().translatePropsToCriterions(storageProps);
        List drStorageList = CommonDAOLocator.getBaseDao().createCriteria(DrStorage.class, criterionList.toArray(new Criterion[criterionList.size()]));
        HashMap<String, List<DrStorage>> siteStorage = new HashMap<String, List<DrStorage>>();
        for (DrStorage drStorage : drStorageList) {
            ArrayList<DrStorage> list = (ArrayList<DrStorage>)siteStorage.get(drStorage.getSiteId());
            if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)list)) {
                list = new ArrayList<DrStorage>();
                siteStorage.put(drStorage.getSiteId(), list);
            }
            list.add(drStorage);
        }
        List<StoragePool> allStoragePools = this.getStoragePools(siteStorage);
        HashSet<String> dupSet = new HashSet<String>();
        ArrayList<StoragePool> storagePools = new ArrayList<StoragePool>();
        for (StoragePool storagePool : allStoragePools) {
            if (dupSet.contains(CommUtil.combineString((String[])new String[]{storagePool.getNeSN(), storagePool.getPoolId()}))) continue;
            storagePools.add(storagePool);
            dupSet.add(CommUtil.combineString((String[])new String[]{storagePool.getNeSN(), storagePool.getPoolId()}));
        }
        HashMap<String, List<StoragePool>> deviceStoragePool = new HashMap<String, List<StoragePool>>();
        for (StoragePool storagePool : storagePools) {
            ArrayList<StoragePool> list = (ArrayList<StoragePool>)deviceStoragePool.get(storagePool.getNeSN());
            if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)list)) {
                list = new ArrayList<StoragePool>();
                deviceStoragePool.put(storagePool.getNeSN(), list);
            }
            list.add(storagePool);
        }
        JSONArray jSONArray = this.getSiteJsonArray(siteStorage, deviceStoragePool);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"sites", (Object)jSONArray);
        return jSONObject;
    }

    private List<StoragePool> getStoragePools(Map<String, List<DrStorage>> siteStorage) {
        ArrayList<StoragePool> allStoragePools = new ArrayList<StoragePool>();
        for (Map.Entry<String, List<DrStorage>> entry : siteStorage.entrySet()) {
            List storagePoolRecords;
            String siteId = entry.getKey();
            Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(siteId);
            if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)site) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)(storagePoolRecords = CommonDAOLocator.getMoDao().find("from StoragePool", new Object[0])))) continue;
            allStoragePools.addAll(storagePoolRecords);
        }
        return allStoragePools;
    }

    private JSONArray getSiteJsonArray(Map<String, List<DrStorage>> siteStorage, Map<String, List<StoragePool>> deviceStoragePool) {
        JSONArray siteArray = new JSONArray();
        for (Map.Entry<String, List<DrStorage>> entry : siteStorage.entrySet()) {
            String siteId = entry.getKey();
            Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(siteId);
            if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)site)) {
                logger.error((Object)("can not find site:" + siteId));
                continue;
            }
            JSONObject siteObj = DrmStorageUtil.getJsonObject(deviceStoragePool, entry, site);
            siteArray.add((Object)siteObj);
        }
        return siteArray;
    }

    public List<StoragePool> queryStoragePoolsBySn(String deviceSn) {
        HashMap<String, String[]> storageProps = new HashMap<String, String[]>();
        storageProps.put("deviceSn", new String[]{deviceSn});
        List criterionList = CommonDAOLocator.getBaseDao().translatePropsToCriterions(storageProps);
        List drStorageList = CommonDAOLocator.getBaseDao().createCriteria(DrStorage.class, criterionList.toArray(new Criterion[criterionList.size()]));
        HashMap<String, List<DrStorage>> siteStorage = new HashMap<String, List<DrStorage>>();
        for (DrStorage drStorage : drStorageList) {
            ArrayList<DrStorage> list = (ArrayList<DrStorage>)siteStorage.get(drStorage.getSiteId());
            if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)list)) {
                list = new ArrayList<DrStorage>();
                siteStorage.put(drStorage.getSiteId(), list);
            }
            list.add(drStorage);
        }
        List<Object> allStoragePools = this.getStoragePools(siteStorage);
        if (null != allStoragePools) {
            allStoragePools = allStoragePools.stream().filter(pool -> deviceSn.equals(pool.getNeSN())).collect(Collectors.toList());
        }
        return allStoragePools;
    }

    public Lun createLun(String devSn, Lun lun) {
        StorageLunManagerProxy proxy = StorageLunManagerProxy.getInstance();
        IStorageLunManager manager = proxy.getStorageLunMgrByDevId(devSn);
        lun.setDevSn(devSn);
        return manager.createLun(lun);
    }

    public void deleteLun(String devSn, List<String> volIds, List<String> volNames) {
        List lunList;
        List nameList;
        StorageLunManagerProxy proxy = StorageLunManagerProxy.getInstance();
        IStorageLunManager manager = proxy.getStorageLunMgrByDevId(devSn);
        if (null != volNames && !volNames.isEmpty()) {
            manager.deleteLun(devSn, volNames.toArray(new String[volNames.size()]));
        }
        if (null != volIds && !volIds.isEmpty() && !com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)(nameList = ExecutionService.map((Collection)(lunList = manager.queryLuns(devSn, volIds)), lun -> lun.getName())))) {
            manager.deleteLun(devSn, nameList.toArray(new String[nameList.size()]));
        }
    }

    public List<StoragePool> queryStoragePools() {
        return CommonDAOLocator.getMoDao().find("from StoragePool", new Object[0]);
    }

    public Lun queryLunByName(String devSn, String lunName) {
        StorageLunManagerProxy proxy = StorageLunManagerProxy.getInstance();
        IStorageLunManager manager = proxy.getStorageLunMgrByDevId(devSn);
        return manager.getLunByName(devSn, lunName);
    }

    public boolean expandLun(String devSn, Lun lun) {
        StorageLunManagerProxy proxy = StorageLunManagerProxy.getInstance();
        IStorageLunManager manager = proxy.getStorageLunMgrByDevId(devSn);
        return manager.expandLun(lun);
    }

    public String refreshSpecifyResource(Long moId, String userName, int resourceType, String resourceID) {
        IDiscoverService cbbDiscoverService = (IDiscoverService)ServiceLocator.getInstance().getService(IDiscoverService.class);
        NetworkEntity entity = (NetworkEntity)this.getMoDao().getMo(NetworkEntity.class, "moId", (Object)moId);
        if (entity instanceof StorageNE) {
            return cbbDiscoverService.refreshSpecityResourceStorage((StorageNE)entity, userName, resourceType, resourceID);
        }
        logger.error((Object)("the entity is :" + entity.getClass().getName()), 90160758787071L);
        throw new LegoCheckedException(1073947393L);
    }

    public List<StorageLinkPort> getStorageLinkPorts(String devSn) {
        try {
            IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(devSn);
            return mgr.getStorageLinkPorts(devSn);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Find storage link ports failed. msg: %s", new Object[]{e.getMessage()});
            return Collections.emptyList();
        }
    }

    public VstoreInfo getVstoreInfoByVstoreUuid(String vstoreUuid) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)vstoreUuid)) {
            return null;
        }
        return (VstoreInfo)this.getMoDao().getMo(VstoreInfo.class, "uuid", (Object)vstoreUuid);
    }

    private final class UpdateReplicationRelationTask
    implements Callable<Boolean> {
        private String devSn;
        private String lunId;
        private boolean isPrimary;
        private Integer resourceType;

        public UpdateReplicationRelationTask(String devSn, String lunId, boolean isPrimary, Integer resourceType) {
            this.devSn = devSn;
            this.lunId = lunId;
            this.isPrimary = isPrimary;
            this.resourceType = resourceType;
        }

        @Override
        public Boolean call() {
            try {
                DrmStorageServiceImpl.this.updateReplicationRelationsByLunIds(this.devSn, this.lunId, this.isPrimary, this.resourceType);
                return true;
            }
            catch (LegoUnsupportedOperationException ex) {
                logger.error((Object)ex, 90160758784000L);
            }
            catch (Exception e) {
                logger.error((Object)("update Replication Pairs error!devSn:" + this.devSn + ", lunId:" + this.lunId + "." + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
            return false;
        }
    }
}

