/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.service.router;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.service.IsmDrmBaseService;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.IManagementServerService;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.ism.unistor.sdk.model.VstoreInfo;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class StorageResourceServiceRouter
extends IsmDrmBaseService {
    private static final Log logger = LogFactory.getInstance(StorageResourceServiceRouter.class);
    private static StorageResourceServiceRouter instance = new StorageResourceServiceRouter();

    private StorageResourceServiceRouter() {
    }

    public static StorageResourceServiceRouter getInstance() {
        return instance;
    }

    public <T extends StorageResource> List<T> getStorageResourcesByIds(String devSn, List<String> resourceIds, Class<T> clazz) {
        logger.debug((Object)("sn=" + devSn + ", resourceIds=" + resourceIds + ", clazz=" + clazz));
        Site site = this.getSiteByDevSn(devSn);
        if (0 == site.getSiteType()) {
            IStorageResourceService srService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
            return srService.getStorageResources(devSn, resourceIds, clazz);
        }
        throw new LegoCheckedException(1073947393L);
    }

    private Site getSiteByDevSn(String devSn) {
        ServiceLocator locator = ServiceLocator.getInstance();
        DrResource drResource = ((IResourceService)locator.getService(IResourceService.class)).getDrResourceBySn(devSn, "ism.deviceType.storage.mainType");
        if (null == drResource) {
            logger.error((Object)("DrResource not exist, sn=" + devSn));
            throw new LegoCheckedException(1073947394L);
        }
        Site site = ((ISiteService)locator.getService(ISiteService.class)).getSiteById(drResource.getSiteId());
        if (null == site) {
            logger.error((Object)("Site not exist, siteId=" + drResource.getSiteId()));
            throw new LegoCheckedException(1073947394L);
        }
        return site;
    }

    public List<HyperMetroPair> getHyperMetroPairsByCg(String devSn, String cgId, boolean isRealTime) {
        logger.debug((Object)"Enter getHyperMetroPairsByCg, sn=%s, cgId=%s, isRealTime=%s", new Object[]{devSn, cgId, isRealTime});
        VerifyUtil.checkStrs((String[])new String[]{devSn, cgId});
        IStorageResourceService srService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        List list = srService.getHyperMetroPairByConsistentGroup(devSn, cgId, isRealTime);
        logger.debug((Object)"Exit getHyperMetroPairsByCg");
        return list;
    }

    public List<HyperMetroPair> getHyperMetroPairsByFileSystemIds(String serverUuid, String devSn, List<String> fileSystemIds, Boolean isPrimary, boolean isRealTime) {
        logger.debug((Object)"Enter getHyperMetroPairsByFileSystemIds, serverUuid=%s, fileSystemIds=%s, isPrimary=%s, isRealTime=%s", new Object[]{serverUuid, fileSystemIds, isPrimary, isRealTime});
        if (VerifyUtil.isEmpty(fileSystemIds)) {
            logger.error((Object)"FileSystemIds list is empty.");
            return null;
        }
        IStorageResourceService srService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        List list = srService.getHyperMetroPairByFileSystems(devSn, fileSystemIds, isPrimary, Boolean.valueOf(isRealTime));
        logger.debug((Object)"Exit getHyperMetroPairsByWwns");
        return list;
    }

    public List<HyperMetroPair> getHyperMetroPairsByWwns(String serverUuid, List<String> wwns, Boolean isPrimary, boolean isRealTime) {
        return this.getHyperMetroPairsByWwns(serverUuid, wwns, isPrimary, "", isRealTime);
    }

    public List<HyperMetroPair> getHyperMetroPairsByWwns(String serverUuid, List<String> wwns, Boolean isPrimary, String devSn, boolean isRealTime) {
        logger.debug((Object)"Enter getHyperMetroPairsByWwns, serverUuid=%s, wwns=%s, isPrimary=%s, isRealTime=%s", new Object[]{serverUuid, wwns, isPrimary, isRealTime});
        if (VerifyUtil.isEmpty(wwns)) {
            logger.error((Object)"Wwn list is empty.");
            return null;
        }
        IStorageResourceService srService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        List list = srService.getHyperMetroPairByWwn(wwns, isPrimary, devSn, isRealTime);
        logger.debug((Object)"Exit getHyperMetroPairsByWwns");
        return list;
    }

    public HyperMetroConsistentGroup getHyperMetroConsistentGroup(String devSn, String cgId, boolean isRealTime) {
        logger.debug((Object)"Enter getHyperMetroConsistentGroup, sn=%s, cgId=%s, isRealTime=%s", new Object[]{devSn, cgId, isRealTime});
        VerifyUtil.checkStrs((String[])new String[]{devSn, cgId});
        IStorageResourceService srSvc = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        HyperMetroConsistentGroup group = srSvc.getHyperMetroConsistentGroup(devSn, cgId, isRealTime);
        logger.debug((Object)"Exit getHyperMetroConsistentGroup");
        return group;
    }

    public <T extends StorageResource> List<T> getStorageResourcesByWwns(String serverUuid, List<String> wwns, Class<T> clazz) {
        logger.debug((Object)"Enter getStorageResourcesByWwns, serverUuid=%s, wwns=%s, clazz=%s", new Object[]{serverUuid, wwns, clazz});
        if (null == clazz) {
            logger.error((Object)"Clazz is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty(wwns)) {
            logger.info((Object)"Wwns is empty.");
            return new ArrayList();
        }
        List list = CommonDAOLocator.getMoDao().getMoList(clazz, "wwn", (Object)wwns.toArray());
        logger.debug((Object)"Exit getStorageResourcesByWwns");
        return list;
    }

    public VstoreHyperMetroPair getVstoreHyperMetroPairByVstoreId(String devSN, String vstoreId) {
        logger.debug((Object)("Enter getVstoreHyperMetroPairByVstoreId, sn=" + devSN + ", vstoreId=" + vstoreId));
        VerifyUtil.checkStrs((String[])new String[]{devSN, vstoreId});
        return this.getVstoreHyperMetroPairById(devSN, vstoreId, true);
    }

    public VstoreHyperMetroPair getVstoreHyperMetroPairByVstorePairId(String devSN, String vstorePairId) {
        logger.debug((Object)("Enter getVstoreHyperMetroPairByVstorePairId, sn=" + devSN + ", vstorePairId=" + vstorePairId));
        VerifyUtil.checkStrs((String[])new String[]{devSN, vstorePairId});
        return this.getVstoreHyperMetroPairById(devSN, vstorePairId, false);
    }

    private VstoreHyperMetroPair getVstoreHyperMetroPairById(String devSN, String id, Boolean isAssociate) {
        logger.debug((Object)"Enter getVstoreHyperMetroPairByVstoreId, sn=%s, id=%s", new Object[]{devSN, id});
        VerifyUtil.checkStrs((String[])new String[]{devSN, id});
        IStorageResourceService srSvc = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        return srSvc.getVstoreHyperMetroPairById(devSN, id, isAssociate);
    }

    public List<HyperMetroPair> getHyperMetroPairsByVstore(String devSn, String vstoreId) {
        logger.debug((Object)"Enter getHyperMetroPairsByVstore, sn=%s, vstoreId=%s", new Object[]{devSn, vstoreId});
        VerifyUtil.checkStrs((String[])new String[]{devSn, vstoreId});
        IStorageResourceService srService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        return srService.getHyperMetroPairByVstore(devSn, vstoreId);
    }

    public List<NasFileSystem> getFileSystemByVstore(String devSn, String vstoreId) {
        logger.debug((Object)"Enter getFileSystemByVstore, sn=%s, vstoreId=%s", new Object[]{devSn, vstoreId});
        VerifyUtil.checkStrs((String[])new String[]{devSn, vstoreId});
        IStorageResourceService srService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        return srService.getFileSystemsByVstore(devSn, vstoreId);
    }

    public List<VstoreHyperMetroPair> getVstoreHyperPair(String serverUuid, VstoreHyperMetroPair vstoreHyperMetroPair) {
        logger.debug((Object)("Enter getVstoreHyperPair, serverUuid=" + serverUuid));
        VerifyUtil.checkObject((Object)vstoreHyperMetroPair);
        IStorageResourceService srService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        return srService.getVstoreHyperPair(serverUuid, vstoreHyperMetroPair.getVstorePairId(), vstoreHyperMetroPair.getLocalVstoreId(), vstoreHyperMetroPair.getRemoteVstoreId());
    }

    public void switchVstoreHyperMetroPair(String devSN, String vstorePairId) {
        logger.debug((Object)("Enter getVstoreHyperMetroPairByVstoreId, sn=" + devSN + ", vstorePairId=" + vstorePairId));
        VerifyUtil.checkStrs((String[])new String[]{devSN, vstorePairId});
        Site site = this.getSiteBySn(devSN);
        ManagementServer server = ((IManagementServerService)ServiceLocator.getInstance().getService(IManagementServerService.class)).getServer(site.getServerUuid());
        if (null == server || 0 == server.getServerType()) {
            IStorageResourceService srSvc = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
            srSvc.swapVstoreHyperMetroPair(devSN, vstorePairId);
        } else {
            RestClient client = SiteUtil.initClient(site);
            String url = "/ws/storages/{devSn}/vstore_hypermetro_pair/swap/{vstorePairId}";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("devSn", devSN);
            params.put("vstorePairId", vstorePairId);
            client.post(url, null, params);
        }
    }

    private Site getSiteBySn(String devSn) {
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(devSn, "ism.deviceType.storage.mainType");
        if (null == drResource) {
            logger.error((Object)("DrResource is null, sn=" + devSn));
            throw new LegoCheckedException(1073947393L);
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(drResource.getSiteId());
        if (null == site) {
            logger.error((Object)("Site is null, siteId=" + drResource.getSiteId()));
            throw new LegoCheckedException(1073947393L);
        }
        return site;
    }

    public List<StorageResource> getNasHyperMetroStoreageList(String devSn, String vstorePairId, List<HyperMetroPair> pairList) {
        if (VerifyUtil.isEmpty(pairList)) {
            logger.error((Object)"pairList can not be null!");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<StorageResource> result = new ArrayList<StorageResource>();
        HashSet<String> localResourceIds = new HashSet<String>();
        HashSet<String> remoteResourceIds = new HashSet<String>();
        for (HyperMetroPair pair : pairList) {
            remoteResourceIds.add(pair.getRemoteObjId());
            localResourceIds.add(pair.getLocalObjId());
        }
        List<NasFileSystem> localList = this.getStorageResourcesByIds(devSn, new ArrayList<String>(localResourceIds), NasFileSystem.class);
        VstoreHyperMetroPair vstoreHyperMetroPair = this.getVstoreHyperMetroPairByVstorePairId(devSn, vstorePairId);
        Site site = this.getSiteByDevSn(devSn);
        List<VstoreHyperMetroPair> vstoreHyperMetroPairs = this.getVstoreHyperPair(site.getServerUuid(), vstoreHyperMetroPair);
        String remoteDevSN = null;
        for (VstoreHyperMetroPair pair : vstoreHyperMetroPairs) {
            ManagedObject managedObject = pair.getParentMo();
            if (!(managedObject instanceof HvsUnit) || devSn.equals(((HvsUnit)managedObject).getDevSn())) continue;
            remoteDevSN = ((HvsUnit)managedObject).getDevSn();
            break;
        }
        if (null == remoteDevSN) {
            logger.error((Object)"can not find remoteDevsn!");
            throw new LegoCheckedException(1073947393L);
        }
        List<NasFileSystem> remoteList = this.getStorageResourcesByIds(remoteDevSN, new ArrayList<String>(remoteResourceIds), NasFileSystem.class);
        result.addAll(localList);
        result.addAll(remoteList);
        return result;
    }

    public VstoreInfo getVstoreById(String devSn, String vstoreId) {
        logger.debug((Object)"Enter getFileSystemByVstore, sn=%s, vstoreId=%s", new Object[]{devSn, vstoreId});
        VerifyUtil.checkStrs((String[])new String[]{devSn, vstoreId});
        String hql = "from VstoreInfo as vi where vi.vstoreId = ? and vi.devSn = ?";
        List viList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[]{vstoreId, devSn});
        if (!VerifyUtil.isEmpty((Collection)viList) && viList.size() == 1) {
            return (VstoreInfo)viList.iterator().next();
        }
        return null;
    }
}

