/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.cfgdata;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.system.cfgdata.DrvSshPara;
import com.huawei.ism.drm.system.cfgdata.DrvUserInfo;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class SftpUtil {
    private static final Log logger = LogFactory.getInstance(SftpUtil.class);
    private Session session;
    private ChannelSftp sftp = null;
    private BufferedInputStream bufferedIn = null;
    private BufferedOutputStream bufferedOut = null;
    private String homeDirectory = null;

    private void initSession(DrvSshPara para) throws JSchException {
        JSch jsch = new JSch();
        this.session = jsch.getSession(para.getUserName(), para.getIp(), para.getSshPort().intValue());
        this.session.setPassword(para.getSshPassword());
        this.session.setUserInfo((UserInfo)new DrvUserInfo(para.getSshPassword()));
        Properties prop = new Properties();
        prop.setProperty("StrictHostKeyChecking", "no");
        this.session.setConfig(prop);
        this.session.setTimeout(900000);
        String proxyHost = System.getProperty("socksProxyHost");
        String proxyPort = System.getProperty("socksProxyPort");
        if (!this.isInvalidStr(proxyHost) && !this.isInvalidStr(proxyPort)) {
            logger.info((Object)("proxy host is: " + proxyHost + ", proxy port is: " + proxyPort), 90160758786816L);
            this.session.setProxy((Proxy)new ProxySOCKS5(proxyHost, NumberUtil.convertToInteger((Object)proxyPort).intValue()));
        }
        this.session.connect();
    }

    private boolean connect(DrvSshPara para) {
        try {
            this.initSession(para);
            this.sftp = (ChannelSftp)this.session.openChannel("sftp");
            this.sftp.connect();
            logger.info((Object)("connect success. host : " + this.session.getHost()), 90160758786816L);
        }
        catch (Exception e) {
            logger.error((Object)("connect " + this.session.getHost() + " failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return false;
        }
        return true;
    }

    public void logout() {
        try {
            if (null != this.bufferedIn) {
                this.bufferedIn.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"close io failed.", 90160758787071L);
        }
        finally {
            if (null != this.sftp) {
                this.sftp.disconnect();
            }
            if (null != this.session) {
                this.session.disconnect();
            }
            logger.info((Object)"logout success.", 90160758786816L);
        }
        try {
            if (null != this.bufferedOut) {
                this.bufferedOut.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"close io failed.", 90160758787071L);
        }
    }

    public boolean login(DrvSshPara para) {
        boolean isFinished = false;
        if (this.isInvalidSshPara(para)) {
            logger.error((Object)"invalid login parameter.", 90160758787071L);
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (!this.connect(para)) continue;
            isFinished = true;
            try {
                this.homeDirectory = this.sftp.pwd();
            }
            catch (SftpException e) {
                this.homeDirectory = "";
                logger.error((Object)"failed to get home directory of ftp server .", 90160758787071L);
            }
            break;
        }
        if (!isFinished) {
            logger.error((Object)("login ftp server failed. IP\uff1a" + para.getIp() + " , user :" + para.getUserName()), 90160758787071L);
        } else {
            logger.info((Object)("login ftp server success. IP\uff1a" + para.getIp() + " , user :" + para.getUserName()), 90160758786816L);
        }
        return isFinished;
    }

    public boolean createDirectory(String path) {
        try {
            String[] dir;
            this.sftp.cd(this.homeDirectory);
            if (path.startsWith(this.homeDirectory)) {
                path = path.substring(this.homeDirectory.length());
            }
            for (String dirName : dir = path.split("/")) {
                if (dirName == null || dirName.isEmpty()) continue;
                boolean bDirCreated = false;
                Vector lsVec = this.sftp.ls(".");
                for (ChannelSftp.LsEntry entry : lsVec) {
                    if (!entry.getAttrs().isDir() || entry.getFilename().equals(".") || entry.getFilename().equals("..") || !entry.getFilename().equals(dirName)) continue;
                    logger.info((Object)"Directory exists : %s, %x", new Object[]{SftpUtil.getName(entry.getFilename()), 90160758786816L});
                    this.sftp.cd(entry.getFilename());
                    bDirCreated = true;
                    break;
                }
                if (bDirCreated) continue;
                this.sftp.mkdir(dirName);
                logger.info((Object)"Create directory : %s, %x", new Object[]{SftpUtil.getName(dirName), 90160758786816L});
                this.sftp.cd(dirName);
            }
            logger.info((Object)("create directory success : " + SftpUtil.getName(path)), 90160758786816L);
        }
        catch (Exception e) {
            logger.error((Object)("create directory failed : " + SftpUtil.getName(path) + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upLoadFile(File localFile, String directory, String remoteFileName) {
        try {
            this.sftp.cd(this.homeDirectory);
            if (!directory.startsWith(this.homeDirectory)) {
                directory = this.homeDirectory + directory;
            }
            File remoteFile = new File(directory + "/" + remoteFileName);
            this.bufferedIn = new BufferedInputStream(new FileInputStream(localFile));
            this.sftp.cd(directory);
            this.sftp.put((InputStream)this.bufferedIn, remoteFile.getName());
            logger.info((Object)("upload file success. file name : " + remoteFileName), 90160758786816L);
        }
        catch (SftpException e) {
            logger.error((Object)("upload file failed. file name : " + remoteFileName), (Throwable)e, 90160758787071L);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            logger.error((Object)("upload file failed. file name : " + remoteFileName), 90160758787071L);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != this.bufferedIn) {
                    this.bufferedIn.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"error close stream!", 90160758787071L);
            }
            this.bufferedIn = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upLoadFile(File localFile, String remotePath) {
        File remoteFile = new File(remotePath);
        try {
            this.bufferedIn = new BufferedInputStream(new FileInputStream(localFile));
            remotePath = remoteFile.getParent();
            if (remotePath.contains(File.separator)) {
                remotePath = remotePath.substring(remotePath.indexOf(File.separator));
                this.sftp.cd(remotePath);
            }
            this.sftp.put((InputStream)this.bufferedIn, remoteFile.getName());
            logger.info((Object)("upload file success. file name: " + remoteFile.getName()), 90160758786816L);
        }
        catch (SftpException e) {
            logger.error((Object)("upload file failed. file name : " + remoteFile.getName()), (Throwable)e, 90160758787071L);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            logger.error((Object)("upload file failed. file name : " + remoteFile.getName()), 90160758787071L);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != this.bufferedIn) {
                    this.bufferedIn.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"error close stream!", 90160758787071L);
            }
            this.bufferedIn = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upLoadFile(String localPath, String remotePath) {
        File localFile = new File(localPath);
        File remoteFile = new File(remotePath);
        try {
            this.bufferedIn = new BufferedInputStream(new FileInputStream(localFile));
            remotePath = remoteFile.getParent();
            if (remotePath.contains(File.separator)) {
                remotePath = remotePath.substring(remotePath.indexOf(File.separator));
                this.sftp.cd(remotePath);
            }
            this.sftp.put((InputStream)this.bufferedIn, remoteFile.getName());
            logger.info((Object)("upload file success. file name: " + remoteFile.getName()), 90160758786816L);
        }
        catch (SftpException e) {
            logger.error((Object)("upload file failed. file name : " + remoteFile.getName()), (Throwable)e, 90160758787071L);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            logger.error((Object)("upload file failed. file name : " + remoteFile.getName()), 90160758787071L);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != this.bufferedIn) {
                    this.bufferedIn.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"stream close error!", 90160758787071L);
            }
            this.bufferedIn = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downLoadFile(String localPath, String remotePath) {
        File localFile = new File(localPath);
        File remoteFile = new File(remotePath);
        try {
            this.bufferedOut = new BufferedOutputStream(new FileOutputStream(localFile));
            remotePath = remoteFile.getParent();
            if (remotePath.contains(File.separator)) {
                remotePath = remotePath.substring(remotePath.indexOf(File.separator));
                this.sftp.cd(remotePath);
            }
            this.sftp.get(remoteFile.getName(), (OutputStream)this.bufferedOut);
            logger.info((Object)("download file success. file name: " + remoteFile.getName()), 90160758786816L);
            this.bufferedOut.flush();
        }
        catch (SftpException e) {
            logger.error((Object)("download file failed. file name : " + remoteFile.getName()), (Throwable)e, 90160758787071L);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            logger.error((Object)("download file failed. file name : " + remoteFile.getName()), 90160758787071L);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != this.bufferedOut) {
                    this.bufferedOut.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"error close stream!", 90160758787071L);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downLoadFile(String localPath, String remotePath, DrvSshPara para) {
        if (this.isInvalidSshPara(para)) {
            logger.error((Object)"invalid ftp parameter.", 90160758787071L);
            return false;
        }
        File localFile = new File(localPath);
        File remoteFile = new File(remotePath);
        try {
            boolean respCode = this.login(para);
            if (!respCode) {
                logger.error((Object)("connect ftp server: " + para.getIp() + " failed."), 90160758787071L);
                boolean bl = false;
                return bl;
            }
            this.bufferedOut = new BufferedOutputStream(new FileOutputStream(localFile));
            remotePath = remoteFile.getParent();
            if (remotePath.contains(File.separator)) {
                remotePath = remotePath.substring(remotePath.indexOf(File.separator));
                this.sftp.cd(remotePath);
            }
            this.sftp.get(remoteFile.getName(), (OutputStream)this.bufferedOut);
            logger.info((Object)("download file success. file name: " + remoteFile.getName()), 90160758786816L);
            this.bufferedOut.flush();
        }
        catch (IOException e) {
            logger.error((Object)("download file failed. file name : " + remoteFile.getName()), 90160758787071L);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)("download file failed. file name : " + remoteFile.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            boolean bl = false;
            return bl;
        }
        finally {
            this.logout();
        }
        return true;
    }

    public boolean deleteChildDirectoryAndFile(String path) {
        try {
            if (path.startsWith(this.homeDirectory)) {
                this.sftp.cd(path);
            } else {
                path = this.homeDirectory + path;
                this.sftp.cd(this.homeDirectory);
                this.sftp.cd(path);
            }
            Vector lsVec = this.sftp.ls(".");
            for (ChannelSftp.LsEntry entry : lsVec) {
                if (entry.getFilename().equals(".") || entry.getFilename().equals("..")) continue;
                if (entry.getAttrs().isDir()) {
                    this.deleteChildDirectoryAndFile(path + "/" + entry.getFilename());
                    this.sftp.cd(path);
                    this.sftp.rmdir(entry.getFilename());
                    continue;
                }
                this.sftp.rm(entry.getFilename());
            }
            logger.info((Object)("delete child directory success. file name: " + SftpUtil.getName(path)), 90160758786816L);
        }
        catch (Exception e) {
            logger.error((Object)("delete child directory failed. path : " + SftpUtil.getName(path) + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return false;
        }
        return true;
    }

    public boolean deleteDirectory(String parentDir, String dir) {
        try {
            String curDir = !parentDir.startsWith(this.homeDirectory) ? this.homeDirectory + parentDir : parentDir;
            String deleteDir = curDir + "/" + dir;
            if (!this.deleteChildDirectoryAndFile(deleteDir)) {
                logger.error((Object)"Failed to delete dir. path: %s, %x", new Object[]{SftpUtil.getName(dir), 90160758787071L});
                return false;
            }
            this.sftp.cd(curDir);
            this.sftp.rmdir(dir);
            logger.info((Object)"delete dir success", 90160758786816L);
        }
        catch (Exception e) {
            logger.error((Object)("failed to delete dir. path : " + dir + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return false;
        }
        return true;
    }

    public boolean deleteFile(String dir, String remotePath, DrvSshPara para) {
        if (this.isInvalidSshPara(para)) {
            logger.error((Object)"invalid ftp parameter.", 90160758787071L);
            return false;
        }
        try {
            boolean respCode = this.login(para);
            if (!respCode) {
                logger.error((Object)("connect ftp server: " + para.getIp() + " failed."), 90160758787071L);
                return false;
            }
            this.sftp.cd(dir);
            this.sftp.rm(remotePath);
            logger.info((Object)("delete file success. file name: " + SftpUtil.getName(remotePath)), 90160758786816L);
        }
        catch (Exception e) {
            logger.error((Object)("delete file failed. file name : " + SftpUtil.getName(remotePath) + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return false;
        }
        return true;
    }

    private boolean isInvalidStr(String value) {
        return null == value || value.isEmpty();
    }

    private boolean isInvalidSshPara(DrvSshPara para) {
        if (null == para) {
            return true;
        }
        if (this.isInvalidStr(para.getIp())) {
            logger.error((Object)"invalid ssh ip address.", 90160758787071L);
            return true;
        }
        if (this.isInvalidStr(para.getSshPassword())) {
            logger.error((Object)"invalid ssh password.", 90160758787071L);
            return true;
        }
        if (this.isInvalidStr(para.getUserName())) {
            logger.error((Object)"invalid ssh username.", 90160758787071L);
            return true;
        }
        if (para.getSshPort() > 65535 || para.getSshPort() < 1) {
            logger.error((Object)("invalid ssh port:" + para.getSshPort()), 90160758787071L);
            return true;
        }
        return false;
    }

    public List<ChannelSftp.LsEntry> getChildDirectory(String path) {
        ArrayList<ChannelSftp.LsEntry> retVec = new ArrayList<ChannelSftp.LsEntry>();
        try {
            if (path.startsWith(this.homeDirectory)) {
                this.sftp.cd(path);
            } else {
                path = this.homeDirectory + path;
                this.sftp.cd(this.homeDirectory);
                this.sftp.cd(path);
            }
            Vector lsVec = this.sftp.ls(".");
            for (ChannelSftp.LsEntry entry : lsVec) {
                if (!entry.getAttrs().isDir() || entry.getFilename().equals(".") || entry.getFilename().equals("..")) continue;
                retVec.add(entry);
            }
            logger.info((Object)("get child directory success. path : " + SftpUtil.getName(path)), 90160758787071L);
            return retVec;
        }
        catch (Exception e) {
            logger.error((Object)("get child directory failed. path : " + SftpUtil.getName(path) + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return retVec;
        }
    }

    private static String getName(String path) {
        if (VerifyUtil.isEmpty((String)path)) {
            return "";
        }
        return new File(path).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFtpHostKey(String ip, Integer port) {
        String hostKey = "";
        JSch jsch = new JSch();
        Session tmpSession = null;
        try {
            tmpSession = jsch.getSession("", ip, port.intValue());
            tmpSession.connect(30000);
        }
        catch (JSchException e) {
            logger.error((Object)("getHostKey failed from ip=" + ip), (Throwable)e);
            String exceptionMsg = e.getMessage();
            if (null != tmpSession && exceptionMsg.contains("UnknownHostKey")) {
                HostKey hk = tmpSession.getHostKey();
                hostKey = hk.getFingerPrint(jsch);
            }
        }
        catch (Exception e) {
            logger.error((Object)("getHostKey failed, the sftp server ip = " + ip), (Throwable)e);
        }
        finally {
            if (null != tmpSession) {
                tmpSession.disconnect();
            }
        }
        return hostKey;
    }
}

