/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.cfgdata.database;

import com.huawei.ism.drm.system.cfgdata.database.GuassDBdumpImpl;
import com.huawei.ism.drm.wcc.rest.security.SecureRandomFactory;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class AESUtil {
    private static AESUtil instance = new AESUtil();
    private static final int LEN = 1024;
    private static final int KEYLEN = 128;
    private static final int IVLEN = 16;
    private static final int IREATOR = 50000;
    private static final Log logger = LogFactory.getInstance(AESUtil.class);

    private AESUtil() {
    }

    public static AESUtil getInstance() {
        return instance;
    }

    public Cipher initAESCipher(String sKey, int cipherMode) {
        Cipher cipher = null;
        try {
            SecureRandom saltRandom = SecureRandomFactory.getInstanceStrongWithDRBG();
            SecureRandom ivRandom = SecureRandomFactory.getInstanceStrongWithDRBG();
            byte[] salt = new byte[128];
            saltRandom.nextBytes(salt);
            byte[] iv = new byte[16];
            ivRandom.nextBytes(iv);
            new GuassDBdumpImpl().writeSaltAndIV(salt, iv);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec keyspec = new PBEKeySpec(sKey.toCharArray(), salt, 50000, 128);
            SecretKeySpec key = new SecretKeySpec(factory.generateSecret(keyspec).getEncoded(), "AES");
            GCMParameterSpec ivSpec = new GCMParameterSpec(128, iv);
            cipher = Cipher.getInstance("AES/GCM/PKCS5Padding");
            cipher.init(cipherMode, (Key)key, ivSpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException e) {
            logger.error((Object)"InitAESCipher error.");
        }
        return cipher;
    }

    public File encryptFile(File sourceFile, String fileType, String sKey) throws IOException {
        File encrypfile = null;
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        CipherInputStream cipherInputStream = null;
        try {
            int nRead;
            File dstParent = sourceFile.getParentFile();
            inputStream = new FileInputStream(sourceFile);
            encrypfile = File.createTempFile("apmbackup", fileType, dstParent);
            outputStream = new FileOutputStream(encrypfile);
            Cipher cipher = this.initAESCipher(sKey, 1);
            cipherInputStream = new CipherInputStream(inputStream, cipher);
            byte[] cache = new byte[1024];
            while ((nRead = cipherInputStream.read(cache)) != -1) {
                ((OutputStream)outputStream).write(cache, 0, nRead);
                outputStream.flush();
            }
            this.doCloseStream(inputStream, outputStream, cipherInputStream);
        }
        catch (IOException e) {
            try {
                logger.error((Object)"EncryptFile error.", 90160758787071L);
                throw new LegoCheckedException("EncryptFile error.");
            }
            catch (Throwable throwable) {
                this.doCloseStream(inputStream, outputStream, cipherInputStream);
                throw throwable;
            }
        }
        return encrypfile;
    }

    private void doCloseStream(InputStream inputStream, OutputStream outputStream, CipherInputStream cipherInputStream) {
        try {
            if (null != cipherInputStream) {
                cipherInputStream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"encryptFile cipherInputStream close error.", 90160758787071L);
        }
        try {
            if (null != outputStream) {
                outputStream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"encryptFile close error.", 90160758787071L);
        }
        try {
            if (null != inputStream) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"encryptFile close error.", 90160758787071L);
        }
    }
}

