/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.cfgdata.database;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import java.io.IOException;
import java.io.InputStream;

public final class CmdUtil {
    private static final Log logger = LogFactory.getInstance(CmdUtil.class);
    private static final long THRITY_MINUTES = 1800000L;
    private static final int FAIL_FLAG = -1;
    private static CmdUtil instance = new CmdUtil();

    private CmdUtil() {
    }

    public CmdUtil getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int wait(Process process) {
        InputStream io = process.getInputStream();
        InputStream ro = process.getErrorStream();
        while (process.isAlive()) {
            CmdUtil.clean(io);
            CmdUtil.clean(ro);
        }
        try {
            int n = process.waitFor();
            return n;
        }
        catch (InterruptedException e) {
            logger.error((Object)"wait process failed.", (Throwable)e, 0x300001L);
        }
        finally {
            CmdUtil.close(io);
            CmdUtil.close(ro);
        }
        return 1;
    }

    private static void clean(InputStream io) {
        try {
            int len = io.available();
            if (len > 0) {
                byte[] rs = new byte[len];
                int r = io.read(rs);
                logger.debug((Object)("is clean success:" + r));
            }
        }
        catch (IOException e) {
            logger.error((Object)"clean process failed.", (Throwable)e, 0x300001L);
        }
    }

    private static void close(InputStream io) {
        if (io != null) {
            try {
                io.close();
            }
            catch (IOException e) {
                logger.error((Object)"Close Backup winodws Mysql br Error", (Throwable)e, 90160758787071L);
            }
        }
    }

    public static void runShell(String shPath, String[] params) {
        StringBuffer sb = new StringBuffer();
        sb.append(shPath.replace("\\/", "/").replace(" ", "\" \""));
        if (null != params && params.length > 0) {
            for (String param : params) {
                sb.append(" " + param);
            }
        }
        CmdUtil.runShell(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int waitProcessExecuteWithTimeout(Process process) {
        int result = -1;
        ProcessWorker worker = new ProcessWorker(process);
        try {
            worker.start();
            worker.join(1800000L);
            result = worker.getRetValue();
            if (Integer.MIN_VALUE == result) {
                result = -1;
            }
        }
        catch (Exception ex) {
            worker.interrupt();
            Thread.currentThread().interrupt();
        }
        finally {
            if (null != process) {
                process.destroy();
            }
        }
        return result;
    }

    private static void runShell(String shStr) {
        Process process = null;
        if (SecurityUtil.fileValueBlackListCheck((String)shStr)) {
            logger.error((Object)"Illegal shStr.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            process = Runtime.getRuntime().exec(shStr);
            int result = CmdUtil.waitProcessExecuteWithTimeout(process);
            if (0 != result) {
                logger.error((Object)("The executing result is not normal. Result:" + result), 90160758787071L);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"runShell error.", (long)0x300001L, (String[])new String[0], (Log)logger);
        }
        finally {
            try {
                if (null != process) {
                    process.destroy();
                }
            }
            catch (Exception e2) {
                logger.error((Object)("close process error." + ExceptionUtil.getErrorMessage((Throwable)e2)), 90160758787071L);
            }
        }
    }

    private static class ProcessWorker
    extends Thread {
        private final Process process;
        private int retValue = Integer.MIN_VALUE;

        public ProcessWorker(Process process) {
            this.process = process;
        }

        public int getRetValue() {
            return this.retValue;
        }

        @Override
        public void run() {
            try {
                this.retValue = CmdUtil.wait(this.process);
            }
            catch (Exception e) {
                logger.error((Object)("Executing waitFor failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
        }
    }
}

