/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.cfgdata.processor;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.system.cfgdata.AlarmGenerator;
import com.huawei.ism.drm.system.cfgdata.ConfigDataCommon;
import com.huawei.ism.drm.system.cfgdata.DrvSshPara;
import com.huawei.ism.drm.system.cfgdata.SftpUtil;
import com.huawei.ism.drm.system.cfgdata.database.GuassDBdumpImpl;
import com.huawei.ism.drm.system.cfgdata.sdk.model.FtpServerInfo;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.base.LegoMoGenerator;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import com.huawei.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class ConfigDataAutoBackupTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(ConfigDataAutoBackupTask.class);
    private FtpServerInfo ftpServerInfo = null;
    private SftpUtil sftp = null;

    public ConfigDataAutoBackupTask(FtpServerInfo ftpInfo, BackTask backTask) {
        super(ftpInfo.getFtpServerId(), backTask, true);
        this.ftpServerInfo = ftpInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() {
        File file = null;
        boolean result = false;
        try {
            String encryptPwd;
            this.sftp = new SftpUtil();
            String hostKey = SftpUtil.getFtpHostKey(this.ftpServerInfo.getIp(), this.ftpServerInfo.getPort());
            String oldHostKey = WccEncryptor.decrypt((String)this.ftpServerInfo.getHostKey());
            if (VerifyUtil.isEmpty((String)oldHostKey) || !oldHostKey.equals(hostKey)) {
                logger.error((Object)"SFTP server hostKey is changed.");
                this.sendUploadConfigdataFailAlarm();
                throw new LegoCheckedException(-1L);
            }
            DrvSshPara para = new DrvSshPara(this.ftpServerInfo);
            if (!this.sftp.login(para)) {
                logger.error((Object)"Failed to login ftp server: %s", new Object[]{String.valueOf(para.getIp())});
                this.sendUploadConfigdataFailAlarm();
                throw new LegoCheckedException(-1L);
            }
            if (!this.processStoredConfigDataMaxDayLimit(this.ftpServerInfo.getMaxStoredDay())) {
                logger.error((Object)"Failed to process old config data file: %s", new Object[]{para.getIp()});
            }
            if ((file = this.excuteGaussDbBackup(encryptPwd = WccEncryptor.decrypt((String)this.ftpServerInfo.getDataPassword()))) == null) {
                this.sendUploadConfigdataFailAlarm();
                throw new LegoCheckedException(-1L);
            }
            if (!this.processBackupFile(file)) {
                this.sendUploadConfigdataFailAlarm();
                throw new LegoCheckedException(-1L);
            }
            this.restoreUploadConfigdataFailAlarm();
            result = true;
            this.sftp.logout();
            this.closeConfigDataFile(file);
            this.writeAutoBackupOptLog(result);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"auto backup task of config data failed.", (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            this.sftp.logout();
            this.closeConfigDataFile(file);
            this.writeAutoBackupOptLog(result);
        }
    }

    private void writeAutoBackupOptLog(boolean result) {
        Date currentDate = new Date();
        SysOptLog oOptLog = new SysOptLog();
        oOptLog.setDate(currentDate);
        oOptLog.setTarget("ism.drm.dump.configdata");
        oOptLog.setLevel(SysoplogLevel.normal.getValue());
        oOptLog.setModule("lego.dic.module.storage");
        oOptLog.setOperation("dataMaintainence_execAutoBackup_operateName");
        oOptLog.setResult(result ? 1 : 0);
        oOptLog.setOperator("system");
        oOptLog.setTerminalIp("127.0.0.1");
        oOptLog.setDetail(result ? "" : "lego.operation.status.failure");
        Object lookupService = ServiceContext.getInstance().lookup("system/sysLogService");
        if (!(lookupService instanceof ISysOptLog)) {
            throw new LegoCheckedException("Service [sysLogService] is wrong");
        }
        ISysOptLog sysOptLog = (ISysOptLog)lookupService;
        sysOptLog.writeOptLog(oOptLog);
    }

    protected void resetBackTaskAfterSuccess() {
        String uploadDir = this.generateUploadDirectoryName() + "ConfigData.zip";
        this.getBackTask().setTaskLink(uploadDir);
    }

    private void closeConfigDataFile(File file) {
        if (file != null) {
            try {
                if (!file.delete()) {
                    logger.error((Object)("failed to delete file : " + file.getName()), 90160758787071L);
                }
            }
            catch (Exception e) {
                logger.error((Object)("failed to delete file : " + file.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
        }
    }

    private File excuteGaussDbBackup(String encryptPwd) {
        try {
            return new GuassDBdumpImpl().backup(encryptPwd, false);
        }
        catch (Exception e) {
            logger.error((Object)"failed to excute backup command of mysql. ", 90160758787071L);
            return null;
        }
    }

    private boolean processBackupFile(File file) {
        String uploadDir = this.generateUploadDirectoryName();
        if (!this.sftp.createDirectory(uploadDir)) {
            logger.error((Object)"failed to create directory", 90160758787071L);
            return false;
        }
        if (!this.sftp.upLoadFile(file, uploadDir, "ConfigData.zip")) {
            logger.error((Object)("failed to upload file to ftp server :" + file.getName()), 90160758787071L);
            return false;
        }
        return true;
    }

    private void sendUploadConfigdataFailAlarm() {
        TopoObject manageSystemMo = ConfigDataCommon.getManagementSystemMO();
        if (VerifyUtil.isEmpty((Object)manageSystemMo)) {
            logger.error((Object)"failed to get mangement system mo.", 90160758787071L);
            return;
        }
        AlarmGenerator.generateUploadConfigDataFailAlarm(manageSystemMo, this.getSystemIP(), manageSystemMo.getUuid());
    }

    private void restoreUploadConfigdataFailAlarm() {
        TopoObject manageSystemMo = ConfigDataCommon.getManagementSystemMO();
        if (VerifyUtil.isEmpty((Object)manageSystemMo)) {
            logger.error((Object)"failed to get mangement system mo.", 90160758787071L);
            return;
        }
        AlarmGenerator.restoreUploadConfigDataFailAlarm(manageSystemMo, this.getSystemIP());
    }

    private String getCurrentDate() {
        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return sDateFormat.format(new Date());
    }

    private String getSystemIPAndSN() {
        return this.getSystemIP();
    }

    private String generateUploadDirectoryName() {
        String uploadDir = this.ftpServerInfo.getBaseDir() + this.getSystemIPAndSN() + "/" + this.getCurrentDate() + "/Auto/";
        return uploadDir;
    }

    private String getSystemIP() {
        return new LegoMoGenerator().getInstallServerIp();
    }

    public boolean processStoredConfigDataMaxDayLimit(int maxDay) {
        Date currentDate = new Date();
        String dir = this.ftpServerInfo.getBaseDir() + this.getSystemIP();
        try {
            List<ChannelSftp.LsEntry> dirVec = this.sftp.getChildDirectory(dir);
            for (ChannelSftp.LsEntry entry : dirVec) {
                Date dirDate;
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    dirDate = sdf.parse(entry.getFilename());
                }
                catch (ParseException e) {
                    continue;
                }
                if (ConfigDataCommon.daysBetween(currentDate, dirDate) < maxDay) continue;
                this.sftp.deleteDirectory(dir, entry.getFilename());
            }
        }
        catch (Exception e) {
            logger.error((Object)"processStoredConfigDataMaxDayLimit exception.", 90160758787071L);
            return false;
        }
        return true;
    }
}

