/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.info.service.impl;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.ResourceUtil;
import com.huawei.ism.drm.system.cfgdata.database.CmdUtil;
import com.huawei.ism.drm.system.info.sdk.model.SoftwareInfo;
import com.huawei.ism.drm.system.info.sdk.service.ISoftwareInfoService;
import com.huawei.ism.drm.system.info.service.impl.StreamGobbler;
import com.huawei.lego.cbb.license.util.SignVerifier;
import com.huawei.lego.core.base.LegoMoGenerator;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

@Service(Name="com.huawei.ism.drm.system.info.sdk.service.ISoftwareInfoService", Desc="", Interface=ISoftwareInfoService.class)
public class SoftwareInfoServiceImpl
extends BaseService
implements ISoftwareInfoService {
    private static final String SCRIPT_WIN = "/ism_host_agent/DataCollect/DataCollect.bat";
    private static final String PACK_WIN = "/ism_host_agent/DataCollect/DataCollect.zip";
    private static final String SCRIPT_LIN_PATH = "/usr/sbin/DataCollect";
    private static final String PACK_LIN = "/tmp/DataCollect.zip";
    private static final long FILE_EXPORT_FAILED = 192084002L;
    private static final long DETECT_OS_FAILED = 192084002L;
    private static final Log logger = LogFactory.getInstance(SoftwareInfoServiceImpl.class);
    private static final String ICUSER = "ICUser";
    private Set<String> macAddresses = new HashSet<String>();

    public SoftwareInfo getSoftwareInfo() {
        SoftwareInfo resInfo;
        block5: {
            resInfo = new SoftwareInfo();
            try {
                Enumeration<NetworkInterface> el = NetworkInterface.getNetworkInterfaces();
                if (null == el) break block5;
                while (el.hasMoreElements()) {
                    NetworkInterface ni = el.nextElement();
                    byte[] mac = ni.getHardwareAddress();
                    if (VerifyUtil.isEmpty((Object)mac)) continue;
                    StringBuffer sb = new StringBuffer();
                    StringBuffer msg = new StringBuffer();
                    for (int i = 0; i < mac.length; ++i) {
                        String formattedMacAddr = String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : "");
                        sb.append(formattedMacAddr);
                        if (this.macAddresses.contains(formattedMacAddr)) continue;
                        this.macAddresses.add(formattedMacAddr);
                        msg.append(formattedMacAddr);
                    }
                    if (0 < msg.length()) {
                        logger.info((Object)("Mac Address:" + msg.toString()), 90160758786816L);
                    }
                    resInfo.setSn(sb.toString());
                    resInfo.setIpAddress(new LegoMoGenerator().getInstallServerIp());
                    if (VerifyUtil.isEmpty((String)resInfo.getIpAddress()) || VerifyUtil.isEmpty((String)resInfo.getSn()) || "127.0.0.1".equals(resInfo.getIpAddress())) continue;
                    break;
                }
            }
            catch (SocketException e) {
                logger.error((Object)"getSoftwareArchiveInfo Failed.", 90160758786816L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
        }
        String version = ResourceUtil.getValue("sysversion");
        resInfo.setVersion(version);
        resInfo.setProductModel(this.queryProductModel());
        return resInfo;
    }

    private String queryProductModel() {
        String sql = "select count(*) from pg_class where relname = 'T_VR'";
        String productModel = "OceanStor BCManager";
        try {
            List list = CommonDAOLocator.getBaseDao().executeNativeSql(sql, new Object[0]);
            if (list != null && !list.isEmpty()) {
                if (list.get(0) instanceof BigInteger) {
                    if (((BigInteger)list.get(0)).intValue() > 0) {
                        productModel = "UltraVR";
                    }
                } else {
                    logger.error((Object)"getSoftwareInfo list.get(0) not BigInteger.", 90160758786816L);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"getSoftwareInfo productModel Failed.", 90160758786816L);
        }
        return productModel;
    }

    public String exportLogs() {
        String filePath = "";
        String[] cmd = null;
        String dir = this.getInstallDir();
        if (SystemUtils.IS_OS_WINDOWS) {
            String scriptPath = dir + SCRIPT_WIN;
            try {
                SignVerifier.getInstance().verify(scriptPath);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)"check sign failed.", (long)127454L, (String[])new String[0], (Log)logger);
            }
            cmd = new String[]{"cmd.exe", "/c", "\"" + scriptPath + "\""};
            filePath = dir + PACK_WIN;
        } else if (SystemUtils.IS_OS_LINUX) {
            cmd = new String[]{"/bin/bash", SCRIPT_LIN_PATH, ICUSER};
            filePath = dir + PACK_LIN;
        } else {
            this.throwException(192084002L, "zipLogs(): os NOT support, " + SystemUtils.OS_NAME + " " + SystemUtils.OS_VERSION);
        }
        try {
            int exitVal = this.exec(cmd);
            logger.info((Object)"Detect os: %s %s, exitVal: %s", new Object[]{SystemUtils.OS_NAME, SystemUtils.OS_VERSION, exitVal});
            if (exitVal != 0) {
                logger.error((Object)"Export file failed. %s", new Object[]{String.valueOf(exitVal)});
                throw new LegoCheckedException(192084002L);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"zipLogs() exec Throwable", (long)192084002L, (String[])new String[0], (Log)logger);
        }
        return filePath;
    }

    private String getInstallDir() {
        String userDir;
        try {
            userDir = new File("").getCanonicalPath();
        }
        catch (IOException e) {
            userDir = null;
            logger.error((Object)("getInstallDir failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        String result = null;
        if (null != userDir) {
            Object[] path = userDir.split(Pattern.quote(File.separator));
            Object[] dir = ArrayUtils.subarray((Object[])path, (int)0, (int)(path.length - 1));
            result = StringUtils.join((Object[])dir, (String)File.separator);
        } else {
            this.throwException(192084002L, "getInstallDir() failed.");
        }
        return result;
    }

    private void throwException(long code, String source) {
        throw new LegoCheckedException(code, source);
    }

    private int exec(String[] cmd) throws IOException, InterruptedException {
        if (SecurityUtil.fileValueBlackListCheck((String[])cmd)) {
            logger.error((Object)"Illegal input cmds.");
            throw new LegoCheckedException(1073947393L);
        }
        Process proc = Runtime.getRuntime().exec(cmd);
        StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "std_ERROR");
        StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "std_OUTPUT");
        ExecutionService.submitTask((Runnable)errorGobbler);
        ExecutionService.submitTask((Runnable)outputGobbler);
        return CmdUtil.waitProcessExecuteWithTimeout(proc);
    }

    public Map<String, Object> queryUserLoginInfo(String userName) {
        String sql = "select createtime from T_user where user_name = ?";
        List createTimes = CommonDAOLocator.getBaseDao().executeNativeSql(sql, this.getParams(null, null, userName, null, null));
        long cTime = System.currentTimeMillis();
        BigInteger currentTime = BigInteger.valueOf(cTime);
        BigInteger creatTime = this.initCreatTime(createTimes);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("userName", userName);
        result.put("isFirstLogin", 0);
        sql = "select * from (select rownum num,* from (select operation_ip_addr, operation_time, operation_result from T_sysoplog where operation_name = 'user_login_operateName' and operation_user = ? and operation_time > ? and operation_time < ? order by operation_time desc)) where num = 2 ";
        List firstUserInfo = CommonDAOLocator.getBaseDao().executeNativeSql(sql, this.getParams(null, null, userName, creatTime, currentTime));
        Map<String, Object> firstMap = this.constructUserLoginResult(firstUserInfo);
        BigInteger lastLoginTime = (BigInteger)firstMap.get("loginTime");
        if (VerifyUtil.isEmpty(firstMap)) {
            result.put("isFirstLogin", 1);
            return result;
        }
        if (1 == (Integer)firstMap.get("loginStatus")) {
            return this.getResultWhenLastSuccAccess(result, firstMap, lastLoginTime);
        }
        sql = "select * from (select rownum num, * from (select operation_ip_addr, operation_time, operation_result from T_sysoplog where operation_name = 'user_login_operateName' and operation_result = 1 and operation_user = ? and operation_time > ? and operation_time < ? order by operation_time desc)) where num = 2";
        List secondUserInfo = CommonDAOLocator.getBaseDao().executeNativeSql(sql, this.getParams(null, null, userName, creatTime, currentTime));
        Map<String, Object> secondMap = this.constructUserLoginResult(secondUserInfo);
        if (VerifyUtil.isEmpty(secondMap)) {
            result.putAll(this.getAllFailAccessBeforeLastSuccAccess(userName, currentTime, creatTime, lastLoginTime));
            return result;
        }
        BigInteger firstStartTime = (BigInteger)secondMap.get("loginTime");
        sql = "select count(*) from T_sysoplog where operation_name = 'user_login_operateName' and operation_time between ? and ? and operation_user = ? and operation_time > ? and operation_time < ?";
        List singleFailList = CommonDAOLocator.getBaseDao().executeNativeSql(sql, this.getParams(firstStartTime, lastLoginTime, userName, creatTime, currentTime));
        if (String.valueOf(2).equals(String.valueOf(singleFailList.get(0)))) {
            result.put("startTime", lastLoginTime);
            result.put("endTime", lastLoginTime);
            result.put("failedTimes", 1);
            result.put("ip", "");
            return result;
        }
        result.putAll(this.getSuccAccessBeforeLastAccess(userName, currentTime, creatTime, lastLoginTime, firstStartTime));
        return result;
    }

    private Map<String, Object> getResultWhenLastSuccAccess(Map<String, Object> result, Map<String, Object> firstMap, BigInteger lastLoginTime) {
        result.put("startTime", lastLoginTime);
        result.put("endTime", "");
        result.put("failedTimes", 0);
        result.put("ip", firstMap.get("clientIp"));
        return result;
    }

    private Map<String, Object> getSuccAccessBeforeLastAccess(String userName, BigInteger currentTime, BigInteger creatTime, BigInteger lastLoginTime, BigInteger firstStartTime) {
        String sql = "select * from (select rownum num, * from (select operation_ip_addr, operation_time, operation_result from T_sysoplog where operation_name = 'user_login_operateName'  and operation_time between ? and ? and operation_user = ? and operation_time > ? and operation_time < ?)) where num = 2 ";
        List fourthUserInfo = CommonDAOLocator.getBaseDao().executeNativeSql(sql, this.getParams(firstStartTime, lastLoginTime, userName, creatTime, currentTime));
        Map<String, Object> fourthMap = this.constructUserLoginResult(fourthUserInfo);
        BigInteger secondStartTime = (BigInteger)fourthMap.get("loginTime");
        sql = "select count(*) from T_sysoplog where operation_time between ? and ? and operation_user = ? and operation_time > ? and operation_time < ?";
        List threeTimes = CommonDAOLocator.getBaseDao().executeNativeSql(sql, this.getParams(secondStartTime, lastLoginTime, userName, creatTime, currentTime));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("startTime", secondStartTime);
        result.put("endTime", lastLoginTime);
        result.put("failedTimes", threeTimes.get(0));
        result.put("ip", "");
        return result;
    }

    private Map<String, Object> getAllFailAccessBeforeLastSuccAccess(String userName, BigInteger currentTime, BigInteger creatTime, BigInteger lastLoginTime) {
        String sql = "select * from (select rownum num, * from (select operation_ip_addr, operation_time, operation_result from T_sysoplog where operation_name = 'user_login_operateName' and operation_user = ?  and operation_time > ? and operation_time < ?)) where num = 1";
        List thirdUserInfo = CommonDAOLocator.getBaseDao().executeNativeSql(sql, this.getParams(null, null, userName, creatTime, currentTime));
        Map<String, Object> thirdMap = this.constructUserLoginResult(thirdUserInfo);
        sql = "select count(*) from T_sysoplog where operation_name = 'user_login_operateName' and operation_result = 0 and operation_user = ? and operation_time > ? and operation_time < ?";
        List oneTimes = CommonDAOLocator.getBaseDao().executeNativeSql(sql, this.getParams(null, null, userName, creatTime, currentTime));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("startTime", thirdMap.get("loginTime"));
        result.put("endTime", lastLoginTime);
        result.put("failedTimes", oneTimes.get(0));
        result.put("ip", "");
        return result;
    }

    private BigInteger initCreatTime(List<BigInteger> createTimes) {
        BigInteger creatTime = !createTimes.isEmpty() ? createTimes.get(0) : BigInteger.ZERO;
        if (VerifyUtil.isEmpty((Object)creatTime)) {
            creatTime = BigInteger.ZERO;
        }
        return creatTime;
    }

    private Map<String, Object> constructUserLoginResult(List<?> list) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (VerifyUtil.isEmpty(list)) {
            return result;
        }
        for (Object object : list) {
            Object[] values;
            if (!(object instanceof Object[]) || 4 != (values = (Object[])object).length) continue;
            result.put("clientIp", values[1]);
            result.put("loginTime", values[2]);
            result.put("loginStatus", values[3]);
        }
        return result;
    }

    private Object[] getParams(BigInteger startTime, BigInteger endTime, String userName, BigInteger creatTime, BigInteger currentTime) {
        ArrayList<Object> params = new ArrayList<Object>();
        if (!VerifyUtil.isEmpty((Object)startTime)) {
            params.add(startTime);
        }
        if (!VerifyUtil.isEmpty((Object)endTime)) {
            params.add(endTime);
        }
        if (!VerifyUtil.isEmpty((String)userName)) {
            params.add(userName);
        }
        if (!VerifyUtil.isEmpty((Object)creatTime)) {
            params.add(creatTime);
        }
        if (!VerifyUtil.isEmpty((Object)currentTime)) {
            params.add(currentTime);
        }
        return params.toArray();
    }
}

