/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.syslogj;

import com.cloudbees.syslog.Facility;
import com.cloudbees.syslog.Severity;
import com.cloudbees.syslog.sender.TcpSyslogMessageSender;
import com.huawei.ism.drm.constant.coreenum.SyslogEncryptionModeEnum;
import com.huawei.ism.drm.system.syslogj.SyslogConfig;
import com.huawei.ism.drm.system.thirdservice.sdk.model.LogNotifyServer;
import com.huawei.ism.drm.wcc.rest.security.SecureRandomFactory;
import com.huawei.lego.comm.security.BcmX509TrustManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class SysLogTcpClient {
    private static final Log logger = LogFactory.getInstance(SysLogTcpClient.class);
    private TcpSyslogMessageSender syslogMsgSender = null;
    private static final int SEND_RETRY_TIMES = 3;
    private SyslogConfig syslogConfig;

    public SysLogTcpClient(LogNotifyServer logServer) {
        this.initSyslogClient(logServer);
    }

    private void initSyslogClient(LogNotifyServer logServer) {
        this.syslogConfig = new SyslogConfig(logServer);
        this.syslogMsgSender = new TcpSyslogMessageSender();
        SysLogTcpClient.configMsgSender(this.syslogMsgSender, this.syslogConfig);
    }

    private static void configMsgSender(TcpSyslogMessageSender msgSender, SyslogConfig config) {
        msgSender.setDefaultAppName("eReplication");
        msgSender.setDefaultFacility(Facility.USER);
        msgSender.setSyslogServerHostname(config.getServerIp());
        msgSender.setSyslogServerPort(config.getPort());
        msgSender.setMaxRetryCount(3);
        msgSender.setSocketConnectTimeoutInMillis(5000);
        msgSender.setMessageFormat(config.getMessageFormat());
        String encrytionMode = config.getEncryptionMode();
        if (SyslogEncryptionModeEnum.TCP.getName().equalsIgnoreCase(encrytionMode)) {
            msgSender.setSsl(false);
        } else if (SyslogEncryptionModeEnum.SSL_TCP.getName().equalsIgnoreCase(encrytionMode) || SyslogEncryptionModeEnum.TLS_TCP.getName().equalsIgnoreCase(encrytionMode)) {
            msgSender.setSSLContext(SysLogTcpClient.createSSLContext(config.getServerIp()));
            msgSender.setSsl(true);
        } else {
            logger.error((Object)"EncrytionMode %s is not supported", new Object[]{encrytionMode});
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static SSLContext createSSLContext(String ip) {
        return SysLogTcpClient.createSSLContext(ip, SyslogEncryptionModeEnum.TLS_TCP);
    }

    private static SSLContext createSSLContext(String ip, SyslogEncryptionModeEnum encryptionMode) {
        SSLContext sslContext = null;
        if (SyslogEncryptionModeEnum.TCP.equals((Object)encryptionMode)) {
            return sslContext;
        }
        try {
            sslContext = SSLContext.getInstance(encryptionMode.getProtocol());
            TrustManager[] tms = new TrustManager[]{new BcmX509TrustManager(ip, null)};
            sslContext.init(null, tms, SecureRandomFactory.getInstanceStrongWithDRBG());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            logger.error((Object)"Create ssl context failed!");
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return sslContext;
    }

    public void log(int level, String message) {
        try {
            this.syslogMsgSender.setDefaultSeverity(Severity.fromNumericalCode((int)level));
            this.syslogMsgSender.sendMessage((CharSequence)message);
        }
        catch (IOException e) {
            logger.error((Object)("Upload logs failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    public void stop() {
        if (null != this.syslogMsgSender) {
            try {
                this.syslogMsgSender.close();
            }
            catch (IOException e) {
                logger.error((Object)("Stop syslog client failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
    }

    public static void checkConnection(String ip, String port, String encrytionMode) {
        try {
            int intPort = Integer.parseInt(port);
            SysLogTcpClient.checkConnection(ip, intPort, encrytionMode);
        }
        catch (NumberFormatException e) {
            logger.error((Object)"Input port is %s, which is not a legal integer", new Object[]{port});
            throw e;
        }
    }

    public static void checkConnection(String ip, int port, String encrytionMode) {
        SyslogConfig config = new SyslogConfig(ip, port, encrytionMode);
        TcpSyslogMessageSender syslogTestSender = new TcpSyslogMessageSender();
        SysLogTcpClient.configMsgSender(syslogTestSender, config);
        try {
            syslogTestSender.setDefaultSeverity(Severity.DEBUG);
            syslogTestSender.sendMessage((CharSequence)"eReplication connection check");
        }
        catch (IOException e) {
            logger.error((Object)"CheckSysLogSeverConnection failed ip: %s, port: %s, protocol: %s", new Object[]{ip, port, encrytionMode});
            throw new LegoCheckedException(1073947407L);
        }
        finally {
            try {
                syslogTestSender.close();
            }
            catch (IOException e) {
                logger.error((Object)("Closing syslog failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
    }

    public boolean isAvaliable() {
        boolean available = true;
        try {
            SysLogTcpClient.checkConnection(this.syslogConfig.getServerIp(), this.syslogConfig.getPort(), this.syslogConfig.getEncryptionMode());
        }
        catch (LegoCheckedException e) {
            available = false;
        }
        return available;
    }
}

