/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.task;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.coreenum.SyslogEncryptionModeEnum;
import com.huawei.ism.drm.system.thirdservice.sdk.model.LogNotifyServer;
import com.huawei.lego.core.base.LegoMoGenerator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.TryCatchThrowable;
import com.huawei.lego.core.system.syslog.proxy.OperateLogProxy;
import com.huawei.lego.core.system.syslog.sdk.model.OptLogMo;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import com.huawei.lego.core.system.syslog.service.IOperatelogService;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class ReportLogFailedTask
extends TimerTask {
    private static final Log logger = LogFactory.getInstance(ReportLogFailedTask.class);
    private static final Object SLOCK = new Object();
    private static ReportLogFailedTask task = new ReportLogFailedTask();
    private OperateLogProxy optLogProxy = OperateLogProxy.getInstance();
    private boolean isRunning = false;

    private ReportLogFailedTask() {
    }

    public static ReportLogFailedTask getInstance() {
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = SLOCK;
        synchronized (object) {
            if (this.isRunning) {
                return;
            }
        }
        final HibernateTemplate template = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        TryCatchThrowable tempTry = new TryCatchThrowable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doTry() {
                logger.debug((Object)"start ReportFailedTask");
                Object object = SLOCK;
                synchronized (object) {
                    ReportLogFailedTask.this.isRunning = true;
                }
                ReportLogFailedTask.this.report(template, "administratorlog", 1000);
            }

            protected void doCatch(Throwable e) {
                logger.error((Object)("repeat report error ." + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        };
        tempTry.run();
        tempTry = new TryCatchThrowable(){

            protected void doTry() {
                ReportLogFailedTask.this.report(template, "tenantlog", 200);
            }

            protected void doCatch(Throwable e) {
                logger.error((Object)("repeat report error ." + ExceptionUtil.getErrorMessage((Throwable)e)));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doFinally() {
                logger.debug((Object)"end ReportFailedTask");
                Object object = SLOCK;
                synchronized (object) {
                    ReportLogFailedTask.this.isRunning = false;
                }
            }
        };
        tempTry.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void report(HibernateTemplate template, String logType, int size) {
        Session session = null;
        try {
            session = template.getSessionFactory().openSession();
            if ("tenantlog".equals(logType)) {
                Query queryProject = session.createQuery("select distinct log.projectId  from OptLogMo as log where log.logType = :logType and log.reported = :reported");
                queryProject.setParameter("logType", (Object)logType);
                queryProject.setParameter("reported", (Object)false);
                List projects = queryProject.list();
                if (!VerifyUtil.isEmpty((Collection)projects)) {
                    for (String pro : projects) {
                        Query queryTotal = session.createQuery("select COUNT(*) from OptLogMo as log where log.logType = :logType and log.reported = :reported and log.projectId = :projectId");
                        queryTotal.setParameter("logType", (Object)logType);
                        queryTotal.setParameter("reported", (Object)false);
                        queryTotal.setParameter("projectId", (Object)pro);
                        Object total = queryTotal.uniqueResult();
                        HashMap<String, String> condition = new HashMap<String, String>();
                        condition.put("projectId", pro);
                        this.initLogsAndReport((Long)total, session, logType, size, condition);
                    }
                }
            } else if ("administratorlog".equals(logType)) {
                Query queryTotal = session.createQuery("select COUNT(*) from OptLogMo as log where log.logType = :logType and log.reported = :reported");
                queryTotal.setParameter("logType", (Object)logType);
                queryTotal.setParameter("reported", (Object)false);
                Object total = queryTotal.uniqueResult();
                this.initLogsAndReport((Long)total, session, logType, size, new HashMap<String, String>());
            }
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
    }

    private void initLogsAndReport(long total, Session session, String logType, int size, Map<String, String> condition) {
        if (size > 1000 || total > Integer.MAX_VALUE) {
            logger.error((Object)("page size error . size : " + size + "and total count : " + total));
            throw new LegoCheckedException(1073947393L);
        }
        int start = 0;
        while ((long)start < total) {
            long limitTime = System.currentTimeMillis() - 300000L;
            StringBuilder hql = new StringBuilder();
            hql.append("from OptLogMo as log where log.logType = :logType and log.reported = :reported and log.opTime < :limitTime");
            for (String con : condition.keySet()) {
                hql.append(" and log." + con + " = :" + con);
            }
            hql.append(" order by log.opTime asc");
            Query query = session.createQuery(hql.toString());
            query.setParameter("logType", (Object)logType);
            query.setParameter("reported", (Object)false);
            query.setParameter("limitTime", (Object)limitTime);
            query.setMaxResults(size);
            query.setFirstResult(start);
            Set<Map.Entry<String, String>> entrys = condition.entrySet();
            for (Map.Entry<String, String> entry : entrys) {
                query.setParameter(entry.getKey(), (Object)entry.getValue());
            }
            start += size;
            List logs = query.list();
            if (VerifyUtil.isEmpty((Collection)logs)) {
                logger.error((Object)("get operate logs error . total is " + total));
                AlarmReporter.restoreAlarm(52625474L, logType);
                return;
            }
            IOperatelogService logService = this.optLogProxy.getLogReportService(logType);
            if (VerifyUtil.isEmpty((Object)logService) || !logService.isAvailable()) {
                logger.debug((Object)"logService is unavailable .");
                this.reportAlarm(this.getTime(logs), logType);
                return;
            }
            List<SysOptLog> tarLogs = this.convertLogs(logs);
            try {
                logService.notifyLog(tarLogs);
                AlarmReporter.restoreAlarm(52625474L, logType);
            }
            catch (Exception e) {
                this.reportAlarm(this.getTime(logs), logType);
                throw e;
            }
        }
    }

    private List<SysOptLog> convertLogs(List<OptLogMo> logs) {
        ArrayList<SysOptLog> tarLogs = new ArrayList<SysOptLog>();
        for (OptLogMo optLogMo : logs) {
            SysOptLog tarLog = new SysOptLog();
            tarLog.setDate(new Date(optLogMo.getOpTime()));
            tarLog.setTokenUser(optLogMo.getTokenUser());
            tarLog.setOperation(optLogMo.getOpName());
            tarLog.setLevel(optLogMo.getRiskLevel());
            tarLog.setDetail(optLogMo.getOpDetail());
            tarLog.setResult(optLogMo.getOpResult());
            tarLog.setTerminalIp(optLogMo.getOpIpAddress());
            tarLog.setTarget(optLogMo.getOpTarget());
            tarLog.setLogType(optLogMo.getLogType());
            tarLog.setId(optLogMo.getId().longValue());
            tarLog.setProjectId(optLogMo.getProjectId());
            tarLog.setServiceType(optLogMo.getServiceType());
            String param = optLogMo.getOpDetailPama();
            if (!VerifyUtil.isEmpty((String)param)) {
                tarLog.setDetailPara(param.split("\n"));
            }
            tarLogs.add(tarLog);
        }
        return tarLogs;
    }

    private void reportAlarm(long time, String logType) {
        if (time + 3600000L < System.currentTimeMillis()) {
            LogNotifyServer logserver = this.getLogNotifyServerBy(logType);
            String serverIp = this.getSystemIP();
            if (VerifyUtil.isEmpty((Object)logserver) || !logserver.getIsEnabled()) {
                return;
            }
            JSONObject props = JSONObject.fromObject((Object)logserver.getProtocalProps());
            String ip = props.getString("ip");
            String port = props.getString("port");
            AlarmReporter.sendLogAlarmForNoRepeat(52625474L, null, FaultEnum.AlarmResourceType.UNDEFINED.getValue(), FaultEnum.AlarmSeverity.CRITICAL, new String[]{logserver.getLogType(), serverIp, ip, port});
        }
    }

    private LogNotifyServer getLogNotifyServerBy(String logType) {
        List servers = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from LogNotifyServer as server where server.logType = ?", new Object[]{logType});
        if (VerifyUtil.isEmpty((Collection)servers)) {
            logger.error((Object)("get LogNotifyServer is empty . type is " + logType));
            return null;
        }
        LogNotifyServer server = (LogNotifyServer)servers.get(0);
        JSONObject props = JSONObject.fromObject((Object)server.getProtocalProps());
        if (!"CTS".equalsIgnoreCase(server.getProtocalType()) && !props.containsKey((Object)"encryptionMode")) {
            props.put((Object)"encryptionMode", (Object)SyslogEncryptionModeEnum.TCP.name());
            server.setProtocalProps(props.toString());
        }
        return server;
    }

    private long getTime(List<OptLogMo> logs) {
        long time = Long.MAX_VALUE;
        if (VerifyUtil.isEmpty(logs)) {
            return time;
        }
        for (OptLogMo optLogMo : logs) {
            if (optLogMo.getOpTime() >= time) continue;
            time = optLogMo.getOpTime();
        }
        return time;
    }

    private String getSystemIP() {
        return new LegoMoGenerator().getInstallServerIp();
    }
}

