/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.thirdservice;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.system.thirdservice.sdk.model.LogNotifyServer;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ILogNotifierService;
import com.huawei.lego.cbb.i18n.sdk.I18nMrg;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.huawei.lego.core.system.syslog.service.IOperatelogService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.query.Query;

public abstract class AbstractOperateLogService
implements IOperatelogService {
    protected static final int FACILITY_NUM = 16;
    protected static final String CLOUD_SEVICE_TYPE = "Cloud DR Service";
    private static final Log logger = LogFactory.getInstance(AbstractOperateLogService.class);
    private ILogNotifierService logNotifierService;
    private I18nMrg i18nMgr;

    public I18nMrg getI18nMgr() {
        return this.i18nMgr;
    }

    public void setI18nMgr(I18nMrg i18nMgr) {
        this.i18nMgr = i18nMgr;
    }

    public ILogNotifierService getLogNotifierService() {
        return this.logNotifierService;
    }

    public void setLogNotifierService(ILogNotifierService logNotifierService) {
        this.logNotifierService = logNotifierService;
    }

    protected LogNotifyServer getLogNotifyServerBy(String logType) {
        List list = this.logNotifierService.getNotifyServerListBy(logType);
        if (VerifyUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (LogNotifyServer)list.get(0);
    }

    protected String getSingleLogJson(SysOptLog log) {
        JSONObject logJson = new JSONObject();
        logJson.put((Object)"time", (Object)log.getDate().getTime());
        logJson.put((Object)"user", (Object)log.getTokenUser());
        this.setServiceType(logJson, log);
        logJson.put((Object)"trace_name", (Object)this.i18nMgr.getString(log.getOperation()));
        logJson.put((Object)"trace_name_cn", (Object)this.i18nMgr.getString(log.getOperation(), Locale.SIMPLIFIED_CHINESE));
        logJson.put((Object)"trace_rating", (Object)this.getlogLevelString(log.getLevel()));
        logJson.put((Object)"trace_result", (Object)this.getResult(log.getResult()));
        logJson.put((Object)"source_ip", (Object)log.getTerminalIp());
        logJson.put((Object)"resource_name", (Object)this.i18nMgr.getString(log.getTarget()).replaceAll("\\[", "").replaceAll("\\]", ""));
        logJson.put((Object)"message", (Object)this.i18nMgr.getString(log.getDetail(), Locale.ENGLISH, log.getDetailPara()));
        logJson.put((Object)"trace_message_cn", (Object)this.i18nMgr.getString(log.getDetail(), Locale.SIMPLIFIED_CHINESE, log.getDetailPara()));
        return logJson.toString();
    }

    protected void setServiceType(JSONObject logJson, SysOptLog log) {
        if (VerifyUtil.isEmpty((Map)logJson) || VerifyUtil.isEmpty((Object)log)) {
            logger.error((Object)"param is empty .");
            return;
        }
        String serviceType = log.getServiceType();
        if (!VerifyUtil.isEmpty((String)serviceType)) {
            String type = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getServiceIdFromServiceType((String)serviceType);
            if (!VerifyUtil.isEmpty((String)type)) {
                logJson.put((Object)"service_type", (Object)type.toUpperCase(Locale.US));
            } else {
                logJson.put((Object)"service_type", (Object)serviceType);
            }
        } else if ("tenantlog".equalsIgnoreCase(log.getLogType())) {
            logJson.put((Object)"service_type", (Object)CLOUD_SEVICE_TYPE);
        }
    }

    protected String getOldVersionSingleLog(SysOptLog log) {
        StringBuffer buffer = new StringBuffer();
        int syslogLevel = this.getlogLevel(log.getLevel());
        buffer.append('<').append(128 + syslogLevel).append('>');
        buffer.append(' ').append(this.formateDate(log.getDate())).append(" eReplication : Operate Name: ").append(this.i18nMgr.getString(log.getOperation())).append(", Administrator: ").append(log.getOperator()).append(", Result: ").append(this.getResult(log.getResult())).append(", Terminal: ").append(log.getTerminalIp()).append(", Object: ").append(this.i18nMgr.getString(log.getTarget()));
        if (!VerifyUtil.isEmpty((String)log.getDetail())) {
            buffer.append(", Details: ").append(this.i18nMgr.getString(log.getDetail(), log.getDetailPara()));
        }
        return buffer.toString();
    }

    private String formateDate(Date date) {
        SimpleDateFormat formate = new SimpleDateFormat("MMM dd HH:mm:ss", Locale.ENGLISH);
        return formate.format(date);
    }

    protected String getResult(int result) {
        if (1 == result) {
            return "successed";
        }
        return "failed";
    }

    protected int getlogLevel(int level) {
        if (SysoplogLevel.info.getValue() == level) {
            return 6;
        }
        if (SysoplogLevel.warning.getValue() == level) {
            return 5;
        }
        if (SysoplogLevel.normal.getValue() == level) {
            return 4;
        }
        if (SysoplogLevel.risk.getValue() == level) {
            return 2;
        }
        return 0;
    }

    protected String getlogLevelString(int level) {
        if (SysoplogLevel.info.getValue() == level) {
            return "message";
        }
        if (SysoplogLevel.warning.getValue() == level) {
            return "warning";
        }
        if (SysoplogLevel.normal.getValue() == level) {
            return "normal";
        }
        if (SysoplogLevel.risk.getValue() == level) {
            return "risk";
        }
        return "";
    }

    protected void changeOptLogReportedStatus(boolean reported, List<SysOptLog> logs) {
        if (null == logs || logs.size() > 1000) {
            throw new LegoCheckedException(1073947393L);
        }
        Session session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (SysOptLog log : logs) {
            ids.add(log.getId());
        }
        try {
            session.beginTransaction();
            Query query = session.createQuery("update OptLogMo as mo set mo.reported = :reported where mo.id in (:ids)");
            query.setParameter("reported", (Object)reported);
            query.setParameterList("ids", ids);
            query.executeUpdate();
            session.getTransaction().commit();
        }
        catch (Exception e) {
            DBOperationUtil.rollbackSession(session);
            logger.error((Object)("update log failed , logIds : " + ids));
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
    }

    protected void initLog(StringBuilder builder, List<SysOptLog> logs) {
        builder.append("[");
        for (SysOptLog sysOptLog : logs) {
            builder.append(this.getSingleLogJson(sysOptLog)).append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("]");
    }
}

