/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.thirdservice.impl;

import com.huawei.ism.drm.system.syslogj.SysLogTcpClient;
import com.huawei.ism.drm.system.thirdservice.AbstractOperateLogService;
import com.huawei.ism.drm.system.thirdservice.sdk.model.LogNotifyServer;
import com.huawei.ism.drm.util.FusionCloudUtil;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;

public class SyslogNotifyServiceImpl
extends AbstractOperateLogService
implements SystemStatusChangedListener {
    private static final Log logger = LogFactory.getInstance(SyslogNotifyServiceImpl.class);
    private SysLogTcpClient syslogClient = null;

    public void notifyLog(SysOptLog log) {
        if (VerifyUtil.isEmpty((Object)log)) {
            logger.error((Object)"log is empty .");
            throw new LegoCheckedException(1073947393L);
        }
        if (null == this.syslogClient) {
            this.changeOptLogReportedStatus(true, Arrays.asList(log));
            return;
        }
        if (FusionCloudUtil.isCurrentFCVersionHighThanParamVerion((String)"6.3")) {
            this.syslogClient.log(this.getlogLevel(log.getLevel()), this.getLogHeader(this.getHeaderTimeStamp(log.getDate()), this.getlogLevel(log.getLevel())) + this.getSingleLogJson(log));
        } else {
            this.syslogClient.log(this.getlogLevel(log.getLevel()), this.getOldVersionSingleLog(log));
        }
        this.changeOptLogReportedStatus(true, Arrays.asList(log));
    }

    public void notifyLog(List<SysOptLog> logs) {
        if (VerifyUtil.isEmpty(logs)) {
            logger.error((Object)"logs is empty .");
            throw new LegoCheckedException(1073947393L);
        }
        if (null == this.syslogClient) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        this.initLog(builder, logs);
        String logsString = builder.toString();
        if (FusionCloudUtil.isCurrentFCVersionHighThanParamVerion((String)"6.3")) {
            this.syslogClient.log(1, logsString);
            this.changeOptLogReportedStatus(true, logs);
        } else {
            for (SysOptLog sysOptLog : logs) {
                this.syslogClient.log(1, this.getOldVersionSingleLog(sysOptLog));
                this.changeOptLogReportedStatus(true, Arrays.asList(sysOptLog));
            }
        }
    }

    private String getLogHeader(String timeStamp, int syslogLevel) {
        StringBuilder builder = new StringBuilder();
        builder.append("<").append(128 + syslogLevel);
        builder.append(">").append(timeStamp).append(" ").append(this.getHostName()).append(" -: ");
        return builder.toString();
    }

    @Override
    protected void initLog(StringBuilder builder, List<SysOptLog> logs) {
        for (SysOptLog sysOptLog : logs) {
            builder.append(this.getLogHeader(this.getHeaderTimeStamp(sysOptLog.getDate()), this.getlogLevel(sysOptLog.getLevel())) + this.getSingleLogJson(sysOptLog));
            builder.append(" ");
        }
        builder.deleteCharAt(builder.length() - 1);
    }

    private String getHostName() {
        String hostName;
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            logger.error((Object)("get hostname error ." + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        if (null != addr && !VerifyUtil.isEmpty((String)(hostName = addr.getHostName()))) {
            return hostName.replaceAll(" ", "");
        }
        Enumeration<NetworkInterface> allNet = null;
        try {
            allNet = NetworkInterface.getNetworkInterfaces();
            while (!VerifyUtil.isEmpty(allNet) && allNet.hasMoreElements()) {
                NetworkInterface netInterface = allNet.nextElement();
                List<InterfaceAddress> interAddr = netInterface.getInterfaceAddresses();
                String tarAddr = this.getTargetAddr(interAddr);
                if (VerifyUtil.isEmpty((String)tarAddr)) continue;
                return tarAddr;
            }
        }
        catch (SocketException e) {
            logger.error((Object)("get hostname error ." + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return "-";
    }

    private String getTargetAddr(List<InterfaceAddress> interAddr) {
        if (VerifyUtil.isEmpty(interAddr)) {
            return null;
        }
        for (InterfaceAddress interfaceAddress : interAddr) {
            String ipAddr;
            InetAddress ip = interfaceAddress.getAddress();
            if (null == ip || !(ip instanceof Inet4Address) && !(ip instanceof Inet6Address) || VerifyUtil.isEmpty((String)(ipAddr = ip.getHostAddress()))) continue;
            return ipAddr;
        }
        return null;
    }

    private String getHeaderTimeStamp(Date date) {
        if (null == date) {
            return "-";
        }
        SimpleDateFormat year = new SimpleDateFormat("MMM dd hh:mm:ss", Locale.ENGLISH);
        return year.format(date);
    }

    public void refactorServiceConfig() {
        LogNotifyServer logServer = this.getLogNotifyServerBy("administratorlog");
        if (null != this.syslogClient) {
            this.syslogClient.stop();
        }
        this.syslogClient = null != logServer && logServer.getIsEnabled() ? new SysLogTcpClient(logServer) : null;
    }

    public String getServiceType() {
        return "administratorlog";
    }

    public void checkConnection(String ip, String port, String protocol) {
        SysLogTcpClient.checkConnection(ip, port, protocol);
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        logger.info((Object)"start init administratorlog service .");
        this.refactorServiceConfig();
    }

    public boolean isAvailable() {
        if (null == this.syslogClient) {
            return false;
        }
        return this.syslogClient.isAvaliable();
    }
}

