/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.builder;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.topo.builder.AbstractGlobalTopoBuilder;
import com.huawei.ism.drm.topo.sdk.builder.ITopoBuilder;
import com.huawei.ism.drm.topo.sdk.context.TopoContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;
import twaver.Element;
import twaver.ElementBox;
import twaver.IData;
import twaver.Link;
import twaver.Node;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:Global-Topology-11")
public class GeneralGlobalTopoBuilder
extends AbstractGlobalTopoBuilder {
    private static final Log LOGGER = LogFactory.getInstance(GeneralGlobalTopoBuilder.class);
    private boolean whole = true;

    public boolean isWhole() {
        return this.whole;
    }

    public void setWhole(boolean whole) {
        this.whole = whole;
    }

    @Override
    public void buildTopo(TopoContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        ElementBox layout = (ElementBox)context.find((Object)"layout");
        if (VerifyUtil.isEmpty((Object)layout)) {
            LOGGER.error((Object)"build topo failed, can't find layout in context: pgId=%s", new Object[]{protectGroup.getUuid()});
            throw new LegoCheckedException(2117645L);
        }
        int poType = protectGroup.getPoType();
        if (this.checkPoType(poType)) {
            ITopoBuilder hostBuilder = context.getTopoBuilderManager().getTopoBuilder("Global-Topology-Host");
            hostBuilder.buildTopo(context);
        } else if (poType == 10) {
            ITopoBuilder vsBuilder = context.getTopoBuilderManager().getTopoBuilder("Global-Topology-vSphere");
            vsBuilder.buildTopo(context);
        } else if (poType == 11) {
            ProtectObjectStorageInfo poStorageInfo = context.getTopoService().getProtectObjectStorageInfoByPgId(protectGroup.getUuid());
            this.createStorage(context, protectGroup, poStorageInfo, layout);
        }
        int tempType = protectGroup.getTemplate().getType();
        if (tempType == 45) {
            ProtectObjectStorageInfo poStorageInfo = context.getTopoService().getProtectObjectStorageInfoByPgId(protectGroup.getUuid());
            this.createStorage(context, protectGroup, poStorageInfo, layout);
        }
        if (tempType == 17) {
            this.createHyperVaultTopo(context, layout);
            return;
        }
        if (tempType != 2 && tempType != 14) {
            this.createStorageArray(context, layout);
        }
    }

    private boolean checkPoType(int poType) {
        return 0 < poType && poType <= 9 || poType == 13 || poType == 16;
    }

    private void createHyperVaultTopo(TopoContext context, ElementBox layout) {
        ProtectGroup protectGroup = context.getProtectGroup();
        List replicas = context.getReplicaService().queryProtectGroupReplicaByGroup(protectGroup.getUuid(), "ID", true);
        String productArraySN = "";
        String recoverArraySN = "";
        Node productArrayNode = null;
        Node recoveryArrayNode = null;
        for (ProtectGroupReplica replica : replicas) {
            if (replica.getProtectLocation() != DrmEnumDefine.PROTECT_LOCATION.PL_A.getValue()) continue;
            productArraySN = replica.getProductArray();
            productArrayNode = this.getOrCreateProductSiteNode(context, replica, layout);
            break;
        }
        for (ProtectGroupReplica replica : replicas) {
            if (replica.getProtectLocation() != DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue() && replica.getProtectLocation() != DrmEnumDefine.PROTECT_LOCATION.PL_B.getValue()) continue;
            recoverArraySN = replica.getProductArray();
            recoveryArrayNode = this.getOrCreateProductSiteNode(context, replica, layout);
            break;
        }
        if (null == productArrayNode || null == recoveryArrayNode) {
            LOGGER.error((Object)("some is null: " + productArrayNode + "," + recoveryArrayNode), 1L);
            return;
        }
        Link link = TopoServiceUtil.getExistLinkBetweenNodes(productArrayNode, recoveryArrayNode);
        if (link == null) {
            this.createStorageLink(context, productArraySN, productArrayNode, recoverArraySN, recoveryArrayNode);
        } else {
            this.addProtectGroupIDToElement((Element)link, protectGroup.getUuid());
        }
    }

    private void createStorageArray(TopoContext context, ElementBox layout) {
        ProtectGroup protectGroup = context.getProtectGroup();
        List<ProtectGroupReplica> replicas = this.queryReductionProtectGroupReplicaByGroup(context);
        for (ProtectGroupReplica replica : replicas) {
            Node recoverSiteNode;
            String productArraySN = replica.getProductArray();
            String recoverArraySN = replica.getRecoveryArray();
            Node productArrayNode = this.getOrCreateProductSiteNode(context, replica, layout);
            if (productArrayNode == null || productArraySN.equals(recoverArraySN) || (recoverSiteNode = this.getOrCreateRecoverSiteNode(context, replica, layout)) == null) continue;
            Link link = TopoServiceUtil.getExistLinkBetweenNodes(productArrayNode, recoverSiteNode);
            if (link == null) {
                this.createStorageLink(context, productArraySN, productArrayNode, recoverArraySN, recoverSiteNode);
                continue;
            }
            this.addProtectGroupIDToElement((Element)link, protectGroup.getUuid());
        }
    }

    protected List<ProtectGroupReplica> queryReductionProtectGroupReplicaByGroup(TopoContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        return context.getReplicaService().queryReductionProtectGroupReplicaByGroup(protectGroup.getUuid(), "ID", true);
    }

    protected List<ProtectGroupReplica> queryProtectGroupReplicaByGroup(TopoContext context) {
        return GeneralGlobalTopoBuilder.queryProtectGroupReplicas(context);
    }

    public static List<ProtectGroupReplica> queryProtectGroupReplicas(TopoContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        return context.getReplicaService().queryProtectGroupReplicaByGroup(protectGroup.getUuid(), "ID", true);
    }

    private void createStorageLink(TopoContext context, String productArraySN, Node productArrayNode, String recoverArraySN, Node recoverArrayNode) {
        if (productArraySN.equals(recoverArraySN)) {
            return;
        }
        ElementBox topoBox = context.getElementBox();
        ProtectGroup protectGroup = context.getProtectGroup();
        String sLinkID = "storagelink-" + protectGroup.getUuid() + ":" + productArraySN + "->" + recoverArraySN;
        Link link = new Link((Object)sLinkID, productArrayNode, recoverArrayNode);
        link.setClient("linkToXOffset", 10.0);
        link.setClient("devSN", (Object)productArraySN);
        link.setClient("trgSN", (Object)recoverArraySN);
        this.addProtectGroupIDToElement((Element)link, protectGroup.getUuid());
        link.setStyle("link.width", 1.0);
        link.setStyle("arrow.to", true);
        link.setStyle("arrow.to.width", (Object)REPLICATION_ARROW_IO_WIDTH);
        link.setStyle("arrow.to.height", (Object)REPLICATION_ARROW_IO_HIGHTH);
        link.setStyle("arrow.to.shape", (Object)"arrow.delta");
        StringBuilder storageLinkTips = new StringBuilder();
        ITopoResourceManager resourceManager = TopoContext.getTopoResourceManager();
        storageLinkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.status"));
        storageLinkTips.append(" ");
        int linkStatus = this.getStorageLinkStatus(context, productArraySN, recoverArraySN);
        if (linkStatus == 3 || linkStatus == 4) {
            link.setStyle("link.color", (Object)"0x1dcfef");
            link.setStyle("arrow.to.color", (Object)"0x1dcfef");
            storageLinkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.unknown"));
        } else if (linkStatus == 2 || linkStatus == 1) {
            link.setStyle("link.color", (Object)"0xfc4133");
            link.setStyle("arrow.to.color", (Object)"0xfc4133");
            storageLinkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.allbreak"));
        } else {
            link.setStyle("link.color", (Object)"0x31bd16");
            link.setStyle("arrow.to.color", (Object)"0x31bd16");
            storageLinkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.normal"));
        }
        link.setToolTip(storageLinkTips.toString());
        link.setStyle("select.alpha", 1.0);
        link.setStyle("select.style", (Object)"none");
        TopoServiceUtil.addElementToBox(topoBox, (IData)link);
    }
}

