/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.element;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.CapacityUnitUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.topo.skin.LunSkin;
import com.huawei.ism.drm.topo.twaver.TopoElement;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class LunElement
extends TopoElement {
    private static final int LUN_STATUS_NORMAL = 0;
    private static final int LUN_STATUS_FAULTY = 2;
    private static final int LUN_STATUS_UNKNOWN = -1;
    private final Log logger = LogFactory.getInstance(((Object)((Object)this)).getClass());

    public LunElement() {
    }

    public LunElement(Object id, Lun lun) {
        super(id);
        this.setImage("/theme/recoverydirector/images/topo/Lun.png");
        if (lun != null) {
            this.setName(TopoServiceUtil.getNodeShowName(lun.getName()));
            this.setToolTip(this.createToolTip(lun, lun.getName(), lun.getResourceId()));
        } else {
            this.setName("--");
            StringBuilder builder = new StringBuilder();
            this.appendTooltip(builder, "ism.drm.topo.lun.name", "--");
            this.appendTooltip(builder, "ism.drm.topo.lun.id", "--");
            this.appendTooltip(builder, "ism.drm.topo.volume.wwn", "--");
            this.appendTooltip(builder, "ism.drm.topo.lun.totalcapacity", "--");
            this.appendTooltip(builder, "ism.drm.topo.storage.status", "--");
            this.setToolTip(builder.toString());
            this.setImage("/theme/recoverydirector/images/topo/Lun_unknown.png");
        }
        this.use(new LunSkin());
    }

    public LunElement(Object id, Lun source, ReplicationTargetLun target) {
        this(id, source);
        if (target.getTgtLunName() == null || target.getTgtLunName().isEmpty()) {
            this.setName("--");
        } else {
            this.setName(TopoServiceUtil.getNodeShowName(target.getTgtLunName()));
        }
        this.setToolTip(this.createToolTip(source, target.getTgtLunName(), target.getTgtLunId()));
    }

    public LunElement(Object id, Lun source, String target) {
        this(id, source);
        this.setName("--");
        this.setToolTip(this.createToolTip(source, "--", target));
    }

    protected String createToolTip(Lun lun, String name, String id) {
        StringBuilder builder = new StringBuilder();
        this.appendTooltip(builder, "ism.drm.topo.lun.name", name);
        if (id.contains("Lun-")) {
            this.appendTooltip(builder, "ism.drm.topo.lun.id", "--");
            this.appendTooltip(builder, "ism.drm.topo.volume.wwn", lun.getWwn());
            this.appendTooltip(builder, "ism.drm.topo.lun.totalcapacity", "--");
            this.appendTooltip(builder, "ism.drm.topo.storage.status", "--");
            this.setImage("/theme/recoverydirector/images/topo/Lun_unknown.png");
        } else if (name.equals("--")) {
            this.appendTooltip(builder, "ism.drm.topo.lun.id", id);
            this.appendTooltip(builder, "ism.drm.topo.volume.wwn", lun.getWwn());
            this.appendTooltip(builder, "ism.drm.topo.lun.totalcapacity", "--");
            this.appendTooltip(builder, "ism.drm.topo.storage.status", "--");
            this.setImage("/theme/recoverydirector/images/topo/Lun_unknown.png");
        } else {
            this.appendTooltip(builder, "ism.drm.topo.lun.id", id);
            this.appendTooltip(builder, "ism.drm.topo.volume.wwn", lun.getWwn());
            this.appendTooltip(builder, "ism.drm.topo.lun.totalcapacity", this.getTotalCapacityDisplay(lun));
            this.appendTooltip(builder, "ism.drm.topo.storage.status", this.getLunStatus(lun));
        }
        return builder.toString();
    }

    private String getLunStatus(Lun lun) {
        if (lun == null) {
            this.setImage("/theme/recoverydirector/images/topo/Lun_unknown.png");
            return "--";
        }
        int lunHealthStatus = 0;
        try {
            lunHealthStatus = Integer.parseInt(lun.getHealthStatus());
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)"translate status to string exception", (Throwable)e, 90160758786989L);
            lunHealthStatus = -1;
        }
        if (0 == lunHealthStatus) {
            this.setImage("/theme/recoverydirector/images/topo/Lun.png");
            return this.getTopoResourceManager().getText("ism.drm.topo.lun.status.normal");
        }
        if (2 == lunHealthStatus) {
            this.setImage("/theme/recoverydirector/images/topo/Lun_faulty.png");
            return this.getTopoResourceManager().getText("ism.drm.topo.lun.status.faulty");
        }
        this.setImage("/theme/recoverydirector/images/topo/Lun_unknown.png");
        return this.getTopoResourceManager().getText("ism.drm.topo.lun.status.unknown");
    }

    protected String getDisplayValue(String value) {
        return !TopoServiceUtil.isNullStr(value) ? value : "--";
    }

    protected String getTotalCapacityDisplay(Lun lun) {
        if (lun == null) {
            return "--";
        }
        if (lun.getTotalCapacity() == null) {
            return "0.0" + lun.getTotalCapacityUnit();
        }
        if (lun.getTotalCapacityDisplayValue() != null) {
            return lun.getTotalCapacityDisplayValue();
        }
        return CapacityUnitUtil.formatValue((Double)lun.getTotalCapacity(), (int)3, (int)3) + lun.getTotalCapacityUnit();
    }
}

