/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.element;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.drm.topo.skin.LunSkin;
import com.huawei.ism.drm.topo.twaver.TopoElement;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class NasFileSystemElement
extends TopoElement {
    private static final int STATUS_NORMAL = 0;
    private static final int STATUS_FAULTY = 2;
    private static Log logger = LogFactory.getInstance(NasFileSystemElement.class);

    public NasFileSystemElement() {
    }

    public NasFileSystemElement(Object id, NasFileSystem nasFileSystem) {
        super(id);
        this.setImage("/theme/recoverydirector/images/topo/nas_file_system.png");
        if (nasFileSystem != null) {
            this.setName(TopoServiceUtil.getNodeShowName(nasFileSystem.getName()));
            this.setToolTip(this.createToolTip(nasFileSystem, nasFileSystem.getName(), nasFileSystem.getResourceId()));
        } else {
            this.setImage("/theme/recoverydirector/images/topo/nas_file_system_unknown.png");
        }
        this.use(new LunSkin());
    }

    public NasFileSystemElement(Object id, NasFileSystem source, ReplicationTargetLun target) {
        this(id, source);
        if (VerifyUtil.isEmpty((Object)target)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (target.getTgtLunName() == null || target.getTgtLunName().isEmpty()) {
            this.setName("--");
        } else {
            this.setName(TopoServiceUtil.getNodeShowName(target.getTgtLunName()));
        }
        this.setToolTip(this.createToolTip(source, target.getTgtLunName(), target.getTgtLunId()));
    }

    public NasFileSystemElement(Object id, NasFileSystem source, String target) {
        this(id, source);
        this.setName("--");
        this.setToolTip(this.createToolTip(source, "--", target));
    }

    protected String createToolTip(NasFileSystem nasFileSystem, String name, String id) {
        StringBuilder builder = new StringBuilder();
        this.appendTooltip(builder, "ism.drm.topo.nasfilesystem.name", name);
        if ("--".equals(name)) {
            this.appendTooltip(builder, "ism.drm.topo.nasfilesystem.vstore.name", "--");
            this.appendTooltip(builder, "ism.drm.topo.nasfilesystem.id", id);
            this.appendTooltip(builder, "ism.drm.topo.nasfilesystem.totalcapacity", "--");
            this.appendTooltip(builder, "ism.drm.topo.nasfilesystem.status", "--");
            this.setImage("/theme/recoverydirector/images/topo/nas_file_system_unknown.png");
        } else {
            this.appendTooltip(builder, "ism.drm.topo.nasfilesystem.vstore.name", this.getVstoreName(nasFileSystem.getVstoreId(), nasFileSystem.getDevSn()));
            this.appendTooltip(builder, "ism.drm.topo.nasfilesystem.id", id);
            this.appendTooltip(builder, "ism.drm.topo.nasfilesystem.totalcapacity", nasFileSystem.getTotalCapacityAndUnit());
            this.appendTooltip(builder, "ism.drm.topo.nasfilesystem.status", this.getNasFileSystemStatus(nasFileSystem));
        }
        return builder.toString();
    }

    private String getVstoreName(String vStoreID, String devSn) {
        String name = "--";
        if (VerifyUtil.isEmpty((String)vStoreID)) {
            logger.debug((Object)"vStoreID is empty.");
            return name;
        }
        try {
            VstoreInfo info = StorageResourceServiceRouter.getInstance().getVstoreById(devSn, vStoreID);
            if (!VerifyUtil.isEmpty((Object)info)) {
                name = info.getName();
            }
        }
        catch (Exception e) {
            logger.error((Object)("getVstoreName failed, vStoreID: " + vStoreID + ", devSN: " + devSn), (Throwable)e);
        }
        return name;
    }

    private String getNasFileSystemStatus(NasFileSystem nasFileSystem) {
        if (nasFileSystem == null) {
            this.setImage("/theme/recoverydirector/images/topo/nas_file_system_unknown.png");
            return "--";
        }
        int healthStatus = NumberUtil.parseInteger((Object)nasFileSystem.getHealthStatus());
        if (0 == healthStatus) {
            this.setImage("/theme/recoverydirector/images/topo/nas_file_system.png");
            return this.getTopoResourceManager().getText("ism.drm.topo.nasfilesystem.status.normal");
        }
        if (2 == healthStatus) {
            this.setImage("/theme/recoverydirector/images/topo/nas_file_system_faulty.png");
            return this.getTopoResourceManager().getText("ism.drm.topo.nasfilesystem.status.faulty");
        }
        this.setImage("/theme/recoverydirector/images/topo/nas_file_system_unknown.png");
        return this.getTopoResourceManager().getText("ism.drm.topo.nasfilesystem.status.unknown");
    }
}

