/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.model.storage;

import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.topo.model.IMultiView;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.utils.TooltipUtil;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import twaver.Node;

public class StorageNode
implements IMultiView {
    private static final String TOPO_MODEL = "STORAGE";
    private static final String ICON_PATH = "/theme/recoverydirector/images/topo/arrayIcon.png";
    private static final int GROUP_LOCAL_OUTLINE_CORLOR = 12113637;
    private static final int GROUP_LOCAL_OUTLINE_WIDTH = 2;
    private static final int GROUP_LOCAL_FILL_COLOR = 15595258;
    private static final int GROUP_REMOTE_OUTLINE_CORLOR = 12113637;
    private static final int GROUP_REMOTE_OUTLINE_WIDTH = 2;
    private static final int GROUP_REMOTE_FILL_COLOR = 15595258;
    private static final String GROUP_SHAPE = "roundrect";
    private static final String GROUP_LAYOUT = "topbottom";
    private static final double INNER_TOP_GAP = 7.0;
    private static final double INNER_LEFT_GAP = 7.0;
    private static final double INNER_SONS_GAP = 7.0;
    private static final double ICON_WIDTH = 60.0;
    private static final double ICON_HEIGHT = 60.0;
    private String label = "UnknownArrayType";
    private Node group = null;
    private StorageNE storageNe = null;
    private DrStorage drStorage = null;
    private ITopoResourceManager resourceManager;

    public StorageNode(StorageNE storageNe, ITopoResourceManager resourceManager) {
        this.label = storageNe.getName();
        this.storageNe = storageNe;
        this.resourceManager = resourceManager;
        this.initNode();
    }

    public StorageNode(DrStorage drStorage, ITopoResourceManager resourceManager) {
        this.label = drStorage.getName();
        this.drStorage = drStorage;
        this.resourceManager = resourceManager;
        this.initNode();
    }

    public StorageNode(ITopoResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.initNode();
    }

    private void initNode() {
        if (this.storageNe != null) {
            this.group = new Node((Object)(this.storageNe.getSn() + ":storage"));
            this.group.setToolTip(this.createStorageToolTip(this.storageNe));
        } else if (this.drStorage != null) {
            this.group = new Node((Object)(this.drStorage.getDeviceSn() + ":storage"));
            this.group.setToolTip(this.createStorageToolTip(this.drStorage));
        } else {
            this.group = new Node();
        }
        this.group.setIcon(ICON_PATH);
        this.group.setImage("/theme/recoverydirector/images/topo/array.png");
        this.group.setClient("iconFlag", true);
        this.group.setStyle("icons.names", (Object)ICON_PATH);
        this.group.setStyle("label.bold", false);
        this.group.setStyle("label.font", (Object)this.resourceManager.getText("ism.drm.topo.label.font"));
        this.group.setStyle("icons.position", (Object)"topleft.topright");
        this.group.setClient("imageWidth", 48.0);
        this.group.setClient("imageHeight", 48.0);
        this.group.setStyle("label.position", (Object)"topleft.topright");
        this.group.setStyle("label.xoffset", 48.0);
        this.group.setStyle("label.yoffset", -4.0);
        this.group.setClient("iconWidth", 60.0);
        this.group.setClient("iconHeight", 60.0);
        if (!VerifyUtil.isEmpty((String)this.label)) {
            this.group.setName(TopoServiceUtil.getNodeShowName(this.label));
        } else {
            this.group.setName("--");
        }
        this.group.setClient("layout", (Object)GROUP_LAYOUT);
        this.group.setClient("TopoModel", (Object)TOPO_MODEL);
        this.group.setClient("leftGap", 7.0);
        this.group.setClient("topGap", 7.0);
        this.group.setClient("sonsGap", 7.0);
        this.group.setStyle("content.type", (Object)"vector");
        this.group.setStyle("vector.shape", (Object)GROUP_SHAPE);
        this.group.setStyle("vector.roundrect.radius", 7);
        this.group.setStyle("vector.joint.style", (Object)"bevel");
        this.group.setStyle("select.alpha", 1.0);
        this.group.setStyle("select.style", (Object)"none");
    }

    public Node getNode() {
        return this.group;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Node getLocalView() {
        this.group.setStyle("vector.fill.color", 15595258);
        this.group.setStyle("vector.outline.width", 2);
        this.group.setStyle("vector.outline.color", 12113637);
        return this.group;
    }

    public Node getRemoteView() {
        this.group.setStyle("vector.fill.color", 15595258);
        this.group.setStyle("vector.outline.width", 2);
        this.group.setStyle("vector.outline.color", 12113637);
        return this.group;
    }

    public String createStorageToolTip(DrStorage storage) {
        if (storage == null) {
            return "--";
        }
        StringBuilder builder = new StringBuilder();
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.ip", storage.getIpAddress(), this.resourceManager);
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.name", storage.getName(), this.resourceManager);
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.sn", storage.getDeviceSn(), this.resourceManager);
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.model", storage.getProductModel(), this.resourceManager);
        builder.append(this.constructStorageStatus(storage));
        return builder.toString();
    }

    public String createStorageToolTip(StorageNE storage) {
        if (storage == null) {
            return "--";
        }
        StringBuilder builder = new StringBuilder();
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.ip", storage.getIpAddress(), this.resourceManager);
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.name", storage.getName(), this.resourceManager);
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.sn", storage.getSn(), this.resourceManager);
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.model", storage.getSubType(), this.resourceManager);
        builder.append(this.constructStorageStatus(storage));
        return builder.toString();
    }

    private String constructStorageStatus(StorageNE storageData) {
        return this.getStatusInfo(storageData.getStatus());
    }

    private String constructStorageStatus(DrStorage storage) {
        return this.getStatusInfo(NumberUtil.convertToInteger((Object)storage.getStatus(), (int)0));
    }

    public String getStatusInfo(Integer status) {
        StringBuilder builder = new StringBuilder();
        String value = null;
        if (status == 0) {
            value = "ism.drm.site.storage.status.online";
        } else if (status == -1) {
            value = "ism.drm.site.storage.status.offline";
        } else if (status == 2) {
            value = "ism.drm.site.storage.status.faulty";
        }
        if (value != null) {
            value = this.resourceManager.getText(value);
        }
        TooltipUtil.appendTooltip(builder, "ism.drm.topo.storage.status", value, this.resourceManager);
        return builder.toString();
    }
}

