/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.service.impl;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.topo.builder.TopoLegendBuilder;
import com.huawei.ism.drm.topo.element.PGElement;
import com.huawei.ism.drm.topo.sdk.builder.ITopoBuilder;
import com.huawei.ism.drm.topo.sdk.context.TopoContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoBuilderManager;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.sdk.utils.TopoUtil;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import twaver.Data;
import twaver.DataBox;
import twaver.ElementBox;
import twaver.IData;
import twaver.Layer;
import twaver.Node;
import twaver.SerializationSettings;
import twaver.SubNetwork;
import twaver.XMLSerializer;

public class TopoBuilderManagerImpl
implements ITopoBuilderManager {
    private static final String TYPE_KEY = "type";
    private static final double TOPO_MORE_HIGHT = 15.0;
    private static final List<Integer> ASYNC_POLICY_TEMPLATE_TYPE_LIST = new ArrayList<Integer>(Arrays.asList(1, 3, 4, 5, 6, 16, 35, 36, 33, 38, 39, 40, 41, 42, 43));
    private static final List<Integer> SNAPSHOT_TEMPLATE = new ArrayList<Integer>(Arrays.asList(14, 17, 44, 45));
    private final Log logger = LogFactory.getInstance(this.getClass());
    private ISiteService siteService;
    private IStorageService storageService;
    private IProtectGroupService protectGroupService;
    private IRecoveryPlanService recoveryPlanService;
    private IReplicaService replicaService;
    private IPolicyTemplateManager policyTemplateManager;
    private Map<String, ITopoBuilder> builders = new HashMap<String, ITopoBuilder>();
    private ILicenseControl licenseControl;
    private IStorageResourceService storageResourceService;

    public IStorageResourceService getStorageResourceService() {
        return this.storageResourceService;
    }

    public void setStorageResourceService(IStorageResourceService storageResourceService) {
        this.storageResourceService = storageResourceService;
    }

    public IPolicyTemplateManager getPolicyTemplateManager() {
        return this.policyTemplateManager;
    }

    public void setPolicyTemplateManager(IPolicyTemplateManager policyTemplateManager) {
        this.policyTemplateManager = policyTemplateManager;
    }

    public IReplicaService getReplicaService() {
        return this.replicaService;
    }

    public void setReplicaService(IReplicaService replicaService) {
        this.replicaService = replicaService;
    }

    public ILicenseControl getLicenseControl() {
        return this.licenseControl;
    }

    public void setLicenseControl(ILicenseControl licenseControl) {
        this.licenseControl = licenseControl;
    }

    public ISiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(ISiteService siteService) {
        this.siteService = siteService;
    }

    public IRecoveryPlanService getRecoveryPlanService() {
        return this.recoveryPlanService;
    }

    public void setRecoveryPlanService(IRecoveryPlanService recoveryPlanService) {
        this.recoveryPlanService = recoveryPlanService;
    }

    public IStorageService getStorageService() {
        return this.storageService;
    }

    public void setStorageService(IStorageService storageService) {
        this.storageService = storageService;
    }

    public IProtectGroupService getProtectGroupService() {
        return this.protectGroupService;
    }

    public void setProtectGroupService(IProtectGroupService protectGroupService) {
        this.protectGroupService = protectGroupService;
    }

    public ITopoBuilder getTopoBuilder(String type) {
        return this.builders.get(type);
    }

    public void onBind(ITopoBuilder builder, Map<String, Object> props) {
        block3: {
            Object type;
            block4: {
                block2: {
                    type = props.get(TYPE_KEY);
                    if (!(type instanceof String)) break block2;
                    this.builders.put((String)type, builder);
                    break block3;
                }
                if (!(type instanceof String[])) break block4;
                for (String each : (String[])type) {
                    this.builders.put(each, builder);
                }
                break block3;
            }
            if (!(type instanceof Collection)) break block3;
            for (Object each : (Collection)type) {
                this.builders.put(each.toString(), builder);
            }
        }
    }

    public void onUnbind(ITopoBuilder builder, Map<String, Object> props) {
        block3: {
            Object type;
            block4: {
                block2: {
                    type = props.get(TYPE_KEY);
                    if (!(type instanceof String)) break block2;
                    this.unbind((String)type);
                    break block3;
                }
                if (!(type instanceof String[])) break block4;
                for (String each : (String[])type) {
                    this.unbind(each);
                }
                break block3;
            }
            if (!(type instanceof Collection)) break block3;
            for (Object each : (Collection)type) {
                this.unbind(each.toString());
            }
        }
    }

    private List<String> noPgTopo(List<String> results) {
        results.add("success");
        results.add(new XMLSerializer((DataBox)new ElementBox()).serializeCommon());
        results.add(new XMLSerializer((DataBox)new ElementBox()).serializeCommon());
        results.add("false");
        results.add("false");
        results.add("--");
        return results;
    }

    private List<String> getPgErrorTopo(ITopoResourceManager manager, List<String> results) {
        results.add("error");
        results.add(manager.getText("ism.drm.topo.err.msg.title"));
        results.add(manager.getText("ism.drm.topo.err.group.invalid"));
        results.add("false");
        results.add("false");
        results.add("--");
        return results;
    }

    private List<String> inValidPgTopo(ITopoResourceManager manager, List<String> results) {
        results.add("error");
        results.add(manager.getText("ism.drm.topo.info.msg.title"));
        results.add(manager.getText("ism.drm.topo.err.group.inactive"));
        results.add("false");
        results.add("false");
        results.add("--");
        return results;
    }

    public List<String> createProtectGroupTopoData(String pgId) {
        ProtectGroup protectGroup;
        this.logger.error((Object)"Create protectgroup topo data error, now: %s", new Object[]{new Date()});
        List<String> results = new ArrayList<String>();
        if (VerifyUtil.isEmpty((String)pgId)) {
            return this.noPgTopo(results);
        }
        ITopoResourceManager manager = TopoContext.getTopoResourceManager();
        try {
            protectGroup = this.protectGroupService.getProtectGroupByID(pgId);
        }
        catch (LegoCheckedException legoException) {
            this.logger.error((Object)"Create protectgroup topo data error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)legoException)});
            return this.getPgErrorTopo(manager, results);
        }
        catch (Exception legoException) {
            results = this.getErrorResults(-1L);
            this.logger.error((Object)"Create protectgroup topo data error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)legoException)});
            return results;
        }
        if (protectGroup == null) {
            return this.getPgErrorTopo(manager, results);
        }
        try {
            this.licenseControl.checkEnablePgTopo(protectGroup);
        }
        catch (LegoCheckedException e) {
            results = this.getErrorResults(e.getErrorCode());
            this.logger.error((Object)"Create protectgroup topo data error", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return results;
        }
        catch (Exception legoException) {
            results = this.getErrorResults(-1L);
            this.logger.error((Object)"Create protectgroup topo data error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)legoException)});
            return results;
        }
        if (protectGroup.isInvalid()) {
            return this.inValidPgTopo(manager, results);
        }
        return this.createProtectGroupTopoData(protectGroup, results);
    }

    private List<String> createProtectGroupTopoData(ProtectGroup protectGroup, List<String> results) {
        try {
            TopoContext context = this.createProtectGroupTopoData(protectGroup);
            results.add("success");
            String legendBoxStr = new TopoLegendBuilder().getLegendBoxString(context.getElementBox());
            results.add(context.serialize());
            results.add(legendBoxStr);
            results.add(String.valueOf(context.isSubNetWork()));
            this.getPollInfos(results, protectGroup, context);
        }
        catch (LegoCheckedException e) {
            results = this.getErrorResults(e.getErrorCode());
            this.logger.error((Object)"create protectgroup topo data error", (Throwable)e, 90160758786986L);
        }
        catch (Exception legoException) {
            results = this.getErrorResults(-1L);
            this.logger.error((Object)"Create protectgroup topo data error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)legoException)});
        }
        return results;
    }

    private void getPollInfos(List<String> results, ProtectGroup protectGroup, TopoContext context) {
        if (ASYNC_POLICY_TEMPLATE_TYPE_LIST.contains(protectGroup.getTemplate().getType())) {
            results.add("true");
            results.add(context.getLinkIdList());
        } else {
            results.add("false");
            results.add("--");
        }
    }

    public TopoContext createProtectGroupTopoData(ProtectGroup protectGroup) {
        TopoContext context = new TopoContext((ITopoBuilderManager)this, protectGroup);
        this.buildContext(context);
        int pgTemplateType = protectGroup.getTemplate().getType();
        if (SNAPSHOT_TEMPLATE.contains(pgTemplateType)) {
            return this.buildSnapshotTopoContext(context, pgTemplateType);
        }
        String type = "ProtectGroup-" + protectGroup.getPoType();
        ITopoBuilder builder = this.getTopoBuilder(type);
        if (null != builder) {
            context.setType(type);
            builder.buildTopo(context);
        }
        Node root = context.getRootNode();
        type = "PolicyTemplate-" + pgTemplateType;
        builder = this.getTopoBuilder(type);
        if (builder != null) {
            if (root == null) {
                root = this.setTopoLayout(context);
            } else {
                this.setTopoLayout(context);
            }
            String verticalStyleNodeIdSecBottom = protectGroup.getUuid() + "SecondaryBottom" + "---" + "Style:unvisible";
            Node verticalStyleNodeSecBottom = (Node)context.getElementBox().getDataByID((Object)verticalStyleNodeIdSecBottom);
            if (!VerifyUtil.isEmpty((Object)verticalStyleNodeSecBottom)) {
                context.setRootNode(verticalStyleNodeSecBottom);
            }
            context.setType(type);
            builder.buildTopo(context);
        }
        Set<Integer> addtionTemplateTypeSet = this.getAddtionalTemplateType(context.getProtectGroup());
        for (int addtionTemplateType : addtionTemplateTypeSet) {
            type = "AddtionalPolicyTemplate-" + addtionTemplateType;
            builder = this.getTopoBuilder(type);
            if (builder == null) continue;
            String verticalStyleNodeIdSecTop = protectGroup.getUuid() + "SecondaryTop" + "---" + "Style:unvisible";
            Node verticalStyleNodeSecTop = (Node)context.getElementBox().getDataByID((Object)verticalStyleNodeIdSecTop);
            if (!VerifyUtil.isEmpty((Object)verticalStyleNodeSecTop)) {
                context.setRootNode(verticalStyleNodeSecTop);
            }
            context.setType(type);
            builder.buildTopo(context);
        }
        context.setRootNode(root);
        TopoServiceUtil.computeNodeWidthAndHight(context.getRootNode());
        this.setVirtualMoreNodeSize(context);
        return context;
    }

    private void buildContext(TopoContext context) {
        context.setSiteService(this.siteService);
        context.setStorageService(this.storageService);
        context.setProtectGroupService(this.protectGroupService);
        context.setRecoveryPlanService(this.recoveryPlanService);
        context.setReplicaService(this.replicaService);
        context.setPolicyTemplateManager(this.policyTemplateManager);
        context.setStorageResourceService(this.storageResourceService);
    }

    private TopoContext buildSnapshotTopoContext(TopoContext context, int pgTemplateType) {
        String type = "PolicyTemplate-" + pgTemplateType;
        ITopoBuilder builder = this.getTopoBuilder(type);
        if (builder != null) {
            context.setType(type);
            builder.buildTopo(context);
        }
        TopoServiceUtil.computeNodeWidthAndHight(context.getRootNode());
        return context;
    }

    private Set<Integer> getAddtionalTemplateType(ProtectGroup protectGroup) {
        Set schedules = protectGroup.getTemplate().getSchedules();
        int pgTemplateType = protectGroup.getTemplate().getType();
        HashSet<Integer> addtionalType = new HashSet<Integer>();
        for (Schedule schedule : schedules) {
            if (schedule.getProtectedType() == pgTemplateType) continue;
            addtionalType.add(schedule.getProtectedType());
        }
        return addtionalType;
    }

    protected void initialize(TopoContext context) {
        PGElement root = new PGElement(null);
        ElementBox box = context.getElementBox();
        box.setStyle("background.type", (Object)"image");
        box.setStyle("background.image", (Object)"/theme/recoverydirector/images/topo/default.png");
        box.setStyle("background.image.stretch", (Object)"tile");
        context.setRootNode((Node)root);
        context.add((IData)root);
        String linkLayerId = "linkLayer";
        Layer layer = new Layer((Object)linkLayerId);
        box.getLayerBox().add((IData)layer);
        box.getLayerBox().moveTo((IData)layer, 1);
        Layer layer0 = new Layer((Object)"layer0");
        box.getLayerBox().add((IData)layer0);
        box.getLayerBox().moveTo((IData)layer0, 0);
        layer.setEditable(false);
        layer.setMovable(false);
        box.getLayerBox().getDefaultLayer().setMovable(true);
        box.getLayerBox().getDefaultLayer().setEditable(false);
    }

    private Node setTopoLayout(TopoContext context) {
        Node verticalStyleNodeMajor;
        ProtectGroup protectGroup = context.getProtectGroup();
        if (context.getRootNode() == null) {
            if (context.getRootNode() == null) {
                this.initialize(context);
            }
            verticalStyleNodeMajor = context.getRootNode();
            verticalStyleNodeMajor.setClient("layout", (Object)"topbottom");
        } else {
            String verticalStyleNodeIdMajor = protectGroup.getUuid() + "Major" + "---" + "Style:unvisible";
            verticalStyleNodeMajor = (Node)context.getElementBox().getDataByID((Object)verticalStyleNodeIdMajor);
            if (verticalStyleNodeMajor == null) {
                verticalStyleNodeMajor = TopoServiceUtil.createUnVisibleStorageNode(context, protectGroup.getUuid() + "Major" + "---" + "Style");
                verticalStyleNodeMajor.setClient("layout", (Object)"topbottom");
                context.addChild((IData)context.getRootNode(), (IData)verticalStyleNodeMajor);
            }
        }
        String verticalStyleNodeIdSecTop = protectGroup.getUuid() + "SecondaryTop" + "---" + "Style:unvisible";
        Node verticalStyleNodeSecTop = (Node)context.getElementBox().getDataByID((Object)verticalStyleNodeIdSecTop);
        if (verticalStyleNodeSecTop == null) {
            verticalStyleNodeSecTop = TopoServiceUtil.createUnVisibleStorageNode(context, protectGroup.getUuid() + "SecondaryTop" + "---" + "Style");
            verticalStyleNodeSecTop.setClient("layout", (Object)"leftright");
            context.addChild((IData)verticalStyleNodeMajor, (IData)verticalStyleNodeSecTop);
        }
        String verticalStyleNodeIdSecBottom = protectGroup.getUuid() + "SecondaryBottom" + "---" + "Style:unvisible";
        Node verticalStyleNodeSecBottom = (Node)context.getElementBox().getDataByID((Object)verticalStyleNodeIdSecBottom);
        if (verticalStyleNodeSecBottom == null) {
            verticalStyleNodeSecBottom = TopoServiceUtil.createUnVisibleStorageNode(context, protectGroup.getUuid() + "SecondaryBottom" + "---" + "Style");
            verticalStyleNodeSecBottom.setClient("layout", (Object)"leftright");
            context.addChild((IData)verticalStyleNodeMajor, (IData)verticalStyleNodeSecBottom);
        }
        return verticalStyleNodeMajor;
    }

    private void setVirtualMoreNodeSize(TopoContext context) {
        if (context.getProtectGroup().getPoType() != 10) {
            return;
        }
        try {
            List allDatas = context.getElementBox().getDatas();
            for (Data eachData : allDatas) {
                if (null == eachData.getID() || !String.valueOf(eachData.getID()).contains("subNetwork:more:")) continue;
                ((SubNetwork)eachData).setSize(48.0, 15.0);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("unable to setVirtualMoreNodeSize" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786986L);
        }
    }

    private List<String> getErrorResults(long code) {
        ArrayList<String> results = new ArrayList<String>();
        ITopoResourceManager manager = TopoContext.getTopoResourceManager();
        results.add("error");
        results.add(manager.getText("ism.drm.topo.err.msg.title"));
        results.add(manager.getErrText("lego.err." + code));
        results.add("false");
        results.add("false");
        results.add("--");
        return results;
    }

    private void unbind(String type) {
        this.builders.remove(type);
    }

    static {
        TopoUtil.registerGlobalClientCommonPropties();
        SerializationSettings.registerGlobalClient((String)"protectGroupRelocation", (String)"boolean");
        SerializationSettings.registerGlobalClient((String)"recoveryHostFlag", (String)"boolean");
        SerializationSettings.registerGlobalClient((String)"topoHostName", (String)"string");
        SerializationSettings.registerGlobalClient((String)"siteID", (String)"string");
        SerializationSettings.registerGlobalClient((String)"srcSiteID", (String)"string");
        SerializationSettings.registerGlobalClient((String)"srcSiteName", (String)"string");
        SerializationSettings.registerGlobalClient((String)"topoSiteName", (String)"string");
        SerializationSettings.registerGlobalClient((String)"clusterSn", (String)"string");
        SerializationSettings.registerGlobalClient((String)"isHyperMetro", (String)"boolean");
        SerializationSettings.registerGlobalClient((String)"isHyperMetroSnap", (String)"boolean");
        SerializationSettings.registerGlobalClient((String)"hyperMetroSnapOffset", (String)"number");
        SerializationSettings.registerGlobalClient((String)"transferNode", (String)"true");
    }
}

