/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.service.impl;

import com.huawei.ism.array.sdk.model.HvsStorage;
import com.huawei.ism.array.sdk.model.StorageArray;
import com.huawei.ism.array.sdk.model.XveStorage;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.topo.poll.SitePollTask;
import com.huawei.ism.drm.topo.poll.TopoPollTask;
import com.huawei.ism.drm.topo.sdk.manager.ITopoPollerManager;
import com.huawei.ism.drm.topo.sdk.model.Topo;
import com.huawei.ism.drm.topo.sdk.poll.ITopoPoller;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.springframework.dao.DataAccessException;

public class TopoPollerManagerImpl
extends BaseService
implements ITopoPollerManager {
    private static final String TYPE_KEY = "type";
    private static final String HOST_MAIN_TYPE = "ism.drm.deviceType.drhost.mainType";
    private static final String STRORAGE_MAIN_TYPE = "ism.deviceType.storage.mainType";
    private static final String VSPHERE_MAIN_TYPE = "ism.drm.deviceType.drvsphere.mainType";
    private static final String FSPHERE_MAIN_TYPE = "ism.drm.deviceType.fusionsphere.mainType";
    private static final String VRG_MAIN_TYPE = "ism.drm.deviceType.vrg.mainType";
    private static final int POLL_PERIOD_TWO_MINUTE = 120;
    private static final String STR_POLL_PERIOD_TWO_MINUTE = "120";
    private static final Log logger = LogFactory.getInstance(TopoPollerManagerImpl.class);
    private static TopoPollerManagerImpl connMgr = new TopoPollerManagerImpl();
    private static ExecutorService executorService;
    private static TopoConnPoolChecker connPoolChecker;
    private static Map<String, ITopoPoller> pollers;

    public ITopoPoller getTopoPoller(String type) {
        return pollers.get(type);
    }

    private TopoPollerManagerImpl() {
    }

    public static synchronized TopoPollerManagerImpl getInstance() {
        return connMgr;
    }

    public void onBind(ITopoPoller builder, Map<String, Object> props) {
        block4: {
            Object type;
            block5: {
                block3: {
                    if (null == props) {
                        logger.debug((Object)"param props is null,no onbind.");
                        return;
                    }
                    type = props.get(TYPE_KEY);
                    if (!(type instanceof String)) break block3;
                    pollers.put((String)type, builder);
                    break block4;
                }
                if (!(type instanceof String[])) break block5;
                for (String each : (String[])type) {
                    pollers.put(each, builder);
                }
                break block4;
            }
            if (!(type instanceof Collection)) break block4;
            for (Object each : (Collection)type) {
                pollers.put(each.toString(), builder);
            }
        }
    }

    public void onUnbind(ITopoPoller poller, Map<String, Object> props) {
        block3: {
            Object type;
            block4: {
                block2: {
                    type = props.get(TYPE_KEY);
                    if (!(type instanceof String)) break block2;
                    this.unbind((String)type, poller);
                    break block3;
                }
                if (!(type instanceof String[])) break block4;
                for (String each : (String[])type) {
                    this.unbind(each, poller);
                }
                break block3;
            }
            if (!(type instanceof Collection)) break block3;
            for (Object each : (Collection)type) {
                this.unbind(each.toString(), poller);
            }
        }
    }

    private void unbind(String type, ITopoPoller poller) {
        if (poller.equals(pollers.get(type))) {
            pollers.remove(type);
        }
    }

    static {
        pollers = new HashMap<String, ITopoPoller>();
        connPoolChecker = new TopoConnPoolChecker();
        executorService = Executors.newSingleThreadExecutor();
        executorService.execute(connPoolChecker);
    }

    static class TopoConnPoolChecker
    implements Runnable {
        private static final long SLEEP_TIME = 30000L;
        private static final long SLEEP_INTERVAL_TIME = 30000L;
        private static final boolean CYCLE_FLAG = true;
        private static final long TOTAL_MILLIS_OF_EVERY_SEC = 1000L;
        private static final long DEFAULT_CONN_CHECK_INTERVAL = 120000L;
        private static final long DEFAULT_STARTUP_WAIT = 300000L;
        private static final String XVE_TYPE = XveStorage.class.getName();
        private static final String HVS_TYPE = HvsStorage.class.getName();
        private static final String TV1_TYPE = StorageArray.class.getName();
        private static ExecutorService executorService = Executors.newCachedThreadPool();
        private static boolean changeflag = false;
        private static List<String> executorLists = new ArrayList<String>();
        private static Map<String, TopoPollTask> executorListMaps = new HashMap<String, TopoPollTask>();
        private static List<String> allNeSnList = new ArrayList<String>();
        private static long connCheckIntervalTime = 120000L;
        private static int sleepNum = (int)(connCheckIntervalTime / 30000L);
        private static SitePollTask sitePollTask = new SitePollTask();
        private static Object syncObj = new Object();
        private String topoTimeIndexId = "1000002";

        TopoConnPoolChecker() {
        }

        public static void setConnCheckIntervalTime(long connTime) {
            try {
                connCheckIntervalTime = connTime * 1000L;
                sleepNum = (int)(connCheckIntervalTime / 30000L);
                changeflag = true;
                if (sitePollTask != null) {
                    sitePollTask.setConnCheckIntervalTime(connCheckIntervalTime);
                }
            }
            catch (Exception e) {
                connCheckIntervalTime = 120000L;
                sleepNum = (int)(connCheckIntervalTime / 30000L);
                changeflag = false;
                if (sitePollTask != null) {
                    sitePollTask.setConnCheckIntervalTime(connCheckIntervalTime);
                }
                logger.error((Object)("setConnCheckIntervalTime error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CommUtil.pauseThread((long)300000L);
                Object object = syncObj;
                synchronized (object) {
                    connCheckIntervalTime = (long)this.getPollPeriod() * 1000L;
                    sleepNum = (int)(connCheckIntervalTime / 30000L);
                }
            }
            catch (Exception e) {
                connCheckIntervalTime = 120000L;
                sleepNum = (int)(connCheckIntervalTime / 30000L);
                logger.error((Object)("get ConnCheckIntervalTime error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            try {
                if (sitePollTask == null) {
                    sitePollTask = new SitePollTask();
                }
                sitePollTask.setConnCheckIntervalTime(connCheckIntervalTime);
                Future<?> future = executorService.submit(sitePollTask);
                if (null == future) {
                    logger.error((Object)"future is null", 90160758784001L);
                }
            }
            catch (Exception e) {
                logger.error((Object)("SitePollTask start error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            while (true) {
                try {
                    while (true) {
                        this.startSitePollTask();
                        this.pollTopoObject();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("CYCLE error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                    continue;
                }
                break;
            }
        }

        private synchronized void startSitePollTask() {
            try {
                if (sitePollTask == null) {
                    sitePollTask = new SitePollTask();
                    sitePollTask.setConnCheckIntervalTime(connCheckIntervalTime);
                    Future<?> future = executorService.submit(sitePollTask);
                    if (null == future) {
                        logger.error((Object)"future is null", 90160758784001L);
                    }
                }
            }
            catch (Exception e) {
                if (sitePollTask != null) {
                    sitePollTask.setCycle(false);
                }
                sitePollTask = null;
                logger.error((Object)("SitePollTask start error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
        }

        private void pollTopoObject() {
            try {
                allNeSnList.clear();
                List<NetworkEntity> topoNEs = this.getAllTopoObject();
                if (topoNEs == null || topoNEs.isEmpty()) {
                    this.clearTaskIfNeNotExsit();
                    CommUtil.pauseThread((long)30000L);
                    return;
                }
                List<StorageNE> allStorages = this.getAllStorageNE();
                for (NetworkEntity tpNE : topoNEs) {
                    this.checkConnection(tpNE, allStorages);
                }
                this.clearTaskIfNeNotExsit();
                changeflag = false;
                this.waitForSleep();
            }
            catch (Exception e) {
                logger.error((Object)("Checking error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
        }

        private void clearTaskIfNeNotExsit() {
            Iterator<String> it = executorLists.iterator();
            while (it.hasNext()) {
                String taskSn = it.next();
                if (allNeSnList.contains(taskSn)) continue;
                TopoPollTask pollTask = executorListMaps.get(taskSn);
                if (null == pollTask) {
                    logger.info((Object)("pollTask is null: " + taskSn), 1L);
                    return;
                }
                pollTask.setCycle(false);
                executorListMaps.remove(taskSn);
                it.remove();
            }
        }

        private void waitForSleep() throws InterruptedException {
            for (int i = 0; i < sleepNum && !changeflag; ++i) {
                CommUtil.pauseThread((long)30000L);
            }
        }

        private void checkConnection(NetworkEntity tpNE, List<StorageNE> allStorages) {
            try {
                String mainType = tpNE.getMainType();
                String devSn = tpNE.getSn();
                allNeSnList.add(devSn);
                if (executorLists.contains(devSn)) {
                    this.setTaskInfoWhenChangeFlagTrue(devSn);
                    return;
                }
                ITopoPoller topoPoller = null;
                TopoPollTask pollTask = new TopoPollTask();
                if (TopoPollerManagerImpl.HOST_MAIN_TYPE.equals(mainType)) {
                    topoPoller = (ITopoPoller)pollers.get("topoPoller-host");
                    pollTask.setSourceType("host");
                    pollTask.setIpAddress(tpNE.getIpAddress());
                    pollTask.setSourceSN(devSn);
                } else if (TopoPollerManagerImpl.STRORAGE_MAIN_TYPE.equals(mainType)) {
                    topoPoller = this.getPollerByStorageType(tpNE, allStorages, pollTask);
                } else if (TopoPollerManagerImpl.VSPHERE_MAIN_TYPE.equals(mainType)) {
                    topoPoller = (ITopoPoller)pollers.get("topoPoller-vsphere");
                    pollTask.setSourceType("vsphere");
                    pollTask.setIpAddress(tpNE.getIpAddress());
                    pollTask.setSourceSN(devSn);
                } else if (TopoPollerManagerImpl.FSPHERE_MAIN_TYPE.equals(mainType)) {
                    topoPoller = (ITopoPoller)pollers.get("topoPoller-fusionsphere-cloud");
                    pollTask.setSourceType("fsphere");
                    pollTask.setIpAddress(tpNE.getIpAddress());
                    pollTask.setSourceSN(devSn);
                } else if (TopoPollerManagerImpl.VRG_MAIN_TYPE.equals(mainType)) {
                    topoPoller = (ITopoPoller)pollers.get("topoPoller-fusionsphere-vrg");
                    pollTask.setSourceType("vrg");
                    pollTask.setIpAddress(tpNE.getIpAddress());
                    pollTask.setSourceSN(devSn);
                }
                if (topoPoller != null) {
                    pollTask.setTopoPoller(topoPoller);
                    pollTask.setConnCheckIntervalTime(connCheckIntervalTime);
                    Future<?> future = executorService.submit(pollTask);
                    if (null == future) {
                        logger.error((Object)"future is null", 90160758784001L);
                    }
                    executorLists.add(devSn);
                    executorListMaps.put(devSn, pollTask);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Checking error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
        }

        private void setTaskInfoWhenChangeFlagTrue(String devSn) {
            TopoPollTask pollTask;
            if (changeflag && null != (pollTask = executorListMaps.get(devSn))) {
                pollTask.setConnCheckIntervalTime(connCheckIntervalTime);
            }
        }

        private ITopoPoller getPollerByStorageType(NetworkEntity tpNE, List<StorageNE> allStorages, TopoPollTask pollTask) {
            ITopoPoller topoPoller = null;
            StorageNE storage = this.getStorageBySn(allStorages, tpNE.getSn());
            if (null == storage) {
                return null;
            }
            String storageName = storage.getClass().getName();
            if (storageName.equalsIgnoreCase(XVE_TYPE)) {
                topoPoller = (ITopoPoller)pollers.get("topoPoller-storage-xve");
                pollTask.setSourceType("storage-xve");
            } else if (storageName.equalsIgnoreCase(HVS_TYPE)) {
                topoPoller = (ITopoPoller)pollers.get("topoPoller-storage-hvs");
                pollTask.setSourceType("storage-hvs");
            } else if (storageName.equalsIgnoreCase(TV1_TYPE)) {
                topoPoller = (ITopoPoller)pollers.get("topoPoller-storage-tv1");
                pollTask.setSourceType("storage-tv1");
            } else if (storageName.contains("com.huawei.ism.vis.sdk.model.VisStorage")) {
                topoPoller = (ITopoPoller)pollers.get("topoPoller-storage-vis");
                pollTask.setSourceType("storage-vis");
            }
            pollTask.setIpAddress(tpNE.getIpAddress());
            pollTask.setSourceSN(tpNE.getSn());
            return topoPoller;
        }

        private StorageNE getStorageBySn(List<StorageNE> allStorages, String devSn) {
            if (allStorages == null || allStorages.isEmpty()) {
                return null;
            }
            for (StorageNE storage : allStorages) {
                if (!devSn.equalsIgnoreCase(storage.getSn())) continue;
                return storage;
            }
            return null;
        }

        private int getPollPeriod() {
            int topoPeriod = 120;
            try {
                topoPeriod = Integer.parseInt(this.getTopoPeriod());
            }
            catch (NumberFormatException e) {
                topoPeriod = 120;
                logger.error((Object)"unable to get poll period", (Throwable)e, 90160758786986L);
            }
            return topoPeriod;
        }

        private String getTopoPeriod() {
            String topoPeriod = TopoPollerManagerImpl.STR_POLL_PERIOD_TWO_MINUTE;
            try {
                Topo topoInfo = (Topo)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Topo.class, (Serializable)((Object)this.topoTimeIndexId));
                if (topoInfo != null) {
                    topoPeriod = topoInfo.getTopoDetail();
                }
            }
            catch (DataAccessException ex) {
                logger.error((Object)"unable to get sites", (Throwable)ex, 90160758786873L);
            }
            return topoPeriod;
        }

        private List<StorageNE> getAllStorageNE() {
            ArrayList<StorageNE> nes = null;
            try {
                nes = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from StorageNE", new Object[0]);
            }
            catch (LegoCheckedException ex) {
                nes = new ArrayList();
                logger.error((Object)"getAllStorageNE Exception.", (Throwable)ex, 90160758787071L);
            }
            catch (Exception ex) {
                nes = new ArrayList();
                logger.error((Object)("getAllStorageNE Error." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758787071L);
            }
            return nes;
        }

        private List<NetworkEntity> getAllTopoObject() {
            ArrayList<NetworkEntity> nes = null;
            try {
                nes = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from NetworkEntity", new Object[0]);
            }
            catch (LegoCheckedException ex) {
                nes = new ArrayList();
                logger.error((Object)"getAllTopoObject Exception.", (Throwable)ex, 90160758787071L);
            }
            catch (Exception ex) {
                nes = new ArrayList();
                logger.error((Object)("getAllTopoObject Error." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758787071L);
            }
            return nes;
        }
    }
}

