/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.constant;

import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.List;

public final class DrmEnumDefine {
    private DrmEnumDefine() {
    }

    public static enum CONSISTENT_TYPE_ENUM {
        UNKNOWN(-1),
        CRASH_CONSISTENT(0),
        APP_CONSISTENT(1);

        private Integer type;

        private CONSISTENT_TYPE_ENUM(Integer type) {
            this.type = type;
        }

        public Integer getType() {
            return this.type;
        }

        public static CONSISTENT_TYPE_ENUM getType(Integer value) {
            for (CONSISTENT_TYPE_ENUM type : CONSISTENT_TYPE_ENUM.values()) {
                if (!type.getType().equals(value)) continue;
                return type;
            }
            return UNKNOWN;
        }
    }

    public static enum RECOVERY_TARGET_TYPE {
        HOST_WITH_AGENT("HostWithAgent"),
        CLOUD_SERVER("CloudServer"),
        STORAGE("Storage");

        private String type;

        private RECOVERY_TARGET_TYPE(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static RECOVERY_TARGET_TYPE getType(String value) {
            for (RECOVERY_TARGET_TYPE type : RECOVERY_TARGET_TYPE.values()) {
                if (!type.getType().equals(value)) continue;
                return type;
            }
            return null;
        }
    }

    public static enum ROLE_TYPE {
        DEFAULT(-1),
        PRIORITY(0),
        NONE_PRIORITY(1);

        private int value;

        private ROLE_TYPE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ROLE_TYPE getType(int value) {
            for (ROLE_TYPE type : ROLE_TYPE.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return DEFAULT;
        }
    }

    public static enum RECOVERY_EXTEND_ATTRIBUTES {
        REFACTOR_CONFIGURATION_SUCCESS(0);

        private int value;

        private RECOVERY_EXTEND_ATTRIBUTES(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static RECOVERY_EXTEND_ATTRIBUTES getType(int value) {
            RECOVERY_EXTEND_ATTRIBUTES enumType = null;
            for (RECOVERY_EXTEND_ATTRIBUTES type : RECOVERY_EXTEND_ATTRIBUTES.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }

    public static enum DEVICE_CAPABILITY_E {
        HYPER_CLONE(1),
        HYPER_REPLIATION_RATE(2),
        INVALID(-1);

        private int value;

        private DEVICE_CAPABILITY_E(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static DEVICE_CAPABILITY_E getType(int value) {
            DEVICE_CAPABILITY_E enumType = null;
            for (DEVICE_CAPABILITY_E type : DEVICE_CAPABILITY_E.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }

    public static enum RECOVERY_PLAN_OPERATION_TYPE {
        DISASTER_RECOVERY(RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue()),
        PLANED_MOTION(RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue()),
        DRILLING(RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue()),
        CLEAN_DRILLING(RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING.getValue()),
        SNAPSHOT_ROLLBACK(RECOVERY_PLAN_EXECUTE_TYPE_E.SNAPSHOT_ROLLBACK.getValue()),
        REPROTECT(RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue()),
        SWAP(RECOVERY_PLAN_EXECUTE_TYPE_E.SWAP.getValue()),
        MODIFY_BASIC_INFO(20),
        MOIFY_RECOVERY_SETTING(21),
        EDIT_RECOVERY_PROCESSOR(22),
        DELETE_RECOVERY_PLAN(23),
        MOUNT_REPLICA(RECOVERY_PLAN_EXECUTE_TYPE_E.MOUNT_REPLICA.getValue()),
        UMOUNT_REPLICA(RECOVERY_PLAN_EXECUTE_TYPE_E.UMOUNT_REPLICA.getValue()),
        HOT_MIGRATION(RECOVERY_PLAN_EXECUTE_TYPE_E.HOT_MIGRATION.getValue()),
        VM_ROLLBACK(RECOVERY_PLAN_EXECUTE_TYPE_E.VM_ROLLBACK.getValue());

        private int value;

        private RECOVERY_PLAN_OPERATION_TYPE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static RECOVERY_PLAN_OPERATION_TYPE getType(int value) {
            RECOVERY_PLAN_OPERATION_TYPE enumType = null;
            for (RECOVERY_PLAN_OPERATION_TYPE type : RECOVERY_PLAN_OPERATION_TYPE.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }

    public static enum TRIGGER_STATE_STATUS {
        NORMAL(0),
        PAUSED(1),
        COMPLETE(2),
        ERROR(3),
        BLOCKED(4),
        NONE(5);

        private int status;

        private TRIGGER_STATE_STATUS(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        public static TRIGGER_STATE_STATUS valueOf(int status) {
            TRIGGER_STATE_STATUS result = null;
            for (TRIGGER_STATE_STATUS value : TRIGGER_STATE_STATUS.values()) {
                if (status != value.getStatus()) continue;
                result = value;
                break;
            }
            return result;
        }
    }

    public static enum PROTECT_GROUP_STATUS {
        NORMAL(1),
        DISABLED(0),
        WAITTING(2),
        LOCKED(4),
        INVALID(3),
        RUNNING(5);

        private int status;

        private PROTECT_GROUP_STATUS(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        public static PROTECT_GROUP_STATUS valueOf(int status) {
            PROTECT_GROUP_STATUS result = null;
            for (PROTECT_GROUP_STATUS value : PROTECT_GROUP_STATUS.values()) {
                if (status != value.getStatus()) continue;
                result = value;
                break;
            }
            return result;
        }
    }

    public static enum PROTECT_LOCATION {
        PL_A(0),
        PL_A_B(1),
        PL_A_C(2),
        PL_B_C(3),
        PL_B(4),
        PL_C(5);

        private int value;

        private PROTECT_LOCATION(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static PROTECT_LOCATION getType(int value) {
            PROTECT_LOCATION enumType = null;
            for (PROTECT_LOCATION type : PROTECT_LOCATION.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }

        public static PROTECT_LOCATION getValueOf(int value) {
            PROTECT_LOCATION enumType = null;
            for (PROTECT_LOCATION type : PROTECT_LOCATION.values()) {
                if (type.value != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }

    public static enum ExecTypeEnum {
        AUTO(0),
        MANUAL(1);

        private final int type;

        private ExecTypeEnum(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public static ExecTypeEnum getExecType(int value) {
            ExecTypeEnum execTypeEnum = null;
            for (ExecTypeEnum type : ExecTypeEnum.values()) {
                if (type.getType() != value) continue;
                execTypeEnum = type;
                break;
            }
            return execTypeEnum;
        }
    }

    public static enum UnitTypeEnum {
        DAY(46),
        MONTH(47),
        YEAR(48);

        private final int type;

        private UnitTypeEnum(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public static UnitTypeEnum getUnitTypeEnum(int value) {
            UnitTypeEnum unitType = null;
            for (UnitTypeEnum type : UnitTypeEnum.values()) {
                if (type.getType() != value) continue;
                unitType = type;
                break;
            }
            return unitType;
        }
    }

    public static enum PROVIDER_TYPE_E {
        STORAGE_DEVICE(0),
        HOST(1),
        HOSTGROUP(2),
        CLOUD_PLATFORM(3);

        private int value;

        private PROVIDER_TYPE_E(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static PROVIDER_TYPE_E getType(int value) {
            PROVIDER_TYPE_E enumType = null;
            for (PROVIDER_TYPE_E type : PROVIDER_TYPE_E.values()) {
                if (value != type.getValue()) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }

    public static enum RECOVERY_PLAN_TYPE_E {
        LOCAL(1),
        REMOTE(2);

        private int value;

        private RECOVERY_PLAN_TYPE_E(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static RECOVERY_PLAN_TYPE_E getType(int value) {
            RECOVERY_PLAN_TYPE_E enumType = null;
            for (RECOVERY_PLAN_TYPE_E type : RECOVERY_PLAN_TYPE_E.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }

    public static enum REPLICA_STATUS {
        UNACTIVE_STATUS(0),
        ACTIVE_STATUS(1),
        ERROR_STATUS(3);

        private int value;

        private REPLICA_STATUS(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static REPLICA_STATUS getType(int value) {
            for (REPLICA_STATUS type : REPLICA_STATUS.values()) {
                if (value != type.getValue()) continue;
                return type;
            }
            return null;
        }
    }

    public static enum STORAGE_TYPE_E {
        UNKNOWN(-1),
        NORMAL(0),
        PRIMAL(1),
        ASM_LIB(2),
        ASM_PRIMAL(3),
        ASM_LINK(4),
        ASM_UDEV(5),
        ASM_WINDOWS(6);

        private int value;

        private STORAGE_TYPE_E(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static STORAGE_TYPE_E getType(int value) {
            STORAGE_TYPE_E enumType = null;
            for (STORAGE_TYPE_E type : STORAGE_TYPE_E.values()) {
                if (value != type.getValue()) continue;
                enumType = type;
            }
            return enumType;
        }
    }

    public static enum RESOURCE_TYPE_E {
        LUN(1),
        VIS(2),
        NAS(3);

        private int value;

        private RESOURCE_TYPE_E(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static RESOURCE_TYPE_E getType(int value) {
            RESOURCE_TYPE_E enumType = null;
            for (RESOURCE_TYPE_E type : RESOURCE_TYPE_E.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
            }
            return enumType;
        }
    }

    public static enum CLUSTER_TYPE_E {
        ORACLE_RAC(1),
        DB2_VCS(2),
        SQL_SERVER_MSFC(3),
        DB2_HACMP(4);

        private int clusterType = 0;
        private static final int ILLEGAL_APP_TYPE = -1;

        private CLUSTER_TYPE_E(int type) {
            this.clusterType = type;
        }

        public int getValue() {
            return this.clusterType;
        }

        public static CLUSTER_TYPE_E getType(int value) {
            CLUSTER_TYPE_E enumType = null;
            for (CLUSTER_TYPE_E type : CLUSTER_TYPE_E.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
            }
            return enumType;
        }

        public static int getAppType(int value) {
            CLUSTER_TYPE_E enumType = CLUSTER_TYPE_E.getType(value);
            if (VerifyUtil.isEmpty((Object)((Object)enumType))) {
                return -1;
            }
            if (enumType == ORACLE_RAC) {
                return enumType.getValue();
            }
            if (enumType == DB2_VCS || enumType == DB2_HACMP) {
                return 3;
            }
            if (enumType == SQL_SERVER_MSFC) {
                return 2;
            }
            return -1;
        }
    }

    public static enum REPORT_TIME_RANGE_E {
        LAST_THREE_MONTHS(7776000L),
        LAST_ONE_MONTH(2592000L),
        LAST_HALF_YEAR(15552000L),
        LAST_ONE_YEAR(31536000L),
        LAST_24_HOURS(86400L),
        LAST_ONE_DAY(86400L),
        LAST_THREE_DAYS(259200L),
        LAST_SEVEN_DAYS(604800L),
        LAST_30_DAYS(2592000L),
        ALL_TIME(-1L);

        private long value = 0L;

        private REPORT_TIME_RANGE_E(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value * 1000L;
        }
    }

    public static enum PROTECT_OBJECT_RECOVERY_STATUS_E {
        NOT_STARTED(0),
        COMPLETED(1),
        FAILED(2),
        RUNNING(3);

        private int value;

        private PROTECT_OBJECT_RECOVERY_STATUS_E(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static PROTECT_OBJECT_RECOVERY_STATUS_E getType(int value) {
            PROTECT_OBJECT_RECOVERY_STATUS_E enumType = null;
            for (PROTECT_OBJECT_RECOVERY_STATUS_E type : PROTECT_OBJECT_RECOVERY_STATUS_E.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }

    public static enum APP_TYPE {
        Oracle(1),
        SqlServer(2),
        DB2(3),
        FileSystem(9),
        VM(10),
        LUN(11),
        EXCHANGE(8),
        GALAX_VM(12),
        EXCHANGE2007(13),
        NAS_FILESYSTEM(14),
        CACHE(15),
        SAPHANA(16);

        private int value;

        private APP_TYPE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static APP_TYPE getType(int value) {
            if (99 == value) {
                return LUN;
            }
            if (101 == value) {
                return NAS_FILESYSTEM;
            }
            APP_TYPE enumType = null;
            for (APP_TYPE type : APP_TYPE.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }

        public static APP_TYPE getValueOf(int value) {
            APP_TYPE enumType = null;
            for (APP_TYPE type : APP_TYPE.values()) {
                if (type.value != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }

    public static enum InitiatorType {
        FC,
        ISCSI,
        SAS;


        public String getName() {
            return this.name();
        }
    }

    public static enum RECOVERY_PLAN_EXECUTE_TYPE_E {
        DISASTER_RECOVERY(0, RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_RUNNING.getValue(), RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED.getValue(), RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_FAILED.getValue()),
        PLANED_MOTION(1, RECOVERY_PLAN_STATUS_E.PLANED_MOTION_RUNNING.getValue(), RECOVERY_PLAN_STATUS_E.PLANED_MOTION_COMPLETED.getValue(), RECOVERY_PLAN_STATUS_E.PLANED_MOTION_FAILED.getValue()),
        DRILLING(2, RECOVERY_PLAN_STATUS_E.TEST_RUNNING.getValue(), RECOVERY_PLAN_STATUS_E.TEST_COMPLETED.getValue(), RECOVERY_PLAN_STATUS_E.TEST_FAILED.getValue()),
        CLEAN_DRILLING(3, RECOVERY_PLAN_STATUS_E.CLEAN_RUNNING.getValue(), RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED.getValue(), RECOVERY_PLAN_STATUS_E.CLEAN_FAILED.getValue()),
        SNAPSHOT_ROLLBACK(4, RECOVERY_PLAN_STATUS_E.ROLLBACK_RUNNING.getValue(), RECOVERY_PLAN_STATUS_E.ROLLBACK_COMPLETED.getValue(), RECOVERY_PLAN_STATUS_E.ROLLBACK_FAILED.getValue()),
        REPROTECT(7, RECOVERY_PLAN_STATUS_E.REPROTECT_RUNNING.getValue(), RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED.getValue(), RECOVERY_PLAN_STATUS_E.REPROTECT_FAILED.getValue()),
        SWAP(8, RECOVERY_PLAN_STATUS_E.SWAP_RUNNING.getValue(), RECOVERY_PLAN_STATUS_E.READY.getValue(), RECOVERY_PLAN_STATUS_E.SWAP_FAILED.getValue()),
        MOUNT_REPLICA(9, RECOVERY_PLAN_STATUS_E.MOUNTING_REPLICA.getValue(), RECOVERY_PLAN_STATUS_E.MOUNT_COMPLETED.getValue(), RECOVERY_PLAN_STATUS_E.MOUNT_FAILED.getValue()),
        UMOUNT_REPLICA(10, RECOVERY_PLAN_STATUS_E.UMOUNTING_REPLICA.getValue(), RECOVERY_PLAN_STATUS_E.UMOUNT_COMPLETED.getValue(), RECOVERY_PLAN_STATUS_E.UMOUNT_FAILED.getValue()),
        HOT_MIGRATION(11, RECOVERY_PLAN_STATUS_E.HOT_MIGRATION_RUNNING.getValue(), RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED.getValue(), RECOVERY_PLAN_STATUS_E.HOT_MIGRATION_FAILED.getValue()),
        VM_ROLLBACK(12, RECOVERY_PLAN_STATUS_E.VM_ROLLBACK_RUNNING.getValue(), RECOVERY_PLAN_STATUS_E.VM_ROLLBACK_COMPLETED.getValue(), RECOVERY_PLAN_STATUS_E.VM_ROLLBACK_FAILED.getValue());

        private int planRunningStatus;
        private int value;
        private int planSuccessStatus;
        private int planFailedStatus;

        private RECOVERY_PLAN_EXECUTE_TYPE_E(int value, int planRunningStatus, int planSuccessStatus, int planFailedStatus) {
            this.value = value;
            this.planRunningStatus = planRunningStatus;
            this.planSuccessStatus = planSuccessStatus;
            this.planFailedStatus = planFailedStatus;
        }

        public int getPlanRunningStatus() {
            return this.planRunningStatus;
        }

        public int getValue() {
            return this.value;
        }

        public int getPlanSuccessStatus() {
            return this.planSuccessStatus;
        }

        public int getPlanFailedStatus() {
            return this.planFailedStatus;
        }

        public static RECOVERY_PLAN_EXECUTE_TYPE_E getType(int value) {
            RECOVERY_PLAN_EXECUTE_TYPE_E enumType = null;
            for (RECOVERY_PLAN_EXECUTE_TYPE_E type : RECOVERY_PLAN_EXECUTE_TYPE_E.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }

    public static enum RECOVERY_PLAN_EXECUTE_RESULT_E {
        SUCCESS(0),
        FAILED(1),
        PART_SUCCESS(2),
        RUNNING(3),
        OTHER(-1);

        private int value;

        private RECOVERY_PLAN_EXECUTE_RESULT_E(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static RECOVERY_PLAN_EXECUTE_RESULT_E getType(int value) {
            RECOVERY_PLAN_EXECUTE_RESULT_E enumType = null;
            for (RECOVERY_PLAN_EXECUTE_RESULT_E type : RECOVERY_PLAN_EXECUTE_RESULT_E.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }

    public static enum RECOVERY_PLAN_STATUS_E {
        READY(0, Arrays.asList(0, 1)),
        PLANED_MOTION_RUNNING(1, 3),
        PLANED_MOTION_COMPLETED(2, Arrays.asList(7)),
        PLANED_MOTION_FAILED(3),
        DISASTER_RECOVERY_RUNNING(10, 12),
        DISASTER_RECOVERY_COMPLETED(11),
        DISASTER_RECOVERY_FAILED(12),
        TEST_RUNNING(4, 6),
        TEST_COMPLETED(5, Arrays.asList(3)),
        TEST_FAILED(6, Arrays.asList(3)),
        CLEAN_RUNNING(7, 9),
        CLEAN_COMPLETED(8, Arrays.asList(2)),
        CLEAN_FAILED(9),
        ROLLBACK_RUNNING(15, 18),
        ROLLBACK_FAILED(18),
        ROLLBACK_COMPLETED(19),
        REPROTECT_FAILED(16),
        REPROTECT_RUNNING(17, 16),
        REPROTECT_COMPLETED(20),
        SWAP_RUNNING(21, 22),
        SWAP_FAILED(22),
        MOUNTING_REPLICA(23, 25),
        UMOUNTING_REPLICA(24, 28),
        MOUNT_FAILED(25, Arrays.asList(10)),
        MOUNT_COMPLETED(26, Arrays.asList(10)),
        UMOUNT_COMPLETED(27, Arrays.asList(9)),
        UMOUNT_FAILED(28),
        HOT_MIGRATION_RUNNING(29, 30),
        HOT_MIGRATION_FAILED(30),
        VM_ROLLBACK_RUNNING(31, 32),
        VM_ROLLBACK_FAILED(32),
        VM_ROLLBACK_COMPLETED(33),
        INVALID(-1);

        private int value;
        private List<Integer> cleanExecuteTypes;
        private Integer failStatusWhenRunning;

        private RECOVERY_PLAN_STATUS_E(int value) {
            this.value = value;
        }

        private RECOVERY_PLAN_STATUS_E(int value, List<Integer> cleanExecuteTypes) {
            this.value = value;
            this.cleanExecuteTypes = cleanExecuteTypes;
        }

        private RECOVERY_PLAN_STATUS_E(int value, Integer failStatusWhenRunning) {
            this.value = value;
            this.failStatusWhenRunning = failStatusWhenRunning;
        }

        public int getValue() {
            return this.value;
        }

        public boolean containsExecuteType(int executeType) {
            if (null == this.cleanExecuteTypes) {
                return false;
            }
            return this.cleanExecuteTypes.contains(executeType);
        }

        public Integer getFailStatusWhenRunning() {
            return this.failStatusWhenRunning;
        }

        public static RECOVERY_PLAN_STATUS_E getType(int value) {
            RECOVERY_PLAN_STATUS_E enumType = null;
            for (RECOVERY_PLAN_STATUS_E type : RECOVERY_PLAN_STATUS_E.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }
}

