/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.operation.sdk.model;

import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class OperationResultBill
implements Serializable {
    private static final long serialVersionUID = 4482421185501031500L;
    private boolean hasFailRecord = false;
    private boolean hasSuccessRecord = false;
    private List<OperationResult> allOpResults = new ArrayList<OperationResult>();

    public synchronized void addFailedOperationResult(String operationName, long errorCode, String ... args) {
        this.addOperationResult(new OperationResult(operationName, false, false, String.valueOf(errorCode), args));
    }

    public synchronized void addFailedOperationResult(String operationName, boolean isMainOperation, long errorCode, String ... args) {
        this.addOperationResult(new OperationResult(operationName, isMainOperation, false, String.valueOf(errorCode), args));
    }

    public synchronized void addFailedOperationResult(String operationName, boolean isMainOperation, long errorCode, int level, String ... args) {
        this.addOperationResult(new OperationResult(operationName, isMainOperation, false, String.valueOf(errorCode), level, args));
    }

    public synchronized void addOperationResult(OperationResult result) {
        if (null == result) {
            return;
        }
        this.allOpResults.add(result);
        if (result.isSuccess()) {
            this.hasSuccessRecord = true;
        } else {
            this.hasFailRecord = true;
        }
    }

    public synchronized void addOperationResults(List<OperationResult> list) {
        if (null != list) {
            for (OperationResult operationResult : list) {
                this.addOperationResult(operationResult);
            }
        }
    }

    public synchronized void addSuccessfulOperationResult(String operationName, String ... args) {
        this.addOperationResult(new OperationResult(operationName, false, true, args));
    }

    public synchronized void addSuccessfulOperationResult(String operationName, boolean isMainOperation, String ... args) {
        this.addOperationResult(new OperationResult(operationName, isMainOperation, true, args));
    }

    public synchronized void addSuccessfulOperationResult(String operationName, boolean isMainOperation, int level, String ... args) {
        this.addOperationResult(new OperationResult(operationName, isMainOperation, true, level, args));
    }

    public synchronized String getBillResult() {
        String result = "success";
        if (this.hasFailRecord) {
            result = "failed";
        }
        return result;
    }

    public synchronized List<OperationResult> getOperationResults() {
        ArrayList<OperationResult> list = new ArrayList<OperationResult>();
        list.addAll(this.allOpResults);
        return list;
    }

    public synchronized int getOperationResultSize() {
        return this.allOpResults.size();
    }

    public synchronized boolean isHasFailRecord() {
        return this.hasFailRecord;
    }

    public synchronized boolean isHasSuccessRecord() {
        return this.hasSuccessRecord;
    }
}

