/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.ism.drm.recovery.task.ICallBackExcuteRecoveryTask;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ServiceBoundInfo(methodName="onBind", targetBeanName="recoveryProcessMgr")
public interface IRecoveryProcessProvider {
    public List<String> getAppType();

    public Map<Integer, Class<? extends RecoveryProcessor>> registerSyncProcessor();

    public RecoveryProcessDefinition getRecoveryProcess(RecoveryPlan var1, String var2, DrmEnumDefine.APP_TYPE var3, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E var4, ProtectGroup var5);

    public Set<RecoveryProcessDefinition> getRecoveryProcesses(RecoveryPlan var1, DrmEnumDefine.APP_TYPE var2, ProtectGroup var3);

    public int getProtectionType(ProtectGroup var1);

    public void resetRecoveryProcessDefinition(RecoveryPlan var1, RecoveryProcessDefinition var2, boolean var3);

    public void enableRecoverySyncProcessor(RecoveryProcessDefinition var1, boolean var2);

    public void disableRecoverySyncProcessor(RecoveryProcessDefinition var1, boolean var2);

    public void updateRecoveryProcessorEnableStatus(RecoveryProcessDefinition var1, List<Class<? extends RecoveryProcessor>> var2, boolean var3);

    public void setRecoveryProcessorEnableStatus(RecoveryProcessDefinition var1, List<Class<? extends RecoveryProcessor>> var2, boolean var3);

    public void insertRecoveryProcessors(RecoveryProcessDefinition var1, Class<? extends RecoveryProcessor> var2, List<Class<? extends RecoveryProcessor>> var3, boolean var4, boolean var5);

    public void insertRecoveryProcessors(RecoveryProcessDefinition var1, Class<? extends RecoveryProcessor> var2, RecoveryProcessor var3, boolean var4, boolean var5);

    public void insertRecoveryProcessors(RecoveryProcessDefinition var1, RecoveryProcessor var2, RecoveryProcessor var3, boolean var4, boolean var5);

    @Deprecated
    public String addCustomRecoveryProcessor(RecoveryProcessDefinition var1, Class<? extends RecoveryProcessor> var2, Map<String, Object> var3, boolean var4, boolean var5);

    public String addCustomRecoveryProcessor(RecoveryProcessDefinition var1, RecoveryProcessor var2, Map<String, Object> var3, boolean var4, boolean var5);

    public void modifyCustomRecoveryProcessor(RecoveryProcessDefinition var1, String var2, Map<String, Object> var3);

    public Map<String, Object> getCustomRecoveryProcessorInfos(RecoveryProcessDefinition var1, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E var2, String var3);

    public void deleteRecoveryProcessors(RecoveryProcessDefinition var1, List<Class<? extends RecoveryProcessor>> var2, boolean var3);

    public void deleteRecoveryProcessors(RecoveryProcessDefinition var1, String var2, boolean var3);

    public void replaceRecoveryProcessor(RecoveryProcessDefinition var1, Class<? extends RecoveryProcessor> var2, Class<? extends RecoveryProcessor> var3, List<Class<? extends RecoveryProcessor>> var4, boolean var5, boolean var6);

    public boolean isSuitableProtectGroup(DrmEnumDefine.RECOVERY_PLAN_TYPE_E var1, ProtectGroup var2);

    public void checkIfAllowReprotect(RecoveryPlan var1);

    public void checkIfAllowRollBack(RecoveryPlan var1);

    public boolean checkProductionBusinessStopped(RecoveryProcessorContext var1);

    public Map<String, Object> checkRecoveryContext(String var1, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E var2, Map<String, String> var3, User var4);

    public Class<? extends RecoveryProcessor> getCustomRecoveryProcessorClass();

    public boolean checkIfAllowDelete(RecoveryProcessor var1);

    public String getRecoverySiteId(String var1, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E var2, Map<String, String> var3);

    public String getRecoverySiteId(RecoveryPlan var1, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E var2, Map<String, String> var3);

    public void encryptProperties(RecoveryPlan var1);

    public void decryptPropreties(RecoveryPlan var1);

    public void checkRecoverySettings(List<RecoverySetting> var1);

    public List<RecoveryProcessor> filterProcessor(List<RecoveryProcessor> var1, Map<String, String> var2);

    default public Set<RecoverySetting> getMountRecoverySettings(RecoveryPlan plan, ProtectGroupReplica protectGroupReplica, MountConfiguration mountConfigs) {
        if (null == protectGroupReplica || null == mountConfigs) {
            return new HashSet<RecoverySetting>();
        }
        HashSet<RecoverySetting> results = new HashSet<RecoverySetting>();
        Set<ProtectObjectReplica> protectObjectReplicaSet = protectGroupReplica.getReplicas();
        for (ProtectObjectReplica replica : protectObjectReplicaSet) {
            RecoverySetting startAppSetting = new RecoverySetting();
            startAppSetting.setRecoveryPlan(plan);
            startAppSetting.setOwnerId(replica.getPoId());
            startAppSetting.setName("isStart");
            startAppSetting.setValue(String.valueOf(mountConfigs.isStartDB()));
            results.add(startAppSetting);
            RecoverySetting startOrderSetting = new RecoverySetting();
            startOrderSetting.setRecoveryPlan(plan);
            startOrderSetting.setOwnerId(replica.getPoId());
            startOrderSetting.setName("startOrder");
            startOrderSetting.setValue("10");
            results.add(startOrderSetting);
        }
        return results;
    }

    default public ICallBackExcuteRecoveryTask getRecoveryCallbackTask(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E executeTypeE) {
        return new ICallBackExcuteRecoveryTask(){

            @Override
            public void afterExecuteRecoveryPlan(RecoveryProcessorContext context, RecoveryPlan recoveryPlan) {
            }

            @Override
            public void beforeExecuteRecoveryPlan(RecoveryProcessorContext context, RecoveryPlan recoveryPlan) {
            }
        };
    }
}

