/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.sdk.twaver;

public class RGB {
    public static final int FULL = 0xFFFFFF;
    public static final int MASK = 255;
    public static final int CHANNELS = 3;
    public static final int BITS = 8;
    private int value;

    public RGB() {
    }

    public RGB(int value) {
        this.setValue(Math.max(value, 0));
    }

    public void setValue(int value) {
        this.value = value & 0xFFFFFF;
    }

    public int getValue() {
        return this.value;
    }

    public RGB color(int v) {
        this.setValue(v);
        return this;
    }

    public int color() {
        return this.value;
    }

    public RGB light(double ratio) {
        return this.light(ratio, false);
    }

    public RGB light(double ratio, boolean create) {
        return this.transform(new RGB(0xFFFFFF), ratio, create);
    }

    public RGB darkle(double ratio) {
        return this.transform(new RGB(), ratio, false);
    }

    public RGB darkle(double ratio, boolean create) {
        return this.transform(new RGB(), ratio, create);
    }

    public RGB transform(RGB rgb, double ratio, boolean create) {
        int color = 0;
        int target = rgb.value;
        ratio = Math.min(Math.max(ratio, 0.0), 1.0);
        for (int i = 0; i < 3; ++i) {
            int offest = i * 8;
            int diff = target >> offest & 0xFF;
            int chanel = this.value >> offest & 0xFF;
            chanel += (int)((double)(diff - chanel) * ratio);
            color |= chanel << offest;
        }
        return (create ? new RGB() : this).color(color);
    }
}

