/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.TimeUtil;
import java.lang.reflect.Method;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CommUtil {
    private static final Log logger = LogFactory.getInstance(CommUtil.class);
    private static final int APM_NAME_PARAM_MIN_SIZE = 4;
    private static final int APM_NAME_PARAM_MAX_SIZE = 256;
    private static final int APM_DESC_PARAM_MAX_SIZE = 255;
    private static final int APM_PORT_PARAM_MAX_SZIE = 65535;
    private static final long MAX_SLEEP_TIME = 3600000L;

    private CommUtil() {
    }

    public static boolean isNullStr(String str) {
        return null == str || str.length() < 1;
    }

    public static String formatDate(Date date) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeContent = dateFormat.format(date);
        String timeZoneStr = " " + TimeUtil.getDefaultTimeZone();
        timeContent = timeContent + timeZoneStr;
        return timeContent;
    }

    public static boolean checkParam(String param, String match, int minSize, int maxSize) {
        if (VerifyUtil.isEmpty((String)param) || VerifyUtil.isEmpty((String)match) || 0 > minSize || 0 > maxSize || minSize > maxSize) {
            StringBuilder sb = new StringBuilder();
            sb.append("check param is error.");
            sb.append(" regEx :");
            sb.append(match);
            sb.append(" minSize :");
            sb.append(minSize);
            sb.append(" maxSize :");
            sb.append(maxSize);
            sb.append(" is error.");
            logger.error((Object)sb.toString(), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (minSize > param.length() || maxSize < param.length()) {
            return false;
        }
        Pattern pat = Pattern.compile(match);
        Matcher mat = pat.matcher(Normalizer.normalize(param, Normalizer.Form.NFKC));
        return mat.matches() && mat.find(0) && 0 <= mat.groupCount();
    }

    public static boolean isBlackListCharacter(String param) {
        String strBlack = "[`'\"\\^&\\(\\)\\|<>\\s]";
        return Pattern.compile(strBlack).matcher(param).find();
    }

    public static boolean checkParam(String param, String match) {
        if (VerifyUtil.isEmpty((String)param) || VerifyUtil.isEmpty((String)match)) {
            StringBuilder sb = new StringBuilder();
            sb.append("check param is error.");
            sb.append(" regEx :");
            sb.append(match);
            sb.append(" is error.");
            logger.error((Object)sb.toString(), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        Pattern pat = Pattern.compile(match);
        Matcher mat = pat.matcher(Normalizer.normalize(param, Normalizer.Form.NFKC));
        return mat.matches() && mat.find(0) && 0 <= mat.groupCount();
    }

    public static boolean checkParam(String param, int minSize, int maxSize) {
        if (VerifyUtil.isEmpty((String)param) || 0 > minSize || 0 > maxSize || minSize > maxSize) {
            StringBuilder sb = new StringBuilder();
            sb.append("check param is error.");
            sb.append(" minSize :");
            sb.append(minSize);
            sb.append(" maxSize :");
            sb.append(maxSize);
            sb.append(" is error.");
            logger.error((Object)sb.toString(), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        return minSize <= param.length() && maxSize >= param.length();
    }

    public static boolean checkParam(String param, int maxSize) {
        if (VerifyUtil.isEmpty((String)param)) {
            StringBuilder sb = new StringBuilder();
            sb.append("check param is error.");
            sb.append(" maxSize :");
            sb.append(maxSize);
            sb.append(" is error.");
            logger.error((Object)sb.toString(), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        return maxSize >= param.length();
    }

    public static boolean checkDrmNameParam(String name) {
        String match = "^[a-zA-Z0-9_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-]*$";
        return CommUtil.checkParam(name, match, 4, 256);
    }

    public static boolean checkDrmNameParamWithOutChinese(String name) {
        String match = "^[a-zA-Z0-9_]{1}[\\w-]*$";
        return CommUtil.checkParam(name, match, 4, 256);
    }

    public static boolean checkDrmIpParam(String ip) {
        if (VerifyUtil.isEmpty((String)ip)) {
            return false;
        }
        return AddressUtil.isIpAddress((String)ip);
    }

    public static boolean checkDrmIpV6Param(String ipv6) {
        if (VerifyUtil.isEmpty((String)ipv6)) {
            return false;
        }
        return Ipv6AddressUtil.isIPv6Address((String)ipv6);
    }

    public static boolean checkDrmDomainParam(String domain) {
        if (VerifyUtil.isEmpty((String)domain)) {
            return false;
        }
        String matchIp = "^(?=^.{3,255}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+$";
        return CommUtil.checkParam(domain, matchIp);
    }

    public static boolean checkDrmPortParam(String portStr) {
        int port = 0;
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            logger.error((Object)("check port is error . parm:" + portStr), (Throwable)e, 90160758786989L);
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
        return port > 0 && 65535 >= port;
    }

    public static boolean checkDrmDescParam(String description) {
        return VerifyUtil.isEmpty((String)description) || CommUtil.checkParam(description, 255);
    }

    public static boolean checkTimeParam(String timeStr) {
        String regTime = "^(([0-1][0-9])|2[0-3]):[0-5][0-9]$";
        return CommUtil.checkParam(timeStr, regTime);
    }

    public static <T> void checkEnumByType(Class<T> classs, int type) {
        block4: {
            if (VerifyUtil.isEmpty(classs) || !classs.isEnum()) {
                throw new LegoCheckedException(1073947393L);
            }
            try {
                Method getTypeMothod = classs.getMethod("getType", Integer.TYPE);
                Object result = getTypeMothod.invoke(null, type);
                if (VerifyUtil.isEmpty((Object)result)) {
                    throw new LegoCheckedException(1073947393L);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Checking EnumByType failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                Object result = CommUtil.checkUnknownEnumByType(classs, type);
                if (!VerifyUtil.isEmpty((Object)result)) break block4;
                throw new LegoCheckedException(1073947393L, (Throwable)e);
            }
        }
    }

    public static <T> void checkEnumByType(Class<T> classs, String types) {
        if (VerifyUtil.isEmpty((String)types)) {
            throw new LegoCheckedException(1073947393L);
        }
        int type = 0;
        try {
            type = Integer.parseInt(types);
        }
        catch (NumberFormatException e) {
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
        CommUtil.checkEnumByType(classs, type);
    }

    public static void pauseThread(long millis) {
        if (millis <= 0L || millis > 3600000L) {
            logger.error((Object)"Invalid parameter. Time:%d . Error code:%d", new Object[]{millis, 90160758784001L});
            throw new LegoCheckedException(1073947393L);
        }
        try {
            TimeUnit.MILLISECONDS.sleep(millis);
        }
        catch (Exception e) {
            logger.error((Object)"Pausing thread failed. Millis:%d. %s . Error code:%d", new Object[]{millis, ExceptionUtil.getErrorMessage((Throwable)e), 90160758784001L});
        }
    }

    public static void interruptiblePauseThread(long millis) throws InterruptedException {
        if (millis <= 0L || millis > 3600000L) {
            logger.error((Object)"Invalid parameter. Time:%d . Error code:%d", new Object[]{millis, 90160758784001L});
            throw new LegoCheckedException(1073947393L);
        }
        TimeUnit.MILLISECONDS.sleep(millis);
    }

    private static <T> Object checkUnknownEnumByType(Class<T> classs, int type) {
        Object result;
        block3: {
            result = null;
            try {
                T[] properties = classs.getEnumConstants();
                if (null == properties) break block3;
                for (T p : properties) {
                    Method getTypeMothod = p.getClass().getMethod("getValue", new Class[0]);
                    if (type != (Integer)getTypeMothod.invoke(p, new Object[0])) continue;
                    result = p;
                    break;
                }
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, null, (long)1073947393L, null, (Log)logger);
            }
        }
        return result;
    }

    public static String convertToString(Object object) {
        if (null == object) {
            return null;
        }
        return String.valueOf(object);
    }

    public static Long convertToLong(Object object) {
        if (null == object) {
            return Long.MIN_VALUE;
        }
        try {
            return Long.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Convert failed. Obj:" + object), (Throwable)e, 90160758784001L);
            return Long.MIN_VALUE;
        }
    }

    public static Integer convertToInteger(Object object) {
        if (null == object) {
            return Integer.MIN_VALUE;
        }
        try {
            return Integer.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Convert failed. Obj:" + object), (Throwable)e, 90160758784001L);
            return Integer.MIN_VALUE;
        }
    }

    public static Boolean convertToBoolean(Object object) {
        if (null == object) {
            return false;
        }
        boolean retValue = true;
        try {
            int result = Integer.parseInt(String.valueOf(object));
            if (0 == result) {
                retValue = false;
            }
        }
        catch (Exception e) {
            retValue = Boolean.valueOf(String.valueOf(object));
        }
        return retValue;
    }

    public static String combineString(String ... strs) {
        return String.join((CharSequence)"-", strs);
    }

    public static String combineStringBySign(String ... strs) {
        StringBuilder sb = new StringBuilder();
        for (String str : strs) {
            sb.append(str).append("@");
        }
        return sb.toString();
    }

    public static <T, L extends Collection> void addToMap(Map<String, L> map, String key, T obj) {
        ArrayList<T> list = (ArrayList<T>)map.get(key);
        if (null == list) {
            list = new ArrayList<T>();
            map.put(key, list);
        }
        list.add(obj);
    }

    public static <K, T> void addSetToMap(Map<K, Set<T>> map, K key, T obj) {
        Set<T> set = map.get(key);
        if (null == set) {
            set = new HashSet<T>();
            map.put(key, set);
        }
        set.add(obj);
    }

    public static List<Map> convertToListMap(String object) {
        if (VerifyUtil.isEmpty((String)object)) {
            return Collections.emptyList();
        }
        JSONArray jsonArray = JSONArray.fromObject((Object)object);
        return JSONArray.toCollection((JSONArray)jsonArray, Map.class);
    }

    public static boolean checkParamEmpty(Object ... params) {
        if (VerifyUtil.isEmpty((Object[])params)) {
            throw new LegoCheckedException(1073947393L);
        }
        for (Object param : params) {
            if (!VerifyUtil.isEmpty((Object)param)) continue;
            throw new LegoCheckedException(1073947393L);
        }
        return true;
    }

    public static boolean checkObjectExists(Object ... params) {
        if (VerifyUtil.isEmpty((Object[])params)) {
            throw new LegoCheckedException(1073947394L);
        }
        for (Object param : params) {
            if (!VerifyUtil.isEmpty((Object)param)) continue;
            throw new LegoCheckedException(1073947394L);
        }
        return true;
    }
}

