/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.task.sdk;

import com.huawei.lego.cbb.task.sdk.model.Task;
import com.huawei.lego.cbb.task.sdk.service.TaskPeriodType;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class TaskTimeUtil {
    private static final int SEVEN = 7;
    private static final int HOUNDRED = 100;
    private static Log log = LogFactory.getInstance(TaskTimeUtil.class);

    private TaskTimeUtil() {
    }

    public static Date getEndDateWithCount(Task task) {
        Date endDate = null;
        int repeat = task.getPeriodtimes();
        int period = task.getPeriod();
        int internal = repeat * period;
        if (repeat >= 0 && internal >= 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(task.getBaseTime());
            if (TaskPeriodType.date.getValue() == task.getPeriodType().intValue()) {
                cal.add(5, internal);
            } else if (TaskPeriodType.week.getValue() == task.getPeriodType().intValue()) {
                cal.add(5, internal * 7);
            } else if (TaskPeriodType.month.getValue() == task.getPeriodType().intValue()) {
                cal.add(2, internal);
            } else if (TaskPeriodType.hour.getValue() == task.getPeriodType().intValue()) {
                cal.add(10, internal);
            }
            endDate = cal.getTime();
            endDate.setTime(endDate.getTime() + 100L);
        }
        return endDate;
    }

    public static Date getTaskNextTime(Date nextTime, Task task) {
        Date next = nextTime;
        while (next.before(new Date())) {
            next = TaskTimeUtil.getNextTime(next, task);
        }
        log.info((Object)("Task(" + task.getTaskId() + "," + task.getTaskName() + ") nextime is " + next), 0L);
        return next;
    }

    private static Date getNextTime(Date nextTime, Task task) {
        Date next = nextTime;
        boolean nextTimeIsAfter = TaskTimeUtil.nextTimeIsAfterCurrentDate(nextTime);
        if (null != task.getPeriod() && task.getPeriod() >= 1) {
            log.info((Object)("task.getPeriod() is " + task.getPeriod()), 0L);
            int taskPeriod = task.getPeriod();
            if (nextTimeIsAfter) {
                taskPeriod = task.getPeriod() - 1;
            }
            Calendar nextCal = Calendar.getInstance();
            nextCal.setTime(nextTime);
            nextCal.getTime();
            nextCal = TaskTimeUtil.processNexCal(nextCal, task, taskPeriod);
            next = nextCal.getTime();
        }
        return next;
    }

    private static Calendar processNexCal(Calendar nextCal, Task task, int taskPeriod) {
        if (TaskPeriodType.date.getValue() == task.getPeriodType().intValue()) {
            nextCal.add(5, taskPeriod);
        } else if (TaskPeriodType.week.getValue() == task.getPeriodType().intValue()) {
            nextCal.add(5, (task.getPeriod() - 1) * 7);
        } else if (TaskPeriodType.month.getValue() == task.getPeriodType().intValue()) {
            nextCal.add(2, task.getPeriod() - 1);
        } else if (TaskPeriodType.minute.getValue() == task.getPeriodType().intValue()) {
            nextCal.add(12, task.getPeriod() - 1);
        } else if (TaskPeriodType.hour.getValue() == task.getPeriodType().intValue()) {
            nextCal.add(10, task.getPeriod());
        }
        return nextCal;
    }

    public static Boolean nextTimeIsAfterCurrentDate(Date nextTime) {
        Date time = null;
        Date curretTime = null;
        SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
        try {
            time = formatDay.parse(formatDay.format(nextTime));
            curretTime = formatDay.parse(formatDay.format(new Date()));
        }
        catch (ParseException e) {
            log.error((Object)"ParseException", (Throwable)e, 0L);
            return false;
        }
        if (time.after(curretTime)) {
            return true;
        }
        return false;
    }
}

