/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.task.sdk.job;

import com.huawei.lego.cbb.task.sdk.TaskTimeUtil;
import com.huawei.lego.cbb.task.sdk.model.Task;
import com.huawei.lego.cbb.task.sdk.model.TaskResult;
import com.huawei.lego.cbb.task.sdk.service.ITaskJobService;
import com.huawei.lego.cbb.task.sdk.service.ITaskService;
import com.huawei.lego.cbb.task.sdk.service.TaskExecuteType;
import com.huawei.lego.cbb.task.sdk.service.TaskPeriodType;
import com.huawei.lego.cbb.task.sdk.service.TaskResultState;
import com.huawei.lego.cbb.task.sdk.service.TaskStatus;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Trigger;
import org.springframework.scheduling.quartz.QuartzJobBean;

public abstract class BaseJobBean
extends QuartzJobBean {
    private static final int LOOP_COUNT = 100;
    private static final int SLEEP_TIME = 200;
    private Log log = LogFactory.getInstance(BaseJobBean.class);
    private boolean isFirstExcute = true;

    protected void executeInternal(JobExecutionContext jobexecutioncontext) throws JobExecutionException {
        JobDataMap data = jobexecutioncontext.getTrigger().getJobDataMap();
        Task task = (Task)data.get((Object)"task");
        Date startTime = new Date();
        Trigger trigger = jobexecutioncontext.getTrigger();
        this.log.info((Object)("Task jobbean current time is " + startTime), 0L);
        if (!this.isRuning(task, startTime, trigger)) {
            return;
        }
        ITaskJobService taskJobService = this.getTaskService();
        this.log.info((Object)("Job " + trigger.getJobKey() + "start."), 0L);
        TaskResultState state = null;
        task.setTaskStatus(TaskStatus.running.getValue());
        if (null != taskJobService) {
            taskJobService.updateTask(task);
        }
        String resultLink = "";
        try {
            resultLink = this.executeJob(task);
            state = resultLink.equals("") ? TaskResultState.fail : TaskResultState.sucess;
        }
        catch (Exception e) {
            state = TaskResultState.fail;
            this.log.error((Object)("Exception" + ExceptionUtil.getErrorMessage(e)), 0L);
        }
        Date endTime = new Date();
        String hql = "from TaskResult t where t.taskId = " + task.getTaskId() + " and t.result = " + TaskResultState.running.getValue();
        List<TaskResult> taskResultList = null;
        if (null != taskJobService) {
            taskResultList = taskJobService.queryTaskResultByHql(hql);
        }
        TaskResult result = null;
        if (null != taskResultList && !taskResultList.isEmpty()) {
            result = taskResultList.get(0);
            result.setStartTime(startTime);
            result.setEndTime(endTime);
            result.setResult(state.getValue());
            result.setResultLink(resultLink);
            this.updateResultList(result, taskJobService);
        } else {
            result = new TaskResult();
            result.setTaskId(task);
            result.setStartTime(startTime);
            result.setEndTime(endTime);
            result.setResult(state.getValue());
            result.setResultLink(resultLink);
            result.setResultInfo("Task execute ok.");
            this.addResultList(result, taskJobService);
        }
        task.setPreTime(new Date(trigger.getPreviousFireTime().getTime()));
        boolean isUpdate = false;
        this.extractedMethod(task, trigger, taskJobService, endTime, isUpdate);
    }

    private void updateResultList(TaskResult result, ITaskJobService taskJobService) {
        if (null != taskJobService) {
            taskJobService.updateTaskResult(result);
        }
    }

    private void addResultList(TaskResult result, ITaskJobService taskJobService) {
        if (null != taskJobService) {
            taskJobService.addTaskResult(result);
        }
    }

    private void extractedMethod(Task task, Trigger trigger, ITaskJobService taskJobService, Date endTime, boolean isUpdate) {
        if (null != trigger.getEndTime() && trigger.getEndTime().before(endTime)) {
            task.setTaskStatus(TaskStatus.finish.getValue());
            task.setNextTime(null);
        } else {
            task = this.calculateTaskNextTime(task, trigger);
            if (this.isFirstExcute) {
                isUpdate = this.reStartTask(task);
            }
            this.isFirstExcute = false;
        }
        if (null != taskJobService && !isUpdate) {
            taskJobService.updateTask(task);
        }
    }

    private boolean isRuning(Task task, Date startTime, Trigger trigger) {
        Date nextTime;
        if (null != task.getNextTime() && null != (nextTime = trigger.getNextFireTime())) {
            Date taskNextTime = task.getNextTime();
            this.log.info((Object)("Task jobbean taskNextTime time is " + taskNextTime), 0L);
            if (task.getNextTime().after(startTime)) {
                this.log.info((Object)"task.getNextTime().after(startTime) is  true", 0L);
                return false;
            }
        }
        return true;
    }

    private ITaskJobService getTaskService() {
        ITaskJobService taskJobService = null;
        for (int i = 0; i < 100 && null == taskJobService; ++i) {
            try {
                taskJobService = (ITaskJobService)ServiceContext.getInstance().lookup("task/taskjob");
                CommonUtil.sleep(200L);
                continue;
            }
            catch (Exception ex) {
                this.log.error((Object)("Exception" + ExceptionUtil.getErrorMessage(ex)), 0L);
            }
        }
        return taskJobService;
    }

    private boolean reStartTask(Task task) {
        boolean isUpdate = false;
        try {
            ITaskService taskService = (ITaskService)ServiceContext.getInstance().lookup("task/task");
            if (null != taskService) {
                taskService.updateTask(task);
                isUpdate = true;
            }
        }
        catch (Exception e) {
            this.log.error((Object)("ITaskService update task exception." + ExceptionUtil.getErrorMessage(e)), 0L);
        }
        return isUpdate;
    }

    private Task calculateTaskNextTime(Task task, Trigger trigger) {
        Date nextTime = trigger.getNextFireTime();
        if (null != nextTime) {
            this.log.info((Object)("trigger.getNextFireTime() is " + nextTime), 0L);
            nextTime.setTime(trigger.getPreviousFireTime().getTime());
            nextTime.setHours(task.getBaseTime().getHours());
            nextTime.setMinutes(task.getBaseTime().getMinutes());
            nextTime.setSeconds(task.getBaseTime().getSeconds());
            if (this.isFirstExcute && TaskPeriodType.hour.getValue() == task.getPeriodType().intValue()) {
                Calendar nextCal = Calendar.getInstance();
                nextCal.setTime(nextTime);
                nextCal.add(5, -1);
                nextTime = nextCal.getTime();
            }
            Date next = TaskTimeUtil.getTaskNextTime(nextTime, task);
            task.setTaskStatus(TaskStatus.idle.getValue());
            task.setNextTime(next);
            return task;
        }
        Date currentTime = new Date();
        task.setTaskStatus(TaskStatus.finish.getValue());
        this.processTaskTime(task, currentTime);
        return task;
    }

    private void processTaskTime(Task task, Date currentTime) {
        if (TaskExecuteType.single.getValue() == task.getExecuteType().intValue()) {
            if (currentTime.before(task.getBaseTime())) {
                task.setTaskStatus(TaskStatus.idle.getValue());
            }
        } else {
            this.processTaskTime1(task, currentTime);
        }
    }

    private void processTaskTime1(Task task, Date currentTime) {
        if (task.getPeriodtimes() == -1) {
            task.setTaskStatus(TaskStatus.idle.getValue());
        } else {
            Date endDate = TaskTimeUtil.getEndDateWithCount(task);
            if (null != endDate && currentTime.before(endDate)) {
                task.setTaskStatus(TaskStatus.idle.getValue());
            }
        }
    }

    public abstract String executeJob(Task var1);
}

