/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.com.south.sdk.model;

import com.huawei.lego.com.south.sdk.model.SnmpEnum;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.io.Serializable;

public class SnmpV3Param
implements Serializable {
    private static final long serialVersionUID = 4092637408577066515L;
    private Long snmpV3ParamId;
    private String securityName;
    private String userName;
    private SnmpEnum.AuthProtocol authProtocol = SnmpEnum.AuthProtocol.NO_AUTH;
    private String authPwd;
    private SnmpEnum.PrivProtocol privProtocol = SnmpEnum.PrivProtocol.NO_PRIV;
    private String privPwd;
    private String contextName;
    private String engineId;
    private String contextEngineId;
    private SnmpEnum.SecurityLevel securityLevel;
    private String discoveredDeviceUuid;
    private String ipAddress;
    private Integer port;
    private Integer type;
    private Integer version;
    private String readCommunity;
    private String writeCommunity;

    public Long getSnmpV3ParamId() {
        return this.snmpV3ParamId;
    }

    public void setSnmpV3ParamId(Long snmpV3ParamId) {
        this.snmpV3ParamId = snmpV3ParamId;
    }

    public String getSecurityName() {
        return this.securityName;
    }

    public void setSecurityName(String securityName) {
        this.securityName = securityName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public SnmpEnum.AuthProtocol getAuthProtocol() {
        return this.authProtocol;
    }

    public void setAuthProtocol(SnmpEnum.AuthProtocol authProtocol) {
        this.authProtocol = authProtocol;
    }

    public String getAuthPwd() {
        return this.authPwd;
    }

    public void setAuthPwd(String authPwd) {
        this.authPwd = authPwd;
    }

    public SnmpEnum.PrivProtocol getPrivProtocol() {
        return this.privProtocol;
    }

    public void setPrivProtocol(SnmpEnum.PrivProtocol privProtocol) {
        this.privProtocol = privProtocol;
    }

    public String getPrivPwd() {
        return this.privPwd;
    }

    public void setPrivPwd(String privPwd) {
        this.privPwd = privPwd;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public String getContextEngineId() {
        return this.contextEngineId;
    }

    public void setContextEngineId(String contextEngineId) {
        this.contextEngineId = contextEngineId;
    }

    public SnmpEnum.SecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(SnmpEnum.SecurityLevel securityLevel) {
        this.securityLevel = securityLevel;
    }

    public String getEngineId() {
        return this.engineId;
    }

    public void setEngineId(String engineId) {
        this.engineId = engineId;
    }

    private int getAuthProtocolNum() {
        if (this.authProtocol != null) {
            return this.authProtocol.getValue();
        }
        return 20;
    }

    private void setAuthProtocolNum(int authProtocolNum) {
        this.authProtocol = SnmpEnum.AuthProtocol.getAuthProtocol(authProtocolNum);
    }

    private int getPrivProtocolNum() {
        if (this.privProtocol != null) {
            return this.privProtocol.getValue();
        }
        return 51;
    }

    private void setPrivProtocolNum(int privProtocolNum) {
        this.privProtocol = SnmpEnum.PrivProtocol.getPrivProtocol(privProtocolNum);
    }

    private int getSecurityLevelNum() {
        if (this.securityLevel != null) {
            return this.securityLevel.getValue();
        }
        return 0;
    }

    private void setSecurityLevelNum(int securityLevelNum) {
        this.securityLevel = SnmpEnum.SecurityLevel.getSecurityLevel(securityLevelNum);
    }

    public String getDiscoveredDeviceUuid() {
        return this.discoveredDeviceUuid;
    }

    public void setDiscoveredDeviceUuid(String discoveredDeviceUuid) {
        this.discoveredDeviceUuid = discoveredDeviceUuid;
    }

    private void setAuthPwd2(String pwd) {
        this.authPwd = pwd != null && !pwd.equals("") ? WccEncryptor.decrypt(pwd) : pwd;
    }

    private String getAuthPwd2() {
        if (this.authPwd != null && !this.authPwd.equals("")) {
            return WccEncryptor.encrypt(this.authPwd);
        }
        return this.authPwd;
    }

    private String getPrivPwd2() {
        if (this.privPwd != null && !this.privPwd.equals("")) {
            return WccEncryptor.encrypt(this.privPwd);
        }
        return this.privPwd;
    }

    private void setPrivPwd2(String pwd) {
        this.privPwd = pwd != null && !pwd.equals("") ? WccEncryptor.decrypt(pwd) : pwd;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public int getPort() {
        if (VerifyUtil.isEmpty(this.port)) {
            return 0;
        }
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public int getType() {
        if (VerifyUtil.isEmpty(this.type)) {
            this.type = 0;
        }
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setWriteCommunity(String writeCommunity) {
        this.writeCommunity = writeCommunity;
    }

    public void setReadCommunity(String readCommunity) {
        this.readCommunity = readCommunity;
    }

    public int getVersion() {
        if (VerifyUtil.isEmpty(this.version)) {
            return SnmpEnum.SnmpVersion.VERSION3.getValue();
        }
        return this.version;
    }

    public String getWriteCommunity() {
        return this.writeCommunity;
    }

    public String getReadCommunity() {
        return this.readCommunity;
    }

    public String toString() {
        return "SnmpV3Param [authProtocol=" + (Object)((Object)this.authProtocol) + ", contextEngineId=" + this.contextEngineId + ", contextName=" + this.contextName + ", discoveredDeviceUuid=" + this.discoveredDeviceUuid + ", engineId=" + this.engineId + ", privProtocol=" + (Object)((Object)this.privProtocol) + ", securityLevel=" + (Object)((Object)this.securityLevel) + ", securityName=" + this.securityName + ", snmpV3ParamId=" + this.snmpV3ParamId + ", userName=" + this.userName + "]";
    }
}

