/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.com.south.snmp.abs;

import com.huawei.lego.com.south.snmp.abs.Property;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.List;

public final class VBPro {
    public static final int TYPE_INT32 = 2;
    public static final int TYPE_OCTSTRING = 4;
    public static final int TYPE_NULL = 5;
    public static final int TYPE_OID = 6;
    public static final int TYPE_GAUGE32 = 66;
    public static final int TYPE_COUNT32 = 65;
    public static final int TYPE_COUNT64 = 70;
    public static final int TYPE_TIMETICKS = 67;
    public static final int TYPE_IPADDR = 64;
    private List<Property> vblist = new ArrayList<Property>();
    private Log log = LogFactory.getInstance(VBPro.class);

    public Property get(int idx) {
        return this.vblist.get(idx);
    }

    public VBPro add(String oid, String value, int type) {
        if (oid == null || oid.isEmpty()) {
            throw new IllegalArgumentException("oid cannot be null or empty!");
        }
        Property p = this.getProperty(oid);
        if (p != null) {
            this.vblist.remove(p);
        }
        this.vblist.add(new Property(oid, value, type));
        return this;
    }

    public int getInt(String oid) {
        Property p = this.getProperty(oid);
        if (p != null) {
            try {
                return NumberUtil.convertToInteger(p.getValue());
            }
            catch (NumberFormatException e) {
                this.log.debug((Object)"error!", 0L);
            }
        }
        return Integer.MIN_VALUE;
    }

    public long getLong(String oid) {
        Property p = this.getProperty(oid);
        if (p != null) {
            try {
                return NumberUtil.convertToLong(p.getValue());
            }
            catch (NumberFormatException e) {
                this.log.debug((Object)"error!", 0L);
            }
        }
        return Long.MIN_VALUE;
    }

    public double getDouble(String oid) {
        Property p = this.getProperty(oid);
        if (p != null) {
            try {
                return NumberUtil.convertToDouble(p.getValue());
            }
            catch (NumberFormatException e) {
                this.log.debug((Object)"error!", 0L);
            }
        }
        return Double.MIN_VALUE;
    }

    public String getString(String oid) {
        Property p = this.getProperty(oid);
        if (p != null) {
            return p.getValue();
        }
        return null;
    }

    public int size() {
        return this.vblist.size();
    }

    public List<Property> getVbs() {
        return this.vblist;
    }

    private Property getProperty(String oid) {
        for (Property p : this.vblist) {
            if (!p.getName().equals(oid)) continue;
            return p;
        }
        return null;
    }
}

